/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.ExportedPreferences;
import org.eclipse.core.internal.preferences.PreferencesOSGiUtils;
import org.eclipse.core.internal.preferences.PreferencesService;
import org.eclipse.core.internal.preferences.PreferencesService$2;
import org.eclipse.core.internal.preferences.PreferencesService$3;
import org.eclipse.core.internal.preferences.PreferencesService$6;
import org.eclipse.core.internal.preferences.PrefsMessages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.Preferences;

public class PreferencesService$$Cold {
    public static boolean containsKeys(PreferencesService preferencesService, IEclipsePreferences iEclipsePreferences) {
        boolean[] blArray = new boolean[1];
        PreferencesService$2 preferencesService$2 = new PreferencesService$2(preferencesService, blArray);
        iEclipsePreferences.accept(preferencesService$2);
        return blArray[0];
    }

    public static Properties convertFromLegacy(PreferencesService preferencesService, Properties properties) {
        Properties properties2 = new Properties();
        String string = "/instance/";
        Iterator iterator = ((Hashtable)properties).keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = properties.getProperty(string2);
            if (string3 == null) continue;
            int n = string2.indexOf(47);
            if (n == -1) {
                ((Hashtable)properties2).put(String.valueOf('@') + string2, string3);
                ((Hashtable)properties2).put(String.valueOf('!') + string + string2, "");
                continue;
            }
            String string4 = string2.substring(0, n);
            string2 = string2.substring(n + 1);
            ((Hashtable)properties2).put(EclipsePreferences.encodePath(String.valueOf(string) + string4, string2), string3);
        }
        return properties2;
    }

    public static IExportedPreferences convertFromProperties(PreferencesService preferencesService, Properties properties) {
        IExportedPreferences iExportedPreferences = ExportedPreferences.newRoot();
        Iterator iterator = ((Hashtable)properties).keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            String string = (String)iterator.next();
            String string2 = properties.getProperty(string);
            if (string.charAt(0) == '!') {
                object = (String[])iExportedPreferences.node(string.substring(1));
                ((ExportedPreferences)object).setExportRoot();
                continue;
            }
            if (string.charAt(0) == '@') {
                object = (ExportedPreferences)iExportedPreferences.node("instance").node(string.substring(1));
                ((ExportedPreferences)object).setVersion(string2);
                continue;
            }
            object = EclipsePreferences.decodePath(string);
            string = object[0] == null ? "" : object[0];
            ExportedPreferences exportedPreferences = (ExportedPreferences)iExportedPreferences.node(string);
            Object object2 = object[1];
            ((EclipsePreferences)exportedPreferences).put((String)object2, string2);
        }
        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Converted preferences file to IExportedPreferences tree: " + ((EclipsePreferences)((Object)iExportedPreferences)).toDeepDebugString());
        }
        return iExportedPreferences;
    }

    public static Properties convertToProperties(PreferencesService preferencesService, IEclipsePreferences iEclipsePreferences, String[] stringArray) {
        Properties properties = new Properties();
        int n = iEclipsePreferences.absolutePath().length();
        PreferencesService$3 preferencesService$3 = new PreferencesService$3(preferencesService, n, stringArray, properties);
        iEclipsePreferences.accept(preferencesService$3);
        return properties;
    }

    public static void copyFromTo(PreferencesService preferencesService, Preferences preferences, Preferences preferences2, String[] stringArray, int n) {
        String[] stringArray2 = stringArray == null ? preferences.keys() : stringArray;
        int n2 = 0;
        while (n2 < stringArray2.length) {
            String string = preferences.get(stringArray2[n2], null);
            if (string != null) {
                preferences2.put(stringArray2[n2], string);
            }
            ++n2;
        }
        if (n == 0) {
            return;
        }
        String[] stringArray3 = preferences.childrenNames();
        int n3 = 0;
        while (n3 < stringArray3.length) {
            preferencesService.copyFromTo(preferences.node(stringArray3[n3]), preferences2.node(stringArray3[n3]), stringArray, n);
            ++n3;
        }
    }

    public static IStatus createStatusError(String string, Exception exception) {
        return (IStatus)new Status(4, "org.eclipse.equinox.preferences", 4, string, (Throwable)exception);
    }

    public static String get(PreferencesService preferencesService, String string, String string2, Preferences[] preferencesArray) {
        if (preferencesArray == null) {
            return string2;
        }
        int n = 0;
        while (n < preferencesArray.length) {
            String string3;
            Preferences preferences = preferencesArray[n];
            if (preferences != null && (string3 = preferences.get(string, null)) != null) {
                return string3;
            }
            ++n;
        }
        return string2;
    }

    public static String getBundleName(PreferencesService preferencesService, String string) {
        if (string.length() == 0 || string.charAt(0) != '/') {
            return null;
        }
        int n = string.indexOf(47, 1);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(47, n + 1);
        return n2 == -1 ? string.substring(n + 1) : string.substring(n + 1, n2);
    }

    public static String getBundleVersion(PreferencesService preferencesService, String string) {
        Object v;
        Bundle bundle = PreferencesOSGiUtils.getDefault().getBundle(string);
        if (bundle != null && (v = bundle.getHeaders("").get("Bundle-Version")) != null && v instanceof String) {
            return (String)v;
        }
        return null;
    }

    public static Preferences[] getNodes(PreferencesService preferencesService, String string, String string2, IScopeContext[] iScopeContextArray) {
        String[] stringArray = preferencesService.getLookupOrder(string, string2);
        String string3 = EclipsePreferences.makeRelative(EclipsePreferences.decodePath(string2)[0]);
        ArrayList<Preferences> arrayList = new ArrayList<Preferences>();
        int n = 0;
        while (n < stringArray.length) {
            String string4 = stringArray[n];
            boolean bl = false;
            int n2 = 0;
            while (iScopeContextArray != null && n2 < iScopeContextArray.length) {
                Preferences preferences;
                IScopeContext iScopeContext = iScopeContextArray[n2];
                if (iScopeContext != null && iScopeContext.getName().equals(string4) && (preferences = iScopeContext.getNode(string)) != null) {
                    bl = true;
                    if (string3 != null) {
                        preferences = preferences.node(string3);
                    }
                    arrayList.add(preferences);
                }
                ++n2;
            }
            if (!bl) {
                Preferences preferences = preferencesService.getRootNode().node(string4).node(string);
                if (string3 != null) {
                    preferences = preferences.node(string3);
                }
                arrayList.add(preferences);
            }
            bl = false;
            ++n;
        }
        return arrayList.toArray(new Preferences[arrayList.size()]);
    }

    public static String getRegistryKey(PreferencesService preferencesService, String string, String string2) {
        if (string == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (string2 == null) {
            return string;
        }
        return String.valueOf(string) + '/' + string2;
    }

    public static String getScope(PreferencesService preferencesService, String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        int n = string.indexOf(47);
        if (n == -1) {
            return string;
        }
        if (string.length() == 1) {
            return "";
        }
        int n2 = string.indexOf(47, n + 1);
        if (n2 == -1) {
            n2 = string.length();
        }
        return string.substring(n + 1, n2);
    }

    public static IStatus importPreferences(PreferencesService preferencesService, InputStream inputStream) {
        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Importing preferences...");
        }
        return preferencesService.applyPreferences(preferencesService.readPreferences(inputStream));
    }

    public static IEclipsePreferences mergeTrees(PreferencesService preferencesService, IEclipsePreferences[] iEclipsePreferencesArray) {
        if (iEclipsePreferencesArray.length == 1) {
            return iEclipsePreferencesArray[0];
        }
        IExportedPreferences iExportedPreferences = ExportedPreferences.newRoot();
        if (iEclipsePreferencesArray.length == 0) {
            return iExportedPreferences;
        }
        PreferencesService$6 preferencesService$6 = new PreferencesService$6(preferencesService, iExportedPreferences);
        int n = 0;
        while (n < iEclipsePreferencesArray.length) {
            iEclipsePreferencesArray[n].accept(preferencesService$6);
            ++n;
        }
        return iExportedPreferences;
    }

    public static boolean scopeMatches(PreferencesService preferencesService, String string, IEclipsePreferences iEclipsePreferences) {
        String string2;
        if (iEclipsePreferences.parent() == null) {
            return false;
        }
        int n = (string2 = iEclipsePreferences.absolutePath()).indexOf(47, 1);
        String string3 = string2.substring(1, n == -1 ? string2.length() : n);
        return string.equals(string3);
    }

    public static IStatus validatePluginVersions(PreferencesService preferencesService, String string, PluginVersionIdentifier pluginVersionIdentifier, PluginVersionIdentifier pluginVersionIdentifier2) {
        if (pluginVersionIdentifier2.getMajorComponent() == pluginVersionIdentifier.getMajorComponent() && pluginVersionIdentifier2.getMinorComponent() == pluginVersionIdentifier.getMinorComponent()) {
            return null;
        }
        int n = pluginVersionIdentifier2.getMajorComponent() < pluginVersionIdentifier.getMajorComponent() ? 4 : 2;
        String string2 = NLS.bind((String)PrefsMessages.preferences_incompatible, (Object[])new Object[]{pluginVersionIdentifier, string, pluginVersionIdentifier2});
        return (IStatus)new Status(n, "org.eclipse.equinox.preferences", 1, string2, null);
    }
}

