/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.InstancePreferences;
import org.eclipse.core.internal.preferences.PreferencesOSGiUtils;
import org.eclipse.core.internal.preferences.PrefsMessages;
import org.eclipse.core.internal.runtime.MetaDataKeeper;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.service.datalocation.Location;

public class InstancePreferences$$Cold {
    public static void loadLegacy(InstancePreferences instancePreferences) {
        Path path = new Path(instancePreferences.absolutePath());
        if (path.segmentCount() != 2) {
            return;
        }
        if (PreferencesOSGiUtils.getDefault().getInstanceLocation() == null) {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Cannot load Legacy plug-in preferences since instance location is not set.");
            }
            return;
        }
        String string = path.segment(1);
        File file = null;
        Location location = PreferencesOSGiUtils.getDefault().getInstanceLocation();
        if (location != null && location.isSet()) {
            file = MetaDataKeeper.getMetaArea().getPreferenceLocation(string, false).toFile();
        }
        if (file == null) {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Cannot load legacy values because instance location is not set.");
            }
            return;
        }
        if (!file.exists()) {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Legacy plug-in preference file not found: " + file);
            }
            return;
        }
        if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Loading legacy preferences from " + file);
        }
        BufferedInputStream bufferedInputStream = null;
        Properties properties = new Properties();
        try {
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                properties.load(bufferedInputStream);
            }
            catch (IOException iOException) {
                block27: {
                    if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                        PrefsMessages.message("IOException encountered loading legacy preference file " + file);
                    }
                    if (bufferedInputStream != null) {
                        try {
                            ((InputStream)bufferedInputStream).close();
                        }
                        catch (IOException iOException2) {
                            if (!EclipsePreferences.DEBUG_PREFERENCE_GENERAL) break block27;
                            PrefsMessages.message("IOException encountered closing legacy preference file " + file);
                            ((Throwable)iOException2).printStackTrace();
                        }
                    }
                }
                return;
            }
        }
        finally {
            block28: {
                if (bufferedInputStream != null) {
                    try {
                        ((InputStream)bufferedInputStream).close();
                    }
                    catch (IOException iOException) {
                        if (!EclipsePreferences.DEBUG_PREFERENCE_GENERAL) break block28;
                        PrefsMessages.message("IOException encountered closing legacy preference file " + file);
                        ((Throwable)iOException).printStackTrace();
                    }
                }
            }
        }
        Iterator iterator = ((Hashtable)properties).keySet().iterator();
        while (iterator.hasNext()) {
            String string2;
            String string3 = (String)iterator.next();
            String string4 = properties.getProperty(string3);
            if (string4 == null) continue;
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Loaded legacy preference: " + string3 + " -> " + string4);
            }
            if (string4.equals(string2 = instancePreferences.internalPut(string3, string4))) continue;
            instancePreferences.makeDirty();
        }
        if (!file.delete() && EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Unable to delete legacy preferences file: " + file);
        }
    }
}

