/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import org.eclipse.core.internal.preferences.ImmutableMap;
import org.eclipse.core.internal.preferences.StringPool;

class ImmutableMap$ArrayMap
extends ImmutableMap {
    private static final float LOAD_FACTOR = 0.45f;
    private int elementSize = 0;
    private String[] keyTable;
    private int threshold;
    private String[] valueTable;

    ImmutableMap$ArrayMap(int n) {
        int n2 = 1;
        while (n2 < n) {
            n2 *= 2;
        }
        this.keyTable = new String[n2];
        this.valueTable = new String[n2];
        this.threshold = (int)((float)n2 * 0.45f);
    }

    public String get(String string) {
        String string2;
        int n = this.keyTable.length - 1;
        int n2 = string.hashCode() & n;
        while ((string2 = this.keyTable[n2]) != null) {
            if (string2.equals(string)) {
                return this.valueTable[n2];
            }
            n2 = n2 + 1 & n;
        }
        return null;
    }

    protected void internalPut(String string, String string2) {
        String string3;
        int n = this.keyTable.length - 1;
        int n2 = string.hashCode() & n;
        while ((string3 = this.keyTable[n2]) != null) {
            if (string3.equals(string)) {
                this.valueTable[n2] = string2;
                return;
            }
            n2 = n2 + 1 & n;
        }
        this.keyTable[n2] = string;
        this.valueTable[n2] = string2;
        ++this.elementSize;
    }

    public String[] keys() {
        if (this.elementSize == 0) {
            return ImmutableMap.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = new String[this.elementSize];
        int n = 0;
        int n2 = 0;
        while (n2 < this.keyTable.length) {
            if (this.keyTable[n2] != null) {
                stringArray[n++] = this.keyTable[n2];
            }
            ++n2;
        }
        return stringArray;
    }

    public ImmutableMap put(String string, String string2) {
        ImmutableMap$ArrayMap immutableMap$ArrayMap;
        int n = this.keyTable.length;
        if (this.elementSize + 1 > this.threshold) {
            immutableMap$ArrayMap = new ImmutableMap$ArrayMap(n * 2);
            int n2 = n;
            while (--n2 >= 0) {
                String string3 = this.keyTable[n2];
                if (string3 == null) continue;
                immutableMap$ArrayMap.internalPut(string3, this.valueTable[n2]);
            }
        } else {
            immutableMap$ArrayMap = new ImmutableMap$ArrayMap(n);
            System.arraycopy(this.keyTable, 0, immutableMap$ArrayMap.keyTable, 0, this.keyTable.length);
            System.arraycopy(this.valueTable, 0, immutableMap$ArrayMap.valueTable, 0, this.valueTable.length);
            immutableMap$ArrayMap.elementSize = this.elementSize;
        }
        immutableMap$ArrayMap.internalPut(string, string2);
        return immutableMap$ArrayMap;
    }

    public ImmutableMap removeKey(String string) {
        String string2;
        int n = this.keyTable.length - 1;
        int n2 = string.hashCode() & n;
        while ((string2 = this.keyTable[n2]) != null) {
            if (string2.equals(string)) {
                if (this.elementSize <= 1) {
                    return ImmutableMap.EMPTY;
                }
                ImmutableMap immutableMap = ImmutableMap.createMap((int)((float)this.elementSize / 0.45f));
                int n3 = 0;
                while (n3 < n2) {
                    string2 = this.keyTable[n3];
                    if (string2 != null) {
                        immutableMap.internalPut(string2, this.valueTable[n3]);
                    }
                    ++n3;
                }
                n3 = n2 + 1;
                while (n3 <= n) {
                    string2 = this.keyTable[n3];
                    if (string2 != null) {
                        immutableMap.internalPut(string2, this.valueTable[n3]);
                    }
                    ++n3;
                }
                return immutableMap;
            }
            n2 = n2 + 1 & n;
        }
        return this;
    }

    public void shareStrings(StringPool stringPool) {
        String string;
        String[] stringArray = this.keyTable;
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            string = stringArray[n];
            if (string != null) {
                stringArray[n] = stringPool.add(string);
            }
            ++n;
        }
        stringArray = this.valueTable;
        if (stringArray == null) {
            return;
        }
        n = 0;
        while (n < stringArray.length) {
            string = stringArray[n];
            if (string != null) {
                stringArray[n] = stringPool.add(string);
            }
            ++n;
        }
    }

    public int size() {
        return this.elementSize;
    }
}

