/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.EclipsePreferences$3;
import org.eclipse.core.internal.preferences.ImmutableMap;
import org.eclipse.core.internal.preferences.PreferencesService;
import org.eclipse.core.internal.preferences.PrefsMessages;
import org.eclipse.core.internal.preferences.RootPreferences;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences$NodeChangeEvent;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;

public class EclipsePreferences$$Cold {
    public static void accept(EclipsePreferences eclipsePreferences, IPreferenceNodeVisitor iPreferenceNodeVisitor) {
        if (!iPreferenceNodeVisitor.visit(eclipsePreferences)) {
            return;
        }
        IEclipsePreferences[] iEclipsePreferencesArray = eclipsePreferences.getChildren(true);
        int n = 0;
        while (n < iEclipsePreferencesArray.length) {
            iEclipsePreferencesArray[n].accept(iPreferenceNodeVisitor);
            ++n;
        }
    }

    public static IEclipsePreferences calculateRoot(EclipsePreferences eclipsePreferences) {
        IEclipsePreferences iEclipsePreferences = eclipsePreferences;
        while (iEclipsePreferences.parent() != null) {
            iEclipsePreferences = (IEclipsePreferences)iEclipsePreferences.parent();
        }
        return iEclipsePreferences;
    }

    public static boolean childExists(EclipsePreferences eclipsePreferences, String string) {
        if (eclipsePreferences.children == null) {
            return false;
        }
        return eclipsePreferences.children.get(string) != null;
    }

    public static void clear(EclipsePreferences eclipsePreferences) {
        eclipsePreferences.checkRemoved();
        String[] stringArray = eclipsePreferences.properties.keys();
        int n = 0;
        while (n < stringArray.length) {
            eclipsePreferences.remove(stringArray[n]);
            ++n;
        }
        eclipsePreferences.makeDirty();
    }

    public static Properties convertToProperties(EclipsePreferences eclipsePreferences, Properties properties, String string) {
        Object object;
        boolean bl = string.length() != 0;
        ImmutableMap immutableMap = eclipsePreferences.properties;
        String[] stringArray = immutableMap.keys();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            object = immutableMap.get(stringArray[n]);
            if (object != null) {
                ((Hashtable)properties).put(EclipsePreferences.encodePath(string, stringArray[n]), object);
            }
            ++n;
        }
        IEclipsePreferences[] iEclipsePreferencesArray = eclipsePreferences.getChildren(true);
        n2 = 0;
        while (n2 < iEclipsePreferencesArray.length) {
            object = (EclipsePreferences)iEclipsePreferencesArray[n2];
            String string2 = bl ? String.valueOf(string) + EclipsePreferences.PATH_SEPARATOR + ((EclipsePreferences)object).name() : ((EclipsePreferences)object).name();
            ((EclipsePreferences)object).convertToProperties(properties, string2);
            ++n2;
        }
        PreferencesService.getDefault().shareStrings();
        return properties;
    }

    public static String[] decodePath(String string) {
        String string2 = null;
        String string3 = null;
        int n = string.indexOf("//");
        if (n == -1) {
            int n2 = string.lastIndexOf(47);
            if (n2 == -1) {
                string2 = string;
            } else {
                string3 = string.substring(0, n2);
                string2 = string.substring(n2 + 1);
            }
        } else {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 2);
        }
        if (string3 != null) {
            if (string3.length() == 0) {
                string3 = null;
            } else if (string3.charAt(0) == '/') {
                string3 = string3.substring(1);
            }
        }
        return new String[]{string3, string2};
    }

    public static String encodePath(String string, String string2) {
        int n;
        int n2 = n = string == null ? 0 : string.length();
        String string3 = string2.indexOf(47) == -1 ? (n == 0 ? string2 : String.valueOf(string) + '/' + string2) : (n == 0 ? "//" + string2 : String.valueOf(string) + "//" + string2);
        return string3;
    }

    public static String get(EclipsePreferences eclipsePreferences, String string, String string2) {
        String string3 = eclipsePreferences.internalGet(string);
        return string3 == null ? string2 : string3;
    }

    public static boolean getBoolean(EclipsePreferences eclipsePreferences, String string, boolean bl) {
        String string2 = eclipsePreferences.internalGet(string);
        return string2 == null ? bl : "true".equalsIgnoreCase(string2);
    }

    public static byte[] getByteArray(EclipsePreferences eclipsePreferences, String string, byte[] byArray) {
        String string2 = eclipsePreferences.internalGet(string);
        return string2 == null ? byArray : Base64.decode(string2.getBytes());
    }

    public static double getDouble(EclipsePreferences eclipsePreferences, String string, double d) {
        String string2 = eclipsePreferences.internalGet(string);
        double d2 = d;
        if (string2 != null) {
            try {
                d2 = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return d2;
    }

    public static float getFloat(EclipsePreferences eclipsePreferences, String string, float f) {
        String string2 = eclipsePreferences.internalGet(string);
        float f2 = f;
        if (string2 != null) {
            try {
                f2 = Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return f2;
    }

    public static int getInt(EclipsePreferences eclipsePreferences, String string, int n) {
        String string2 = eclipsePreferences.internalGet(string);
        int n2 = n;
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n2;
    }

    public static long getLong(EclipsePreferences eclipsePreferences, String string, long l) {
        String string2 = eclipsePreferences.internalGet(string);
        long l2 = l;
        if (string2 != null) {
            try {
                l2 = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return l2;
    }

    public static String internalGet(EclipsePreferences eclipsePreferences, String string) {
        if (string == null) {
            throw (Throwable)new NullPointerException();
        }
        eclipsePreferences.checkRemoved();
        String string2 = eclipsePreferences.properties.get(string);
        if (EclipsePreferences.DEBUG_PREFERENCE_GET) {
            PrefsMessages.message("Getting preference value: " + eclipsePreferences.absolutePath() + '/' + string + "->" + string2);
        }
        return string2;
    }

    public static String internalPut(EclipsePreferences eclipsePreferences, String string, String string2) {
        eclipsePreferences.checkRemoved();
        String string3 = eclipsePreferences.properties.get(string);
        if (string3 != null && string3.equals(string2)) {
            return string3;
        }
        if (EclipsePreferences.DEBUG_PREFERENCE_SET) {
            PrefsMessages.message("Setting preference: " + eclipsePreferences.absolutePath() + '/' + string + '=' + string2);
        }
        eclipsePreferences.properties = eclipsePreferences.properties.put(string, string2);
        return string3;
    }

    public static void makeDirty(EclipsePreferences eclipsePreferences) {
        EclipsePreferences eclipsePreferences2 = eclipsePreferences;
        while (eclipsePreferences2 != null && !eclipsePreferences2.removed) {
            eclipsePreferences2.dirty = true;
            eclipsePreferences2 = (EclipsePreferences)eclipsePreferences2.parent();
        }
    }

    public static String makeRelative(String string) {
        String string2 = string;
        if (string == null) {
            return "";
        }
        if (string.length() > 0 && string.charAt(0) == '/') {
            string2 = string.length() == 0 ? "" : string.substring(1);
        }
        return string2;
    }

    public static void put(EclipsePreferences eclipsePreferences, String string, String string2) {
        if (string == null || string2 == null) {
            throw (Throwable)new NullPointerException();
        }
        String string3 = eclipsePreferences.internalPut(string, string2);
        if (!string2.equals(string3)) {
            eclipsePreferences.makeDirty();
            eclipsePreferences.firePreferenceEvent(string, string3, string2);
        }
    }

    public static void putBoolean(EclipsePreferences eclipsePreferences, String string, boolean bl) {
        String string2;
        if (string == null) {
            throw (Throwable)new NullPointerException();
        }
        String string3 = bl ? "true" : "false";
        if (!string3.equals(string2 = eclipsePreferences.internalPut(string, string3))) {
            eclipsePreferences.makeDirty();
            eclipsePreferences.firePreferenceEvent(string, string2, string3);
        }
    }

    public static void putByteArray(EclipsePreferences eclipsePreferences, String string, byte[] byArray) {
        String string2;
        if (string == null || byArray == null) {
            throw (Throwable)new NullPointerException();
        }
        String string3 = new String(Base64.encode(byArray));
        if (!string3.equals(string2 = eclipsePreferences.internalPut(string, string3))) {
            eclipsePreferences.makeDirty();
            eclipsePreferences.firePreferenceEvent(string, string2, string3);
        }
    }

    public static void putDouble(EclipsePreferences eclipsePreferences, String string, double d) {
        String string2;
        if (string == null) {
            throw (Throwable)new NullPointerException();
        }
        String string3 = Double.toString(d);
        if (!string3.equals(string2 = eclipsePreferences.internalPut(string, string3))) {
            eclipsePreferences.makeDirty();
            eclipsePreferences.firePreferenceEvent(string, string2, string3);
        }
    }

    public static void putFloat(EclipsePreferences eclipsePreferences, String string, float f) {
        String string2;
        if (string == null) {
            throw (Throwable)new NullPointerException();
        }
        String string3 = Float.toString(f);
        if (!string3.equals(string2 = eclipsePreferences.internalPut(string, string3))) {
            eclipsePreferences.makeDirty();
            eclipsePreferences.firePreferenceEvent(string, string2, string3);
        }
    }

    public static void putInt(EclipsePreferences eclipsePreferences, String string, int n) {
        String string2;
        if (string == null) {
            throw (Throwable)new NullPointerException();
        }
        String string3 = Integer.toString(n);
        if (!string3.equals(string2 = eclipsePreferences.internalPut(string, string3))) {
            eclipsePreferences.makeDirty();
            eclipsePreferences.firePreferenceEvent(string, string2, string3);
        }
    }

    public static void putLong(EclipsePreferences eclipsePreferences, String string, long l) {
        String string2;
        if (string == null) {
            throw (Throwable)new NullPointerException();
        }
        String string3 = Long.toString(l);
        if (!string3.equals(string2 = eclipsePreferences.internalPut(string, string3))) {
            eclipsePreferences.makeDirty();
            eclipsePreferences.firePreferenceEvent(string, string2, string3);
        }
    }

    public static void remove(EclipsePreferences eclipsePreferences, String string) {
        String string2 = eclipsePreferences.properties.get(string);
        if (string2 == null) {
            return;
        }
        eclipsePreferences.properties = eclipsePreferences.properties.removeKey(string);
        eclipsePreferences.makeDirty();
        eclipsePreferences.firePreferenceEvent(string, string2, null);
    }

    public static void removeNode(EclipsePreferences eclipsePreferences) {
        eclipsePreferences.checkRemoved();
        String[] stringArray = eclipsePreferences.keys();
        int n = 0;
        while (n < stringArray.length) {
            eclipsePreferences.remove(stringArray[n]);
            ++n;
        }
        if (eclipsePreferences.parent != null && !(eclipsePreferences.parent instanceof RootPreferences)) {
            eclipsePreferences.removed = true;
            eclipsePreferences.parent.removeNode(eclipsePreferences);
        }
        IEclipsePreferences[] iEclipsePreferencesArray = eclipsePreferences.getChildren(false);
        int n2 = 0;
        while (n2 < iEclipsePreferencesArray.length) {
            try {
                iEclipsePreferencesArray[n2].removeNode();
            }
            catch (IllegalStateException illegalStateException) {}
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeNode(EclipsePreferences eclipsePreferences, String string) {
        EclipsePreferences eclipsePreferences2 = eclipsePreferences;
        synchronized (eclipsePreferences2) {
            if (eclipsePreferences.children != null) {
                boolean bl;
                boolean bl2 = bl = eclipsePreferences.children.remove(string) != null;
                if (bl) {
                    eclipsePreferences.makeDirty();
                }
                if (eclipsePreferences.children.isEmpty()) {
                    eclipsePreferences.children = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeNode(EclipsePreferences eclipsePreferences, IEclipsePreferences iEclipsePreferences) {
        boolean bl = false;
        EclipsePreferences eclipsePreferences2 = eclipsePreferences;
        synchronized (eclipsePreferences2) {
            if (eclipsePreferences.children != null) {
                boolean bl2 = bl = eclipsePreferences.children.remove(iEclipsePreferences.name()) != null;
                if (bl) {
                    eclipsePreferences.makeDirty();
                }
                if (eclipsePreferences.children.isEmpty()) {
                    eclipsePreferences.children = null;
                }
            }
        }
        if (bl) {
            eclipsePreferences.fireNodeEvent(new IEclipsePreferences$NodeChangeEvent(eclipsePreferences, iEclipsePreferences), false);
        }
    }

    public static void save(EclipsePreferences eclipsePreferences, IPath iPath) {
        File file;
        FileOutputStream fileOutputStream;
        OutputStream outputStream;
        Properties properties;
        block18: {
            block19: {
                if (iPath == null) {
                    if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                        PrefsMessages.message("Unable to determine location of preference file for node: " + eclipsePreferences.absolutePath());
                    }
                    return;
                }
                if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                    PrefsMessages.message("Saving preferences to file: " + iPath);
                }
                if (((Hashtable)(properties = eclipsePreferences.convertToProperties(new Properties(), ""))).isEmpty()) {
                    if (iPath.toFile().exists() && !iPath.toFile().delete()) {
                        String string = NLS.bind((String)PrefsMessages.preferences_failedDelete, (Object)iPath);
                        EclipsePreferences.log((IStatus)new Status(2, "org.eclipse.equinox.preferences", 2, string, null));
                    }
                    return;
                }
                ((Hashtable)properties).put("eclipse.preferences.version", "1");
                outputStream = null;
                fileOutputStream = null;
                file = iPath.toFile().getParentFile();
                if (file != null) break block18;
                if (outputStream == null) break block19;
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            return;
        }
        try {
            try {
                file.mkdirs();
                fileOutputStream = new FileOutputStream(iPath.toOSString(), false);
                outputStream = new BufferedOutputStream(fileOutputStream);
                properties.store(outputStream, null);
                outputStream.flush();
                fileOutputStream.getFD().sync();
            }
            catch (IOException iOException) {
                String string = NLS.bind((String)PrefsMessages.preferences_saveException, (Object)iPath);
                EclipsePreferences.log((IStatus)new Status(4, "org.eclipse.equinox.preferences", 4, string, (Throwable)iOException));
                throw (Throwable)new BackingStoreException(string);
            }
        }
        catch (Throwable throwable) {
            if (outputStream != null) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void sync(EclipsePreferences eclipsePreferences) {
        eclipsePreferences.checkRemoved();
        IEclipsePreferences iEclipsePreferences = eclipsePreferences.getLoadLevel();
        if (iEclipsePreferences == null) {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Preference node is not a load root: " + eclipsePreferences.absolutePath());
            }
            return;
        }
        if (iEclipsePreferences instanceof EclipsePreferences) {
            ((EclipsePreferences)iEclipsePreferences).load();
            iEclipsePreferences.flush();
        }
    }

    public static String toDeepDebugString(EclipsePreferences eclipsePreferences) {
        StringBuffer stringBuffer = new StringBuffer();
        EclipsePreferences$3 eclipsePreferences$3 = new EclipsePreferences$3(eclipsePreferences, stringBuffer);
        try {
            eclipsePreferences.accept(eclipsePreferences$3);
        }
        catch (BackingStoreException backingStoreException) {
            System.out.println("Exception while calling #toDeepDebugString()");
            ((Throwable)backingStoreException).printStackTrace();
        }
        return stringBuffer.toString();
    }
}

