/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.internal.preferences.Activator;
import org.eclipse.core.internal.preferences.DefaultPreferences$$Cold;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.preferences.PreferencesOSGiUtils;
import org.eclipse.core.internal.preferences.PreferencesService;
import org.eclipse.core.internal.preferences.PrefsMessages;
import org.eclipse.core.internal.preferences.exchange.IProductPreferencesService;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class DefaultPreferences
extends EclipsePreferences {
    private static Set loadedNodes = new HashSet();
    private static final String KEY_PREFIX = "%";
    private static final String KEY_DOUBLE_PREFIX = "%%";
    private static final IPath NL_DIR = (IPath)new Path("$nl$");
    private static final String PROPERTIES_FILE_EXTENSION = "properties";
    private static Properties productCustomization;
    private static Properties productTranslation;
    private static Properties commandLineCustomization;
    private EclipsePreferences loadLevel;
    private String qualifier;
    private int segmentCount;
    private WeakReference pluginReference;
    public static String pluginCustomizationFile;
    static Class class$0;

    static {
        pluginCustomizationFile = null;
    }

    public DefaultPreferences() {
        this(null, null);
    }

    private DefaultPreferences(EclipsePreferences eclipsePreferences, String string) {
        super(eclipsePreferences, string);
        if (eclipsePreferences instanceof DefaultPreferences) {
            this.pluginReference = ((DefaultPreferences)eclipsePreferences).pluginReference;
        }
        String string2 = this.absolutePath();
        this.segmentCount = EclipsePreferences.getSegmentCount(string2);
        if (this.segmentCount < 2) {
            return;
        }
        this.qualifier = EclipsePreferences.getSegment(string2, 1);
    }

    public IEclipsePreferences node(String string, Object object) {
        return this.internalNode(string, true, object);
    }

    public void flush() {
    }

    protected EclipsePreferences internalCreate(EclipsePreferences eclipsePreferences, String string, Object object) {
        return new DefaultPreferences(eclipsePreferences, string, object);
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences iEclipsePreferences) {
        return loadedNodes.contains(iEclipsePreferences.name());
    }

    protected void load() {
        this.loadDefaults();
    }

    protected void loaded() {
        loadedNodes.add(this.name());
    }

    public void sync() {
    }

    private DefaultPreferences(EclipsePreferences eclipsePreferences, String string, Object object) {
        this(eclipsePreferences, string);
        this.pluginReference = new WeakReference<Object>(object);
    }

    private void applyBundleDefaults() {
        Bundle bundle = PreferencesOSGiUtils.getDefault().getBundle(this.name());
        if (bundle == null) {
            return;
        }
        URL uRL = FileLocator.find((Bundle)bundle, (IPath)((IPath)new Path("preferences.ini")), null);
        if (uRL == null) {
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Preference default override file not found for bundle: " + bundle.getSymbolicName());
            }
            return;
        }
        URL uRL2 = FileLocator.find((Bundle)bundle, (IPath)NL_DIR.append("preferences").addFileExtension(PROPERTIES_FILE_EXTENSION), null);
        if (uRL2 == null && EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
            PrefsMessages.message("Preference translation file not found for bundle: " + bundle.getSymbolicName());
        }
        this.applyDefaults(this.name(), this.loadProperties(uRL), this.loadProperties(uRL2));
    }

    private void applyCommandLineDefaults() {
        if (commandLineCustomization == null) {
            String string = pluginCustomizationFile;
            if (string == null) {
                if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                    PrefsMessages.message("Command-line preferences customization file not specified.");
                }
                return;
            }
            if (EclipsePreferences.DEBUG_PREFERENCE_GENERAL) {
                PrefsMessages.message("Using command-line preference customization file: " + string);
            }
            commandLineCustomization = this.loadProperties(string);
        }
        this.applyDefaults(null, commandLineCustomization, null);
    }

    private void applyDefaults(String string, Properties properties, Properties properties2) {
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = properties.getProperty(string2);
            if (string3 == null) continue;
            Path path = new Path(string2);
            String string4 = path.lastSegment();
            path = path.removeLastSegments(1);
            String string5 = string;
            if (string == null) {
                string5 = path.segment(0);
                path = path.removeFirstSegments(1);
            }
            if (!this.name().equals(string5)) continue;
            string3 = this.translatePreference(string3, properties2);
            if (EclipsePreferences.DEBUG_PREFERENCE_SET) {
                PrefsMessages.message("Setting default preference: " + new Path(this.absolutePath()).append((IPath)path).append(string4) + '=' + string3);
            }
            ((EclipsePreferences)this.internalNode(path.toString(), false, null)).internalPut(string4, string3);
        }
    }

    private void applyRuntimeDefaults() {
        WeakReference weakReference = PreferencesService.getDefault().applyRuntimeDefaults(this.name(), this.pluginReference);
        if (weakReference != null) {
            this.pluginReference = weakReference;
        }
    }

    private void applyProductDefaults() {
        if (productCustomization == null) {
            BundleContext bundleContext = Activator.getContext();
            if (bundleContext != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.internal.preferences.exchange.IProductPreferencesService");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                    }
                }
                ServiceTracker serviceTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
                serviceTracker.open();
                IProductPreferencesService iProductPreferencesService = (IProductPreferencesService)serviceTracker.getService();
                if (iProductPreferencesService != null) {
                    productCustomization = iProductPreferencesService.getProductCustomization();
                    productTranslation = iProductPreferencesService.getProductTranslation();
                }
                serviceTracker.close();
            } else {
                PrefsMessages.message("Product-specified preferences called before plugin is started");
            }
            if (productCustomization == null) {
                productCustomization = new Properties();
            }
        }
        if (!((Hashtable)productCustomization).isEmpty()) {
            this.applyDefaults(null, productCustomization, productTranslation);
        }
    }

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.qualifier == null) {
                return null;
            }
            EclipsePreferences eclipsePreferences = this;
            int n = 2;
            while (n < this.segmentCount) {
                eclipsePreferences = (EclipsePreferences)eclipsePreferences.parent();
                ++n;
            }
            this.loadLevel = eclipsePreferences;
        }
        return this.loadLevel;
    }

    private void loadDefaults() {
        this.applyRuntimeDefaults();
        this.applyBundleDefaults();
        this.applyProductDefaults();
        this.applyCommandLineDefaults();
    }

    private Properties loadProperties(URL uRL) throws  {
        return DefaultPreferences$$Cold.loadProperties(this, uRL);
    }

    private Properties loadProperties(String string) throws  {
        return DefaultPreferences$$Cold.loadProperties(this, string);
    }

    private String translatePreference(String string, Properties properties) throws  {
        return DefaultPreferences$$Cold.translatePreference(this, string, properties);
    }
}

