/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.ui.compare.internal;

import com.ibm.team.filesystem.cli.client.ui.compare.internal.Messages;
import com.ibm.team.filesystem.cli.client.ui.compare.internal.SetEncodingDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

public class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    private ActionFactory.IWorkbenchAction exitAction;
    private ActionFactory.IWorkbenchAction saveAction;
    private ActionFactory.IWorkbenchAction undoAction;
    private ActionFactory.IWorkbenchAction redoAction;
    private ActionFactory.IWorkbenchAction cutAction;
    private ActionFactory.IWorkbenchAction copyAction;
    private ActionFactory.IWorkbenchAction pasteAction;
    private ActionFactory.IWorkbenchAction printAction;
    private ActionFactory.IWorkbenchAction selectAllAction;
    private ActionFactory.IWorkbenchAction findAction;
    private ActionFactory.IWorkbenchAction deleteAction;
    private IAction editEncodingAction;

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    protected void makeActions(final IWorkbenchWindow window) {
        this.exitAction = ActionFactory.CLOSE.create(window);
        this.register((IAction)this.exitAction);
        this.saveAction = ActionFactory.SAVE.create(window);
        this.register((IAction)this.saveAction);
        this.undoAction = ActionFactory.UNDO.create(window);
        this.register((IAction)this.undoAction);
        this.redoAction = ActionFactory.REDO.create(window);
        this.register((IAction)this.redoAction);
        this.cutAction = ActionFactory.CUT.create(window);
        this.register((IAction)this.cutAction);
        this.copyAction = ActionFactory.COPY.create(window);
        this.register((IAction)this.copyAction);
        this.pasteAction = ActionFactory.PASTE.create(window);
        this.register((IAction)this.pasteAction);
        this.printAction = ActionFactory.PRINT.create(window);
        this.register((IAction)this.printAction);
        this.selectAllAction = ActionFactory.SELECT_ALL.create(window);
        this.register((IAction)this.selectAllAction);
        this.findAction = ActionFactory.FIND.create(window);
        this.register((IAction)this.findAction);
        this.deleteAction = ActionFactory.DELETE.create(window);
        this.register((IAction)this.deleteAction);
        this.editEncodingAction = new Action(Messages.ApplicationActionBarAdvisor_0){

            public void run() {
                SetEncodingDialog dialog = new SetEncodingDialog(window.getShell());
                dialog.open();
            }
        };
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        menuBar.add((IContributionItem)this.createFileMenu());
        menuBar.add((IContributionItem)this.createEditMenu());
    }

    private IMenuManager createFileMenu() {
        MenuManager fileMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_2, "CustomFile");
        fileMenu.add((IAction)this.saveAction);
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)this.exitAction);
        return fileMenu;
    }

    private IMenuManager createEditMenu() {
        MenuManager menu = new MenuManager(Messages.ApplicationActionBarAdvisor_1, "edit");
        menu.add((IContributionItem)new GroupMarker("editStart"));
        menu.add((IAction)this.undoAction);
        menu.add((IAction)this.redoAction);
        menu.add((IContributionItem)new GroupMarker("undo.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.cutAction);
        menu.add((IAction)this.copyAction);
        menu.add((IAction)this.pasteAction);
        menu.add((IContributionItem)new GroupMarker("cut.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.deleteAction);
        menu.add((IAction)this.selectAllAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.findAction);
        menu.add((IContributionItem)new GroupMarker("find.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new GroupMarker("add.ext"));
        menu.add((IContributionItem)new GroupMarker("editEnd"));
        menu.add((IContributionItem)new Separator("additions"));
        return menu;
    }
}

