/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.workitems.internal;

import com.ibm.team.filesystem.client.workitems.IFileSystemWorkItemManager;
import com.ibm.team.filesystem.client.workitems.IFileSystemWorkItemRestClient;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.RestUtils;
import com.ibm.team.scm.common.links.ChangeSetLinks;
import com.ibm.team.scm.common.providers.ProviderFactory;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class FileSystemWorkItemRestClient
implements IFileSystemWorkItemRestClient {
    private static final UUID NULL_STATE = null;

    public void postAddWorkItem(IFileSystemWorkItemRestClient.ParmsPostChangeSetWorkItem parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!RestUtils.isSet((String)parms.repositoryUrl)) {
            throw new IllegalArgumentException("missing repositoryUrl parameter");
        }
        if (!RestUtils.isSet((String)parms.changeSetId)) {
            throw new IllegalArgumentException("missing changeSetId parameter");
        }
        if (!RestUtils.isSet((String)parms.workItemItemId)) {
            throw new IllegalArgumentException("missing workItemId parameter");
        }
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(parms.repositoryUrl);
        if (!repo.loggedIn()) {
            repo.login(null);
        }
        IWorkspace workspace = null;
        IChangeSetHandle changeSetHandle = (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.changeSetId), NULL_STATE);
        IWorkItemHandle workItemHandle = (IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.workItemItemId), NULL_STATE);
        if (RestUtils.isSet((String)parms.workspaceId)) {
            IWorkspaceHandle wsHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.workspaceId), NULL_STATE);
            IWorkspaceConnection connection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection(wsHandle, monitor);
            workspace = connection.getResolvedWorkspace();
        }
        IFileSystemWorkItemManager manager = (IFileSystemWorkItemManager)repo.getClientLibrary(IFileSystemWorkItemManager.class);
        manager.createLink(workspace, changeSetHandle, new IWorkItemHandle[]{workItemHandle}, monitor);
    }

    public void postRemoveWorkItem(IFileSystemWorkItemRestClient.ParmsPostChangeSetWorkItem parms, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!RestUtils.isSet((String)parms.repositoryUrl)) {
            throw new IllegalArgumentException("missing repositoryUrl parameter");
        }
        if (!RestUtils.isSet((String)parms.changeSetId)) {
            throw new IllegalArgumentException("missing changeSetId parameter");
        }
        if (!RestUtils.isSet((String)parms.workItemItemId)) {
            throw new IllegalArgumentException("missing workItemId parameter");
        }
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(parms.repositoryUrl);
        if (!repo.loggedIn()) {
            repo.login(null);
        }
        IChangeSetHandle changeSetHandle = (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.changeSetId), NULL_STATE);
        IWorkItemHandle workItemHandle = (IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)parms.workItemItemId), NULL_STATE);
        IFileSystemWorkItemManager manager = (IFileSystemWorkItemManager)repo.getClientLibrary(IFileSystemWorkItemManager.class);
        ProviderFactory providerFactory = (ProviderFactory)repo.getClientLibrary(ProviderFactory.class);
        List links = ChangeSetLinks.findLinks((ProviderFactory)providerFactory, (IChangeSetHandle)changeSetHandle, (IProgressMonitor)monitor);
        ILink linkToRemove = null;
        for (ILink link : links) {
            IItemHandle refHandle;
            IReference targetRef = link.getTargetRef();
            if (!targetRef.isItemReference() || !((refHandle = ((IItemReference)targetRef).getReferencedItem()) instanceof IWorkItemHandle) || !refHandle.sameItemId((IItemHandle)workItemHandle)) continue;
            linkToRemove = link;
        }
        manager.deleteLinks(Collections.singletonList(linkToRemove), monitor);
    }

    public void postDeliverAndResolve(IFileSystemWorkItemRestClient.ParmsPostDeliverAndResolve parms, IProgressMonitor monitor) throws TeamRepositoryException {
    }
}

