/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime.auth;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.internal.runtime.auth.Cipher;

public class CipherInputStream
extends FilterInputStream {
    private static final int SKIP_BUFFER_SIZE = 2048;
    private Cipher cipher;

    public CipherInputStream(InputStream inputStream, String string) {
        super(inputStream);
        this.cipher = new Cipher(-1, string);
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        int n = super.read();
        if (n == -1) {
            return -1;
        }
        try {
            return this.cipher.cipher((byte)n) & 0xFF;
        }
        catch (Exception exception) {
            throw (Throwable)new IOException(((Throwable)exception).getMessage());
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 == -1) {
            return -1;
        }
        try {
            byte[] byArray2 = this.cipher.cipher(byArray, n, n3);
            int n4 = 0;
            while (n4 < byArray2.length) {
                byArray[n4 + n] = byArray2[n4];
                ++n4;
            }
            return n3;
        }
        catch (Exception exception) {
            throw (Throwable)new IOException(((Throwable)exception).getMessage());
        }
    }

    public long skip(long l) throws IOException {
        byte[] byArray = new byte[2048];
        int n = 0;
        long l2 = l;
        while (n != -1 && l2 > 0L) {
            n = this.read(byArray, 0, (int)Math.min(2048L, l2));
            if (n <= 0) continue;
            l2 -= (long)n;
        }
        return l - l2;
    }
}

