/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime.auth;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.internal.runtime.auth.Activator;
import org.eclipse.core.internal.runtime.auth.CipherInputStream;
import org.eclipse.core.internal.runtime.auth.CipherOutputStream;
import org.eclipse.core.internal.runtime.auth.Messages;
import org.eclipse.core.internal.runtime.auth.URLTool;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class AuthorizationDatabase {
    public static final String PI_RUNTIME_AUTH = "org.eclipse.core.runtime.auth.compatibility";
    public static final int FAILED_READ_METADATA = 4;
    public static final int FAILED_WRITE_METADATA = 5;
    private static final int KEYRING_FILE_VERSION = 1;
    private Hashtable authorizationInfo = new Hashtable(5);
    private Hashtable protectionSpace = new Hashtable(5);
    private File file = null;
    private String password = null;
    private boolean needsSaving = true;

    public AuthorizationDatabase() {
    }

    public AuthorizationDatabase(String string, String string2) throws CoreException {
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)string2);
        this.password = string2;
        this.file = new File(string);
        this.load();
    }

    public void addAuthorizationInfo(URL uRL, String string, String string2, Map map) {
        Hashtable<String, Map> hashtable;
        Assert.isNotNull((Object)uRL);
        Assert.isNotNull((Object)string);
        Assert.isNotNull((Object)string2);
        Assert.isNotNull((Object)map);
        String string3 = uRL.toString();
        Hashtable<String, Hashtable<String, Map>> hashtable2 = (Hashtable<String, Hashtable<String, Map>>)this.authorizationInfo.get(string3);
        if (hashtable2 == null) {
            hashtable2 = new Hashtable<String, Hashtable<String, Map>>(5);
            this.authorizationInfo.put(string3, hashtable2);
        }
        if ((hashtable = (Hashtable<String, Map>)hashtable2.get(string)) == null) {
            hashtable = new Hashtable<String, Map>(5);
            hashtable2.put(string, hashtable);
        }
        hashtable.put(string2.toLowerCase(), map);
        this.needsSaving = true;
    }

    public void addProtectionSpace(URL uRL, String string) {
        String string2;
        Assert.isNotNull((Object)uRL);
        Assert.isNotNull((Object)string);
        if (!uRL.getFile().endsWith("/")) {
            uRL = URLTool.getParent(uRL);
        }
        if ((string2 = this.getProtectionSpace(uRL)) != null && string2.equals(string)) {
            return;
        }
        String string3 = uRL.toString();
        Enumeration enumeration = this.protectionSpace.keys();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            if (!string3.startsWith(string4) && !string4.startsWith(string3)) continue;
            this.protectionSpace.remove(string4);
            break;
        }
        this.protectionSpace.put(string3, string);
        this.needsSaving = true;
    }

    public void flushAuthorizationInfo(URL uRL, String string, String string2) {
        Hashtable hashtable = (Hashtable)this.authorizationInfo.get(uRL.toString());
        if (hashtable == null) {
            return;
        }
        Hashtable hashtable2 = (Hashtable)hashtable.get(string);
        if (hashtable2 == null) {
            return;
        }
        hashtable2.remove(string2.toLowerCase());
        this.needsSaving = true;
    }

    public Map getAuthorizationInfo(URL uRL, String string, String string2) {
        Hashtable hashtable = (Hashtable)this.authorizationInfo.get(uRL.toString());
        if (hashtable == null) {
            return null;
        }
        Hashtable hashtable2 = (Hashtable)hashtable.get(string);
        if (hashtable2 == null) {
            return null;
        }
        return (Map)hashtable2.get(string2.toLowerCase());
    }

    public String getProtectionSpace(URL uRL) {
        while (uRL != null) {
            String string = (String)this.protectionSpace.get(uRL.toString());
            if (string != null) {
                return string;
            }
            uRL = URLTool.getParent(uRL);
        }
        return null;
    }

    private void load() throws CoreException {
        if (this.file == null) {
            return;
        }
        if (!this.file.exists()) {
            this.save();
            return;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(this.file);
            try {
                this.load(fileInputStream);
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        catch (IOException iOException) {
            throw (Throwable)new CoreException((IStatus)new Status(4, PI_RUNTIME_AUTH, 4, NLS.bind((String)Messages.meta_unableToReadAuthorization, (Object)this.file), (Throwable)iOException));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw (Throwable)new CoreException((IStatus)new Status(4, PI_RUNTIME_AUTH, 4, NLS.bind((String)Messages.meta_unableToReadAuthorization, (Object)this.file), (Throwable)classNotFoundException));
        }
    }

    private void load(InputStream inputStream) throws IOException, ClassNotFoundException, CoreException {
        int n = inputStream.read();
        if (n == 1) {
            CipherInputStream cipherInputStream = new CipherInputStream(inputStream, this.password);
            ObjectInputStream objectInputStream = new ObjectInputStream(cipherInputStream);
            try {
                this.authorizationInfo = (Hashtable)objectInputStream.readObject();
                this.protectionSpace = (Hashtable)objectInputStream.readObject();
            }
            finally {
                objectInputStream.close();
            }
        }
        Activator.log((IStatus)new Status(2, PI_RUNTIME_AUTH, 4, Messages.meta_authFormatChanged, null));
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        this.needsSaving = true;
        this.save();
    }

    public void save() throws CoreException {
        if (!this.needsSaving || this.file == null) {
            return;
        }
        try {
            this.file.delete();
            if (!this.file.getParentFile().exists() && !this.file.getParentFile().mkdirs() || !AuthorizationDatabase.canWrite(this.file.getParentFile())) {
                throw (Throwable)new CoreException((IStatus)new Status(4, PI_RUNTIME_AUTH, 5, NLS.bind((String)Messages.meta_unableToWriteAuthorization, (Object)this.file), null));
            }
            this.file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(this.file);
            try {
                this.save(fileOutputStream);
            }
            finally {
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            throw (Throwable)new CoreException((IStatus)new Status(4, PI_RUNTIME_AUTH, 5, NLS.bind((String)Messages.meta_unableToWriteAuthorization, (Object)this.file), (Throwable)iOException));
        }
        this.needsSaving = false;
    }

    private static boolean canWrite(File file) {
        if (!file.canWrite()) {
            return false;
        }
        if (!file.isDirectory()) {
            return false;
        }
        File file2 = null;
        try {
            try {
                file2 = File.createTempFile("writtableArea", null, file);
            }
            catch (IOException iOException) {
                if (file2 != null) {
                    file2.delete();
                }
                return false;
            }
        }
        finally {
            if (file2 != null) {
                file2.delete();
            }
        }
        return true;
    }

    private void save(FileOutputStream fileOutputStream) throws IOException {
        fileOutputStream.write(1);
        CipherOutputStream cipherOutputStream = new CipherOutputStream(fileOutputStream, this.password);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(cipherOutputStream);
        try {
            objectOutputStream.writeObject(this.authorizationInfo);
            objectOutputStream.writeObject(this.protectionSpace);
            ((OutputStream)fileOutputStream).flush();
            fileOutputStream.getFD().sync();
        }
        finally {
            objectOutputStream.close();
        }
    }

    public boolean setPassword(String string, String string2) {
        if (!string.equals(this.password)) {
            return false;
        }
        this.password = string2;
        this.needsSaving = true;
        return true;
    }
}

