/*
 *  2008-08-17: this file was modified by International Business Machines Corporation.
 *  Modifications Copyright 2008 IBM Corporation.
 */

/* 
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package javax.sql;

import java.io.PrintWriter;
import java.sql.SQLException;

/**
 * Interface that defines the methods which are common between DataSource,
 * XADataSource and ConnectionPoolDataSource.
 * 
 * @since 1.6
 */
public interface CommonDataSource {

    /**
     * While attempting to connect to a database, this method get the maximum
     * time in seconds that this data source can wait.
     * 
     * @return An integer value to indicate the maximum time.
     * @throws SQLException
     *             An exception threw when a data base access error occurs.
     */
    public int getLoginTimeout() throws SQLException;

    /**
     * Retrieves a log writer which is a character output stream to which all
     * logging and tracing messages for this data source will be printed.
     * 
     * @return The PrintWriter object for this DataSource.
     * @throws SQLException
     *             An exception threw when a data base access error occurs.
     */
    PrintWriter getLogWriter() throws SQLException;

    /**
     * While attempting to connect to a database, this method set the maximum
     * time in seconds that this data source can wait.
     * 
     * @param seconds
     *            An integer value to indicate the maximum time.
     * @throws SQLException
     *             An exception threw when a data base access error occurs.
     */
    void setLoginTimeout(int seconds) throws SQLException;

    /**
     * Set a log writer which is a character output stream to which all logging
     * and tracing messages for this data source will be printed.
     * 
     * @param out
     *            The PrintWriter object for this DataSource.
     * @throws SQLException
     *             An exception threw when a data base access error occurs.
     */
    void setLogWriter(PrintWriter out) throws SQLException;
}
