/*===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 * 
 * IBM SDK, Java(tm) Technology Edition, v6
 * (C) Copyright IBM Corp. 2005, 2005. All Rights Reserved
 *
 * US Government Users Restricted Rights - Use, duplication or disclosure
 * restricted by GSA ADP Schedule Contract with IBM Corp.
 *===========================================================================
 */
/*
 * @(#)FlavorException.java	1.5 05/11/17
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package javax.print;

import javax.print.DocFlavor;

/**
 * Interface FlavorException is a mixin interface which a subclass of {@link 
 * PrintException PrintException} can implement to report an error condition 
 * involving a doc flavor or flavors (class {@link javax.print.DocFlavor 
 * DocFlavor}). The Print Service API does not define any print exception 
 * classes that implement interface FlavorException, that being left to the 
 * Print Service implementor's discretion. 
 * 
 */
public interface FlavorException {

    /**
     * Returns the unsupported flavors.
     * @return the unsupported doc flavors.
     */
    public DocFlavor[] getUnsupportedFlavors();

}
