/*========================================================================
 * IBM Confidential
 * OCO Source Materials
 *
 * IBM SDK, Java(tm) Technology Edition, v6
 * (C) Copyright IBM Corp. 2002, 2005. All Rights Reserved
 *
 * The source code for this program is not published or otherwise divested of
 * its trade secrets, irrespective of what has been deposited with the U.S.
 * Copyright office.
 *========================================================================
 */
/*
 * @(#)Heap-X-Buffer.java	1.29 05/11/17
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

// -- This file was mechanically generated: Do not edit! -- //

package java.nio;


/**



 * A read-only HeapLongBuffer.  This class extends the corresponding
 * read/write class, overriding the mutation methods to throw a {@link
 * ReadOnlyBufferException} and overriding the view-buffer methods to return an
 * instance of this class rather than of the superclass.

 */

class HeapLongBufferR
    extends HeapLongBuffer
{

    // For speed these fields are actually declared in X-Buffer;
    // these declarations are here as documentation
    /*




    */

    HeapLongBufferR(int cap, int lim) {		// package-private







	super(cap, lim);
	this.isReadOnly = true;

    }

    HeapLongBufferR(long[] buf, int off, int len) { // package-private







	super(buf, off, len);
	this.isReadOnly = true;

    }

    protected HeapLongBufferR(long[] buf,
				   int mark, int pos, int lim, int cap,
				   int off)
    {







	super(buf, mark, pos, lim, cap, off);
	this.isReadOnly = true;

    }

    public LongBuffer slice() {
	return new HeapLongBufferR(hb,
					-1,
					0,
					this.remaining(),
					this.remaining(),
					this.position() + offset);
    }

    public LongBuffer duplicate() {
	return new HeapLongBufferR(hb,
					this.markValue(),
					this.position(),
					this.limit(),
					this.capacity(),
					offset);
    }

    public LongBuffer asReadOnlyBuffer() {








	return duplicate();

    }






























    public boolean isReadOnly() {
	return true;
    }

    public LongBuffer put(long x) {




	throw new ReadOnlyBufferException();

    }

    public LongBuffer put(int i, long x) {




	throw new ReadOnlyBufferException();

    }

    public LongBuffer put(long[] src, int offset, int length) {








	throw new ReadOnlyBufferException();

    }

    public LongBuffer put(LongBuffer src) {























	throw new ReadOnlyBufferException();

    }

    public LongBuffer compact() {






	throw new ReadOnlyBufferException();

    }



































































































































































































































































































































































    public ByteOrder order() {
	return ByteOrder.nativeOrder();
    }



}
