/*========================================================================
 * IBM Confidential
 * OCO Source Materials
 *
 * IBM SDK, Java(tm) Technology Edition, v6
 * (C) Copyright IBM Corp. 2002, 2005. All Rights Reserved
 *
 * The source code for this program is not published or otherwise divested of
 * its trade secrets, irrespective of what has been deposited with the U.S.
 * Copyright office.
 *========================================================================
 */
/*
 * @(#)ByteBufferAs-X-Buffer.java	1.18 05/11/17
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

// -- This file was mechanically generated: Do not edit! -- //

package java.nio;


class ByteBufferAsDoubleBufferL			// package-private
    extends DoubleBuffer
{



    protected final ByteBuffer bb;
    protected final int offset;



    ByteBufferAsDoubleBufferL(ByteBuffer bb) {	// package-private

	super(-1, 0,
	      bb.remaining() >> 3,
	      bb.remaining() >> 3);
	this.bb = bb;
	// enforce limit == capacity
	int cap = this.capacity();
	this.limit(cap);
	int pos = this.position();
	assert (pos <= cap);
	offset = pos;



    }

    ByteBufferAsDoubleBufferL(ByteBuffer bb,
				     int mark, int pos, int lim, int cap,
				     int off)
    {

	super(mark, pos, lim, cap);
	this.bb = bb;
	offset = off;



    }

    public DoubleBuffer slice() {
	int pos = this.position();
	int lim = this.limit();
	assert (pos <= lim);
	int rem = (pos <= lim ? lim - pos : 0);
	int off = (pos << 3) + offset;
        assert (off >= 0);
	return new ByteBufferAsDoubleBufferL(bb, -1, 0, rem, rem, off);
    }

    public DoubleBuffer duplicate() {
	return new ByteBufferAsDoubleBufferL(bb,
						    this.markValue(),
						    this.position(),
						    this.limit(),
						    this.capacity(),
						    offset);
    }

    public DoubleBuffer asReadOnlyBuffer() {

	return new ByteBufferAsDoubleBufferRL(bb,
						 this.markValue(),
						 this.position(),
						 this.limit(),
						 this.capacity(),
						 offset);



    }



    protected int ix(int i) {
	return (i << 3) + offset;
    }

    public double get() {
	return Bits.getDoubleL(bb, ix(nextGetIndex()));
    }

    public double get(int i) {
	return Bits.getDoubleL(bb, ix(checkIndex(i)));
    }



    public DoubleBuffer put(double x) {

	Bits.putDoubleL(bb, ix(nextPutIndex()), x);
	return this;



    }

    public DoubleBuffer put(int i, double x) {

	Bits.putDoubleL(bb, ix(checkIndex(i)), x);
	return this;



    }

    public DoubleBuffer compact() {

	int pos = position();
	int lim = limit();
	assert (pos <= lim);
	int rem = (pos <= lim ? lim - pos : 0);

	ByteBuffer db = bb.duplicate();
 	db.limit(ix(lim));
	db.position(ix(0));
	ByteBuffer sb = db.slice();
	sb.position(pos << 3);
	sb.compact();
 	position(rem);
	limit(capacity());
	return this;



    }

    public boolean isDirect() {
	return bb.isDirect();
    }

    public boolean isReadOnly() {
	return false;
    }









































    public ByteOrder order() {




	return ByteOrder.LITTLE_ENDIAN;

    }

}
