/*
 * @(#)StringCoding.java	1.20	06/10/06
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package java.lang;

import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;
import java.security.PrivilegedActionException;                                 //IBM-use_j9
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import sun.io.MalformedInputException;                                          //IBM-use_j9
import sun.io.ByteToCharConverter;                                              //IBM-use_j9
import sun.io.CharToByteConverter;                                              //IBM-use_j9
import sun.io.Converters;                                                       //IBM-use_j9
import sun.misc.MessageUtils;                                        //ibm.55142 //IBM-use_j9
                                                                                //IBM-use_j9

import java.util.Arrays;                                                        //IBM-use_j9
import sun.nio.cs.HistoricallyNamedCharset;                                     //IBM-use_j9
                                                                                //IBM-use_j9
/**
 * Utility class for string encoding and decoding.
 */

class StringCoding {

    private StringCoding() { }

    /* The cached coders for each thread
     */
    private static ThreadLocal decoder = new ThreadLocal();
    private static ThreadLocal encoder = new ThreadLocal();

                                                                                //IBM-use_j9
    /*                                                                          //IBM-use_j9
     * Keep an n-way decoder cache per thread                                   //IBM-use_j9
     */                                                                         //IBM-use_j9
    private final static class DecoderCache {                                   //IBM-use_j9
        private static final int CACHE_SIZE = 6;                                //IBM-use_j9
        private int    max = 0;                                                 //IBM-use_j9
        private int    reuse   = 0;                                             //IBM-use_j9
        private int    current = 0;                                             //IBM-use_j9
        private String encoding [] = new String[CACHE_SIZE];                    //IBM-use_j9
        private Object decoders [] = new Object[CACHE_SIZE];                    //IBM-use_j9
                                                                                //IBM-use_j9
        /*                                                                      //IBM-use_j9
         * Make a decoder or converter by name                                  //IBM-use_j9
         */                                                                     //IBM-use_j9
        Object makeDecoder(final String enc) {                                  //IBM-use_j9
            String encoding = enc;                                              //IBM-use_j9
            if (enc.equals("\uFFFC"))                                           //IBM-use_j9
                encoding = Converters.getDefaultEncodingName();                 //IBM-use_j9
            try {                                                               //IBM-use_j9
                return (Object)ByteToCharConverter.getConverter(encoding);      //IBM-use_j9
            } catch (UnsupportedEncodingException e) {                          //IBM-use_j9
            }                                                                   //IBM-use_j9
            Charset cs;                                                         //IBM-use_j9
            try {                                                               //IBM-use_j9
                cs = Charset.forName(encoding);                                 //IBM-use_j9
            } catch (UnsupportedCharsetException x) {                           //IBM-use_j9
                //ibm.55142, 55582 start                                        //IBM-use_j9
                Object ret = null;                                              //IBM-use_j9
                if (enc.equals("\uFFFC")) {                                     //IBM-use_j9
                    String oldenc = encoding;                                   //IBM-use_j9
                    while (ret == null) {                                       //IBM-use_j9
                        encoding = Converters.getFallbackEncoding(encoding);    //IBM-use_j9
                        if (encoding == null)                                   //IBM-use_j9
                            break;                                              //IBM-use_j9
                        ret = makeDecoder(encoding);                            //IBM-use_j9
                    }                                                           //IBM-use_j9
                    warnUnsupportedCharset(oldenc, ret);                        //IBM-use_j9
                }                                                               //IBM-use_j9
                return ret;                                                     //IBM-use_j9
                //ibm.55142, 55582  end                                         //IBM-use_j9
            }                                                                   //IBM-use_j9
            return (Object)(cs.newDecoder()                                     //IBM-use_j9
                .onMalformedInput(CodingErrorAction.IGNORE)          //ibm.55235 //IBM-use_j9
                .onUnmappableCharacter(CodingErrorAction.REPLACE));  //ibm.55235 //IBM-use_j9
        }                                                                       //IBM-use_j9
                                                                                //IBM-use_j9
        /*                                                                      //IBM-use_j9
         * Get a decoder or converter by name                                   //IBM-use_j9
         */                                                                     //IBM-use_j9
        Object getDecoder(final String enc)                                     //IBM-use_j9
             throws UnsupportedEncodingException {                              //IBM-use_j9
            Object obj;                                                         //IBM-use_j9

            /* In the normal case we are using the same as previous */          //IBM-use_j9
            if (max > 0 && encoding[current].equals(enc)) {                     //IBM-use_j9
                return  decoders[current];                                      //IBM-use_j9
            }                                                                   //IBM-use_j9

            /* Try the others entries in the cache */                           //IBM-use_j9
            int i;                                                              //IBM-use_j9
            for (i=0; i<max; i++) {                                             //IBM-use_j9
                if (i!=current && encoding[i].equals(enc)) {                    //IBM-use_j9
                    current = i;                                                //IBM-use_j9
                    return decoders[i];                                         //IBM-use_j9
                }                                                               //IBM-use_j9
            }                                                                   //IBM-use_j9
            try {                                                               //IBM-use_j9
                obj = (java.security.AccessController.doPrivileged(             //IBM-use_j9
                    new java.security.PrivilegedExceptionAction() {             //IBM-use_j9
                        public Object run () {                                  //IBM-use_j9
                            return makeDecoder(enc);                            //IBM-use_j9
                        }                                                       //IBM-use_j9
                    }                                                           //IBM-use_j9
                ));                                                             //IBM-use_j9
            } catch (PrivilegedActionException e) {                             //IBM-use_j9
                throw (UnsupportedEncodingException)e.getException();           //IBM-use_j9
            } catch (java.nio.charset.IllegalCharsetNameException ee) { /*ibm@86874*/ //IBM-use_j9
                throw new UnsupportedEncodingException(enc);            /*ibm@86874*/ //IBM-use_j9
            }                                                           /*ibm@86874*/ //IBM-use_j9

            if (obj==null) {                                                    //IBM-use_j9
                throw new UnsupportedEncodingException(enc);                    //IBM-use_j9
            }                                                                   //IBM-use_j9

            /* Determine position to reuse and fill in cache */                 //IBM-use_j9
            if (max < CACHE_SIZE) {                                             //IBM-use_j9
                i = max++;                                                      //IBM-use_j9
            } else {                                                            //IBM-use_j9
                i = reuse++;             /* round robin replacement */          //IBM-use_j9
                if (reuse == CACHE_SIZE)                                        //IBM-use_j9
                    reuse = 0;                                                  //IBM-use_j9
            }                                                                   //IBM-use_j9
            decoders[i] = obj;                                                  //IBM-use_j9
            encoding[i] = enc;                                                  //IBM-use_j9
            current = i;                                                        //IBM-use_j9
            return obj;                                                         //IBM-use_j9
        }                                                                       //IBM-use_j9
    }


    /*                                                                          //IBM-use_j9
     * Keep an n-way encoder cache per thread                                   //IBM-use_j9
     */                                                                         //IBM-use_j9
    private final static class EncoderCache {                                   //IBM-use_j9
        private static final int CACHE_SIZE = 6;                                //IBM-use_j9
        private int    max = 0;                                                 //IBM-use_j9
        private int    reuse   = 0;                                             //IBM-use_j9
        private int    current = 0;                                             //IBM-use_j9
        private String encoding [] = new String[CACHE_SIZE];                    //IBM-use_j9
        private Object encoders [] = new Object[CACHE_SIZE];                    //IBM-use_j9
                                                                                //IBM-use_j9
        /*                                                                      //IBM-use_j9
         * Make a decoder or converter by name                                  //IBM-use_j9
         */                                                                     //IBM-use_j9
        Object makeEncoder(final String enc) {                                  //IBM-use_j9
            String encoding = enc;                                              //IBM-use_j9
            if (enc.equals("\uFFFC"))                                           //IBM-use_j9
                encoding = Converters.getDefaultEncodingName();                 //IBM-use_j9
            try {                                                               //IBM-use_j9
                return (Object)CharToByteConverter.getConverter(encoding);      //IBM-use_j9
            } catch (UnsupportedEncodingException e) {}                         //IBM-use_j9
            Charset cs;                                                         //IBM-use_j9
            try {                                                               //IBM-use_j9
                cs = Charset.forName(encoding);                                 //IBM-use_j9
            } catch (UnsupportedCharsetException x) {                           //IBM-use_j9
                //ibm.55142, 55582  start                                       //IBM-use_j9
                Object ret = null;                                              //IBM-use_j9
                if (enc.equals("\uFFFC")) {                                     //IBM-use_j9
                    String oldenc = encoding;                                   //IBM-use_j9
                    while (ret == null) {                                       //IBM-use_j9
                        encoding = Converters.getFallbackEncoding(encoding);    //IBM-use_j9
                        if (encoding == null)                                   //IBM-use_j9
                            break;                                              //IBM-use_j9
                        ret = makeEncoder(encoding);                            //IBM-use_j9
                    }                                                           //IBM-use_j9
                    warnUnsupportedCharset(oldenc, ret);                        //IBM-use_j9
                }                                                               //IBM-use_j9
                return ret;                                                     //IBM-use_j9
                //ibm.55142, 55582  end                                         //IBM-use_j9
            }                                                                   //IBM-use_j9
            return cs.newEncoder()                                              //IBM-use_j9
                .onMalformedInput(CodingErrorAction.IGNORE)          //ibm.55235 //IBM-use_j9
                .onUnmappableCharacter(CodingErrorAction.REPLACE);   //ibm.55235 //IBM-use_j9
        }                                                                       //IBM-use_j9
                                                                                //IBM-use_j9
        /*                                                                      //IBM-use_j9
         * Get a decoder or converter by name                                   //IBM-use_j9
         */                                                                     //IBM-use_j9
        Object getEncoder(final String enc)                                     //IBM-use_j9
             throws UnsupportedEncodingException {                              //IBM-use_j9
            Object obj;                                                         //IBM-use_j9
                                                                                //IBM-use_j9
            /* In the normal case we are using the same as previous */          //IBM-use_j9
            if (max > 0 && encoding[current].equals(enc)) {                     //IBM-use_j9
                return  encoders[current];                                      //IBM-use_j9
            }                                                                   //IBM-use_j9
                                                                                //IBM-use_j9
            /* Try the others entries in the cache */                           //IBM-use_j9
            int i;                                                              //IBM-use_j9
            for (i=0; i<max; i++) {                                             //IBM-use_j9
                if (i!=current && encoding[i].equals(enc)) {                    //IBM-use_j9
                    current = i;                                                //IBM-use_j9
                    return encoders[i];                                         //IBM-use_j9
                }                                                               //IBM-use_j9
            }                                                                   //IBM-use_j9
            try {                                                               //IBM-use_j9
                obj = (java.security.AccessController.doPrivileged(             //IBM-use_j9
                    new java.security.PrivilegedExceptionAction() {             //IBM-use_j9
                        public Object run () {                                  //IBM-use_j9
                            return makeEncoder(enc);                            //IBM-use_j9
                        }                                                       //IBM-use_j9
                    }                                                           //IBM-use_j9
                ));                                                             //IBM-use_j9
            } catch (PrivilegedActionException e) {                             //IBM-use_j9
                throw (UnsupportedEncodingException)e.getException();           //IBM-use_j9
            } catch (java.nio.charset.IllegalCharsetNameException ee) { //ibm@64726.1 //IBM-use_j9
                throw new UnsupportedEncodingException(enc);            //ibm@64726.1 //IBM-use_j9
            }                                                           //ibm@64726.1 //IBM-use_j9
                                                                                //IBM-use_j9
            if (obj==null) {                                                    //IBM-use_j9
                throw new UnsupportedEncodingException(enc);                    //IBM-use_j9
            }                                                                   //IBM-use_j9

            /* Determine position to reuse and fill in cache */                 //IBM-use_j9
            if (max < CACHE_SIZE) {                                             //IBM-use_j9
                i = max++;                                                      //IBM-use_j9
            } else {                                                            //IBM-use_j9
                i = reuse++;             /* round robin replacement */          //IBM-use_j9
                if (reuse == CACHE_SIZE)                                        //IBM-use_j9
                    reuse = 0;                                                  //IBM-use_j9
            }                                                                   //IBM-use_j9
            encoders[i] = obj;                                                  //IBM-use_j9
            encoding[i] = enc;                                                  //IBM-use_j9
            current = i;                                                        //IBM-use_j9
            return obj;                                                         //IBM-use_j9
        }                                                                       //IBM-use_j9
    }


   /*                                                                           //IBM-use_j9
    * Returns an Decoder from the cache                                         //IBM-use_j9
    */                                                                          //IBM-use_j9
    private static Object getDecoder(final String encoding)                     //IBM-use_j9
                                  throws UnsupportedEncodingException {         //IBM-use_j9
        /*                                                                      //IBM-use_j9
         * Put all object creation inside a doPriv so that it appears on        //IBM-use_j9
         * the middleware heap, and not as a cross heap reference               //IBM-use_j9
         */                                                                     //IBM-use_j9
        DecoderCache cache;                                                     //IBM-use_j9

        cache = (DecoderCache)decoder.get();                                    //IBM-use_j9
        if (cache == null) {                                                    //IBM-use_j9
            cache = (DecoderCache) (                                            //IBM-use_j9
            java.security.AccessController.doPrivileged(                        //IBM-use_j9
                new java.security.PrivilegedAction() {                          //IBM-use_j9
                public Object run () {                                          //IBM-use_j9
                    return new DecoderCache();                                  //IBM-use_j9
                }                                                               //IBM-use_j9
            }                                                                   //IBM-use_j9
            ));                                                                 //IBM-use_j9
            decoder.set(cache);                                                 //IBM-use_j9
        }                                                                       //IBM-use_j9
        return cache.getDecoder(encoding);                                      //IBM-use_j9
    }                                                                           //IBM-use_j9


   /*                                                                           //IBM-use_j9
    * Returns an Encoder from the cache                                         //IBM-use_j9
    */                                                                          //IBM-use_j9
    private static Object getEncoder(final String encoding)                     //IBM-use_j9
                                  throws UnsupportedEncodingException {         //IBM-use_j9
        /*                                                                      //IBM-use_j9
         * Put all object creation inside a doPriv so that it appears on        //IBM-use_j9
         * the middleware heap, and not as a cross heap reference               //IBM-use_j9
         */                                                                     //IBM-use_j9
        EncoderCache cache;                                                     //IBM-use_j9

        cache = (EncoderCache)encoder.get();                                    //IBM-use_j9
        if (cache == null) {                                                    //IBM-use_j9
            cache = (EncoderCache) (                                            //IBM-use_j9
            java.security.AccessController.doPrivileged(                        //IBM-use_j9
                new java.security.PrivilegedAction() {                          //IBM-use_j9
                public Object run () {                                          //IBM-use_j9
                    return new EncoderCache();                                  //IBM-use_j9
                }                                                               //IBM-use_j9
            }                                                                   //IBM-use_j9
            ));                                                                 //IBM-use_j9
            encoder.set(cache);                                                 //IBM-use_j9
        }                                                                       //IBM-use_j9
        return cache.getEncoder(encoding);                                      //IBM-use_j9
    }

                                                                                //IBM-use_j9
    /*                                                                          //IBM-use_j9
     * Trim the given byte array to the given length                            //IBM-use_j9
     */                                                                         //IBM-use_j9
    private static byte[] trim(byte[] ba, int len) {                            //IBM-use_j9
        if (len == ba.length)                                                   //IBM-use_j9
            return ba;                                                          //IBM-use_j9
        byte[] tba = new byte[len];                                             //IBM-use_j9
        System.arraycopy(ba, 0, tba, 0, len);                                   //IBM-use_j9
        return tba;                                                             //IBM-use_j9
    }

                                                                                //IBM-use_j9
    /*                                                                          //IBM-use_j9
     * Trim the given char array to the given length                            //IBM-use_j9
     */                                                                         //IBM-use_j9
    private static char[] trim(char[] ca, int len) {                            //IBM-use_j9
        if (len == ca.length)                                                   //IBM-use_j9
            return ca;                                                          //IBM-use_j9
        char[] tca = new char[len];                                             //IBM-use_j9
        System.arraycopy(ca, 0, tca, 0, len);                                   //IBM-use_j9
        return tca;                                                             //IBM-use_j9
    }

                                                                                //IBM-use_j9
    /*                                                                          //IBM-use_j9
     * Warn about unsupported charset                                           //IBM-use_j9
     */                                                                         //IBM-use_j9
    private static void warnUnsupportedCharset(String csn, Object coder) {      //IBM-use_j9
        if (coder == null) {                                                    //IBM-use_j9
            /* This is a fatal condition */                                     //IBM-use_j9
            MessageUtils.err("Error: The encoding ISO-8859-1 is not available."); //IBM-use_j9
            System.exit(1);                                                     //IBM-use_j9
        }                                                                       //IBM-use_j9
        String name = coder.toString();                                         //IBM-use_j9
        int ix = name.indexOf(": ");                                            //IBM-use_j9
        if (ix>=0)                                                              //IBM-use_j9
            name = name.substring(ix+2);                                        //IBM-use_j9
        Converters.setDefaultEncodingName(name);                                //IBM-use_j9
        MessageUtils.err("[ Warning: The encoding '" + csn +                    //IBM-use_j9
                         "' is not supported; using '" + name + "' instead. ]"); //IBM-use_j9
    }


    /*                                                                          //IBM-use_j9
     * Decode from a named charset                                              //IBM-use_j9
     */                                                                         //IBM-use_j9
    static char[] decode(String charsetName, byte[] ba, int off, int len)       //IBM-use_j9
        throws UnsupportedEncodingException {                                   //IBM-use_j9
        Object obj = getDecoder(charsetName);                                   //IBM-use_j9

        /*                                                                      //IBM-use_j9
         * ByteToCharConverter                                                  //IBM-use_j9
         */                                                                     //IBM-use_j9
        if (obj instanceof ByteToCharConverter) {                               //IBM-use_j9
            ByteToCharConverter b2c = (ByteToCharConverter)obj;                 //IBM-use_j9
            //MessageUtils.err ("IO decoder is :" + b2c);                       //IBM-use_j9
            int en = b2c.getMaxCharsPerByte() * len;                            //IBM-use_j9
            char[] ca = new char[en];                                           //IBM-use_j9
            if (len == 0)                                                       //IBM-use_j9
                return ca;                                                      //IBM-use_j9

            b2c.reset();                                                        //IBM-use_j9

            /*                                                                  //IBM-use_j9
             * Loop thru the buffer ingoring MalforedInput                      //IBM-use_j9
             */                                                                 //IBM-use_j9
            int outlen = 0;                                                     //IBM-use_j9
            int inend  = off+len;                                               //IBM-use_j9
            for (;;) {                                                          //IBM-use_j9
                try {                                                           //IBM-use_j9
                    outlen += b2c.convert(ba, off, inend, ca, outlen, en); /*ibm@61845*/ //IBM-use_j9
                    break;                                                      //IBM-use_j9
                } catch (MalformedInputException x) {                           //IBM-use_j9
                    int newoff = b2c.nextByteIndex() + b2c.getBadInputLength(); //IBM-use_j9
                    if (newoff <= off)   /* paranoid check for loop */          //IBM-use_j9
                        break;                                                  //IBM-use_j9
                    off = newoff;                                               //IBM-use_j9
                    outlen = b2c.nextCharIndex();       //ibm.52333             //IBM-use_j9
                } catch (Exception e) {                                         //IBM-use_j9
                    throw new Error(e);                                         //IBM-use_j9
                }                                                               //IBM-use_j9
            }                                                                   //IBM-use_j9

            /*                                                                  //IBM-use_j9
             * Fast return for single byte.  We can do this because neither     //IBM-use_j9
             * flush() nor trim is required.                                    //IBM-use_j9
             *                                                                  //IBM-use_j9
            if (en == outlen)                                                   //IBM-use_j9
                return ca;                                                      //IBM-use_j9

            /*                                                                  //IBM-use_j9
             * Flush the converter and trim the output                          //IBM-use_j9
             */                                                                 //IBM-use_j9
            try {                                                               //IBM-use_j9
                outlen += b2c.flush(ca, b2c.nextCharIndex(), en);               //IBM-use_j9
            } catch (MalformedInputException x) {                               //IBM-use_j9
            } catch (Exception e) {                                             //IBM-use_j9
                throw new Error(e);                                             //IBM-use_j9
            }                                                                   //IBM-use_j9
            return trim(ca, outlen);                                            //IBM-use_j9
        }                                                                       //IBM-use_j9

        /*                                                                      //IBM-use_j9
         * Charset Decoder                                                      //IBM-use_j9
         */                                                                     //IBM-use_j9
        else {                                                                  //IBM-use_j9
            CharsetDecoder cd = (CharsetDecoder)obj;                            //IBM-use_j9
            //MessageUtils.err ("NIO decoder is :" + cd);                       //IBM-use_j9
            int en = (int)(cd.maxCharsPerByte() * len);                         //IBM-use_j9
            char[] ca = new char[en];                                           //IBM-use_j9
            if (len == 0)                                                       //IBM-use_j9
                return ca;                                                      //IBM-use_j9
            cd.reset();                                                         //IBM-use_j9
            ByteBuffer bb = ByteBuffer.wrap(ba, off, len);                      //IBM-use_j9
            CharBuffer cb = CharBuffer.wrap(ca);                                //IBM-use_j9
            CoderResult cr = cd.decode(bb, cb, true);                           //IBM-use_j9
            cr = cd.flush(cb);                                                  //IBM-use_j9
            return trim(ca, cb.position());                                     //IBM-use_j9
        }                                                                       //IBM-use_j9
    }

                                                                                //IBM-use_j9
    /*                                                                          //IBM-use_j9
     * Decode from the default charset                                          //IBM-use_j9
     */                                                                         //IBM-use_j9
    static char[] decode(byte[] ba, int off, int len) {                         //IBM-use_j9
        try {                                                                   //IBM-use_j9
            return decode("\ufffc", ba, off, len);                              //IBM-use_j9
        } catch (UnsupportedEncodingException e) {                              //IBM-use_j9
            return null;                                                        //IBM-use_j9
        }                                                                       //IBM-use_j9
    }

    /*                                                                          //IBM-use_j9
     * Encode to a named charset                                                //IBM-use_j9
     */                                                                         //IBM-use_j9
    static byte[] encode(String charsetName, char[] ca, int off, int len)       //IBM-use_j9
        throws UnsupportedEncodingException {                                   //IBM-use_j9
        Object obj = getEncoder(charsetName);                                   //IBM-use_j9
                                                                                //IBM-use_j9
        /*                                                                      //IBM-use_j9
         * CharToByteConverter                                                  //IBM-use_j9
         */                                                                     //IBM-use_j9
        if (obj instanceof CharToByteConverter) {                               //IBM-use_j9
            CharToByteConverter c2b = (CharToByteConverter)obj;                 //IBM-use_j9
            int    en = c2b.getMaxBytesPerChar() * len;                         //IBM-use_j9
            byte[] ba = new byte[en];                                           //IBM-use_j9
            if (len == 0)                                                       //IBM-use_j9
                return ba;                                                      //IBM-use_j9
                                                                                //IBM-use_j9
            c2b.reset();                                                        //IBM-use_j9
            int outlen = 0;                                                     //IBM-use_j9
            int inend  = off+len;                                               //IBM-use_j9
            for (;;) {                                                          //IBM-use_j9
                try {                                                           //IBM-use_j9
                    outlen += c2b.convert(ca, off, inend, ba, outlen, en);      //IBM-use_j9
                    break;                                                      //IBM-use_j9
                } catch (MalformedInputException e) {                           //IBM-use_j9
                    /* Ignore malformed input.  Be paranoid about badInputLength */ //IBM-use_j9
                    int newoff = c2b.nextCharIndex() + c2b.getBadInputLength(); //IBM-use_j9
                    if (newoff <= off)                                          //IBM-use_j9
                        break;                                                  //IBM-use_j9
                    off = newoff;                                               //IBM-use_j9
                    outlen = c2b.nextByteIndex();     //ibm.52333               //IBM-use_j9
                } catch (Exception e) {                                         //IBM-use_j9
                    throw new Error(e);           /* Should never happen */     //IBM-use_j9
                }                                                               //IBM-use_j9
            }                                                                   //IBM-use_j9
            try {                                                               //IBM-use_j9
                outlen += c2b.flush(ba, c2b.nextByteIndex(), en);               //IBM-use_j9
            } catch (MalformedInputException x) {                               //IBM-use_j9
            } catch (Exception e) {                                             //IBM-use_j9
                throw new Error(e);                                             //IBM-use_j9
            }                                                                   //IBM-use_j9
            return trim(ba, outlen);                                            //IBM-use_j9
        }                                                                       //IBM-use_j9
                                                                                //IBM-use_j9
        /*                                                                      //IBM-use_j9
         * Charset Encoder                                                      //IBM-use_j9
         */                                                                     //IBM-use_j9
        else {                                                                  //IBM-use_j9
            CharsetEncoder ce = (CharsetEncoder)obj;                            //IBM-use_j9
            int en = (int)(ce.maxBytesPerChar() * len);                         //IBM-use_j9
            byte[] ba = new byte[en];                                           //IBM-use_j9
            if (len == 0)                                                       //IBM-use_j9
                return ba;                                                      //IBM-use_j9
                                                                                //IBM-use_j9
            ce.reset();                                                         //IBM-use_j9
            ByteBuffer bb = ByteBuffer.wrap(ba);                                //IBM-use_j9
            CharBuffer cb = CharBuffer.wrap(ca, off, len);                      //IBM-use_j9
            CoderResult cr = ce.encode(cb, bb, true);                           //IBM-use_j9
            cr = ce.flush(bb);                                                  //IBM-use_j9
            return trim(ba, bb.position());                                     //IBM-use_j9
        }                                                                       //IBM-use_j9
    }

                                                                                //IBM-use_j9
    /*                                                                          //IBM-use_j9
     * Encode to the default charset                                            //IBM-use_j9
     */                                                                         //IBM-use_j9
    static byte[] encode(char[] ca, int off, int len) {
        try {                                                                   //IBM-use_j9
            return encode("\ufffc", ca, off, len);                              //IBM-use_j9
        } catch (UnsupportedEncodingException e) {                              //IBM-use_j9
            return null;                                                        //IBM-use_j9
        }                                                                       //IBM-use_j9
    }                                                                           //IBM-use_j9
                                                                                //IBM-use_j9
    /* Required slow path code for calls that pass a charset.                   //IBM-use_j9
     * The method above of taking the Charset name and throwing                 //IBM-use_j9
     * away the Charset itself does not work if we are passed                   //IBM-use_j9
     * a non-standard Charset object that someone has written                   //IBM-use_j9
     * themselves.                                                              //IBM-use_j9
     * In the cases where we are passed a Charset object we                     //IBM-use_j9
     * need to make sure we use it or we risk failing if                        //IBM-use_j9
     * we can't find that Charset by name later.                                //IBM-use_j9
     * Sadly this means we have the slow path available still                   //IBM-use_j9
     * but as far as I know this is only used by new methods                    //IBM-use_j9
     * in java 1.6 specifically:                                                //IBM-use_j9
     * java.lang.String.String(byte[] bytes, Charset charset)                   //IBM-use_j9
     * java.lang.String.String(byte[] bytes, int offset, int length, Charset charset) //IBM-use_j9
     * java.lang.String.getBytes(Charset charset)                               //IBM-use_j9
     * so no existing users will notice the drop in performance.                //IBM-use_j9
     * The code below comes straight from Suns original                         //IBM-use_j9
     * implementation.                                                          //IBM-use_j9
     *                                                                          //IBM-use_j9
     * See CMVC 127158 or JSE-3044 for full details and a                       //IBM-use_j9
     * couple of testcases that demonstrate the problem.                        //IBM-use_j9
     */                                                                         //IBM-use_j9
                                                                                //IBM-use_j9
    // Trim the given byte array to the given length                            //IBM-use_j9
    //                                                                          //IBM-use_j9
    private static byte[] safeTrim(byte[] ba, int len, Charset cs) {            //IBM-use_j9
 	if (len == ba.length                                                   //IBM-use_j9
	    && (System.getSecurityManager() == null                             //IBM-use_j9
		|| cs.getClass().getClassLoaderImpl() == ClassLoader.systemClassLoader)) //IBM-use_j9
	    return ba;                                                          //IBM-use_j9
        else                                                                    //IBM-use_j9
            return Arrays.copyOf(ba, len);                                      //IBM-use_j9
    }                                                                           //IBM-use_j9
                                                                                //IBM-use_j9
    // Trim the given char array to the given length                            //IBM-use_j9
    //                                                                          //IBM-use_j9
    private static char[] safeTrim(char[] ca, int len, Charset cs) {            //IBM-use_j9
 	if (len == ca.length                                                   //IBM-use_j9
	    && (System.getSecurityManager() == null                             //IBM-use_j9
		|| cs.getClass().getClassLoaderImpl() == ClassLoader.systemClassLoader)) //IBM-use_j9
	    return ca;                                                          //IBM-use_j9
        else                                                                    //IBM-use_j9
            return Arrays.copyOf(ca, len);                                      //IBM-use_j9
    }                                                                           //IBM-use_j9
                                                                                //IBM-use_j9
    private static int scale(int len, float expansionFactor) {                  //IBM-use_j9
	// We need to perform double, not float, arithmetic; otherwise          //IBM-use_j9
	// we lose low order bits when len is larger than 2**24.                //IBM-use_j9
	return (int)(len * (double)expansionFactor);                            //IBM-use_j9
    }                                                                           //IBM-use_j9
                                                                                //IBM-use_j9
    // -- Decoding --                                                           //IBM-use_j9
    private static class StringDecoder {                                        //IBM-use_j9
	private final String requestedCharsetName;                              //IBM-use_j9
	private final Charset cs;                                               //IBM-use_j9
	private final CharsetDecoder cd;                                        //IBM-use_j9
                                                                                //IBM-use_j9
	private StringDecoder(Charset cs, String rcn) {                         //IBM-use_j9
            this.requestedCharsetName = rcn;                                    //IBM-use_j9
	    this.cs = cs;                                                       //IBM-use_j9
	    this.cd = cs.newDecoder()                                           //IBM-use_j9
		.onMalformedInput(CodingErrorAction.REPLACE)                    //IBM-use_j9
		.onUnmappableCharacter(CodingErrorAction.REPLACE);              //IBM-use_j9
	}                                                                       //IBM-use_j9
                                                                                //IBM-use_j9
	String charsetName() {                                                  //IBM-use_j9
 	    if (cs instanceof HistoricallyNamedCharset)                        //IBM-use_j9
 		return ((HistoricallyNamedCharset)cs).historicalName();        //IBM-use_j9
 	    return cs.name();                                                  //IBM-use_j9
	}                                                                       //IBM-use_j9
                                                                                //IBM-use_j9
	final String requestedCharsetName() {                                   //IBM-use_j9
	    return requestedCharsetName;                                        //IBM-use_j9
	}                                                                       //IBM-use_j9
                                                                                //IBM-use_j9
	char[] decode(byte[] ba, int off, int len) {                            //IBM-use_j9
	    int en = scale(len, cd.maxCharsPerByte());                          //IBM-use_j9
	    char[] ca = new char[en];                                           //IBM-use_j9
	    if (len == 0)                                                       //IBM-use_j9
		return ca;                                                      //IBM-use_j9
	    cd.reset();                                                         //IBM-use_j9
	    ByteBuffer bb = ByteBuffer.wrap(ba, off, len);                      //IBM-use_j9
	    CharBuffer cb = CharBuffer.wrap(ca);                                //IBM-use_j9
	    try {                                                               //IBM-use_j9
		CoderResult cr = cd.decode(bb, cb, true);                       //IBM-use_j9
		if (!cr.isUnderflow())                                          //IBM-use_j9
		    cr.throwException();                                        //IBM-use_j9
		cr = cd.flush(cb);                                              //IBM-use_j9
		if (!cr.isUnderflow())                                          //IBM-use_j9
		    cr.throwException();                                        //IBM-use_j9
	    } catch (CharacterCodingException x) {                              //IBM-use_j9
		// Substitution is always enabled,                              //IBM-use_j9
		// so this shouldn't happen                                     //IBM-use_j9
		throw new Error(x);                                             //IBM-use_j9
	    }                                                                   //IBM-use_j9
	    return safeTrim(ca, cb.position(), cs);                             //IBM-use_j9
	}                                                                       //IBM-use_j9
    }
                                                                                //IBM-use_j9
    static char[] decode(Charset cs, byte[] ba, int off, int len) {             //IBM-use_j9
 	StringDecoder sd = new StringDecoder(cs, cs.name());                   //IBM-use_j9
	byte[] b = Arrays.copyOf(ba, ba.length);                                //IBM-use_j9
	return sd.decode(b, off, len);                                          //IBM-use_j9
    }                                                                           //IBM-use_j9
                                                                                //IBM-use_j9
    // -- Encoding --                                                           //IBM-use_j9
    private static class StringEncoder {                                        //IBM-use_j9
	private Charset cs;                                                     //IBM-use_j9
	private CharsetEncoder ce;                                              //IBM-use_j9
	private final String requestedCharsetName;                              //IBM-use_j9
                                                                                //IBM-use_j9
	private StringEncoder(Charset cs, String rcn) {                         //IBM-use_j9
	    this.requestedCharsetName = rcn;                                    //IBM-use_j9
	    this.cs = cs;                                                       //IBM-use_j9
	    this.ce = cs.newEncoder()                                           //IBM-use_j9
		.onMalformedInput(CodingErrorAction.REPLACE)                    //IBM-use_j9
		.onUnmappableCharacter(CodingErrorAction.REPLACE);              //IBM-use_j9
	}                                                                       //IBM-use_j9
                                                                                //IBM-use_j9
	String charsetName() {                                                  //IBM-use_j9
 	    if (cs instanceof HistoricallyNamedCharset)                        //IBM-use_j9
 		return ((HistoricallyNamedCharset)cs).historicalName();        //IBM-use_j9
 	    return cs.name();                                                  //IBM-use_j9
	}                                                                       //IBM-use_j9
                                                                                //IBM-use_j9
	final String requestedCharsetName() {                                   //IBM-use_j9
	    return requestedCharsetName;                                        //IBM-use_j9
	}                                                                       //IBM-use_j9
                                                                                //IBM-use_j9
	byte[] encode(char[] ca, int off, int len) {                            //IBM-use_j9
	    int en = scale(len, ce.maxBytesPerChar());                          //IBM-use_j9
	    byte[] ba = new byte[en];                                           //IBM-use_j9
	    if (len == 0)                                                       //IBM-use_j9
		return ba;                                                      //IBM-use_j9
                                                                                //IBM-use_j9
	    ce.reset();                                                         //IBM-use_j9
	    ByteBuffer bb = ByteBuffer.wrap(ba);                                //IBM-use_j9
	    CharBuffer cb = CharBuffer.wrap(ca, off, len);                      //IBM-use_j9
	    try {                                                               //IBM-use_j9
		CoderResult cr = ce.encode(cb, bb, true);                       //IBM-use_j9
		if (!cr.isUnderflow())                                          //IBM-use_j9
		    cr.throwException();                                        //IBM-use_j9
		cr = ce.flush(bb);                                              //IBM-use_j9
		if (!cr.isUnderflow())                                          //IBM-use_j9
		    cr.throwException();                                        //IBM-use_j9
	    } catch (CharacterCodingException x) {                              //IBM-use_j9
		// Substitution is always enabled,                              //IBM-use_j9
		// so this shouldn't happen                                     //IBM-use_j9
		throw new Error(x);                                             //IBM-use_j9
	    }                                                                   //IBM-use_j9
	    return safeTrim(ba, bb.position(), cs);                             //IBM-use_j9
	}                                                                       //IBM-use_j9
    }                                                                           //IBM-use_j9
                                                                                //IBM-use_j9
    static byte[] encode(Charset cs, char[] ca, int off, int len) {             //IBM-use_j9
	StringEncoder se = new StringEncoder(cs, cs.name());                    //IBM-use_j9
	char[] c = Arrays.copyOf(ca, ca.length);                                //IBM-use_j9
	return se.encode(c, off, len);                                          //IBM-use_j9
    }                                                                           //IBM-use_j9
                                                                                //IBM-use_j9
}
//IBM-use_j9
