/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.RSAPrivateCrtKey;
import com.ibm.crypto.provider.RSAPublicKey;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;

public final class RSAKeyPairGenerator
extends KeyPairGeneratorSpi {
    private BigInteger a;
    private int b = 1024;
    SecureRandom c = null;
    private static String[] z;

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof RSAKeyGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException(z[3]);
        }
        RSAKeyGenParameterSpec rSAKeyGenParameterSpec = (RSAKeyGenParameterSpec)algorithmParameterSpec;
        int n2 = rSAKeyGenParameterSpec.getKeysize();
        this.a = rSAKeyGenParameterSpec.getPublicExponent();
        this.c = secureRandom;
        if (n2 < 512) {
            throw new InvalidAlgorithmParameterException(z[1]);
        }
        if (n2 > 65536) {
            throw new InvalidAlgorithmParameterException(z[0]);
        }
        if (n2 % 8 != 0) {
            throw new InvalidAlgorithmParameterException(z[5]);
        }
        this.b = n2;
        if (this.a == null) {
            this.a = RSAKeyGenParameterSpec.F4;
        } else {
            if (this.a.compareTo(RSAKeyGenParameterSpec.F0) < 0) {
                throw new InvalidAlgorithmParameterException(z[4]);
            }
            if (this.a.bitLength() > n2) {
                throw new InvalidAlgorithmParameterException(z[2]);
            }
        }
    }

    public void initialize(int n2, SecureRandom secureRandom) {
        if (n2 < 512) {
            throw new InvalidParameterException(z[1]);
        }
        if (n2 > 65536) {
            throw new InvalidParameterException(z[0]);
        }
        if (n2 % 8 != 0) {
            throw new InvalidParameterException(z[5]);
        }
        this.b = n2;
        this.c = secureRandom;
        this.a = RSAKeyGenParameterSpec.F4;
    }

    public void initialize(int n2) {
        if (n2 < 512) {
            throw new InvalidParameterException(z[1]);
        }
        if (n2 > 65536) {
            throw new InvalidParameterException(z[0]);
        }
        if (n2 % 8 != 0) {
            throw new InvalidParameterException(z[5]);
        }
        this.b = n2;
        try {
            this.c = SecureRandom.getInstance(z[6]);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.c = new SecureRandom();
        }
        this.a = RSAKeyGenParameterSpec.F4;
    }

    public KeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        BigInteger bigInteger5;
        BigInteger bigInteger6;
        int n2;
        if (this.c == null) {
            this.c = null;
            try {
                this.c = SecureRandom.getInstance(z[6]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.c = new SecureRandom();
            }
        }
        BigInteger bigInteger7 = this.a != null ? this.a : RSAKeyGenParameterSpec.F4;
        while ((n2 = (bigInteger6 = (bigInteger5 = new BigInteger(this.b / 2, 10, this.c)).multiply(bigInteger4 = new BigInteger(this.b / 2, 10, this.c))).bitLength()) != this.b || !bigInteger7.gcd(bigInteger3 = (bigInteger2 = bigInteger5.subtract(BigInteger.ONE)).multiply(bigInteger = bigInteger4.subtract(BigInteger.ONE))).equals(BigInteger.ONE)) {
        }
        BigInteger bigInteger8 = bigInteger7.modInverse(bigInteger3);
        BigInteger bigInteger9 = bigInteger8.mod(bigInteger2);
        BigInteger bigInteger10 = bigInteger8.mod(bigInteger);
        BigInteger bigInteger11 = bigInteger4.modInverse(bigInteger5);
        try {
            RSAPublicKey rSAPublicKey = new RSAPublicKey(bigInteger6, bigInteger7);
            RSAPrivateCrtKey rSAPrivateCrtKey = new RSAPrivateCrtKey(bigInteger6, bigInteger8, bigInteger7, bigInteger5, bigInteger4, bigInteger9, bigInteger10, bigInteger11);
            return new KeyPair(rSAPublicKey, rSAPrivateCrtKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ProviderException(invalidKeyException.getMessage());
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block69: {
            int n2;
            int n3;
            block68: {
                char[] cArray2;
                Object var0;
                block67: {
                    int n4;
                    block66: {
                        char[] cArray3;
                        block65: {
                            int n5;
                            block64: {
                                char[] cArray4;
                                block63: {
                                    int n6;
                                    block62: {
                                        char[] cArray5;
                                        block61: {
                                            int n7;
                                            block60: {
                                                char[] cArray6;
                                                block59: {
                                                    int n8;
                                                    block58: {
                                                        char[] cArray7;
                                                        block57: {
                                                            int n9;
                                                            block56: {
                                                                stringArray = new String[7];
                                                                var0 = null;
                                                                char[] cArray8 = "A.x\tIy2<\u000fLv$<\u0011P\u007f5<\u001e@, h\\Hc2h\\\u00139t/J".toCharArray();
                                                                cArray7 = cArray8;
                                                                n9 = cArray8.length;
                                                                n3 = 0;
                                                                if (!true) break block56;
                                                                n9 = n9;
                                                                if (n9 <= n3) break block57;
                                                            }
                                                            do {
                                                                int n10;
                                                                cArray7 = cArray7;
                                                                int n11 = n3;
                                                                char c2 = cArray7[n11];
                                                                switch (n3 % 5) {
                                                                    case 0: {
                                                                        n10 = 12;
                                                                        break;
                                                                    }
                                                                    case 1: {
                                                                        n10 = 65;
                                                                        break;
                                                                    }
                                                                    case 2: {
                                                                        n10 = 28;
                                                                        break;
                                                                    }
                                                                    case 3: {
                                                                        n10 = 124;
                                                                        break;
                                                                    }
                                                                    default: {
                                                                        n10 = 37;
                                                                    }
                                                                }
                                                                cArray7[n11] = (char)(c2 ^ n10);
                                                                ++n3;
                                                                n9 = n9;
                                                            } while (n9 > n3);
                                                        }
                                                        stringArray[0] = new String(cArray7).intern();
                                                        var0 = null;
                                                        char[] cArray9 = "A.x\tIy2<\u000fLv$<\u0011P\u007f5<\u001e@, h\\Ii o\b\u00059p.".toCharArray();
                                                        cArray6 = cArray9;
                                                        n8 = cArray9.length;
                                                        n3 = 0;
                                                        if (!true) break block58;
                                                        n8 = n8;
                                                        if (n8 <= n3) break block59;
                                                    }
                                                    do {
                                                        int n12;
                                                        cArray6 = cArray6;
                                                        int n13 = n3;
                                                        char c3 = cArray6[n13];
                                                        switch (n3 % 5) {
                                                            case 0: {
                                                                n12 = 12;
                                                                break;
                                                            }
                                                            case 1: {
                                                                n12 = 65;
                                                                break;
                                                            }
                                                            case 2: {
                                                                n12 = 28;
                                                                break;
                                                            }
                                                            case 3: {
                                                                n12 = 124;
                                                                break;
                                                            }
                                                            default: {
                                                                n12 = 37;
                                                            }
                                                        }
                                                        cArray6[n13] = (char)(c3 ^ n12);
                                                        ++n3;
                                                        n8 = n8;
                                                    } while (n8 > n3);
                                                }
                                                stringArray[1] = new String(cArray6).intern();
                                                var0 = null;
                                                char[] cArray10 = "\\4~\u0010Loay\u0004Uc/y\u0012Q,,i\u000fQ,#y\\Va p\u0010@~ah\u0014Dbaw\u0019\\,2u\u0006@".toCharArray();
                                                cArray5 = cArray10;
                                                n7 = cArray10.length;
                                                n3 = 0;
                                                if (!true) break block60;
                                                n7 = n7;
                                                if (n7 <= n3) break block61;
                                            }
                                            do {
                                                int n14;
                                                cArray5 = cArray5;
                                                int n15 = n3;
                                                char c4 = cArray5[n15];
                                                switch (n3 % 5) {
                                                    case 0: {
                                                        n14 = 12;
                                                        break;
                                                    }
                                                    case 1: {
                                                        n14 = 65;
                                                        break;
                                                    }
                                                    case 2: {
                                                        n14 = 28;
                                                        break;
                                                    }
                                                    case 3: {
                                                        n14 = 124;
                                                        break;
                                                    }
                                                    default: {
                                                        n14 = 37;
                                                    }
                                                }
                                                cArray5[n15] = (char)(c4 ^ n14);
                                                ++n3;
                                                n7 = n7;
                                            } while (n7 > n3);
                                        }
                                        stringArray[2] = new String(cArray5).intern();
                                        var0 = null;
                                        char[] cArray11 = "\\ n\u001dH\u007faq\tVxa~\u0019\u0005e/o\bDb\"y\\JjaN/dG$e;@b\u0011}\u000eDa$h\u0019W_1y\u001f".toCharArray();
                                        cArray4 = cArray11;
                                        n6 = cArray11.length;
                                        n3 = 0;
                                        if (!true) break block62;
                                        n6 = n6;
                                        if (n6 <= n3) break block63;
                                    }
                                    do {
                                        int n16;
                                        cArray4 = cArray4;
                                        int n17 = n3;
                                        char c5 = cArray4[n17];
                                        switch (n3 % 5) {
                                            case 0: {
                                                n16 = 12;
                                                break;
                                            }
                                            case 1: {
                                                n16 = 65;
                                                break;
                                            }
                                            case 2: {
                                                n16 = 28;
                                                break;
                                            }
                                            case 3: {
                                                n16 = 124;
                                                break;
                                            }
                                            default: {
                                                n16 = 37;
                                            }
                                        }
                                        cArray4[n17] = (char)(c5 ^ n16);
                                        ++n3;
                                        n6 = n6;
                                    } while (n6 > n3);
                                }
                                stringArray[3] = new String(cArray4).intern();
                                var0 = null;
                                char[] cArray12 = "\\4~\u0010Loay\u0004Uc/y\u0012Q,,i\u000fQ,#y\\\u0016,.n\\Im3{\u0019W".toCharArray();
                                cArray3 = cArray12;
                                n5 = cArray12.length;
                                n3 = 0;
                                if (!true) break block64;
                                n5 = n5;
                                if (n5 <= n3) break block65;
                            }
                            do {
                                int n18;
                                cArray3 = cArray3;
                                int n19 = n3;
                                char c6 = cArray3[n19];
                                switch (n3 % 5) {
                                    case 0: {
                                        n18 = 12;
                                        break;
                                    }
                                    case 1: {
                                        n18 = 65;
                                        break;
                                    }
                                    case 2: {
                                        n18 = 28;
                                        break;
                                    }
                                    case 3: {
                                        n18 = 124;
                                        break;
                                    }
                                    default: {
                                        n18 = 37;
                                    }
                                }
                                cArray3[n19] = (char)(c6 ^ n18);
                                ++n3;
                                n5 = n5;
                            } while (n5 > n3);
                        }
                        stringArray[4] = new String(cArray3).intern();
                        var0 = null;
                        char[] cArray13 = "A.x\tIy2<\u000fLv$<\u0011P\u007f5<\u001e@,,i\u0010Qe1p\u0019\u0005c'<D".toCharArray();
                        cArray2 = cArray13;
                        n4 = cArray13.length;
                        n3 = 0;
                        if (!true) break block66;
                        n4 = n4;
                        if (n4 <= n3) break block67;
                    }
                    do {
                        int n20;
                        cArray2 = cArray2;
                        int n21 = n3;
                        char c7 = cArray2[n21];
                        switch (n3 % 5) {
                            case 0: {
                                n20 = 12;
                                break;
                            }
                            case 1: {
                                n20 = 65;
                                break;
                            }
                            case 2: {
                                n20 = 28;
                                break;
                            }
                            case 3: {
                                n20 = 124;
                                break;
                            }
                            default: {
                                n20 = 37;
                            }
                        }
                        cArray2[n21] = (char)(c7 ^ n20);
                        ++n3;
                        n4 = n4;
                    } while (n4 > n3);
                }
                stringArray[5] = new String(cArray2).intern();
                var0 = null;
                char[] cArray14 = "E\u0003Q/@o4n\u0019wm/x\u0013H".toCharArray();
                cArray = cArray14;
                n2 = cArray14.length;
                n3 = 0;
                if (!true) break block68;
                n2 = n2;
                if (n2 <= n3) break block69;
            }
            do {
                int n22;
                cArray = cArray;
                int n23 = n3;
                char c8 = cArray[n23];
                switch (n3 % 5) {
                    case 0: {
                        n22 = 12;
                        break;
                    }
                    case 1: {
                        n22 = 65;
                        break;
                    }
                    case 2: {
                        n22 = 28;
                        break;
                    }
                    case 3: {
                        n22 = 124;
                        break;
                    }
                    default: {
                        n22 = 37;
                    }
                }
                cArray[n23] = (char)(c8 ^ n22);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        stringArray[6] = new String(cArray).intern();
        z = stringArray;
    }
}

