/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.RSAPrivateCrtKey;
import com.ibm.crypto.provider.RSAPrivateKey;
import com.ibm.crypto.provider.RSAPublicKey;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class RSAKeyFactory
extends KeyFactorySpi {
    private static String[] z;

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof RSAPublicKeySpec) {
                RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)keySpec;
                return new RSAPublicKey(rSAPublicKeySpec.getModulus(), rSAPublicKeySpec.getPublicExponent());
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                return new RSAPublicKey(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException(z[1]);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(z[0] + invalidKeyException.getMessage());
        }
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                try {
                    return new RSAPrivateCrtKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                }
                catch (InvalidKeyException invalidKeyException) {
                    return new RSAPrivateKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                }
            }
            if (keySpec instanceof RSAPrivateCrtKeySpec) {
                RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = (RSAPrivateCrtKeySpec)keySpec;
                return new RSAPrivateCrtKey(rSAPrivateCrtKeySpec.getModulus(), rSAPrivateCrtKeySpec.getPrivateExponent(), rSAPrivateCrtKeySpec.getPublicExponent(), rSAPrivateCrtKeySpec.getPrimeP(), rSAPrivateCrtKeySpec.getPrimeQ(), rSAPrivateCrtKeySpec.getPrimeExponentP(), rSAPrivateCrtKeySpec.getPrimeExponentQ(), rSAPrivateCrtKeySpec.getCrtCoefficient());
            }
            if (keySpec instanceof RSAPrivateKeySpec) {
                RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)keySpec;
                return new RSAPrivateKey(rSAPrivateKeySpec.getModulus(), rSAPrivateKeySpec.getPrivateExponent());
            }
            throw new InvalidKeySpecException(z[1]);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(z[0] + invalidKeyException.getMessage());
        }
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        try {
            if (key instanceof java.security.interfaces.RSAPublicKey) {
                Class<?> clazz2 = Class.forName(z[6]);
                Class<?> clazz3 = Class.forName(z[7]);
                if (clazz2.isAssignableFrom(clazz)) {
                    java.security.interfaces.RSAPublicKey rSAPublicKey = (java.security.interfaces.RSAPublicKey)key;
                    return new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
                }
                if (clazz3.isAssignableFrom(clazz)) {
                    return new X509EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException(z[1]);
            }
            if (key instanceof java.security.interfaces.RSAPrivateCrtKey) {
                Class<?> clazz4 = Class.forName(z[4]);
                Class<?> clazz5 = Class.forName(z[10]);
                if (clazz4.isAssignableFrom(clazz)) {
                    java.security.interfaces.RSAPrivateCrtKey rSAPrivateCrtKey = (java.security.interfaces.RSAPrivateCrtKey)key;
                    return new RSAPrivateCrtKeySpec(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
                }
                if (clazz5.isAssignableFrom(clazz)) {
                    return new PKCS8EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException(z[1]);
            }
            if (key instanceof java.security.interfaces.RSAPrivateKey) {
                Class<?> clazz6 = Class.forName(z[9]);
                Class<?> clazz7 = Class.forName(z[10]);
                if (clazz6.isAssignableFrom(clazz)) {
                    java.security.interfaces.RSAPrivateKey rSAPrivateKey = (java.security.interfaces.RSAPrivateKey)key;
                    return new RSAPrivateKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
                }
                if (clazz7.isAssignableFrom(clazz)) {
                    return new PKCS8EncodedKeySpec(key.getEncoded());
                }
                throw new InvalidKeySpecException(z[1]);
            }
            throw new InvalidKeySpecException(z[8]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidKeySpecException(z[5] + classNotFoundException.getMessage());
        }
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        try {
            if (key instanceof java.security.interfaces.RSAPublicKey) {
                if (key instanceof RSAPublicKey) {
                    return key;
                }
                RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)this.engineGetKeySpec(key, RSAPublicKeySpec.class);
                return this.engineGeneratePublic(rSAPublicKeySpec);
            }
            if (key instanceof java.security.interfaces.RSAPrivateCrtKey) {
                if (key instanceof RSAPrivateCrtKey) {
                    return key;
                }
                RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)this.engineGetKeySpec(key, RSAPrivateCrtKeySpec.class);
                return this.engineGeneratePrivate(rSAPrivateKeySpec);
            }
            if (key instanceof java.security.interfaces.RSAPrivateKey) {
                if (key instanceof RSAPrivateKey) {
                    return key;
                }
                RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)this.engineGetKeySpec(key, RSAPrivateKeySpec.class);
                return this.engineGeneratePrivate(rSAPrivateKeySpec);
            }
            throw new InvalidKeyException(z[3]);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException(z[2] + invalidKeySpecException.getMessage());
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block109: {
            int n2;
            int n3;
            block108: {
                char[] cArray2;
                Object var0;
                block107: {
                    int n4;
                    block106: {
                        char[] cArray3;
                        block105: {
                            int n5;
                            block104: {
                                char[] cArray4;
                                block103: {
                                    int n6;
                                    block102: {
                                        char[] cArray5;
                                        block101: {
                                            int n7;
                                            block100: {
                                                char[] cArray6;
                                                block99: {
                                                    int n8;
                                                    block98: {
                                                        char[] cArray7;
                                                        block97: {
                                                            int n9;
                                                            block96: {
                                                                char[] cArray8;
                                                                block95: {
                                                                    int n10;
                                                                    block94: {
                                                                        char[] cArray9;
                                                                        block93: {
                                                                            int n11;
                                                                            block92: {
                                                                                char[] cArray10;
                                                                                block91: {
                                                                                    int n12;
                                                                                    block90: {
                                                                                        char[] cArray11;
                                                                                        block89: {
                                                                                            int n13;
                                                                                            block88: {
                                                                                                stringArray = new String[11];
                                                                                                var0 = null;
                                                                                                char[] cArray12 = "[A=C:`@,A#s[9\u0013!wV|@:wL5U#qN(Z%|\u0015|".toCharArray();
                                                                                                cArray11 = cArray12;
                                                                                                n13 = cArray12.length;
                                                                                                n3 = 0;
                                                                                                if (!true) break block88;
                                                                                                n13 = n13;
                                                                                                if (n13 <= n3) break block89;
                                                                                            }
                                                                                            do {
                                                                                                int n14;
                                                                                                cArray11 = cArray11;
                                                                                                int n15 = n3;
                                                                                                char c2 = cArray11[n15];
                                                                                                switch (n3 % 5) {
                                                                                                    case 0: {
                                                                                                        n14 = 18;
                                                                                                        break;
                                                                                                    }
                                                                                                    case 1: {
                                                                                                        n14 = 47;
                                                                                                        break;
                                                                                                    }
                                                                                                    case 2: {
                                                                                                        n14 = 92;
                                                                                                        break;
                                                                                                    }
                                                                                                    case 3: {
                                                                                                        n14 = 51;
                                                                                                        break;
                                                                                                    }
                                                                                                    default: {
                                                                                                        n14 = 74;
                                                                                                    }
                                                                                                }
                                                                                                cArray11[n15] = (char)(c2 ^ n14);
                                                                                                ++n3;
                                                                                                n13 = n13;
                                                                                            } while (n13 > n3);
                                                                                        }
                                                                                        stringArray[0] = new String(cArray11).intern();
                                                                                        var0 = null;
                                                                                        char[] cArray13 = "[A=C:`@,A#s[9\u0013!wV|@:wL5U#qN(Z%|".toCharArray();
                                                                                        cArray10 = cArray13;
                                                                                        n12 = cArray13.length;
                                                                                        n3 = 0;
                                                                                        if (!true) break block90;
                                                                                        n12 = n12;
                                                                                        if (n12 <= n3) break block91;
                                                                                    }
                                                                                    do {
                                                                                        int n16;
                                                                                        cArray10 = cArray10;
                                                                                        int n17 = n3;
                                                                                        char c3 = cArray10[n17];
                                                                                        switch (n3 % 5) {
                                                                                            case 0: {
                                                                                                n16 = 18;
                                                                                                break;
                                                                                            }
                                                                                            case 1: {
                                                                                                n16 = 47;
                                                                                                break;
                                                                                            }
                                                                                            case 2: {
                                                                                                n16 = 92;
                                                                                                break;
                                                                                            }
                                                                                            case 3: {
                                                                                                n16 = 51;
                                                                                                break;
                                                                                            }
                                                                                            default: {
                                                                                                n16 = 74;
                                                                                            }
                                                                                        }
                                                                                        cArray10[n17] = (char)(c3 ^ n16);
                                                                                        ++n3;
                                                                                        n12 = n12;
                                                                                    } while (n12 > n3);
                                                                                }
                                                                                stringArray[1] = new String(cArray10).intern();
                                                                                var0 = null;
                                                                                char[] cArray14 = "QN2]%f\u000f(A+|\\0R>w\u000f7V3(\u000f".toCharArray();
                                                                                cArray9 = cArray14;
                                                                                n11 = cArray14.length;
                                                                                n3 = 0;
                                                                                if (!true) break block92;
                                                                                n11 = n11;
                                                                                if (n11 <= n3) break block93;
                                                                            }
                                                                            do {
                                                                                int n18;
                                                                                cArray9 = cArray9;
                                                                                int n19 = n3;
                                                                                char c4 = cArray9[n19];
                                                                                switch (n3 % 5) {
                                                                                    case 0: {
                                                                                        n18 = 18;
                                                                                        break;
                                                                                    }
                                                                                    case 1: {
                                                                                        n18 = 47;
                                                                                        break;
                                                                                    }
                                                                                    case 2: {
                                                                                        n18 = 92;
                                                                                        break;
                                                                                    }
                                                                                    case 3: {
                                                                                        n18 = 51;
                                                                                        break;
                                                                                    }
                                                                                    default: {
                                                                                        n18 = 74;
                                                                                    }
                                                                                }
                                                                                cArray9[n19] = (char)(c4 ^ n18);
                                                                                ++n3;
                                                                                n11 = n11;
                                                                            } while (n11 > n3);
                                                                        }
                                                                        stringArray[2] = new String(cArray9).intern();
                                                                        var0 = null;
                                                                        char[] cArray15 = "E]3]-2N0T%`F(['2[%C/".toCharArray();
                                                                        cArray8 = cArray15;
                                                                        n10 = cArray15.length;
                                                                        n3 = 0;
                                                                        if (!true) break block94;
                                                                        n10 = n10;
                                                                        if (n10 <= n3) break block95;
                                                                    }
                                                                    do {
                                                                        int n20;
                                                                        cArray8 = cArray8;
                                                                        int n21 = n3;
                                                                        char c5 = cArray8[n21];
                                                                        switch (n3 % 5) {
                                                                            case 0: {
                                                                                n20 = 18;
                                                                                break;
                                                                            }
                                                                            case 1: {
                                                                                n20 = 47;
                                                                                break;
                                                                            }
                                                                            case 2: {
                                                                                n20 = 92;
                                                                                break;
                                                                            }
                                                                            case 3: {
                                                                                n20 = 51;
                                                                                break;
                                                                            }
                                                                            default: {
                                                                                n20 = 74;
                                                                            }
                                                                        }
                                                                        cArray8[n21] = (char)(c5 ^ n20);
                                                                        ++n3;
                                                                        n10 = n10;
                                                                    } while (n10 > n3);
                                                                }
                                                                stringArray[3] = new String(cArray8).intern();
                                                                var0 = null;
                                                                char[] cArray16 = "xN*RdaJ?F8{[%\u001d9bJ?\u001d\u0018An\fA#dN(V\t`[\u0017V3A_9P".toCharArray();
                                                                cArray7 = cArray16;
                                                                n9 = cArray16.length;
                                                                n3 = 0;
                                                                if (!true) break block96;
                                                                n9 = n9;
                                                                if (n9 <= n3) break block97;
                                                            }
                                                            do {
                                                                int n22;
                                                                cArray7 = cArray7;
                                                                int n23 = n3;
                                                                char c6 = cArray7[n23];
                                                                switch (n3 % 5) {
                                                                    case 0: {
                                                                        n22 = 18;
                                                                        break;
                                                                    }
                                                                    case 1: {
                                                                        n22 = 47;
                                                                        break;
                                                                    }
                                                                    case 2: {
                                                                        n22 = 92;
                                                                        break;
                                                                    }
                                                                    case 3: {
                                                                        n22 = 51;
                                                                        break;
                                                                    }
                                                                    default: {
                                                                        n22 = 74;
                                                                    }
                                                                }
                                                                cArray7[n23] = (char)(c6 ^ n22);
                                                                ++n3;
                                                                n9 = n9;
                                                            } while (n9 > n3);
                                                        }
                                                        stringArray[4] = new String(cArray7).intern();
                                                        var0 = null;
                                                        char[] cArray17 = "GA/F:b@.G/v\u000f7V32\\,V){I5P+fF3]p2".toCharArray();
                                                        cArray6 = cArray17;
                                                        n8 = cArray17.length;
                                                        n3 = 0;
                                                        if (!true) break block98;
                                                        n8 = n8;
                                                        if (n8 <= n3) break block99;
                                                    }
                                                    do {
                                                        int n24;
                                                        cArray6 = cArray6;
                                                        int n25 = n3;
                                                        char c7 = cArray6[n25];
                                                        switch (n3 % 5) {
                                                            case 0: {
                                                                n24 = 18;
                                                                break;
                                                            }
                                                            case 1: {
                                                                n24 = 47;
                                                                break;
                                                            }
                                                            case 2: {
                                                                n24 = 92;
                                                                break;
                                                            }
                                                            case 3: {
                                                                n24 = 51;
                                                                break;
                                                            }
                                                            default: {
                                                                n24 = 74;
                                                            }
                                                        }
                                                        cArray6[n25] = (char)(c7 ^ n24);
                                                        ++n3;
                                                        n8 = n8;
                                                    } while (n8 > n3);
                                                }
                                                stringArray[5] = new String(cArray6).intern();
                                                var0 = null;
                                                char[] cArray18 = "xN*RdaJ?F8{[%\u001d9bJ?\u001d\u0018An\fF(~F?x/k|,V)".toCharArray();
                                                cArray5 = cArray18;
                                                n7 = cArray18.length;
                                                n3 = 0;
                                                if (!true) break block100;
                                                n7 = n7;
                                                if (n7 <= n3) break block101;
                                            }
                                            do {
                                                int n26;
                                                cArray5 = cArray5;
                                                int n27 = n3;
                                                char c8 = cArray5[n27];
                                                switch (n3 % 5) {
                                                    case 0: {
                                                        n26 = 18;
                                                        break;
                                                    }
                                                    case 1: {
                                                        n26 = 47;
                                                        break;
                                                    }
                                                    case 2: {
                                                        n26 = 92;
                                                        break;
                                                    }
                                                    case 3: {
                                                        n26 = 51;
                                                        break;
                                                    }
                                                    default: {
                                                        n26 = 74;
                                                    }
                                                }
                                                cArray5[n27] = (char)(c8 ^ n26);
                                                ++n3;
                                                n7 = n7;
                                            } while (n7 > n3);
                                        }
                                        stringArray[6] = new String(cArray5).intern();
                                        var0 = null;
                                        char[] cArray19 = "xN*RdaJ?F8{[%\u001d9bJ?\u001d\u0012'\u001fev$q@8V.YJ%`:wL".toCharArray();
                                        cArray4 = cArray19;
                                        n6 = cArray19.length;
                                        n3 = 0;
                                        if (!true) break block102;
                                        n6 = n6;
                                        if (n6 <= n3) break block103;
                                    }
                                    do {
                                        int n28;
                                        cArray4 = cArray4;
                                        int n29 = n3;
                                        char c9 = cArray4[n29];
                                        switch (n3 % 5) {
                                            case 0: {
                                                n28 = 18;
                                                break;
                                            }
                                            case 1: {
                                                n28 = 47;
                                                break;
                                            }
                                            case 2: {
                                                n28 = 92;
                                                break;
                                            }
                                            case 3: {
                                                n28 = 51;
                                                break;
                                            }
                                            default: {
                                                n28 = 74;
                                            }
                                        }
                                        cArray4[n29] = (char)(c9 ^ n28);
                                        ++n3;
                                        n6 = n6;
                                    } while (n6 > n3);
                                }
                                stringArray[7] = new String(cArray4).intern();
                                var0 = null;
                                char[] cArray20 = "[A=C:`@,A#s[9\u0013!wV|G3bJ".toCharArray();
                                cArray3 = cArray20;
                                n5 = cArray20.length;
                                n3 = 0;
                                if (!true) break block104;
                                n5 = n5;
                                if (n5 <= n3) break block105;
                            }
                            do {
                                int n30;
                                cArray3 = cArray3;
                                int n31 = n3;
                                char c10 = cArray3[n31];
                                switch (n3 % 5) {
                                    case 0: {
                                        n30 = 18;
                                        break;
                                    }
                                    case 1: {
                                        n30 = 47;
                                        break;
                                    }
                                    case 2: {
                                        n30 = 92;
                                        break;
                                    }
                                    case 3: {
                                        n30 = 51;
                                        break;
                                    }
                                    default: {
                                        n30 = 74;
                                    }
                                }
                                cArray3[n31] = (char)(c10 ^ n30);
                                ++n3;
                                n5 = n5;
                            } while (n5 > n3);
                        }
                        stringArray[8] = new String(cArray3).intern();
                        var0 = null;
                        char[] cArray21 = "xN*RdaJ?F8{[%\u001d9bJ?\u001d\u0018An\fA#dN(V\u0001wV\u000fC/q".toCharArray();
                        cArray2 = cArray21;
                        n4 = cArray21.length;
                        n3 = 0;
                        if (!true) break block106;
                        n4 = n4;
                        if (n4 <= n3) break block107;
                    }
                    do {
                        int n32;
                        cArray2 = cArray2;
                        int n33 = n3;
                        char c11 = cArray2[n33];
                        switch (n3 % 5) {
                            case 0: {
                                n32 = 18;
                                break;
                            }
                            case 1: {
                                n32 = 47;
                                break;
                            }
                            case 2: {
                                n32 = 92;
                                break;
                            }
                            case 3: {
                                n32 = 51;
                                break;
                            }
                            default: {
                                n32 = 74;
                            }
                        }
                        cArray2[n33] = (char)(c11 ^ n32);
                        ++n3;
                        n4 = n4;
                    } while (n4 > n3);
                }
                stringArray[9] = new String(cArray2).intern();
                var0 = null;
                char[] cArray22 = "xN*RdaJ?F8{[%\u001d9bJ?\u001d\u001aYl\u000f\u000b\u000f|L3W/vd9J\u0019bJ?".toCharArray();
                cArray = cArray22;
                n2 = cArray22.length;
                n3 = 0;
                if (!true) break block108;
                n2 = n2;
                if (n2 <= n3) break block109;
            }
            do {
                int n34;
                cArray = cArray;
                int n35 = n3;
                char c12 = cArray[n35];
                switch (n3 % 5) {
                    case 0: {
                        n34 = 18;
                        break;
                    }
                    case 1: {
                        n34 = 47;
                        break;
                    }
                    case 2: {
                        n34 = 92;
                        break;
                    }
                    case 3: {
                        n34 = 51;
                        break;
                    }
                    default: {
                        n34 = 74;
                    }
                }
                cArray[n35] = (char)(c12 ^ n34);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        stringArray[10] = new String(cArray).intern();
        z = stringArray;
    }
}

