/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.provider;

import com.ibm.crypto.provider.n;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.security.AccessController;
import java.security.Identity;
import java.security.IdentityScope;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signer;
import java.util.Enumeration;
import java.util.Hashtable;

public class IdentityDatabase
extends IdentityScope
implements Serializable {
    private static final long serialVersionUID = 4923799573357658384L;
    private static final boolean debug = false;
    private static final boolean error = true;
    File sourceFile;
    Hashtable identities = new Hashtable();
    private static String[] z;

    IdentityDatabase() throws InvalidParameterException {
        this(z[13]);
    }

    public IdentityDatabase(File file) throws InvalidParameterException {
        this(file.getName());
        this.sourceFile = file;
    }

    public IdentityDatabase(String string) throws InvalidParameterException {
        super(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IdentityDatabase fromStream(InputStream inputStream) throws IOException {
        IdentityDatabase identityDatabase = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Object object = objectInputStream.readObject();
            if (object instanceof IdentityDatabase) {
                identityDatabase = (IdentityDatabase)object;
            } else {
                Enumeration enumeration = ((sun.security.provider.IdentityDatabase)object).identities();
                identityDatabase = new IdentityDatabase();
                while (enumeration.hasMoreElements()) {
                    try {
                        identityDatabase.addIdentity((Identity)enumeration.nextElement());
                    }
                    catch (KeyManagementException keyManagementException) {
                        throw new IOException(keyManagementException.getMessage());
                    }
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            IdentityDatabase.a(z[18], classNotFoundException);
            IdentityDatabase.b(z[21]);
        }
        catch (InvalidClassException invalidClassException) {
            IdentityDatabase.a(z[18], invalidClassException);
            IdentityDatabase.b(z[20]);
        }
        catch (StreamCorruptedException streamCorruptedException) {
            IdentityDatabase.a(z[19], streamCorruptedException);
            IdentityDatabase.b(z[23]);
        }
        if (identityDatabase != null) return identityDatabase;
        return new IdentityDatabase(z[22]);
    }

    public static IdentityDatabase fromFile(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        IdentityDatabase identityDatabase = IdentityDatabase.fromStream(fileInputStream);
        identityDatabase.sourceFile = file;
        return identityDatabase;
    }

    public int size() {
        return this.identities.size();
    }

    public Identity getIdentity(String string) {
        Identity identity = (Identity)this.identities.get(string);
        if (identity instanceof Signer) {
            this.c(z[17]);
        }
        return identity;
    }

    public Identity getIdentity(PublicKey publicKey) {
        if (publicKey == null) {
            return null;
        }
        Enumeration enumeration = this.identities();
        while (enumeration.hasMoreElements()) {
            Identity identity = (Identity)enumeration.nextElement();
            PublicKey publicKey2 = identity.getPublicKey();
            if (publicKey2 == null || !this.a(publicKey2, publicKey)) continue;
            if (identity instanceof Signer) {
                this.c(z[17]);
            }
            return identity;
        }
        return null;
    }

    private boolean a(Key key, Key key2) {
        if (key == key2) {
            return true;
        }
        return MessageDigest.isEqual(key.getEncoded(), key2.getEncoded());
    }

    public void addIdentity(Identity identity) throws KeyManagementException {
        this.c(z[2]);
        Identity identity2 = this.getIdentity(identity.getName());
        Identity identity3 = this.getIdentity(identity.getPublicKey());
        String string = null;
        if (identity2 != null) {
            string = z[1];
        }
        if (identity3 != null) {
            string = z[3];
        }
        if (string != null) {
            throw new KeyManagementException(string);
        }
        this.identities.put(identity.getName(), identity);
    }

    public void removeIdentity(Identity identity) throws KeyManagementException {
        this.c(z[16]);
        String string = identity.getName();
        if (this.identities.get(string) == null) {
            throw new KeyManagementException(z[15] + string + z[14] + this);
        }
        this.identities.remove(string);
    }

    public Enumeration identities() {
        return this.identities.elements();
    }

    void a(File file) {
        this.sourceFile = file;
    }

    File a() {
        return this.sourceFile;
    }

    public void save(OutputStream outputStream) throws IOException {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
        }
        catch (InvalidClassException invalidClassException) {
            IdentityDatabase.a(z[18], invalidClassException);
            return;
        }
    }

    void b(File file) throws IOException {
        this.a(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.save(fileOutputStream);
    }

    public void save() throws IOException {
        if (this.sourceFile == null) {
            throw new IOException(z[4]);
        }
        this.b(this.sourceFile);
    }

    private static File c() {
        String string = Security.getProperty(z[8]);
        if (string == null) {
            string = System.getProperty(z[7]) + File.separatorChar + z[6];
        }
        return new File(string);
    }

    private static void d() {
        File file = IdentityDatabase.c();
        try {
            IdentityDatabase identityDatabase;
            if (file.exists()) {
                IdentityDatabase.a(z[12] + file);
                identityDatabase = IdentityDatabase.fromFile(file);
            } else {
                identityDatabase = new IdentityDatabase(file);
            }
            IdentityScope.setSystemScope(identityDatabase);
            IdentityDatabase.a(z[11] + identityDatabase);
        }
        catch (IOException iOException) {
            IdentityDatabase.a(z[10] + file, iOException);
            return;
        }
        catch (InvalidParameterException invalidParameterException) {
            IdentityDatabase.a(z[9] + file, invalidParameterException);
            return;
        }
    }

    public String toString() {
        return z[5] + this.sourceFile;
    }

    private static void a(String string) {
    }

    private static void a(String string, Throwable throwable) {
    }

    private static void b(String string) {
        System.err.println(string);
    }

    void c(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            string = this.getClass().getName() + "." + string + "." + this.e();
            securityManager.checkSecurityAccess(string);
        }
    }

    String e() {
        String string = this.getName();
        if (this.getScope() != null) {
            string = string + "." + this.getScope().getName();
        }
        return string;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.c(z[0]);
        objectOutputStream.writeObject(this.identities);
        objectOutputStream.writeObject(this.sourceFile);
    }

    static void f() {
        IdentityDatabase.d();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block239: {
            int n2;
            int n3;
            block238: {
                char[] cArray2;
                Object var0;
                block237: {
                    int n4;
                    block236: {
                        char[] cArray3;
                        block235: {
                            int n5;
                            block234: {
                                char[] cArray4;
                                block233: {
                                    int n6;
                                    block232: {
                                        char[] cArray5;
                                        block231: {
                                            int n7;
                                            block230: {
                                                char[] cArray6;
                                                block229: {
                                                    int n8;
                                                    block228: {
                                                        char[] cArray7;
                                                        block227: {
                                                            int n9;
                                                            block226: {
                                                                char[] cArray8;
                                                                block225: {
                                                                    int n10;
                                                                    block224: {
                                                                        char[] cArray9;
                                                                        block223: {
                                                                            int n11;
                                                                            block222: {
                                                                                char[] cArray10;
                                                                                block221: {
                                                                                    int n12;
                                                                                    block220: {
                                                                                        char[] cArray11;
                                                                                        block219: {
                                                                                            int n13;
                                                                                            block218: {
                                                                                                char[] cArray12;
                                                                                                block217: {
                                                                                                    int n14;
                                                                                                    block216: {
                                                                                                        char[] cArray13;
                                                                                                        block215: {
                                                                                                            int n15;
                                                                                                            block214: {
                                                                                                                char[] cArray14;
                                                                                                                block213: {
                                                                                                                    int n16;
                                                                                                                    block212: {
                                                                                                                        char[] cArray15;
                                                                                                                        block211: {
                                                                                                                            int n17;
                                                                                                                            block210: {
                                                                                                                                char[] cArray16;
                                                                                                                                block209: {
                                                                                                                                    int n18;
                                                                                                                                    block208: {
                                                                                                                                        char[] cArray17;
                                                                                                                                        block207: {
                                                                                                                                            int n19;
                                                                                                                                            block206: {
                                                                                                                                                char[] cArray18;
                                                                                                                                                block205: {
                                                                                                                                                    int n20;
                                                                                                                                                    block204: {
                                                                                                                                                        char[] cArray19;
                                                                                                                                                        block203: {
                                                                                                                                                            int n21;
                                                                                                                                                            block202: {
                                                                                                                                                                char[] cArray20;
                                                                                                                                                                block201: {
                                                                                                                                                                    int n22;
                                                                                                                                                                    block200: {
                                                                                                                                                                        char[] cArray21;
                                                                                                                                                                        block199: {
                                                                                                                                                                            int n23;
                                                                                                                                                                            block198: {
                                                                                                                                                                                char[] cArray22;
                                                                                                                                                                                block197: {
                                                                                                                                                                                    int n24;
                                                                                                                                                                                    block196: {
                                                                                                                                                                                        char[] cArray23;
                                                                                                                                                                                        block195: {
                                                                                                                                                                                            int n25;
                                                                                                                                                                                            block194: {
                                                                                                                                                                                                char[] cArray24;
                                                                                                                                                                                                block193: {
                                                                                                                                                                                                    int n26;
                                                                                                                                                                                                    block192: {
                                                                                                                                                                                                        stringArray = new String[24];
                                                                                                                                                                                                        var0 = null;
                                                                                                                                                                                                        char[] cArray25 = "n\u001bg\u0004\u000fq\u0017o\b@t\u001ap\u0003\u001at\nlC\n|\nt\u000f\u000fn\u001b".toCharArray();
                                                                                                                                                                                                        cArray24 = cArray25;
                                                                                                                                                                                                        n26 = cArray25.length;
                                                                                                                                                                                                        n3 = 0;
                                                                                                                                                                                                        if (!true) break block192;
                                                                                                                                                                                                        n26 = n26;
                                                                                                                                                                                                        if (n26 <= n3) break block193;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    do {
                                                                                                                                                                                                        int n27;
                                                                                                                                                                                                        cArray24 = cArray24;
                                                                                                                                                                                                        int n28 = n3;
                                                                                                                                                                                                        char c2 = cArray24[n28];
                                                                                                                                                                                                        switch (n3 % 5) {
                                                                                                                                                                                                            case 0: {
                                                                                                                                                                                                                n27 = 29;
                                                                                                                                                                                                                break;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            case 1: {
                                                                                                                                                                                                                n27 = 126;
                                                                                                                                                                                                                break;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            case 2: {
                                                                                                                                                                                                                n27 = 21;
                                                                                                                                                                                                                break;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            case 3: {
                                                                                                                                                                                                                n27 = 109;
                                                                                                                                                                                                                break;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            default: {
                                                                                                                                                                                                                n27 = 110;
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                        cArray24[n28] = (char)(c2 ^ n27);
                                                                                                                                                                                                        ++n3;
                                                                                                                                                                                                        n26 = n26;
                                                                                                                                                                                                    } while (n26 > n3);
                                                                                                                                                                                                }
                                                                                                                                                                                                stringArray[0] = new String(cArray24).intern();
                                                                                                                                                                                                var0 = null;
                                                                                                                                                                                                char[] cArray26 = "s\u001fx\bN~\u0011{\u000b\u0002t\u001da".toCharArray();
                                                                                                                                                                                                cArray23 = cArray26;
                                                                                                                                                                                                n25 = cArray26.length;
                                                                                                                                                                                                n3 = 0;
                                                                                                                                                                                                if (!true) break block194;
                                                                                                                                                                                                n25 = n25;
                                                                                                                                                                                                if (n25 <= n3) break block195;
                                                                                                                                                                                            }
                                                                                                                                                                                            do {
                                                                                                                                                                                                int n29;
                                                                                                                                                                                                cArray23 = cArray23;
                                                                                                                                                                                                int n30 = n3;
                                                                                                                                                                                                char c3 = cArray23[n30];
                                                                                                                                                                                                switch (n3 % 5) {
                                                                                                                                                                                                    case 0: {
                                                                                                                                                                                                        n29 = 29;
                                                                                                                                                                                                        break;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    case 1: {
                                                                                                                                                                                                        n29 = 126;
                                                                                                                                                                                                        break;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    case 2: {
                                                                                                                                                                                                        n29 = 21;
                                                                                                                                                                                                        break;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    case 3: {
                                                                                                                                                                                                        n29 = 109;
                                                                                                                                                                                                        break;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    default: {
                                                                                                                                                                                                        n29 = 110;
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                                cArray23[n30] = (char)(c3 ^ n29);
                                                                                                                                                                                                ++n3;
                                                                                                                                                                                                n25 = n25;
                                                                                                                                                                                            } while (n25 > n3);
                                                                                                                                                                                        }
                                                                                                                                                                                        stringArray[1] = new String(cArray23).intern();
                                                                                                                                                                                        var0 = null;
                                                                                                                                                                                        char[] cArray27 = "|\u001aqC\u0007y\u001b{\u0019\u0007i\u0007".toCharArray();
                                                                                                                                                                                        cArray22 = cArray27;
                                                                                                                                                                                        n24 = cArray27.length;
                                                                                                                                                                                        n3 = 0;
                                                                                                                                                                                        if (!true) break block196;
                                                                                                                                                                                        n24 = n24;
                                                                                                                                                                                        if (n24 <= n3) break block197;
                                                                                                                                                                                    }
                                                                                                                                                                                    do {
                                                                                                                                                                                        int n31;
                                                                                                                                                                                        cArray22 = cArray22;
                                                                                                                                                                                        int n32 = n3;
                                                                                                                                                                                        char c4 = cArray22[n32];
                                                                                                                                                                                        switch (n3 % 5) {
                                                                                                                                                                                            case 0: {
                                                                                                                                                                                                n31 = 29;
                                                                                                                                                                                                break;
                                                                                                                                                                                            }
                                                                                                                                                                                            case 1: {
                                                                                                                                                                                                n31 = 126;
                                                                                                                                                                                                break;
                                                                                                                                                                                            }
                                                                                                                                                                                            case 2: {
                                                                                                                                                                                                n31 = 21;
                                                                                                                                                                                                break;
                                                                                                                                                                                            }
                                                                                                                                                                                            case 3: {
                                                                                                                                                                                                n31 = 109;
                                                                                                                                                                                                break;
                                                                                                                                                                                            }
                                                                                                                                                                                            default: {
                                                                                                                                                                                                n31 = 110;
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                        cArray22[n32] = (char)(c4 ^ n31);
                                                                                                                                                                                        ++n3;
                                                                                                                                                                                        n24 = n24;
                                                                                                                                                                                    } while (n24 > n3);
                                                                                                                                                                                }
                                                                                                                                                                                stringArray[2] = new String(cArray22).intern();
                                                                                                                                                                                var0 = null;
                                                                                                                                                                                char[] cArray28 = "v\u001blM\rr\u0010s\u0001\u0007~\n".toCharArray();
                                                                                                                                                                                cArray21 = cArray28;
                                                                                                                                                                                n23 = cArray28.length;
                                                                                                                                                                                n3 = 0;
                                                                                                                                                                                if (!true) break block198;
                                                                                                                                                                                n23 = n23;
                                                                                                                                                                                if (n23 <= n3) break block199;
                                                                                                                                                                            }
                                                                                                                                                                            do {
                                                                                                                                                                                int n33;
                                                                                                                                                                                cArray21 = cArray21;
                                                                                                                                                                                int n34 = n3;
                                                                                                                                                                                char c5 = cArray21[n34];
                                                                                                                                                                                switch (n3 % 5) {
                                                                                                                                                                                    case 0: {
                                                                                                                                                                                        n33 = 29;
                                                                                                                                                                                        break;
                                                                                                                                                                                    }
                                                                                                                                                                                    case 1: {
                                                                                                                                                                                        n33 = 126;
                                                                                                                                                                                        break;
                                                                                                                                                                                    }
                                                                                                                                                                                    case 2: {
                                                                                                                                                                                        n33 = 21;
                                                                                                                                                                                        break;
                                                                                                                                                                                    }
                                                                                                                                                                                    case 3: {
                                                                                                                                                                                        n33 = 109;
                                                                                                                                                                                        break;
                                                                                                                                                                                    }
                                                                                                                                                                                    default: {
                                                                                                                                                                                        n33 = 110;
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                                cArray21[n34] = (char)(c5 ^ n33);
                                                                                                                                                                                ++n3;
                                                                                                                                                                                n23 = n23;
                                                                                                                                                                            } while (n23 > n3);
                                                                                                                                                                        }
                                                                                                                                                                        stringArray[3] = new String(cArray21).intern();
                                                                                                                                                                        var0 = null;
                                                                                                                                                                        char[] cArray29 = "i\u0016|\u001eNy\u001fa\f\f|\rpM\u0006|\r5\u0003\u0001=\rz\u0018\u001c~\u001b5\u000b\u0007q\u001b".toCharArray();
                                                                                                                                                                        cArray20 = cArray29;
                                                                                                                                                                        n22 = cArray29.length;
                                                                                                                                                                        n3 = 0;
                                                                                                                                                                        if (!true) break block200;
                                                                                                                                                                        n22 = n22;
                                                                                                                                                                        if (n22 <= n3) break block201;
                                                                                                                                                                    }
                                                                                                                                                                    do {
                                                                                                                                                                        int n35;
                                                                                                                                                                        cArray20 = cArray20;
                                                                                                                                                                        int n36 = n3;
                                                                                                                                                                        char c6 = cArray20[n36];
                                                                                                                                                                        switch (n3 % 5) {
                                                                                                                                                                            case 0: {
                                                                                                                                                                                n35 = 29;
                                                                                                                                                                                break;
                                                                                                                                                                            }
                                                                                                                                                                            case 1: {
                                                                                                                                                                                n35 = 126;
                                                                                                                                                                                break;
                                                                                                                                                                            }
                                                                                                                                                                            case 2: {
                                                                                                                                                                                n35 = 21;
                                                                                                                                                                                break;
                                                                                                                                                                            }
                                                                                                                                                                            case 3: {
                                                                                                                                                                                n35 = 109;
                                                                                                                                                                                break;
                                                                                                                                                                            }
                                                                                                                                                                            default: {
                                                                                                                                                                                n35 = 110;
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                        cArray20[n36] = (char)(c6 ^ n35);
                                                                                                                                                                        ++n3;
                                                                                                                                                                        n22 = n22;
                                                                                                                                                                    } while (n22 > n3);
                                                                                                                                                                }
                                                                                                                                                                stringArray[4] = new String(cArray20).intern();
                                                                                                                                                                var0 = null;
                                                                                                                                                                char[] cArray30 = "~\u0011xC\u0007\u007f\u0013;\u000e\u001cd\u000ea\u0002@m\fz\u001b\u0007y\u001bgC'y\u001b{\u0019\u0007i\u0007Q\f\u001a|\u001ct\u001e\u000b1^f\u0002\u001bo\u001dpM\bt\u0012pWN".toCharArray();
                                                                                                                                                                cArray19 = cArray30;
                                                                                                                                                                n21 = cArray30.length;
                                                                                                                                                                n3 = 0;
                                                                                                                                                                if (!true) break block202;
                                                                                                                                                                n21 = n21;
                                                                                                                                                                if (n21 <= n3) break block203;
                                                                                                                                                            }
                                                                                                                                                            do {
                                                                                                                                                                int n37;
                                                                                                                                                                cArray19 = cArray19;
                                                                                                                                                                int n38 = n3;
                                                                                                                                                                char c7 = cArray19[n38];
                                                                                                                                                                switch (n3 % 5) {
                                                                                                                                                                    case 0: {
                                                                                                                                                                        n37 = 29;
                                                                                                                                                                        break;
                                                                                                                                                                    }
                                                                                                                                                                    case 1: {
                                                                                                                                                                        n37 = 126;
                                                                                                                                                                        break;
                                                                                                                                                                    }
                                                                                                                                                                    case 2: {
                                                                                                                                                                        n37 = 21;
                                                                                                                                                                        break;
                                                                                                                                                                    }
                                                                                                                                                                    case 3: {
                                                                                                                                                                        n37 = 109;
                                                                                                                                                                        break;
                                                                                                                                                                    }
                                                                                                                                                                    default: {
                                                                                                                                                                        n37 = 110;
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                                cArray19[n38] = (char)(c7 ^ n37);
                                                                                                                                                                ++n3;
                                                                                                                                                                n21 = n21;
                                                                                                                                                            } while (n21 > n3);
                                                                                                                                                        }
                                                                                                                                                        stringArray[5] = new String(cArray19).intern();
                                                                                                                                                        var0 = null;
                                                                                                                                                        char[] cArray31 = "t\u001ap\u0003\u001at\nl\t\f3\u0011w\u0007".toCharArray();
                                                                                                                                                        cArray18 = cArray31;
                                                                                                                                                        n20 = cArray31.length;
                                                                                                                                                        n3 = 0;
                                                                                                                                                        if (!true) break block204;
                                                                                                                                                        n20 = n20;
                                                                                                                                                        if (n20 <= n3) break block205;
                                                                                                                                                    }
                                                                                                                                                    do {
                                                                                                                                                        int n39;
                                                                                                                                                        cArray18 = cArray18;
                                                                                                                                                        int n40 = n3;
                                                                                                                                                        char c8 = cArray18[n40];
                                                                                                                                                        switch (n3 % 5) {
                                                                                                                                                            case 0: {
                                                                                                                                                                n39 = 29;
                                                                                                                                                                break;
                                                                                                                                                            }
                                                                                                                                                            case 1: {
                                                                                                                                                                n39 = 126;
                                                                                                                                                                break;
                                                                                                                                                            }
                                                                                                                                                            case 2: {
                                                                                                                                                                n39 = 21;
                                                                                                                                                                break;
                                                                                                                                                            }
                                                                                                                                                            case 3: {
                                                                                                                                                                n39 = 109;
                                                                                                                                                                break;
                                                                                                                                                            }
                                                                                                                                                            default: {
                                                                                                                                                                n39 = 110;
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                        cArray18[n40] = (char)(c8 ^ n39);
                                                                                                                                                        ++n3;
                                                                                                                                                        n20 = n20;
                                                                                                                                                    } while (n20 > n3);
                                                                                                                                                }
                                                                                                                                                stringArray[6] = new String(cArray18).intern();
                                                                                                                                                var0 = null;
                                                                                                                                                char[] cArray32 = "h\rp\u001f@u\u0011x\b".toCharArray();
                                                                                                                                                cArray17 = cArray32;
                                                                                                                                                n19 = cArray32.length;
                                                                                                                                                n3 = 0;
                                                                                                                                                if (!true) break block206;
                                                                                                                                                n19 = n19;
                                                                                                                                                if (n19 <= n3) break block207;
                                                                                                                                            }
                                                                                                                                            do {
                                                                                                                                                int n41;
                                                                                                                                                cArray17 = cArray17;
                                                                                                                                                int n42 = n3;
                                                                                                                                                char c9 = cArray17[n42];
                                                                                                                                                switch (n3 % 5) {
                                                                                                                                                    case 0: {
                                                                                                                                                        n41 = 29;
                                                                                                                                                        break;
                                                                                                                                                    }
                                                                                                                                                    case 1: {
                                                                                                                                                        n41 = 126;
                                                                                                                                                        break;
                                                                                                                                                    }
                                                                                                                                                    case 2: {
                                                                                                                                                        n41 = 21;
                                                                                                                                                        break;
                                                                                                                                                    }
                                                                                                                                                    case 3: {
                                                                                                                                                        n41 = 109;
                                                                                                                                                        break;
                                                                                                                                                    }
                                                                                                                                                    default: {
                                                                                                                                                        n41 = 110;
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                                cArray17[n42] = (char)(c9 ^ n41);
                                                                                                                                                ++n3;
                                                                                                                                                n19 = n19;
                                                                                                                                            } while (n19 > n3);
                                                                                                                                        }
                                                                                                                                        stringArray[7] = new String(cArray17).intern();
                                                                                                                                        var0 = null;
                                                                                                                                        char[] cArray33 = "t\u001ap\u0003\u001at\nlC\n|\nt\u000f\u000fn\u001b".toCharArray();
                                                                                                                                        cArray16 = cArray33;
                                                                                                                                        n18 = cArray33.length;
                                                                                                                                        n3 = 0;
                                                                                                                                        if (!true) break block208;
                                                                                                                                        n18 = n18;
                                                                                                                                        if (n18 <= n3) break block209;
                                                                                                                                    }
                                                                                                                                    do {
                                                                                                                                        int n43;
                                                                                                                                        cArray16 = cArray16;
                                                                                                                                        int n44 = n3;
                                                                                                                                        char c10 = cArray16[n44];
                                                                                                                                        switch (n3 % 5) {
                                                                                                                                            case 0: {
                                                                                                                                                n43 = 29;
                                                                                                                                                break;
                                                                                                                                            }
                                                                                                                                            case 1: {
                                                                                                                                                n43 = 126;
                                                                                                                                                break;
                                                                                                                                            }
                                                                                                                                            case 2: {
                                                                                                                                                n43 = 21;
                                                                                                                                                break;
                                                                                                                                            }
                                                                                                                                            case 3: {
                                                                                                                                                n43 = 109;
                                                                                                                                                break;
                                                                                                                                            }
                                                                                                                                            default: {
                                                                                                                                                n43 = 110;
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                        cArray16[n44] = (char)(c10 ^ n43);
                                                                                                                                        ++n3;
                                                                                                                                        n18 = n18;
                                                                                                                                    } while (n18 > n3);
                                                                                                                                }
                                                                                                                                stringArray[8] = new String(cArray16).intern();
                                                                                                                                var0 = null;
                                                                                                                                char[] cArray34 = "X\fg\u0002\u001c=\ng\u0014\u0007s\u00195\u0019\u0001=\u0017{\u001e\u001a|\u0010a\u0004\u000fi\u001b5\fNn\u0007f\u0019\u000bp^|\t\u000bs\n|\u0019\u0007x\r5\t\f=\u0017{M".toCharArray();
                                                                                                                                cArray15 = cArray34;
                                                                                                                                n17 = cArray34.length;
                                                                                                                                n3 = 0;
                                                                                                                                if (!true) break block210;
                                                                                                                                n17 = n17;
                                                                                                                                if (n17 <= n3) break block211;
                                                                                                                            }
                                                                                                                            do {
                                                                                                                                int n45;
                                                                                                                                cArray15 = cArray15;
                                                                                                                                int n46 = n3;
                                                                                                                                char c11 = cArray15[n46];
                                                                                                                                switch (n3 % 5) {
                                                                                                                                    case 0: {
                                                                                                                                        n45 = 29;
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                    case 1: {
                                                                                                                                        n45 = 126;
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                    case 2: {
                                                                                                                                        n45 = 21;
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                    case 3: {
                                                                                                                                        n45 = 109;
                                                                                                                                        break;
                                                                                                                                    }
                                                                                                                                    default: {
                                                                                                                                        n45 = 110;
                                                                                                                                    }
                                                                                                                                }
                                                                                                                                cArray15[n46] = (char)(c11 ^ n45);
                                                                                                                                ++n3;
                                                                                                                                n17 = n17;
                                                                                                                            } while (n17 > n3);
                                                                                                                        }
                                                                                                                        stringArray[9] = new String(cArray15).intern();
                                                                                                                        var0 = null;
                                                                                                                        char[] cArray35 = "X\fg\u0002\u001c=\u0017{\u0004\u001at\u001fy\u0004\u0014t\u0010rM\u0007y\u001b{\u0019\u0007i\u00075\t\u000fi\u001fw\f\u001dxD5".toCharArray();
                                                                                                                        cArray14 = cArray35;
                                                                                                                        n16 = cArray35.length;
                                                                                                                        n3 = 0;
                                                                                                                        if (!true) break block212;
                                                                                                                        n16 = n16;
                                                                                                                        if (n16 <= n3) break block213;
                                                                                                                    }
                                                                                                                    do {
                                                                                                                        int n47;
                                                                                                                        cArray14 = cArray14;
                                                                                                                        int n48 = n3;
                                                                                                                        char c12 = cArray14[n48];
                                                                                                                        switch (n3 % 5) {
                                                                                                                            case 0: {
                                                                                                                                n47 = 29;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            case 1: {
                                                                                                                                n47 = 126;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            case 2: {
                                                                                                                                n47 = 21;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            case 3: {
                                                                                                                                n47 = 109;
                                                                                                                                break;
                                                                                                                            }
                                                                                                                            default: {
                                                                                                                                n47 = 110;
                                                                                                                            }
                                                                                                                        }
                                                                                                                        cArray14[n48] = (char)(c12 ^ n47);
                                                                                                                        ++n3;
                                                                                                                        n16 = n16;
                                                                                                                    } while (n16 > n3);
                                                                                                                }
                                                                                                                stringArray[10] = new String(cArray14).intern();
                                                                                                                var0 = null;
                                                                                                                char[] cArray36 = "N\u0007f\u0019\u000bp^q\f\u001a|\u001ct\u001e\u000b=\u0017{\u0004\u001at\u001fy\u0004\u0014x\u001a/M".toCharArray();
                                                                                                                cArray13 = cArray36;
                                                                                                                n15 = cArray36.length;
                                                                                                                n3 = 0;
                                                                                                                if (!true) break block214;
                                                                                                                n15 = n15;
                                                                                                                if (n15 <= n3) break block215;
                                                                                                            }
                                                                                                            do {
                                                                                                                int n49;
                                                                                                                cArray13 = cArray13;
                                                                                                                int n50 = n3;
                                                                                                                char c13 = cArray13[n50];
                                                                                                                switch (n3 % 5) {
                                                                                                                    case 0: {
                                                                                                                        n49 = 29;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    case 1: {
                                                                                                                        n49 = 126;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    case 2: {
                                                                                                                        n49 = 21;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    case 3: {
                                                                                                                        n49 = 109;
                                                                                                                        break;
                                                                                                                    }
                                                                                                                    default: {
                                                                                                                        n49 = 110;
                                                                                                                    }
                                                                                                                }
                                                                                                                cArray13[n50] = (char)(c13 ^ n49);
                                                                                                                ++n3;
                                                                                                                n15 = n15;
                                                                                                            } while (n15 > n3);
                                                                                                        }
                                                                                                        stringArray[11] = new String(cArray13).intern();
                                                                                                        var0 = null;
                                                                                                        char[] cArray37 = "q\u0011t\t\u0007s\u00195\u001e\u0017n\np\u0000Ny\u001fa\f\f|\rpM\bo\u0011xM\bt\u0012pWN".toCharArray();
                                                                                                        cArray12 = cArray37;
                                                                                                        n14 = cArray37.length;
                                                                                                        n3 = 0;
                                                                                                        if (!true) break block216;
                                                                                                        n14 = n14;
                                                                                                        if (n14 <= n3) break block217;
                                                                                                    }
                                                                                                    do {
                                                                                                        int n51;
                                                                                                        cArray12 = cArray12;
                                                                                                        int n52 = n3;
                                                                                                        char c14 = cArray12[n52];
                                                                                                        switch (n3 % 5) {
                                                                                                            case 0: {
                                                                                                                n51 = 29;
                                                                                                                break;
                                                                                                            }
                                                                                                            case 1: {
                                                                                                                n51 = 126;
                                                                                                                break;
                                                                                                            }
                                                                                                            case 2: {
                                                                                                                n51 = 21;
                                                                                                                break;
                                                                                                            }
                                                                                                            case 3: {
                                                                                                                n51 = 109;
                                                                                                                break;
                                                                                                            }
                                                                                                            default: {
                                                                                                                n51 = 110;
                                                                                                            }
                                                                                                        }
                                                                                                        cArray12[n52] = (char)(c14 ^ n51);
                                                                                                        ++n3;
                                                                                                        n14 = n14;
                                                                                                    } while (n14 > n3);
                                                                                                }
                                                                                                stringArray[12] = new String(cArray12).intern();
                                                                                                var0 = null;
                                                                                                char[] cArray38 = "o\u001bf\u0019\u0001o\u0017{\n@3P".toCharArray();
                                                                                                cArray11 = cArray38;
                                                                                                n13 = cArray38.length;
                                                                                                n3 = 0;
                                                                                                if (!true) break block218;
                                                                                                n13 = n13;
                                                                                                if (n13 <= n3) break block219;
                                                                                            }
                                                                                            do {
                                                                                                int n53;
                                                                                                cArray11 = cArray11;
                                                                                                int n54 = n3;
                                                                                                char c15 = cArray11[n54];
                                                                                                switch (n3 % 5) {
                                                                                                    case 0: {
                                                                                                        n53 = 29;
                                                                                                        break;
                                                                                                    }
                                                                                                    case 1: {
                                                                                                        n53 = 126;
                                                                                                        break;
                                                                                                    }
                                                                                                    case 2: {
                                                                                                        n53 = 21;
                                                                                                        break;
                                                                                                    }
                                                                                                    case 3: {
                                                                                                        n53 = 109;
                                                                                                        break;
                                                                                                    }
                                                                                                    default: {
                                                                                                        n53 = 110;
                                                                                                    }
                                                                                                }
                                                                                                cArray11[n54] = (char)(c15 ^ n53);
                                                                                                ++n3;
                                                                                                n13 = n13;
                                                                                            } while (n13 > n3);
                                                                                        }
                                                                                        stringArray[13] = new String(cArray11).intern();
                                                                                        var0 = null;
                                                                                        char[] cArray39 = "=\u0017{M".toCharArray();
                                                                                        cArray10 = cArray39;
                                                                                        n12 = cArray39.length;
                                                                                        n3 = 0;
                                                                                        if (!true) break block220;
                                                                                        n12 = n12;
                                                                                        if (n12 <= n3) break block221;
                                                                                    }
                                                                                    do {
                                                                                        int n55;
                                                                                        cArray10 = cArray10;
                                                                                        int n56 = n3;
                                                                                        char c16 = cArray10[n56];
                                                                                        switch (n3 % 5) {
                                                                                            case 0: {
                                                                                                n55 = 29;
                                                                                                break;
                                                                                            }
                                                                                            case 1: {
                                                                                                n55 = 126;
                                                                                                break;
                                                                                            }
                                                                                            case 2: {
                                                                                                n55 = 21;
                                                                                                break;
                                                                                            }
                                                                                            case 3: {
                                                                                                n55 = 109;
                                                                                                break;
                                                                                            }
                                                                                            default: {
                                                                                                n55 = 110;
                                                                                            }
                                                                                        }
                                                                                        cArray10[n56] = (char)(c16 ^ n55);
                                                                                        ++n3;
                                                                                        n12 = n12;
                                                                                    } while (n12 > n3);
                                                                                }
                                                                                stringArray[14] = new String(cArray10).intern();
                                                                                var0 = null;
                                                                                char[] cArray40 = "i\u0016p\u001f\u000b=\u0017fM\u0000r^|\t\u000bs\n|\u0019\u0017=\u0010t\u0000\u000by^".toCharArray();
                                                                                cArray9 = cArray40;
                                                                                n11 = cArray40.length;
                                                                                n3 = 0;
                                                                                if (!true) break block222;
                                                                                n11 = n11;
                                                                                if (n11 <= n3) break block223;
                                                                            }
                                                                            do {
                                                                                int n57;
                                                                                cArray9 = cArray9;
                                                                                int n58 = n3;
                                                                                char c17 = cArray9[n58];
                                                                                switch (n3 % 5) {
                                                                                    case 0: {
                                                                                        n57 = 29;
                                                                                        break;
                                                                                    }
                                                                                    case 1: {
                                                                                        n57 = 126;
                                                                                        break;
                                                                                    }
                                                                                    case 2: {
                                                                                        n57 = 21;
                                                                                        break;
                                                                                    }
                                                                                    case 3: {
                                                                                        n57 = 109;
                                                                                        break;
                                                                                    }
                                                                                    default: {
                                                                                        n57 = 110;
                                                                                    }
                                                                                }
                                                                                cArray9[n58] = (char)(c17 ^ n57);
                                                                                ++n3;
                                                                                n11 = n11;
                                                                            } while (n11 > n3);
                                                                        }
                                                                        stringArray[15] = new String(cArray9).intern();
                                                                        var0 = null;
                                                                        char[] cArray41 = "o\u001bx\u0002\u0018xP|\t\u000bs\n|\u0019\u0017".toCharArray();
                                                                        cArray8 = cArray41;
                                                                        n10 = cArray41.length;
                                                                        n3 = 0;
                                                                        if (!true) break block224;
                                                                        n10 = n10;
                                                                        if (n10 <= n3) break block225;
                                                                    }
                                                                    do {
                                                                        int n59;
                                                                        cArray8 = cArray8;
                                                                        int n60 = n3;
                                                                        char c18 = cArray8[n60];
                                                                        switch (n3 % 5) {
                                                                            case 0: {
                                                                                n59 = 29;
                                                                                break;
                                                                            }
                                                                            case 1: {
                                                                                n59 = 126;
                                                                                break;
                                                                            }
                                                                            case 2: {
                                                                                n59 = 21;
                                                                                break;
                                                                            }
                                                                            case 3: {
                                                                                n59 = 109;
                                                                                break;
                                                                            }
                                                                            default: {
                                                                                n59 = 110;
                                                                            }
                                                                        }
                                                                        cArray8[n60] = (char)(c18 ^ n59);
                                                                        ++n3;
                                                                        n10 = n10;
                                                                    } while (n10 > n3);
                                                                }
                                                                stringArray[16] = new String(cArray8).intern();
                                                                var0 = null;
                                                                char[] cArray42 = "z\u001baC\u001dt\u0019{\b\u001c".toCharArray();
                                                                cArray7 = cArray42;
                                                                n9 = cArray42.length;
                                                                n3 = 0;
                                                                if (!true) break block226;
                                                                n9 = n9;
                                                                if (n9 <= n3) break block227;
                                                            }
                                                            do {
                                                                int n61;
                                                                cArray7 = cArray7;
                                                                int n62 = n3;
                                                                char c19 = cArray7[n62];
                                                                switch (n3 % 5) {
                                                                    case 0: {
                                                                        n61 = 29;
                                                                        break;
                                                                    }
                                                                    case 1: {
                                                                        n61 = 126;
                                                                        break;
                                                                    }
                                                                    case 2: {
                                                                        n61 = 21;
                                                                        break;
                                                                    }
                                                                    case 3: {
                                                                        n61 = 109;
                                                                        break;
                                                                    }
                                                                    default: {
                                                                        n61 = 110;
                                                                    }
                                                                }
                                                                cArray7[n62] = (char)(c19 ^ n61);
                                                                ++n3;
                                                                n9 = n9;
                                                            } while (n9 > n3);
                                                        }
                                                        stringArray[17] = new String(cArray7).intern();
                                                        var0 = null;
                                                        char[] cArray43 = "I\u0016|\u001eNn\u0016z\u0018\u0002y^{\u0002\u001a=\u001cpM\u0006|\u000ee\b\u0000t\u0010rC".toCharArray();
                                                        cArray6 = cArray43;
                                                        n8 = cArray43.length;
                                                        n3 = 0;
                                                        if (!true) break block228;
                                                        n8 = n8;
                                                        if (n8 <= n3) break block229;
                                                    }
                                                    do {
                                                        int n63;
                                                        cArray6 = cArray6;
                                                        int n64 = n3;
                                                        char c20 = cArray6[n64];
                                                        switch (n3 % 5) {
                                                            case 0: {
                                                                n63 = 29;
                                                                break;
                                                            }
                                                            case 1: {
                                                                n63 = 126;
                                                                break;
                                                            }
                                                            case 2: {
                                                                n63 = 21;
                                                                break;
                                                            }
                                                            case 3: {
                                                                n63 = 109;
                                                                break;
                                                            }
                                                            default: {
                                                                n63 = 110;
                                                            }
                                                        }
                                                        cArray6[n64] = (char)(c20 ^ n63);
                                                        ++n3;
                                                        n8 = n8;
                                                    } while (n8 > n3);
                                                }
                                                stringArray[18] = new String(cArray6).intern();
                                                var0 = null;
                                                char[] cArray44 = "I\u0016pM\u001dx\f|\f\u0002t\u0004t\u0019\u0007r\u00105\u001e\u001ao\u001bt\u0000Nt\r5\u000e\u0001o\f`\u001d\u001ax\u001a;M;s\u001fw\u0001\u000b=\nzM\u0002r\u001fqC".toCharArray();
                                                cArray5 = cArray44;
                                                n7 = cArray44.length;
                                                n3 = 0;
                                                if (!true) break block230;
                                                n7 = n7;
                                                if (n7 <= n3) break block231;
                                            }
                                            do {
                                                int n65;
                                                cArray5 = cArray5;
                                                int n66 = n3;
                                                char c21 = cArray5[n66];
                                                switch (n3 % 5) {
                                                    case 0: {
                                                        n65 = 29;
                                                        break;
                                                    }
                                                    case 1: {
                                                        n65 = 126;
                                                        break;
                                                    }
                                                    case 2: {
                                                        n65 = 21;
                                                        break;
                                                    }
                                                    case 3: {
                                                        n65 = 109;
                                                        break;
                                                    }
                                                    default: {
                                                        n65 = 110;
                                                    }
                                                }
                                                cArray5[n66] = (char)(c21 ^ n65);
                                                ++n3;
                                                n7 = n7;
                                            } while (n7 > n3);
                                        }
                                        stringArray[19] = new String(cArray5).intern();
                                        var0 = null;
                                        char[] cArray45 = "H\u0010t\u000f\u0002x^a\u0002Nt\u0010|\u0019\u0007|\u0012|\u0017\u000b=\rl\u001e\u001ax\u00135\u0004\nx\u0010a\u0004\u001ad^f\u000e\u0001m\u001b/MNT\u0010c\f\u0002t\u001aV\u0001\u000fn\rP\u0015\rx\u000ea\u0004\u0001sP5g:u\u0017fM\u0007n^x\u0002\u001di^y\u0004\u0005x\u0012lM\nh\u001b5\u0019\u0001=\u001f5\u001e\u000bo\u0017t\u0001\u0007g\u001fa\u0004\u0001s^c\b\u001cn\u0017z\u0003\u0007s\u00195\u001d\u001cr\u001cy\b\u0003'^tM\rq\u001ff\u001eNh\rp\tNt\u00105\u0006\u000bd^x\f\u0000|\u0019p\u0000\u000bs\n5\u001a\u000fn^z\u000f\u001dr\u0012p\u0019\u000by".toCharArray();
                                        cArray4 = cArray45;
                                        n6 = cArray45.length;
                                        n3 = 0;
                                        if (!true) break block232;
                                        n6 = n6;
                                        if (n6 <= n3) break block233;
                                    }
                                    do {
                                        int n67;
                                        cArray4 = cArray4;
                                        int n68 = n3;
                                        char c22 = cArray4[n68];
                                        switch (n3 % 5) {
                                            case 0: {
                                                n67 = 29;
                                                break;
                                            }
                                            case 1: {
                                                n67 = 126;
                                                break;
                                            }
                                            case 2: {
                                                n67 = 21;
                                                break;
                                            }
                                            case 3: {
                                                n67 = 109;
                                                break;
                                            }
                                            default: {
                                                n67 = 110;
                                            }
                                        }
                                        cArray4[n68] = (char)(c22 ^ n67);
                                        ++n3;
                                        n6 = n6;
                                    } while (n6 > n3);
                                }
                                stringArray[20] = new String(cArray4).intern();
                                var0 = null;
                                char[] cArray46 = "I\u0016pM\u0018x\ff\u0004\u0001s^z\u000bNi\u0016pM\n|\nt\u000f\u000fn\u001b5\u0004\u001d=\u0011w\u001e\u0001q\u001ba\b@==t\u0003\u0000r\n5\u0004\u0000t\n|\f\u0002t\u0004pC".toCharArray();
                                cArray3 = cArray46;
                                n5 = cArray46.length;
                                n3 = 0;
                                if (!true) break block234;
                                n5 = n5;
                                if (n5 <= n3) break block235;
                            }
                            do {
                                int n69;
                                cArray3 = cArray3;
                                int n70 = n3;
                                char c23 = cArray3[n70];
                                switch (n3 % 5) {
                                    case 0: {
                                        n69 = 29;
                                        break;
                                    }
                                    case 1: {
                                        n69 = 126;
                                        break;
                                    }
                                    case 2: {
                                        n69 = 21;
                                        break;
                                    }
                                    case 3: {
                                        n69 = 109;
                                        break;
                                    }
                                    default: {
                                        n69 = 110;
                                    }
                                }
                                cArray3[n70] = (char)(c23 ^ n69);
                                ++n3;
                                n5 = n5;
                            } while (n5 > n3);
                        }
                        stringArray[21] = new String(cArray3).intern();
                        var0 = null;
                        char[] cArray47 = "h\u0010|\u0003\u0007i\u0017t\u0001\u0007g\u001bq".toCharArray();
                        cArray2 = cArray47;
                        n4 = cArray47.length;
                        n3 = 0;
                        if (!true) break block236;
                        n4 = n4;
                        if (n4 <= n3) break block237;
                    }
                    do {
                        int n71;
                        cArray2 = cArray2;
                        int n72 = n3;
                        char c24 = cArray2[n72];
                        switch (n3 % 5) {
                            case 0: {
                                n71 = 29;
                                break;
                            }
                            case 1: {
                                n71 = 126;
                                break;
                            }
                            case 2: {
                                n71 = 21;
                                break;
                            }
                            case 3: {
                                n71 = 109;
                                break;
                            }
                            default: {
                                n71 = 110;
                            }
                        }
                        cArray2[n72] = (char)(c24 ^ n71);
                        ++n3;
                        n4 = n4;
                    } while (n4 > n3);
                }
                stringArray[22] = new String(cArray2).intern();
                var0 = null;
                char[] cArray48 = "H\u0010t\u000f\u0002x^a\u0002Nt\u0010|\u0019\u0007|\u0012|\u0017\u000b=\rl\u001e\u001ax\u00135\u0004\nx\u0010a\u0004\u001ad^f\u000e\u0001m\u001b;M=i\fp\f\u0003^\u0011g\u001f\u001eh\np\t+e\u001dp\u001d\u001at\u0011{C".toCharArray();
                cArray = cArray48;
                n2 = cArray48.length;
                n3 = 0;
                if (!true) break block238;
                n2 = n2;
                if (n2 <= n3) break block239;
            }
            do {
                int n73;
                cArray = cArray;
                int n74 = n3;
                char c25 = cArray[n74];
                switch (n3 % 5) {
                    case 0: {
                        n73 = 29;
                        break;
                    }
                    case 1: {
                        n73 = 126;
                        break;
                    }
                    case 2: {
                        n73 = 21;
                        break;
                    }
                    case 3: {
                        n73 = 109;
                        break;
                    }
                    default: {
                        n73 = 110;
                    }
                }
                cArray[n74] = (char)(c25 ^ n73);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        stringArray[23] = new String(cArray).intern();
        z = stringArray;
        AccessController.doPrivileged(new n());
    }
}

