/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.DynamicMXBeanImpl;
import com.ibm.lang.management.ManagementUtils;
import com.ibm.lang.management.MemoryMXBeanImpl;
import com.ibm.lang.management.MemoryNotificationThread;
import com.ibm.lang.management.MemoryPoolMXBean;
import java.lang.management.ManagementPermission;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.Iterator;
import java.util.LinkedList;

public final class MemoryPoolMXBeanImpl
extends DynamicMXBeanImpl
implements MemoryPoolMXBean {
    private final String name;
    private final int id;
    private final MemoryType type;
    private final MemoryMXBeanImpl memBean;

    MemoryPoolMXBeanImpl(String name, MemoryType type, int id, MemoryMXBeanImpl memBean) {
        this.name = name;
        this.type = type;
        this.id = id;
        this.memBean = memBean;
        this.setMBeanInfo(ManagementUtils.getMBeanInfo(java.lang.management.MemoryPoolMXBean.class.getName()));
        if (this.isUsageThresholdSupported() || this.isCollectionUsageThresholdSupported()) {
            MemoryNotificationThread t = new MemoryNotificationThread(memBean, this, id);
            t.setDaemon(true);
            t.setName("MemoryPoolMXBean notification dispatcher");
            t.setPriority(6);
            t.start();
        }
    }

    private native MemoryUsage getCollectionUsageImpl();

    public MemoryUsage getCollectionUsage() {
        return this.getCollectionUsageImpl();
    }

    private native MemoryUsage getPreCollectionUsageImpl();

    public MemoryUsage getPreCollectionUsage() {
        return this.getPreCollectionUsageImpl();
    }

    private native long getCollectionUsageThresholdImpl();

    public long getCollectionUsageThreshold() {
        if (!this.isCollectionUsageThresholdSupported()) {
            throw new UnsupportedOperationException("VM does not support collection usage threshold.");
        }
        return this.getCollectionUsageThresholdImpl();
    }

    private native long getCollectionUsageThresholdCountImpl();

    public long getCollectionUsageThresholdCount() {
        if (!this.isCollectionUsageThresholdSupported()) {
            throw new UnsupportedOperationException("VM does not support collection usage threshold.");
        }
        return this.getCollectionUsageThresholdCountImpl();
    }

    public String[] getMemoryManagerNames() {
        Iterator<MemoryManagerMXBean> iter = this.memBean.getMemoryManagerMXBeans().iterator();
        LinkedList<String> result = new LinkedList<String>();
        block0: while (iter.hasNext()) {
            MemoryManagerMXBean bean = iter.next();
            String[] managedPools = bean.getMemoryPoolNames();
            int i = 0;
            while (i < managedPools.length) {
                if (managedPools[i].equals(this.name)) {
                    result.add(bean.getName());
                    continue block0;
                }
                ++i;
            }
        }
        return result.toArray(new String[0]);
    }

    public String getName() {
        return this.name;
    }

    private native MemoryUsage getPeakUsageImpl();

    public MemoryUsage getPeakUsage() {
        return this.getPeakUsageImpl();
    }

    public MemoryType getType() {
        return this.type;
    }

    private native MemoryUsage getUsageImpl();

    public MemoryUsage getUsage() {
        return this.getUsageImpl();
    }

    private native long getUsageThresholdImpl();

    public long getUsageThreshold() {
        if (!this.isUsageThresholdSupported()) {
            throw new UnsupportedOperationException("VM does not support usage threshold.");
        }
        return this.getUsageThresholdImpl();
    }

    private native long getUsageThresholdCountImpl();

    public long getUsageThresholdCount() {
        if (!this.isUsageThresholdSupported()) {
            throw new UnsupportedOperationException("VM does not support usage threshold.");
        }
        return this.getUsageThresholdCountImpl();
    }

    private native boolean isCollectionUsageThresholdExceededImpl();

    public boolean isCollectionUsageThresholdExceeded() {
        if (!this.isCollectionUsageThresholdSupported()) {
            throw new UnsupportedOperationException("VM does not support collection usage threshold.");
        }
        return this.isCollectionUsageThresholdExceededImpl();
    }

    private native boolean isCollectionUsageThresholdSupportedImpl();

    public boolean isCollectionUsageThresholdSupported() {
        return this.isCollectionUsageThresholdSupportedImpl();
    }

    private native boolean isUsageThresholdExceededImpl();

    public boolean isUsageThresholdExceeded() {
        if (!this.isUsageThresholdSupported()) {
            throw new UnsupportedOperationException("VM does not support usage threshold.");
        }
        return this.isUsageThresholdExceededImpl();
    }

    private native boolean isUsageThresholdSupportedImpl();

    public boolean isUsageThresholdSupported() {
        return this.isUsageThresholdSupportedImpl();
    }

    private native boolean isValidImpl();

    public boolean isValid() {
        return this.isValidImpl();
    }

    private native void resetPeakUsageImpl();

    public void resetPeakUsage() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new ManagementPermission("control"));
        }
        this.resetPeakUsageImpl();
    }

    private native void setCollectionUsageThresholdImpl(long var1);

    public void setCollectionUsageThreshold(long threshold) {
        if (!this.isCollectionUsageThresholdSupported()) {
            throw new UnsupportedOperationException("VM does not support collection usage threshold.");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new ManagementPermission("control"));
        }
        if (threshold < 0L) {
            throw new IllegalArgumentException("Collection usage threshold cannot be negative.");
        }
        if (this.exceedsMaxPoolSize(threshold)) {
            throw new IllegalArgumentException("Collection usage threshold cannot exceed maximum amount of memory for pool.");
        }
        this.setCollectionUsageThresholdImpl(threshold);
    }

    private native void setUsageThresholdImpl(long var1);

    public void setUsageThreshold(long threshold) {
        if (!this.isUsageThresholdSupported()) {
            throw new UnsupportedOperationException("VM does not support usage threshold.");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new ManagementPermission("control"));
        }
        if (threshold < 0L) {
            throw new IllegalArgumentException("Usage threshold cannot be negative.");
        }
        if (this.exceedsMaxPoolSize(threshold)) {
            throw new IllegalArgumentException("Usage threshold cannot exceed maximum amount of memory for pool.");
        }
        this.setUsageThresholdImpl(threshold);
    }

    private boolean exceedsMaxPoolSize(long value) {
        MemoryUsage m = this.getUsage();
        return m.getMax() != -1L && m.getMax() < value;
    }
}

