/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.ManagementUtils;
import com.ibm.lang.management.MemoryMXBeanImpl;
import com.ibm.lang.management.MemoryNotificationThreadShutdown;
import com.ibm.lang.management.MemoryPoolMXBeanImpl;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryUsage;
import javax.management.Notification;

class MemoryNotificationThread
extends Thread {
    private MemoryMXBeanImpl memBean;
    private MemoryPoolMXBeanImpl memPool;
    int internalID;

    MemoryNotificationThread(MemoryMXBeanImpl mem, MemoryPoolMXBeanImpl myPool, int id) {
        this.memBean = mem;
        this.memPool = myPool;
        this.internalID = id;
    }

    public void run() {
        MemoryNotificationThreadShutdown myShutdownNotifier = new MemoryNotificationThreadShutdown(this);
        try {
            Runtime.getRuntime().addShutdownHook(myShutdownNotifier);
        }
        catch (IllegalStateException e) {
            return;
        }
        this.processNotificationLoop(this.internalID);
    }

    private native void processNotificationLoop(int var1);

    private void dispatchNotificationHelper(long min, long used, long committed, long max, long count, long sequenceNumber, boolean isCollectionUsageNotification) {
        MemoryNotificationInfo info = new MemoryNotificationInfo(this.memPool.getName(), new MemoryUsage(min, used, committed, max), count);
        Notification n = new Notification(isCollectionUsageNotification ? "java.management.memory.collection.threshold.exceeded" : "java.management.memory.threshold.exceeded", "java.lang:type=Memory", sequenceNumber);
        n.setUserData(ManagementUtils.toMemoryNotificationInfoCompositeData(info));
        this.memBean.sendNotification(n);
    }
}

