/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.DynamicMXBeanImpl;
import com.ibm.lang.management.GarbageCollectorMXBeanImpl;
import com.ibm.lang.management.ManagementUtils;
import com.ibm.lang.management.MemoryMXBean;
import com.ibm.lang.management.MemoryManagerMXBeanImpl;
import com.ibm.oti.shared.SharedClassStatistics;
import java.lang.management.ManagementPermission;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryUsage;
import java.util.LinkedList;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MemoryMXBeanImpl
extends DynamicMXBeanImpl
implements MemoryMXBean,
NotificationEmitter {
    private NotificationBroadcasterSupport notifier = new NotificationBroadcasterSupport();
    private static MemoryMXBeanImpl instance = new MemoryMXBeanImpl();
    private List<MemoryManagerMXBean> memoryManagerList;

    private MemoryMXBeanImpl() {
        this.setMBeanInfo(ManagementUtils.getMBeanInfo(java.lang.management.MemoryMXBean.class.getName()));
        this.memoryManagerList = new LinkedList<MemoryManagerMXBean>();
        this.createMemoryManagers();
    }

    static MemoryMXBeanImpl getInstance() {
        return instance;
    }

    private native void createMemoryManagers();

    private void createMemoryManagerHelper(String name, int internalID, boolean isGC) {
        if (isGC) {
            this.memoryManagerList.add(new GarbageCollectorMXBeanImpl(name, internalID, this));
        } else {
            this.memoryManagerList.add(new MemoryManagerMXBeanImpl(name, internalID, this));
        }
    }

    List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        return this.memoryManagerList;
    }

    @Override
    public void gc() {
        System.gc();
    }

    private native MemoryUsage getHeapMemoryUsageImpl();

    @Override
    public MemoryUsage getHeapMemoryUsage() {
        return this.getHeapMemoryUsageImpl();
    }

    private native MemoryUsage getNonHeapMemoryUsageImpl();

    @Override
    public MemoryUsage getNonHeapMemoryUsage() {
        return this.getNonHeapMemoryUsageImpl();
    }

    private native int getObjectPendingFinalizationCountImpl();

    @Override
    public int getObjectPendingFinalizationCount() {
        return this.getObjectPendingFinalizationCountImpl();
    }

    private native boolean isVerboseImpl();

    @Override
    public boolean isVerbose() {
        return this.isVerboseImpl();
    }

    private native void setVerboseImpl(boolean var1);

    @Override
    public void setVerbose(boolean value) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new ManagementPermission("control"));
        }
        this.setVerboseImpl(value);
    }

    private native long getMaxHeapSizeLimitImpl();

    @Override
    public long getMaxHeapSizeLimit() {
        return this.getMaxHeapSizeLimitImpl();
    }

    private native long getMaxHeapSizeImpl();

    @Override
    public long getMaxHeapSize() {
        return this.getMaxHeapSizeImpl();
    }

    private native long getMinHeapSizeImpl();

    @Override
    public long getMinHeapSize() {
        return this.getMinHeapSizeImpl();
    }

    private native void setMaxHeapSizeImpl(long var1);

    @Override
    public void setMaxHeapSize(long size) {
        if (!this.isSetMaxHeapSizeSupported()) {
            throw new UnsupportedOperationException();
        }
        if (size < this.getMinHeapSize() || size > this.getMaxHeapSizeLimit()) {
            throw new IllegalArgumentException();
        }
        this.setMaxHeapSizeImpl(size);
    }

    private native boolean isSetMaxHeapSizeSupportedImpl();

    @Override
    public boolean isSetMaxHeapSizeSupported() {
        return this.isSetMaxHeapSizeSupportedImpl();
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.notifier.removeNotificationListener(listener, filter, handback);
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.notifier.addNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.notifier.removeNotificationListener(listener);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.getMBeanInfo().getNotifications();
    }

    public void sendNotification(Notification notification) {
        this.notifier.sendNotification(notification);
    }

    @Override
    public long getSharedClassCacheSize() {
        return SharedClassStatistics.maxSizeBytes();
    }

    @Override
    public long getSharedClassCacheFreeSpace() {
        return SharedClassStatistics.freeSpaceBytes();
    }

    @Override
    public String getGCMode() {
        return this.getGCModeImpl();
    }

    private native String getGCModeImpl();
}

