/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.AvailableProcessorsNotificationInfo;
import com.ibm.lang.management.ClassLoadingMXBeanImpl;
import com.ibm.lang.management.CompilationMXBeanImpl;
import com.ibm.lang.management.GarbageCollectorMXBeanImpl;
import com.ibm.lang.management.LoggingMXBeanImpl;
import com.ibm.lang.management.MemoryMXBeanImpl;
import com.ibm.lang.management.MemoryManagerMXBeanImpl;
import com.ibm.lang.management.MemoryPoolMXBeanImpl;
import com.ibm.lang.management.OperatingSystemMXBeanImpl;
import com.ibm.lang.management.ProcessingCapacityNotificationInfo;
import com.ibm.lang.management.RuntimeMXBeanImpl;
import com.ibm.lang.management.ThreadMXBeanImpl;
import com.ibm.lang.management.TotalPhysicalMemoryNotificationInfo;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.LockInfo;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.management.MonitorInfo;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.LoggingMXBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.Notification;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementUtils {
    private static Map<String, MBeanInfo> infoMap = ManagementUtils.buildInfoMap();
    private static CompositeType MEMORYUSAGE_COMPOSITETYPE;
    private static CompositeType MEMORYNOTIFICATIONINFO_COMPOSITETYPE;
    private static CompositeType PROCESSINGCAPACITYNOTIFICATIONINFO_COMPOSITETYPE;
    private static CompositeType TOTALPHYSICALMEMORYNOTIFICATIONINFO_COMPOSITETYPE;
    private static CompositeType AVAILABLEPROCESSORSNOTIFICATIONINFO_COMPOSITETYPE;
    private static CompositeType THREADINFO_COMPOSITETYPE;
    private static CompositeType MONITORINFO_COMPOSITETYPE;
    private static CompositeType LOCKINFO_COMPOSITETYPE;
    private static CompositeType STACKTRACEELEMENT_COMPOSITETYPE;
    public static final boolean VERBOSE_MODE;

    static {
        VERBOSE_MODE = ManagementUtils.checkVerboseProperty();
    }

    public static ClassLoadingMXBeanImpl getClassLoadingBean() {
        return ClassLoadingMXBeanImpl.getInstance();
    }

    private static boolean checkVerboseProperty() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                if (System.getProperty("com.ibm.lang.management.verbose") != null) {
                    return true;
                }
                return false;
            }
        });
    }

    static MBeanInfo getMBeanInfo(String name) {
        return infoMap.get(name);
    }

    private static Map<String, MBeanInfo> buildInfoMap() {
        HashMap<String, MBeanInfo> map = new HashMap<String, MBeanInfo>();
        ManagementUtils.addClassLoadingInfo(map);
        ManagementUtils.addCompilationBeanInfo(map);
        ManagementUtils.addLoggingBeanInfo(map);
        ManagementUtils.addMemoryManagerBeanInfo(map);
        ManagementUtils.addGarbageCollectorBeanInfo(map);
        ManagementUtils.addMemoryBeanInfo(map);
        ManagementUtils.addMemoryPoolBeanInfo(map);
        ManagementUtils.addOperatingSystemBeanInfo(map);
        ManagementUtils.addRuntimeBeanInfo(map);
        ManagementUtils.addThreadBeanInfo(map);
        return map;
    }

    private static void addThreadBeanInfo(HashMap<String, MBeanInfo> map) {
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{new MBeanAttributeInfo("AllThreadIds", "[J", "AllThreadIds", true, false, false), new MBeanAttributeInfo("CurrentThreadCpuTime", Long.TYPE.getName(), "CurrentThreadCpuTime", true, false, false), new MBeanAttributeInfo("CurrentThreadUserTime", Long.TYPE.getName(), "CurrentThreaduserTime", true, false, false), new MBeanAttributeInfo("DaemonThreadCount", Integer.TYPE.getName(), "DaemonThreadCount", true, false, false), new MBeanAttributeInfo("PeakThreadCount", Integer.TYPE.getName(), "PeakThreadCount", true, false, false), new MBeanAttributeInfo("ThreadCount", Integer.TYPE.getName(), "ThreadCount", true, false, false), new MBeanAttributeInfo("TotalStartedThreadCount", Long.TYPE.getName(), "TotalStartedThreadCount", true, false, false), new MBeanAttributeInfo("CurrentThreadCpuTimeSupported", Boolean.TYPE.getName(), "CurrentThreadCpuTimeSupported", true, false, true), new MBeanAttributeInfo("ThreadContentionMonitoringEnabled", Boolean.TYPE.getName(), "ThreadContentionMonitoringEnabled", true, true, true), new MBeanAttributeInfo("ThreadContentionMonitoringSupported", Boolean.TYPE.getName(), "ThreadContentionMonitoringSupported", true, false, true), new MBeanAttributeInfo("ThreadCpuTimeEnabled", Boolean.TYPE.getName(), "ThreadCpuTimeEnabled", true, true, true), new MBeanAttributeInfo("ThreadCpuTimeSupported", Boolean.TYPE.getName(), "ThreadCpuTimeSupported", true, false, true), new MBeanAttributeInfo("ObjectMonitorUsageSupported", Boolean.TYPE.getName(), "ObjectMonitorUsageSupported", true, false, true), new MBeanAttributeInfo("SynchronizerUsageSupported", Boolean.TYPE.getName(), "SynchronizerUsageSupported", true, false, true)};
        MBeanOperationInfo[] operations = new MBeanOperationInfo[11];
        MBeanParameterInfo[] nullParams = new MBeanParameterInfo[]{};
        operations[0] = new MBeanOperationInfo("findMonitorDeadlockedThreads", "findMonitorDeadlockedThreads", nullParams, "[J", 2);
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("id", Long.TYPE.getName(), "id")};
        operations[1] = new MBeanOperationInfo("getThreadCpuTime", "getThreadCpuTime", params, Long.TYPE.getName(), 2);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("id", Long.TYPE.getName(), "id")};
        operations[2] = new MBeanOperationInfo("getThreadInfo", "getThreadInfo", params, CompositeData.class.getName(), 2);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("ids", "[J", "ids")};
        operations[3] = new MBeanOperationInfo("getThreadInfo", "getThreadInfo", params, "[L" + CompositeData.class.getName() + ";", 2);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("ids", "[J", "ids"), new MBeanParameterInfo("maxDepth", Integer.TYPE.getName(), "maxDepth")};
        operations[4] = new MBeanOperationInfo("getThreadInfo", "getThreadInfo", params, "[L" + CompositeData.class.getName() + ";", 2);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("id", Long.TYPE.getName(), "id"), new MBeanParameterInfo("maxDepth", Integer.TYPE.getName(), "maxDepth")};
        operations[5] = new MBeanOperationInfo("getThreadInfo", "getThreadInfo", params, CompositeData.class.getName(), 2);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("id", Long.TYPE.getName(), "id")};
        operations[6] = new MBeanOperationInfo("getThreadUserTime", "getThreadUserTime", params, Long.TYPE.getName(), 2);
        operations[7] = new MBeanOperationInfo("resetPeakThreadCount", "resetPeakThreadCount", nullParams, Void.TYPE.getName(), 2);
        operations[8] = new MBeanOperationInfo("findDeadlockedThreads", "findDeadlockedThreads", nullParams, "[J", 2);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("lockedMonitors", Boolean.TYPE.getName(), "lockedMonitors"), new MBeanParameterInfo("lockedSynchronizers)", Boolean.TYPE.getName(), "lockedSynchronizers)")};
        operations[9] = new MBeanOperationInfo("dumpAllThreads", "dumpAllThreads", params, "[L" + CompositeData.class.getName() + ";", 2);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("ids", "[J", "ids"), new MBeanParameterInfo("lockedMonitors", Boolean.TYPE.getName(), "lockedMonitors"), new MBeanParameterInfo("lockedSynchronizers", Boolean.TYPE.getName(), "lockedSynchronizers")};
        operations[10] = new MBeanOperationInfo("getThreadInfo", "getThreadInfo", params, "[L" + CompositeData.class.getName() + ";", 2);
        map.put(ThreadMXBean.class.getName(), new MBeanInfo(ThreadMXBeanImpl.class.getName(), ThreadMXBeanImpl.class.getName(), attributes, null, operations, null));
    }

    private static void addRuntimeBeanInfo(HashMap<String, MBeanInfo> map) {
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{new MBeanAttributeInfo("BootClassPath", String.class.getName(), "BootClassPath", true, false, false), new MBeanAttributeInfo("ClassPath", String.class.getName(), "ClassPath", true, false, false), new MBeanAttributeInfo("InputArguments", "[Ljava.lang.String;", "InputArguments", true, false, false), new MBeanAttributeInfo("LibraryPath", String.class.getName(), "LibraryPath", true, false, false), new MBeanAttributeInfo("ManagementSpecVersion", String.class.getName(), "ManagementSpecVersion", true, false, false), new MBeanAttributeInfo("Name", String.class.getName(), "Name", true, false, false), new MBeanAttributeInfo("SpecName", String.class.getName(), "SpecName", true, false, false), new MBeanAttributeInfo("SpecVendor", String.class.getName(), "SpecVendor", true, false, false), new MBeanAttributeInfo("SpecVersion", String.class.getName(), "SpecVersion", true, false, false), new MBeanAttributeInfo("StartTime", Long.TYPE.getName(), "StartTime", true, false, false), new MBeanAttributeInfo("SystemProperties", TabularData.class.getName(), "SystemProperties", true, false, false), new MBeanAttributeInfo("Uptime", Long.TYPE.getName(), "Uptime", true, false, false), new MBeanAttributeInfo("VmName", String.class.getName(), "VmName", true, false, false), new MBeanAttributeInfo("VmVendor", String.class.getName(), "VmVendor", true, false, false), new MBeanAttributeInfo("VmVersion", String.class.getName(), "VmVersion", true, false, false), new MBeanAttributeInfo("BootClassPathSupported", Boolean.TYPE.getName(), "BootClassPathSupported", true, false, true)};
        map.put(RuntimeMXBean.class.getName(), new MBeanInfo(RuntimeMXBeanImpl.class.getName(), RuntimeMXBeanImpl.class.getName(), attributes, null, null, null));
    }

    private static void addOperatingSystemBeanInfo(HashMap<String, MBeanInfo> map) {
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{new MBeanAttributeInfo("Arch", String.class.getName(), "Arch", true, false, false), new MBeanAttributeInfo("AvailableProcessors", Integer.TYPE.getName(), "AvailableProcessors", true, false, false), new MBeanAttributeInfo("Name", String.class.getName(), "Name", true, false, false), new MBeanAttributeInfo("SystemLoadAverage", Double.TYPE.getName(), "SystemLoadAverage", true, false, false), new MBeanAttributeInfo("Version", String.class.getName(), "Version", true, false, false), new MBeanAttributeInfo("TotalPhysicalMemory", Long.TYPE.getName(), "TotalPhysicalMemory", true, false, false), new MBeanAttributeInfo("ProcessingCapacity", Integer.TYPE.getName(), "ProcessingCapacity", true, false, false)};
        MBeanNotificationInfo[] notifications = new MBeanNotificationInfo[3];
        String[] notifTypes = new String[]{"com.ibm.management.processing.capacity.change"};
        notifications[0] = new MBeanNotificationInfo(notifTypes, Notification.class.getName(), "Processing Capacity Notification");
        notifTypes = new String[]{"com.ibm.management.total.physical.memory.change"};
        notifications[1] = new MBeanNotificationInfo(notifTypes, Notification.class.getName(), "Total Physical Memory Notification");
        notifTypes = new String[]{"com.ibm.management.available.processors.change"};
        notifications[2] = new MBeanNotificationInfo(notifTypes, Notification.class.getName(), "Available Processors Notification");
        MBeanInfo mbeanInfo = new MBeanInfo(OperatingSystemMXBeanImpl.class.getName(), OperatingSystemMXBeanImpl.class.getName(), attributes, null, null, notifications);
        map.put(OperatingSystemMXBean.class.getName(), mbeanInfo);
        map.put("com.ibm.lang.management.OperatingSystemMXBean", mbeanInfo);
    }

    private static void addMemoryPoolBeanInfo(HashMap<String, MBeanInfo> map) {
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{new MBeanAttributeInfo("CollectionUsage", CompositeData.class.getName(), "CollectionUsage", true, false, false), new MBeanAttributeInfo("CollectionUsageThreshold", Long.TYPE.getName(), "CollectionUsageThreshold", true, true, false), new MBeanAttributeInfo("CollectionUsageThresholdCount", Long.TYPE.getName(), "CollectionUsageThresholdCount", true, false, false), new MBeanAttributeInfo("MemoryManagerNames", "[Ljava.lang.String;", "MemoryManagerNames", true, false, false), new MBeanAttributeInfo("Name", String.class.getName(), "Name", true, false, false), new MBeanAttributeInfo("PeakUsage", CompositeData.class.getName(), "PeakUsage", true, false, false), new MBeanAttributeInfo("Type", String.class.getName(), "Type", true, false, false), new MBeanAttributeInfo("Usage", CompositeData.class.getName(), "Usage", true, false, false), new MBeanAttributeInfo("UsageThreshold", Long.TYPE.getName(), "UsageThreshold", true, true, false), new MBeanAttributeInfo("UsageThresholdCount", Long.TYPE.getName(), "UsageThresholdCount", true, false, false), new MBeanAttributeInfo("CollectionUsageThresholdExceeded", Boolean.TYPE.getName(), "CollectionUsageThresholdExceeded", true, false, true), new MBeanAttributeInfo("CollectionUsageThresholdSupported", Boolean.TYPE.getName(), "CollectionUsageThresholdSupported", true, false, true), new MBeanAttributeInfo("UsageThresholdExceeded", Boolean.TYPE.getName(), "UsageThresholdExceeded", true, false, true), new MBeanAttributeInfo("UsageThresholdSupported", Boolean.TYPE.getName(), "UsageThresholdSupported", true, false, true), new MBeanAttributeInfo("Valid", Boolean.TYPE.getName(), "Valid", true, false, true), new MBeanAttributeInfo("PreCollectionUsage", CompositeData.class.getName(), "PreCollectionUsage", true, false, false)};
        MBeanOperationInfo[] operations = new MBeanOperationInfo[1];
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{};
        operations[0] = new MBeanOperationInfo("resetPeakUsage", "resetPeakUsage", params, Void.TYPE.getName(), 2);
        MBeanInfo mbeanInfo = new MBeanInfo(MemoryPoolMXBeanImpl.class.getName(), MemoryPoolMXBeanImpl.class.getName(), attributes, null, operations, null);
        map.put(MemoryPoolMXBean.class.getName(), mbeanInfo);
        map.put("com.ibm.lang.management.MemoryPoolMXBean", mbeanInfo);
    }

    private static void addMemoryBeanInfo(HashMap<String, MBeanInfo> map) {
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{new MBeanAttributeInfo("HeapMemoryUsage", CompositeData.class.getName(), "HeapMemoryUsage", true, false, false), new MBeanAttributeInfo("NonHeapMemoryUsage", CompositeData.class.getName(), "NonHeapMemoryUsage", true, false, false), new MBeanAttributeInfo("ObjectPendingFinalizationCount", Integer.TYPE.getName(), "ObjectPendingFinalizationCount", true, false, false), new MBeanAttributeInfo("Verbose", Boolean.TYPE.getName(), "Verbose", true, true, true), new MBeanAttributeInfo("MaxHeapSizeLimit", Long.TYPE.getName(), "MaxHeapSizeLimit", true, false, false), new MBeanAttributeInfo("MaxHeapSize", Long.TYPE.getName(), "MaxHeapSize", true, true, false), new MBeanAttributeInfo("MinHeapSize", Long.TYPE.getName(), "MinHeapSize", true, false, false), new MBeanAttributeInfo("SetMaxHeapSizeSupported", Boolean.TYPE.getName(), "SetMaxHeapSizeSupported", true, false, true), new MBeanAttributeInfo("SharedClassCacheSize", Long.TYPE.getName(), "SharedClassCacheSize", true, false, false), new MBeanAttributeInfo("SharedClassCacheFreeSpace", Long.TYPE.getName(), "SharedClassCacheFreeSpace", true, false, false), new MBeanAttributeInfo("GCMode", String.class.getName(), "GCMode", true, false, false)};
        MBeanOperationInfo[] operations = new MBeanOperationInfo[1];
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{};
        operations[0] = new MBeanOperationInfo("gc", "gc", params, Void.TYPE.getName(), 2);
        MBeanNotificationInfo[] notifications = new MBeanNotificationInfo[1];
        String[] notifTypes = new String[]{"java.management.memory.threshold.exceeded", "java.management.memory.collection.threshold.exceeded"};
        notifications[0] = new MBeanNotificationInfo(notifTypes, Notification.class.getName(), "Memory Notification");
        MBeanInfo mbeanInfo = new MBeanInfo(MemoryMXBeanImpl.class.getName(), MemoryMXBeanImpl.class.getName(), attributes, null, operations, notifications);
        map.put(MemoryMXBean.class.getName(), mbeanInfo);
        map.put("com.ibm.lang.management.MemoryMXBean", mbeanInfo);
    }

    private static void addMemoryManagerBeanInfo(HashMap<String, MBeanInfo> map) {
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{new MBeanAttributeInfo("MemoryPoolNames", "[Ljava.lang.String;", "MemoryPoolNames", true, false, false), new MBeanAttributeInfo("Name", String.class.getName(), "Name", true, false, false), new MBeanAttributeInfo("Valid", Boolean.TYPE.getName(), "Valid", true, false, true)};
        map.put(MemoryManagerMXBean.class.getName(), new MBeanInfo(MemoryManagerMXBeanImpl.class.getName(), MemoryManagerMXBeanImpl.class.getName(), attributes, null, null, null));
    }

    private static void addLoggingBeanInfo(HashMap<String, MBeanInfo> result) {
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{new MBeanAttributeInfo("LoggerNames", "[Ljava.lang.String;", "LoggerNames", true, false, false)};
        MBeanOperationInfo[] operations = new MBeanOperationInfo[3];
        MBeanParameterInfo[] params = new MBeanParameterInfo[]{new MBeanParameterInfo("loggerName", String.class.getName(), "loggerName")};
        operations[0] = new MBeanOperationInfo("getLoggerLevel", "getLoggerLevel", params, String.class.getName(), 2);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("loggerName", String.class.getName(), "loggerName")};
        operations[1] = new MBeanOperationInfo("getParentLoggerName", "getParentLoggerName", params, String.class.getName(), 2);
        params = new MBeanParameterInfo[]{new MBeanParameterInfo("loggerName", String.class.getName(), "loggerName"), new MBeanParameterInfo("levelName", String.class.getName(), "levelName")};
        operations[2] = new MBeanOperationInfo("setLoggerLevel", "setLoggerLevel", params, Void.TYPE.getName(), 2);
        result.put(LoggingMXBean.class.getName(), new MBeanInfo(LoggingMXBeanImpl.class.getName(), LoggingMXBeanImpl.class.getName(), attributes, null, operations, null));
    }

    private static void addGarbageCollectorBeanInfo(HashMap<String, MBeanInfo> map) {
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{new MBeanAttributeInfo("MemoryPoolNames", "[Ljava.lang.String;", "MemoryPoolNames", true, false, false), new MBeanAttributeInfo("Name", String.class.getName(), "Name", true, false, false), new MBeanAttributeInfo("Valid", Boolean.TYPE.getName(), "Valid", true, false, true), new MBeanAttributeInfo("CollectionCount", Long.TYPE.getName(), "CollectionCount", true, false, false), new MBeanAttributeInfo("CollectionTime", Long.TYPE.getName(), "CollectionTime", true, false, false), new MBeanAttributeInfo("LastCollectionStartTime", Long.TYPE.getName(), "LastCollectionStartTime", true, false, false), new MBeanAttributeInfo("LastCollectionEndTime", Long.TYPE.getName(), "LastCollectionEndTime", true, false, false)};
        MBeanInfo mbeanInfo = new MBeanInfo(GarbageCollectorMXBeanImpl.class.getName(), GarbageCollectorMXBeanImpl.class.getName(), attributes, null, null, null);
        map.put(GarbageCollectorMXBean.class.getName(), mbeanInfo);
        map.put("com.ibm.lang.management.GarbageCollectorMXBean", mbeanInfo);
    }

    private static void addCompilationBeanInfo(HashMap<String, MBeanInfo> result) {
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{new MBeanAttributeInfo("Name", String.class.getName(), "Name", true, false, false), new MBeanAttributeInfo("TotalCompilationTime", Long.TYPE.getName(), "TotalCompilationTime", true, false, false), new MBeanAttributeInfo("CompilationTimeMonitoringSupported", Boolean.TYPE.getName(), "CompilationTimeMonitoringSupported", true, false, true)};
        result.put(CompilationMXBean.class.getName(), new MBeanInfo(CompilationMXBeanImpl.class.getName(), CompilationMXBeanImpl.class.getName(), attributes, null, null, null));
    }

    private static void addClassLoadingInfo(HashMap<String, MBeanInfo> result) {
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{new MBeanAttributeInfo("LoadedClassCount", Integer.TYPE.getName(), "LoadedClassCount", true, false, false), new MBeanAttributeInfo("TotalLoadedClassCount", Long.TYPE.getName(), "TotalLoadedClassCount", true, false, false), new MBeanAttributeInfo("UnloadedClassCount", Long.TYPE.getName(), "UnloadedClassCount", true, false, false), new MBeanAttributeInfo("Verbose", Boolean.TYPE.getName(), "Verbose", true, true, true)};
        result.put(ClassLoadingMXBean.class.getName(), new MBeanInfo(ClassLoadingMXBeanImpl.class.getName(), ClassLoadingMXBeanImpl.class.getName(), attributes, null, null, null));
    }

    public static MemoryMXBeanImpl getMemoryBean() {
        return MemoryMXBeanImpl.getInstance();
    }

    public static ThreadMXBeanImpl getThreadBean() {
        return ThreadMXBeanImpl.getInstance();
    }

    public static RuntimeMXBeanImpl getRuntimeBean() {
        return RuntimeMXBeanImpl.getInstance();
    }

    public static OperatingSystemMXBeanImpl getOperatingSystemBean() {
        return OperatingSystemMXBeanImpl.getInstance();
    }

    public static CompilationMXBeanImpl getCompliationBean() {
        return CompilationMXBeanImpl.getInstance();
    }

    public static LoggingMXBeanImpl getLoggingBean() {
        return LoggingMXBeanImpl.getInstance();
    }

    public static List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        return new LinkedList<MemoryManagerMXBean>(ManagementUtils.getMemoryBean().getMemoryManagerMXBeans());
    }

    public static List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        LinkedList<MemoryPoolMXBean> result = new LinkedList<MemoryPoolMXBean>();
        for (MemoryManagerMXBeanImpl memoryManagerMXBeanImpl : ManagementUtils.getMemoryManagerMXBeans()) {
            result.addAll(memoryManagerMXBeanImpl.getMemoryPoolMXBeans());
        }
        return result;
    }

    public static List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        LinkedList<GarbageCollectorMXBean> result = new LinkedList<GarbageCollectorMXBean>();
        for (MemoryManagerMXBean b : ManagementUtils.getMemoryBean().getMemoryManagerMXBeans()) {
            if (!(b instanceof GarbageCollectorMXBean)) continue;
            result.add((GarbageCollectorMXBean)b);
        }
        return result;
    }

    public static void verifyFieldTypes(CompositeData cd, String[] expectedNames, String[] expectedTypes) {
        CompositeType cType = cd.getCompositeType();
        Object[] allVals = cd.getAll(expectedNames);
        if (allVals.length != expectedTypes.length) {
            throw new IllegalArgumentException("CompositeData does not contain the expected number of attributes.");
        }
        boolean expectedIndex = false;
        int i = 0;
        while (i < allVals.length) {
            String actualType;
            String expectedType = expectedTypes[i];
            Object actualVal = allVals[i];
            if (actualVal != null && !(actualType = actualVal.getClass().getName()).equals(expectedType)) {
                if (expectedType.equals(CompositeData.class.getName())) {
                    if (actualVal instanceof CompositeData) {
                        // empty if block
                    }
                } else {
                    throw new IllegalArgumentException("CompositeData contains an attribute not of expected type. Expected " + expectedType + ", found " + actualType);
                }
            }
            ++i;
        }
    }

    public static void verifyFieldNames(CompositeData cd, String[] expected) {
        int i = 0;
        while (i < expected.length) {
            if (!cd.containsKey(expected[i])) {
                throw new IllegalArgumentException("CompositeData object does not contain expected key : " + expected[i]);
            }
            ++i;
        }
    }

    public static void verifyFieldNumber(CompositeData cd, int i) {
        if (cd == null) {
            throw new NullPointerException("Null CompositeData");
        }
        if (cd.values().size() != i) {
            throw new IllegalArgumentException("CompositeData object does not have the expected number of attributes");
        }
    }

    public static CompositeData toMemoryUsageCompositeData(MemoryUsage usage) {
        CompositeDataSupport result;
        block3: {
            if (usage == null) {
                return null;
            }
            result = null;
            String[] names = new String[]{"init", "used", "committed", "max"};
            Object[] values = new Object[]{new Long(usage.getInit()), new Long(usage.getUsed()), new Long(usage.getCommitted()), new Long(usage.getMax())};
            CompositeType cType = ManagementUtils.getMemoryUsageCompositeType();
            try {
                result = new CompositeDataSupport(cType, names, values);
            }
            catch (OpenDataException e) {
                if (!VERBOSE_MODE) break block3;
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    public static CompositeType getMemoryUsageCompositeType() {
        block3: {
            if (MEMORYUSAGE_COMPOSITETYPE == null) {
                String[] typeNames = new String[]{"init", "used", "committed", "max"};
                String[] typeDescs = new String[]{"init", "used", "committed", "max"};
                OpenType[] typeTypes = new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG};
                try {
                    MEMORYUSAGE_COMPOSITETYPE = new CompositeType(MemoryUsage.class.getName(), MemoryUsage.class.getName(), typeNames, typeDescs, typeTypes);
                }
                catch (OpenDataException e) {
                    if (!VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return MEMORYUSAGE_COMPOSITETYPE;
    }

    public static CompositeData toMemoryNotificationInfoCompositeData(MemoryNotificationInfo info) {
        CompositeDataSupport result;
        block3: {
            if (info == null) {
                return null;
            }
            result = null;
            String[] names = new String[]{"poolName", "usage", "count"};
            Object[] values = new Object[]{new String(info.getPoolName()), ManagementUtils.toMemoryUsageCompositeData(info.getUsage()), new Long(info.getCount())};
            CompositeType cType = ManagementUtils.getMemoryNotificationInfoCompositeType();
            try {
                result = new CompositeDataSupport(cType, names, values);
            }
            catch (OpenDataException e) {
                if (!VERBOSE_MODE) break block3;
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    private static CompositeType getMemoryNotificationInfoCompositeType() {
        block3: {
            if (MEMORYNOTIFICATIONINFO_COMPOSITETYPE == null) {
                String[] typeNames = new String[]{"poolName", "usage", "count"};
                String[] typeDescs = new String[]{"poolName", "usage", "count"};
                OpenType[] typeTypes = new OpenType[]{SimpleType.STRING, ManagementUtils.getMemoryUsageCompositeType(), SimpleType.LONG};
                try {
                    MEMORYNOTIFICATIONINFO_COMPOSITETYPE = new CompositeType(MemoryNotificationInfo.class.getName(), MemoryNotificationInfo.class.getName(), typeNames, typeDescs, typeTypes);
                }
                catch (OpenDataException e) {
                    if (!VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return MEMORYNOTIFICATIONINFO_COMPOSITETYPE;
    }

    private static CompositeType getProcessingCapacityNotificationInfoCompositeType() {
        block3: {
            if (PROCESSINGCAPACITYNOTIFICATIONINFO_COMPOSITETYPE == null) {
                String[] typeNames = new String[]{"newProcessingCapacity"};
                String[] typeDescs = new String[]{"newProcessingCapacity"};
                OpenType[] typeTypes = new OpenType[]{SimpleType.INTEGER};
                try {
                    PROCESSINGCAPACITYNOTIFICATIONINFO_COMPOSITETYPE = new CompositeType(ProcessingCapacityNotificationInfo.class.getName(), ProcessingCapacityNotificationInfo.class.getName(), typeNames, typeDescs, typeTypes);
                }
                catch (OpenDataException e) {
                    if (!VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return PROCESSINGCAPACITYNOTIFICATIONINFO_COMPOSITETYPE;
    }

    private static CompositeType getTotalPhysicalMemoryNotificationInfoCompositeType() {
        block3: {
            if (TOTALPHYSICALMEMORYNOTIFICATIONINFO_COMPOSITETYPE == null) {
                String[] typeNames = new String[]{"newTotalPhysicalMemory"};
                String[] typeDescs = new String[]{"newTotalPhysicalMemory"};
                OpenType[] typeTypes = new OpenType[]{SimpleType.LONG};
                try {
                    TOTALPHYSICALMEMORYNOTIFICATIONINFO_COMPOSITETYPE = new CompositeType(TotalPhysicalMemoryNotificationInfo.class.getName(), TotalPhysicalMemoryNotificationInfo.class.getName(), typeNames, typeDescs, typeTypes);
                }
                catch (OpenDataException e) {
                    if (!VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return TOTALPHYSICALMEMORYNOTIFICATIONINFO_COMPOSITETYPE;
    }

    private static CompositeType getAvailableProcessorsNotificationInfoCompositeType() {
        block3: {
            if (AVAILABLEPROCESSORSNOTIFICATIONINFO_COMPOSITETYPE == null) {
                String[] typeNames = new String[]{"newAvailableProcessors"};
                String[] typeDescs = new String[]{"newAvailableProcessors"};
                OpenType[] typeTypes = new OpenType[]{SimpleType.INTEGER};
                try {
                    AVAILABLEPROCESSORSNOTIFICATIONINFO_COMPOSITETYPE = new CompositeType(AvailableProcessorsNotificationInfo.class.getName(), AvailableProcessorsNotificationInfo.class.getName(), typeNames, typeDescs, typeTypes);
                }
                catch (OpenDataException e) {
                    if (!VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return AVAILABLEPROCESSORSNOTIFICATIONINFO_COMPOSITETYPE;
    }

    public static CompositeData toProcessingCapacityNotificationInfoCompositeData(ProcessingCapacityNotificationInfo info) {
        CompositeDataSupport result;
        block3: {
            if (info == null) {
                return null;
            }
            result = null;
            String[] names = new String[]{"newProcessingCapacity"};
            Object[] values = new Object[]{new Integer(info.getNewProcessingCapacity())};
            CompositeType cType = ManagementUtils.getProcessingCapacityNotificationInfoCompositeType();
            try {
                result = new CompositeDataSupport(cType, names, values);
            }
            catch (OpenDataException e) {
                if (!VERBOSE_MODE) break block3;
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    public static CompositeData toTotalPhysicalMemoryNotificationInfoCompositeData(TotalPhysicalMemoryNotificationInfo info) {
        CompositeDataSupport result;
        block3: {
            if (info == null) {
                return null;
            }
            result = null;
            String[] names = new String[]{"newTotalPhysicalMemory"};
            Object[] values = new Object[]{new Long(info.getNewTotalPhysicalMemory())};
            CompositeType cType = ManagementUtils.getTotalPhysicalMemoryNotificationInfoCompositeType();
            try {
                result = new CompositeDataSupport(cType, names, values);
            }
            catch (OpenDataException e) {
                if (!VERBOSE_MODE) break block3;
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    public static CompositeData toAvailableProcessorsNotificationInfoCompositeData(AvailableProcessorsNotificationInfo info) {
        CompositeDataSupport result;
        block3: {
            if (info == null) {
                return null;
            }
            result = null;
            String[] names = new String[]{"newAvailableProcessors"};
            Object[] values = new Object[]{new Integer(info.getNewAvailableProcessors())};
            CompositeType cType = ManagementUtils.getAvailableProcessorsNotificationInfoCompositeType();
            try {
                result = new CompositeDataSupport(cType, names, values);
            }
            catch (OpenDataException e) {
                if (!VERBOSE_MODE) break block3;
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    public static CompositeData toThreadInfoCompositeData(ThreadInfo info) {
        CompositeDataSupport result;
        block6: {
            if (info == null) {
                return null;
            }
            result = null;
            StackTraceElement[] st = info.getStackTrace();
            CompositeData[] stArray = new CompositeData[st.length];
            int i = 0;
            while (i < st.length) {
                stArray[i] = ManagementUtils.toStackTraceElementCompositeData(st[i]);
                ++i;
            }
            MonitorInfo[] lockedMonitors = info.getLockedMonitors();
            CompositeData[] lmArray = new CompositeData[lockedMonitors.length];
            int i2 = 0;
            while (i2 < lmArray.length) {
                lmArray[i2] = ManagementUtils.toMonitorInfoCompositeData(lockedMonitors[i2]);
                ++i2;
            }
            LockInfo[] lockedSynchronizers = info.getLockedSynchronizers();
            CompositeData[] lsArray = new CompositeData[lockedSynchronizers.length];
            int i3 = 0;
            while (i3 < lsArray.length) {
                lsArray[i3] = ManagementUtils.toLockInfoCompositeData(lockedSynchronizers[i3]);
                ++i3;
            }
            String[] names = new String[]{"threadId", "threadName", "threadState", "suspended", "inNative", "blockedCount", "blockedTime", "waitedCount", "waitedTime", "lockInfo", "lockName", "lockOwnerId", "lockOwnerName", "stackTrace", "lockedMonitors", "lockedSynchronizers"};
            Object[] values = new Object[]{new Long(info.getThreadId()), new String(info.getThreadName()), new String(info.getThreadState().name()), new Boolean(info.isSuspended()), new Boolean(info.isInNative()), new Long(info.getBlockedCount()), new Long(info.getBlockedTime()), new Long(info.getWaitedCount()), new Long(info.getWaitedTime()), info.getLockInfo() != null ? ManagementUtils.toLockInfoCompositeData(info.getLockInfo()) : null, info.getLockName() != null ? new String(info.getLockName()) : null, new Long(info.getLockOwnerId()), info.getLockOwnerName() != null ? new String(info.getLockOwnerName()) : null, stArray, lmArray, lsArray};
            CompositeType cType = ManagementUtils.getThreadInfoCompositeType();
            try {
                result = new CompositeDataSupport(cType, names, values);
            }
            catch (OpenDataException e) {
                if (!VERBOSE_MODE) break block6;
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    public static CompositeData toMonitorInfoCompositeData(MonitorInfo info) {
        CompositeDataSupport result;
        block3: {
            if (info == null) {
                return null;
            }
            result = null;
            String[] names = new String[]{"className", "identityHashCode", "lockedStackFrame", "lockedStackDepth"};
            StackTraceElement frame = info.getLockedStackFrame();
            CompositeData frameCD = ManagementUtils.toStackTraceElementCompositeData(frame);
            Object[] values = new Object[]{new String(info.getClassName()), new Integer(info.getIdentityHashCode()), frameCD, new Integer(info.getLockedStackDepth())};
            CompositeType cType = ManagementUtils.getMonitorInfoCompositeType();
            try {
                result = new CompositeDataSupport(cType, names, values);
            }
            catch (OpenDataException e) {
                if (!VERBOSE_MODE) break block3;
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    public static CompositeData toLockInfoCompositeData(LockInfo info) {
        CompositeDataSupport result;
        block3: {
            if (info == null) {
                return null;
            }
            result = null;
            String[] names = new String[]{"className", "identityHashCode"};
            Object[] values = new Object[]{new String(info.getClassName()), new Integer(info.getIdentityHashCode())};
            CompositeType cType = ManagementUtils.getLockInfoCompositeType();
            try {
                result = new CompositeDataSupport(cType, names, values);
            }
            catch (OpenDataException e) {
                if (!VERBOSE_MODE) break block3;
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    public static CompositeData toStackTraceElementCompositeData(StackTraceElement element) {
        CompositeDataSupport result;
        block3: {
            if (element == null) {
                return null;
            }
            result = null;
            String[] names = new String[]{"className", "methodName", "fileName", "lineNumber", "nativeMethod"};
            String fileName = element.getFileName();
            String fileNameValue = fileName == null ? null : new String(fileName);
            Object[] values = new Object[]{new String(element.getClassName()), new String(element.getMethodName()), fileNameValue, new Integer(element.getLineNumber()), new Boolean(element.isNativeMethod())};
            CompositeType cType = ManagementUtils.getStackTraceElementCompositeType();
            try {
                result = new CompositeDataSupport(cType, names, values);
            }
            catch (OpenDataException e) {
                if (!VERBOSE_MODE) break block3;
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    private static CompositeType getMonitorInfoCompositeType() {
        block3: {
            if (MONITORINFO_COMPOSITETYPE == null) {
                try {
                    String[] typeNames = new String[]{"className", "identityHashCode", "lockedStackFrame", "lockedStackDepth"};
                    String[] typeDescs = new String[]{"className", "identityHashCode", "lockedStackFrame", "lockedStackDepth"};
                    OpenType[] typeTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER, ManagementUtils.getStackTraceElementCompositeType(), SimpleType.INTEGER};
                    MONITORINFO_COMPOSITETYPE = new CompositeType(MonitorInfo.class.getName(), MonitorInfo.class.getName(), typeNames, typeDescs, typeTypes);
                }
                catch (OpenDataException e) {
                    if (!VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return MONITORINFO_COMPOSITETYPE;
    }

    public static CompositeType getLockInfoCompositeType() {
        block3: {
            if (LOCKINFO_COMPOSITETYPE == null) {
                try {
                    String[] typeNames = new String[]{"className", "identityHashCode"};
                    String[] typeDescs = new String[]{"className", "identityHashCode"};
                    OpenType[] typeTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER};
                    LOCKINFO_COMPOSITETYPE = new CompositeType(LockInfo.class.getName(), LockInfo.class.getName(), typeNames, typeDescs, typeTypes);
                }
                catch (OpenDataException e) {
                    if (!VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return LOCKINFO_COMPOSITETYPE;
    }

    public static CompositeType getThreadInfoCompositeType() {
        block3: {
            if (THREADINFO_COMPOSITETYPE == null) {
                try {
                    String[] typeNames = new String[]{"threadId", "threadName", "threadState", "suspended", "inNative", "blockedCount", "blockedTime", "waitedCount", "waitedTime", "lockInfo", "lockName", "lockOwnerId", "lockOwnerName", "stackTrace", "lockedMonitors", "lockedSynchronizers"};
                    String[] typeDescs = new String[]{"threadId", "threadName", "threadState", "suspended", "inNative", "blockedCount", "blockedTime", "waitedCount", "waitedTime", "lockInfo", "lockName", "lockOwnerId", "lockOwnerName", "stackTrace", "lockedMonitors", "lockedSynchronizers"};
                    OpenType[] typeTypes = new OpenType[]{SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.BOOLEAN, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, ManagementUtils.getLockInfoCompositeType(), SimpleType.STRING, SimpleType.LONG, SimpleType.STRING, new ArrayType(1, ManagementUtils.getStackTraceElementCompositeType()), new ArrayType(1, ManagementUtils.getMonitorInfoCompositeType()), new ArrayType(1, ManagementUtils.getLockInfoCompositeType())};
                    THREADINFO_COMPOSITETYPE = new CompositeType(ThreadInfo.class.getName(), ThreadInfo.class.getName(), typeNames, typeDescs, typeTypes);
                }
                catch (OpenDataException e) {
                    if (!VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return THREADINFO_COMPOSITETYPE;
    }

    private static CompositeType getStackTraceElementCompositeType() {
        block3: {
            if (STACKTRACEELEMENT_COMPOSITETYPE == null) {
                String[] typeNames = new String[]{"className", "methodName", "fileName", "lineNumber", "nativeMethod"};
                String[] typeDescs = new String[]{"className", "methodName", "fileName", "lineNumber", "nativeMethod"};
                OpenType[] typeTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.BOOLEAN};
                try {
                    STACKTRACEELEMENT_COMPOSITETYPE = new CompositeType(StackTraceElement.class.getName(), StackTraceElement.class.getName(), typeNames, typeDescs, typeTypes);
                }
                catch (OpenDataException e) {
                    if (!VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
        }
        return STACKTRACEELEMENT_COMPOSITETYPE;
    }

    public static List<String> convertStringArrayToList(String[] data) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < data.length) {
            result.add(data[i]);
            ++i;
        }
        return result;
    }

    public static Object convertTabularDataToMap(TabularData data) {
        if (data == null) {
            return null;
        }
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        Set<String> cdKeySet = data.getTabularType().getRowType().keySet();
        if (cdKeySet.size() != 2) {
            throw new IllegalArgumentException("TabularData's row type is not a CompositeType with two items.");
        }
        String[] keysArray = new String[2];
        int count = 0;
        Iterator<String> keysIt = cdKeySet.iterator();
        while (keysIt.hasNext()) {
            keysArray[count++] = keysIt.next();
        }
        Collection<?> rows = data.values();
        for (CompositeData rowCD : rows) {
            result.put(rowCD.get(keysArray[0]), rowCD.get(keysArray[1]));
        }
        return result;
    }

    public static <T> T convertFromCompositeData(CompositeData data, Class<T> realClass) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (data == null) {
            return null;
        }
        Method forMethod = realClass.getMethod("from", CompositeData.class);
        return (T)forMethod.invoke(null, data);
    }

    public static <T> T convertFromOpenType(Object data, Class<?> openClass, Class<T> realClass) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        if (data == null) {
            return null;
        }
        Object result = null;
        if (openClass.isArray() && realClass.isArray()) {
            Class<?> openElementClass = openClass.getComponentType();
            Class<?> realElementClass = realClass.getComponentType();
            Object[] dataArray = (Object[])data;
            result = Array.newInstance(realElementClass, dataArray.length);
            int i = 0;
            while (i < Array.getLength(result)) {
                Array.set(result, i, ManagementUtils.convertFromOpenType(dataArray[i], openElementClass, realElementClass));
                ++i;
            }
        } else if (openClass.equals(CompositeData.class)) {
            result = ManagementUtils.convertFromCompositeData((CompositeData)data, realClass);
        } else if (openClass.equals(TabularData.class)) {
            if (realClass.equals(Map.class)) {
                result = ManagementUtils.convertTabularDataToMap((TabularData)data);
            }
        } else if (openClass.equals(String[].class)) {
            if (realClass.equals(List.class)) {
                result = ManagementUtils.convertStringArrayToList((String[])data);
            }
        } else if (openClass.equals(String.class) && realClass.equals(MemoryType.class)) {
            result = ManagementUtils.convertStringToMemoryType((String)data);
        }
        return (T)result;
    }

    private static MemoryType convertStringToMemoryType(String data) {
        MemoryType result;
        block2: {
            result = null;
            try {
                result = MemoryType.valueOf(data);
            }
            catch (IllegalArgumentException e) {
                if (!VERBOSE_MODE) break block2;
                e.printStackTrace(System.err);
            }
        }
        return result;
    }

    public static <T> T convertToOpenType(Object data, Class<T> openClass, Class<?> realClass) {
        if (data == null) {
            return null;
        }
        Object result = null;
        if (openClass.isArray() && realClass.isArray()) {
            Class<?> openElementClass = openClass.getComponentType();
            Class<?> realElementClass = realClass.getComponentType();
            Object[] dataArray = (Object[])data;
            result = Array.newInstance(openElementClass, dataArray.length);
            int i = 0;
            while (i < Array.getLength(result)) {
                Array.set(result, i, ManagementUtils.convertToOpenType(dataArray[i], openElementClass, realElementClass));
                ++i;
            }
        } else if (openClass.equals(CompositeData.class)) {
            if (realClass.equals(ThreadInfo.class)) {
                result = ManagementUtils.toThreadInfoCompositeData((ThreadInfo)data);
            } else if (realClass.equals(MemoryUsage.class)) {
                result = ManagementUtils.toMemoryUsageCompositeData((MemoryUsage)data);
            } else if (realClass.equals(MonitorInfo.class)) {
                result = ManagementUtils.toMonitorInfoCompositeData((MonitorInfo)data);
            } else if (realClass.equals(LockInfo.class)) {
                result = ManagementUtils.toLockInfoCompositeData((LockInfo)data);
            }
        } else if (openClass.equals(TabularData.class)) {
            if (realClass.equals(Map.class)) {
                result = ManagementUtils.toSystemPropertiesTabularData((Map)data);
            }
        } else if (openClass.equals(String[].class)) {
            if (realClass.equals(List.class)) {
                result = ManagementUtils.convertListToArray((List)data, openClass, openClass.getComponentType());
            }
        } else if (openClass.equals(String.class) && realClass.isEnum()) {
            result = ((Enum)data).name();
        }
        return (T)result;
    }

    private static <T, E> T convertListToArray(List<E> list, Class<T> arrayType, Class<E> elementType) {
        Object result = Array.newInstance(elementType, list.size());
        Iterator<E> it = list.iterator();
        int count = 0;
        while (it.hasNext()) {
            E element = it.next();
            Array.set(result, count++, element);
        }
        return (T)result;
    }

    public static TabularData toSystemPropertiesTabularData(Map<String, String> propsMap) {
        if (propsMap == null) {
            return null;
        }
        TabularDataSupport result = null;
        try {
            String[] rtItemNames = new String[]{"key", "value"};
            String[] rtItemDescs = new String[]{"key", "value"};
            OpenType[] rtItemTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING};
            CompositeType rowType = new CompositeType(propsMap.getClass().getName(), propsMap.getClass().getName(), rtItemNames, rtItemDescs, rtItemTypes);
            TabularType sysPropsType = new TabularType(propsMap.getClass().getName(), propsMap.getClass().getName(), rowType, new String[]{"key"});
            result = new TabularDataSupport(sysPropsType);
            Set<String> keys = propsMap.keySet();
            for (String propKey : keys) {
                String propVal = propsMap.get(propKey);
                result.put(new CompositeDataSupport(rowType, rtItemNames, new String[]{propKey, propVal}));
            }
        }
        catch (OpenDataException e) {
            if (VERBOSE_MODE) {
                e.printStackTrace(System.err);
            }
            result = null;
        }
        return result;
    }

    public static Class getClassMaybePrimitive(String name) throws ClassNotFoundException {
        Class<Object> result = null;
        try {
            result = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            if (name.equals(Boolean.TYPE.getName())) {
                result = Boolean.TYPE;
            }
            if (name.equals(Character.TYPE.getName())) {
                result = Character.TYPE;
            }
            if (name.equals(Byte.TYPE.getName())) {
                result = Byte.TYPE;
            }
            if (name.equals(Short.TYPE.getName())) {
                result = Short.TYPE;
            }
            if (name.equals(Integer.TYPE.getName())) {
                result = Integer.TYPE;
            }
            if (name.equals(Long.TYPE.getName())) {
                result = Long.TYPE;
            }
            if (name.equals(Float.TYPE.getName())) {
                result = Float.TYPE;
            }
            if (name.equals(Double.TYPE.getName())) {
                result = Double.TYPE;
            }
            if (name.equals(Void.TYPE.getName())) {
                result = Void.TYPE;
            }
            if (VERBOSE_MODE) {
                e.printStackTrace(System.err);
            }
            throw e;
        }
        return result;
    }

    public static boolean isWrapperClass(Class<? extends Object> wrapper, Class primitive) {
        boolean result = true;
        if (primitive.equals(Boolean.TYPE) && !wrapper.equals(Boolean.class)) {
            result = false;
        } else if (primitive.equals(Character.TYPE) && !wrapper.equals(Character.class)) {
            result = false;
        } else if (primitive.equals(Byte.TYPE) && !wrapper.equals(Byte.class)) {
            result = false;
        } else if (primitive.equals(Short.TYPE) && !wrapper.equals(Short.class)) {
            result = false;
        } else if (primitive.equals(Integer.TYPE) && !wrapper.equals(Integer.class)) {
            result = false;
        } else if (primitive.equals(Long.TYPE) && !wrapper.equals(Long.class)) {
            result = false;
        } else if (primitive.equals(Float.TYPE) && !wrapper.equals(Float.class)) {
            result = false;
        } else if (primitive.equals(Double.TYPE) && !wrapper.equals(Double.class)) {
            result = false;
        }
        return result;
    }

    public static <T> boolean isANotificationEmitter(Class<T> mxbeanInterface) {
        MBeanNotificationInfo[] notifications;
        boolean result = false;
        MBeanInfo info = ManagementUtils.getMBeanInfo(mxbeanInterface.getName());
        if (info != null && (notifications = info.getNotifications()) != null && notifications.length > 0) {
            result = true;
        }
        return result;
    }

    public static StackTraceElement[] getStackTracesFromCompositeDataArray(CompositeData[] stackTraceDataVal) {
        if (stackTraceDataVal == null) {
            return null;
        }
        StackTraceElement[] result = new StackTraceElement[stackTraceDataVal.length];
        int i = 0;
        while (i < stackTraceDataVal.length) {
            CompositeData data = stackTraceDataVal[i];
            if (data != null) {
                StackTraceElement element;
                ManagementUtils.verifyFieldNumber(data, 5);
                String[] attributeNames = new String[]{"className", "methodName", "fileName", "lineNumber", "nativeMethod"};
                ManagementUtils.verifyFieldNames(data, attributeNames);
                String[] attributeTypes = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.Integer", "java.lang.Boolean"};
                ManagementUtils.verifyFieldTypes(data, attributeNames, attributeTypes);
                Object[] attributeVals = data.getAll(attributeNames);
                String classNameVal = (String)attributeVals[0];
                String methodNameVal = (String)attributeVals[1];
                String fileNameVal = (String)attributeVals[2];
                int lineNumberVal = (Integer)attributeVals[3];
                boolean nativeMethodVal = (Boolean)attributeVals[4];
                result[i] = element = new StackTraceElement(classNameVal, methodNameVal, fileNameVal, lineNumberVal);
            } else {
                result[i] = null;
            }
            ++i;
        }
        return result;
    }

    public static LockInfo[] getLockInfosFromCompositeDataArray(CompositeData[] lockInfosCDArray) {
        if (lockInfosCDArray == null) {
            return null;
        }
        LockInfo[] result = new LockInfo[lockInfosCDArray.length];
        int i = 0;
        while (i < lockInfosCDArray.length) {
            LockInfo element;
            CompositeData data = lockInfosCDArray[i];
            ManagementUtils.verifyFieldNumber(data, 2);
            String[] attributeNames = new String[]{"className", "identityHashCode"};
            ManagementUtils.verifyFieldNames(data, attributeNames);
            String[] attributeTypes = new String[]{"java.lang.String", "java.lang.Integer"};
            ManagementUtils.verifyFieldTypes(data, attributeNames, attributeTypes);
            Object[] attributeVals = data.getAll(attributeNames);
            String className = (String)attributeVals[0];
            int idHashCode = (Integer)attributeVals[1];
            result[i] = element = new LockInfo(className, idHashCode);
            ++i;
        }
        return result;
    }

    public static MonitorInfo[] getMonitorInfosFromCompositeDataArray(CompositeData[] monitorInfosCDArray) {
        if (monitorInfosCDArray == null) {
            return null;
        }
        MonitorInfo[] result = new MonitorInfo[monitorInfosCDArray.length];
        int i = 0;
        while (i < monitorInfosCDArray.length) {
            CompositeData data = monitorInfosCDArray[i];
            ManagementUtils.verifyFieldNumber(data, 4);
            String[] attributeNames = new String[]{"className", "identityHashCode", "lockedStackFrame", "lockedStackDepth"};
            ManagementUtils.verifyFieldNames(data, attributeNames);
            String[] attributeTypes = new String[]{"java.lang.String", "java.lang.Integer", CompositeData.class.getName(), "java.lang.Integer"};
            ManagementUtils.verifyFieldTypes(data, attributeNames, attributeTypes);
            result[i] = MonitorInfo.from(data);
            ++i;
        }
        return result;
    }

    public static StackTraceElement getStackTraceFromCompositeData(CompositeData stackTraceCD) {
        return ManagementUtils.getStackTracesFromCompositeDataArray(new CompositeData[]{stackTraceCD})[0];
    }
}

