/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.ManagementUtils;
import java.lang.reflect.Method;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;

public abstract class DynamicMXBeanImpl
implements DynamicMBean {
    protected MBeanInfo info;

    protected void initMBeanInfo(String className, String description, MBeanAttributeInfo[] attributes, MBeanConstructorInfo[] constructors, MBeanOperationInfo[] operations, MBeanNotificationInfo[] notifications) {
        this.info = new MBeanInfo(className, description, attributes, constructors, operations, notifications);
    }

    protected void setMBeanInfo(MBeanInfo info) {
        this.info = info;
    }

    public AttributeList getAttributes(String[] attributes) {
        AttributeList result = new AttributeList();
        int i = 0;
        while (i < attributes.length) {
            block3: {
                try {
                    Object value = this.getAttribute(attributes[i]);
                    result.add(new Attribute(attributes[i], value));
                }
                catch (Exception e) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
            ++i;
        }
        return result;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList result = new AttributeList();
        int i = 0;
        while (i < attributes.size()) {
            block3: {
                Attribute attrib = (Attribute)attributes.get(i);
                String attribName = null;
                Object attribVal = null;
                try {
                    this.setAttribute(attrib);
                    attribName = attrib.getName();
                    attribVal = this.getAttribute(attribName);
                    result.add(new Attribute(attribName, attribVal));
                }
                catch (Exception e) {
                    if (!ManagementUtils.VERBOSE_MODE) break block3;
                    e.printStackTrace(System.err);
                }
            }
            ++i;
        }
        return result;
    }

    public MBeanInfo getMBeanInfo() {
        return this.info;
    }

    protected MBeanAttributeInfo getPresentAttribute(String attributeName, AttributeAccessType access) {
        MBeanAttributeInfo[] attribs = this.info.getAttributes();
        MBeanAttributeInfo result = null;
        int i = 0;
        while (i < attribs.length) {
            MBeanAttributeInfo attribInfo = attribs[i];
            if (attribInfo.getName().equals(attributeName)) {
                if (access.equals((Object)AttributeAccessType.READING)) {
                    if (attribInfo.isReadable()) {
                        result = attribInfo;
                        break;
                    }
                } else if (attribInfo.isWritable()) {
                    result = attribInfo;
                    break;
                }
            }
            ++i;
        }
        return result;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Object result = null;
        Method getterMethod = null;
        MBeanAttributeInfo attribInfo = this.getPresentAttribute(attribute, AttributeAccessType.READING);
        if (attribInfo == null) {
            throw new AttributeNotFoundException("No such attribute : " + attribute);
        }
        try {
            String getterPrefix = attribInfo.isIs() ? "is" : "get";
            getterMethod = this.getClass().getMethod(String.valueOf(getterPrefix) + attribute, null);
        }
        catch (Exception e) {
            if (ManagementUtils.VERBOSE_MODE) {
                e.printStackTrace(System.err);
            }
            throw new ReflectionException(e);
        }
        String realReturnType = getterMethod.getReturnType().getName();
        String openReturnType = attribInfo.getType();
        result = this.invokeMethod(getterMethod, null);
        try {
            if (!realReturnType.equals(openReturnType)) {
                result = ManagementUtils.convertToOpenType(result, Class.forName(openReturnType), Class.forName(realReturnType));
            }
        }
        catch (ClassNotFoundException e) {
            if (ManagementUtils.VERBOSE_MODE) {
                e.printStackTrace(System.err);
            }
            throw new MBeanException(e);
        }
        return result;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Class argType = null;
        MBeanAttributeInfo attribInfo = this.getPresentAttribute(attribute.getName(), AttributeAccessType.WRITING);
        if (attribInfo == null) {
            throw new AttributeNotFoundException("No such attribute : " + attribute);
        }
        try {
            argType = ManagementUtils.getClassMaybePrimitive(attribInfo.getType());
        }
        catch (ClassNotFoundException e) {
            if (ManagementUtils.VERBOSE_MODE) {
                e.printStackTrace(System.err);
            }
            throw new ReflectionException(e);
        }
        if (argType.isPrimitive() ? !ManagementUtils.isWrapperClass(attribute.getValue().getClass(), argType) : !argType.equals(attribute.getValue().getClass())) {
            throw new InvalidAttributeValueException(String.valueOf(attribInfo.getName()) + " is a " + attribInfo.getType() + " attribute");
        }
        Method setterMethod = null;
        try {
            setterMethod = this.getClass().getMethod("set" + attribute.getName(), argType);
        }
        catch (Exception e) {
            if (ManagementUtils.VERBOSE_MODE) {
                e.printStackTrace(System.err);
            }
            throw new ReflectionException(e);
        }
        this.invokeMethod(setterMethod, attribute.getValue());
        try {
            setterMethod.invoke((Object)this, attribute.getValue());
        }
        catch (Exception e) {
            Throwable root;
            if (ManagementUtils.VERBOSE_MODE) {
                e.printStackTrace(System.err);
            }
            if ((root = e.getCause()) instanceof RuntimeException) {
                throw (RuntimeException)root;
            }
            throw new MBeanException((Exception)root);
        }
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        MBeanOperationInfo opInfo;
        Object result = null;
        String[] localSignature = signature;
        if (localSignature == null) {
            localSignature = new String[]{};
        }
        if ((opInfo = this.getPresentOperation(actionName, localSignature)) == null) {
            throw new ReflectionException(new NoSuchMethodException(actionName), "No such operation : " + actionName);
        }
        Method operationMethod = null;
        try {
            Class[] argTypes = new Class[localSignature.length];
            int i = 0;
            while (i < localSignature.length) {
                argTypes[i] = ManagementUtils.getClassMaybePrimitive(localSignature[i]);
                ++i;
            }
            operationMethod = this.getClass().getMethod(actionName, argTypes);
        }
        catch (Exception e) {
            if (ManagementUtils.VERBOSE_MODE) {
                e.printStackTrace(System.err);
            }
            throw new ReflectionException(e);
        }
        String realReturnType = operationMethod.getReturnType().getName();
        String openReturnType = opInfo.getReturnType();
        result = this.invokeMethod(operationMethod, params);
        try {
            if (!realReturnType.equals(openReturnType)) {
                result = ManagementUtils.convertToOpenType(result, Class.forName(openReturnType), Class.forName(realReturnType));
            }
        }
        catch (ClassNotFoundException e) {
            if (ManagementUtils.VERBOSE_MODE) {
                e.printStackTrace(System.err);
            }
            throw new MBeanException(e);
        }
        return result;
    }

    protected MBeanOperationInfo getPresentOperation(String actionName, String[] signature) {
        MBeanOperationInfo[] operations = this.info.getOperations();
        MBeanOperationInfo result = null;
        int i = 0;
        while (i < operations.length) {
            MBeanOperationInfo opInfo = operations[i];
            if (opInfo.getName().equals(actionName) && signature.length == opInfo.getSignature().length) {
                boolean match = true;
                MBeanParameterInfo[] parameters = opInfo.getSignature();
                int j = 0;
                while (j < parameters.length) {
                    MBeanParameterInfo paramInfo = parameters[j];
                    if (!paramInfo.getType().equals(signature[j])) {
                        match = false;
                        break;
                    }
                    ++j;
                }
                if (match) {
                    result = opInfo;
                    break;
                }
            }
            ++i;
        }
        return result;
    }

    private Object invokeMethod(Method operationMethod, Object ... params) throws MBeanException {
        Object result = null;
        try {
            result = operationMethod.invoke((Object)this, params);
        }
        catch (Exception e) {
            Throwable root;
            if (ManagementUtils.VERBOSE_MODE) {
                e.printStackTrace(System.err);
            }
            if ((root = e.getCause()) instanceof Error) {
                throw new MBeanException(null, root.toString());
            }
            if (root instanceof RuntimeException) {
                throw (RuntimeException)root;
            }
            throw new MBeanException((Exception)root);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AttributeAccessType {
        READING,
        WRITING;

    }
}

