/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.inspector.TableSorter;
import sun.tools.jconsole.inspector.Utils;
import sun.tools.jconsole.inspector.XDataViewer;
import sun.tools.jconsole.inspector.XMBean;
import sun.tools.jconsole.inspector.XNodeInfo;
import sun.tools.jconsole.inspector.XTextFieldEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMBeanNotifications
extends JTable
implements NotificationListener {
    private static final String[] columnNames = new String[]{Resources.getText("TimeStamp", new Object[0]), Resources.getText("Type", new Object[0]), Resources.getText("UserData", new Object[0]), Resources.getText("SeqNum", new Object[0]), Resources.getText("Message", new Object[0]), Resources.getText("Event", new Object[0]), Resources.getText("Source", new Object[0])};
    private HashMap<ObjectName, XMBeanNotificationsListener> listeners = new HashMap();
    private boolean subscribed;
    private XMBeanNotificationsListener currentListener;
    public static final String NOTIFICATION_RECEIVED_EVENT = "jconsole.xnotification.received";
    private List<NotificationListener> notificationListenersList;
    private boolean enabled;
    private Font normalFont;
    private Font boldFont;
    private int rowMinHeight = -1;
    private TableCellEditor userDataEditor = new UserDataCellEditor();
    private NotifMouseListener mouseListener = new NotifMouseListener();
    private SimpleDateFormat timeFormater = new SimpleDateFormat("HH:mm:ss:SSS");
    private static TableCellEditor editor = new Utils.ReadOnlyTableCellEditor(new JTextField());

    public XMBeanNotifications() {
        super(new TableSorter(columnNames, 0));
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(false);
        this.getTableHeader().setReorderingAllowed(false);
        ArrayList arrayList = new ArrayList(1);
        this.notificationListenersList = Collections.synchronizedList(arrayList);
        this.addMouseListener(this.mouseListener);
        TableColumnModel tableColumnModel = this.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(45);
        tableColumnModel.getColumn(1).setPreferredWidth(50);
        tableColumnModel.getColumn(2).setPreferredWidth(50);
        tableColumnModel.getColumn(3).setPreferredWidth(40);
        tableColumnModel.getColumn(4).setPreferredWidth(50);
        tableColumnModel.getColumn(5).setPreferredWidth(50);
        this.setColumnEditors();
        this.addKeyListener(new Utils.CopyKeyAdapter());
    }

    public void cancelCellEditing() {
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.cancelCellEditing();
        }
    }

    public void stopCellEditing() {
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        UserDataCell userDataCell = this.getUserDataCell(n, n2);
        if (userDataCell != null) {
            return userDataCell.isMaximized();
        }
        return true;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }

    @Override
    public synchronized Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        if (n >= this.getRowCount()) {
            return null;
        }
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        if (this.normalFont == null) {
            this.normalFont = component.getFont();
            this.boldFont = this.normalFont.deriveFont(1);
        }
        UserDataCell userDataCell = this.getUserDataCell(n, 2);
        if (n2 == 2 && userDataCell != null) {
            component.setFont(this.boldFont);
            int n3 = userDataCell.getHeight();
            if (n3 > 0 && this.getRowHeight(n) != n3) {
                this.setRowHeight(n, n3);
            }
        } else {
            component.setFont(this.normalFont);
        }
        return component;
    }

    @Override
    public synchronized TableCellRenderer getCellRenderer(int n, int n2) {
        if (n >= this.getRowCount()) {
            return null;
        }
        String string = null;
        UserDataCell userDataCell = this.getUserDataCell(n, n2);
        DefaultTableCellRenderer defaultTableCellRenderer = userDataCell != null && userDataCell.isInited() ? (DefaultTableCellRenderer)userDataCell.getRenderer() : (DefaultTableCellRenderer)super.getCellRenderer(n, n2);
        if (userDataCell != null) {
            string = Resources.getText("Double click to expand/collapse", new Object[0]) + ". " + userDataCell.toString();
        } else {
            Object object = ((DefaultTableModel)this.getModel()).getValueAt(n, n2);
            if (object != null) {
                string = object.toString();
            }
        }
        defaultTableCellRenderer.setToolTipText(string);
        return defaultTableCellRenderer;
    }

    private UserDataCell getUserDataCell(int n, int n2) {
        Object object = ((DefaultTableModel)this.getModel()).getValueAt(n, n2);
        if (object instanceof UserDataCell) {
            return (UserDataCell)object;
        }
        return null;
    }

    synchronized void dispose() {
        this.listeners.clear();
    }

    public long getReceivedNotifications(XMBean xMBean) {
        XMBeanNotificationsListener xMBeanNotificationsListener = this.listeners.get(xMBean.getObjectName());
        if (xMBeanNotificationsListener == null) {
            return 0L;
        }
        return xMBeanNotificationsListener.getReceivedNotifications();
    }

    public synchronized boolean clearCurrentNotifications() {
        this.emptyTable();
        if (this.currentListener != null) {
            this.currentListener.clear();
            return true;
        }
        return false;
    }

    public synchronized boolean unregisterListener(DefaultMutableTreeNode defaultMutableTreeNode) {
        XMBean xMBean = (XMBean)((XNodeInfo)defaultMutableTreeNode.getUserObject()).getData();
        return this.unregister(xMBean.getObjectName());
    }

    public synchronized void registerListener(DefaultMutableTreeNode defaultMutableTreeNode) throws InstanceNotFoundException, IOException {
        XMBeanNotificationsListener xMBeanNotificationsListener;
        XMBean xMBean = (XMBean)((XNodeInfo)defaultMutableTreeNode.getUserObject()).getData();
        if (!this.subscribed) {
            try {
                xMBean.getMBeanServerConnection().addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this, null, null);
                this.subscribed = true;
            }
            catch (Exception exception) {
                System.out.println("Error adding listener for delegate :" + exception.getMessage());
            }
        }
        if ((xMBeanNotificationsListener = this.listeners.get(xMBean.getObjectName())) == null) {
            xMBeanNotificationsListener = new XMBeanNotificationsListener(this, xMBean, defaultMutableTreeNode, columnNames);
            this.listeners.put(xMBean.getObjectName(), xMBeanNotificationsListener);
        } else if (!xMBeanNotificationsListener.isRegistered()) {
            this.emptyTable();
            xMBeanNotificationsListener.register(defaultMutableTreeNode);
        }
        this.enabled = true;
        this.currentListener = xMBeanNotificationsListener;
    }

    @Override
    public synchronized void handleNotification(Notification notification, Object object) {
        try {
            if (notification instanceof MBeanServerNotification) {
                ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
                if (notification.getType().indexOf("JMX.mbean.unregistered") >= 0) {
                    this.unregister(objectName);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Error unregistering notification:" + exception.getMessage());
        }
    }

    public synchronized void disableNotifications() {
        this.emptyTable();
        this.currentListener = null;
        this.enabled = false;
    }

    private synchronized boolean unregister(ObjectName objectName) {
        XMBeanNotificationsListener xMBeanNotificationsListener = this.listeners.get(objectName);
        if (xMBeanNotificationsListener != null && xMBeanNotificationsListener.isRegistered()) {
            xMBeanNotificationsListener.unregister();
            return true;
        }
        return false;
    }

    public void addNotificationsListener(NotificationListener notificationListener) {
        this.notificationListenersList.add(notificationListener);
    }

    public void removeNotificationsListener(NotificationListener notificationListener) {
        this.notificationListenersList.remove(notificationListener);
    }

    void fireNotificationReceived(XMBeanNotificationsListener xMBeanNotificationsListener, XMBean xMBean, DefaultMutableTreeNode defaultMutableTreeNode, Object[] objectArray, long l) {
        Serializable serializable;
        if (this.enabled) {
            serializable = (DefaultTableModel)this.getModel();
            if (xMBeanNotificationsListener == this.currentListener) {
                ((DefaultTableModel)serializable).insertRow(0, objectArray);
                this.repaint();
            }
        }
        serializable = new Notification(NOTIFICATION_RECEIVED_EVENT, this, 0L);
        ((Notification)serializable).setUserData(new Long(l));
        for (NotificationListener notificationListener : this.notificationListenersList) {
            notificationListener.handleNotification((Notification)serializable, defaultMutableTreeNode);
        }
    }

    private void updateModel(List<Object[]> list) {
        this.emptyTable();
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        for (Object[] objectArray : list) {
            defaultTableModel.addRow(objectArray);
        }
    }

    public synchronized boolean isListenerRegistered(XMBean xMBean) {
        XMBeanNotificationsListener xMBeanNotificationsListener = this.listeners.get(xMBean.getObjectName());
        if (xMBeanNotificationsListener == null) {
            return false;
        }
        return xMBeanNotificationsListener.isRegistered();
    }

    public synchronized void loadNotifications(XMBean xMBean) {
        XMBeanNotificationsListener xMBeanNotificationsListener = this.listeners.get(xMBean.getObjectName());
        this.emptyTable();
        if (xMBeanNotificationsListener != null) {
            this.enabled = true;
            List<Object[]> list = xMBeanNotificationsListener.getData();
            this.updateModel(list);
            this.currentListener = xMBeanNotificationsListener;
            this.validate();
            this.repaint();
        } else {
            this.enabled = false;
        }
    }

    private void setColumnEditors() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i = 0; i < columnNames.length; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            if (i == 2) {
                tableColumn.setCellEditor(this.userDataEditor);
                continue;
            }
            tableColumn.setCellEditor(editor);
        }
    }

    public boolean isTableEditable() {
        return true;
    }

    public synchronized void emptyTable() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
        while (defaultTableModel.getRowCount() > 0) {
            defaultTableModel.removeRow(0);
        }
        this.validate();
    }

    synchronized void updateUserDataCell(int n, int n2) {
        Object object = this.getModel().getValueAt(n, 2);
        if (object instanceof UserDataCell) {
            UserDataCell userDataCell = (UserDataCell)object;
            if (!userDataCell.isInited()) {
                if (this.rowMinHeight == -1) {
                    this.rowMinHeight = this.getRowHeight(n);
                }
                userDataCell.init(super.getCellRenderer(n, n2), this.rowMinHeight);
            }
            userDataCell.switchState();
            this.setRowHeight(n, userDataCell.getHeight());
            if (!userDataCell.isMaximized()) {
                this.cancelCellEditing();
                this.editCellAt(n, 2);
            }
            this.invalidate();
            this.repaint();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class XMBeanNotificationsListener
    implements NotificationListener {
        private XMBean xmbean;
        private DefaultMutableTreeNode node;
        private long received;
        private XMBeanNotifications notifications;
        private boolean unregistered;
        private ArrayList<Object[]> data = new ArrayList();

        public XMBeanNotificationsListener(XMBeanNotifications xMBeanNotifications2, XMBean xMBean, DefaultMutableTreeNode defaultMutableTreeNode, String[] stringArray) {
            this.notifications = xMBeanNotifications2;
            this.xmbean = xMBean;
            this.node = defaultMutableTreeNode;
            this.register(defaultMutableTreeNode);
        }

        public synchronized List<Object[]> getData() {
            return this.data;
        }

        public synchronized void clear() {
            this.data.clear();
            this.received = 0L;
        }

        public boolean isRegistered() {
            return !this.unregistered;
        }

        public synchronized void unregister() {
            try {
                this.xmbean.getMBeanServerConnection().removeNotificationListener(this.xmbean.getObjectName(), this, null, null);
            }
            catch (Exception exception) {
                System.out.println("Error removing listener :" + exception.getMessage());
            }
            this.unregistered = true;
        }

        public long getReceivedNotifications() {
            return this.received;
        }

        public synchronized void register(DefaultMutableTreeNode defaultMutableTreeNode) {
            this.clear();
            this.node = defaultMutableTreeNode;
            try {
                this.xmbean.getMBeanServerConnection().addNotificationListener(this.xmbean.getObjectName(), this, null, null);
                this.unregistered = false;
            }
            catch (Exception exception) {
                System.out.println("Error adding listener :" + exception.getMessage());
            }
        }

        @Override
        public synchronized void handleNotification(Notification notification, Object object) {
            try {
                if (this.unregistered) {
                    return;
                }
                Date date = new Date(notification.getTimeStamp());
                String string = XMBeanNotifications.this.timeFormater.format(date);
                Object object2 = notification.getUserData();
                Component component = null;
                UserDataCell userDataCell = null;
                component = XDataViewer.createNotificationViewer(object2);
                if (component != null) {
                    XDataViewer.registerForMouseEvent(component, XMBeanNotifications.this.mouseListener);
                    userDataCell = new UserDataCell(object2, component);
                }
                Object[] objectArray = new Object[]{string, notification.getType(), userDataCell == null ? object2 : userDataCell, new Long(notification.getSequenceNumber()), notification.getMessage(), notification, notification.getSource()};
                ++this.received;
                this.data.add(0, objectArray);
                this.notifications.fireNotificationReceived(this, this.xmbean, this.node, objectArray, this.received);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Error when handling notification :" + exception.toString());
            }
        }
    }

    class UserDataCellEditor
    extends XTextFieldEditor {
        UserDataCellEditor() {
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Object object2 = object;
            if (n2 == 2) {
                Object object3 = XMBeanNotifications.this.getModel().getValueAt(n, n2);
                if (object3 instanceof UserDataCell) {
                    UserDataCell userDataCell = (UserDataCell)object3;
                    if (userDataCell.getRenderer() instanceof UserDataCellRenderer) {
                        UserDataCellRenderer userDataCellRenderer = (UserDataCellRenderer)userDataCell.getRenderer();
                        return userDataCellRenderer.getComponent();
                    }
                } else {
                    Component component = super.getTableCellEditorComponent(jTable, object2, bl, n, n2);
                    this.textField.setEditable(false);
                    return component;
                }
            }
            return super.getTableCellEditorComponent(jTable, object2, bl, n, n2);
        }

        public boolean stopCellEditing() {
            UserDataCell userDataCell;
            Object object;
            int n = XMBeanNotifications.this.getEditingRow();
            int n2 = XMBeanNotifications.this.getEditingColumn();
            if (n2 == 2 && (object = XMBeanNotifications.this.getModel().getValueAt(n, n2)) instanceof UserDataCell && (userDataCell = (UserDataCell)object).isMaximized()) {
                this.cancelCellEditing();
                return true;
            }
            return super.stopCellEditing();
        }
    }

    class NotifMouseListener
    extends MouseAdapter {
        NotifMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() >= 2) {
                int n = XMBeanNotifications.this.getSelectedRow();
                int n2 = XMBeanNotifications.this.getSelectedColumn();
                if (n2 != 2) {
                    return;
                }
                if (n2 == -1 || n == -1) {
                    return;
                }
                XMBeanNotifications.this.updateUserDataCell(n, n2);
            }
        }
    }

    class UserDataCell {
        TableCellRenderer minRenderer;
        UserDataCellRenderer maxRenderer;
        int minHeight;
        boolean minimized = true;
        boolean init = false;
        Object userData;

        UserDataCell(Object object, Component component) {
            this.userData = object;
            this.maxRenderer = new UserDataCellRenderer(component);
        }

        public String toString() {
            if (this.userData == null) {
                return null;
            }
            if (this.userData.getClass().isArray()) {
                String string = Utils.getArrayClassName(this.userData.getClass().getName());
                int n = Array.getLength(this.userData);
                return string + "[" + n + "]";
            }
            if (this.userData instanceof CompositeData || this.userData instanceof TabularData) {
                return this.userData.getClass().getName();
            }
            return this.userData.toString();
        }

        boolean isInited() {
            return this.init;
        }

        void init(TableCellRenderer tableCellRenderer, int n) {
            this.minRenderer = tableCellRenderer;
            this.minHeight = n;
            this.init = true;
        }

        void switchState() {
            this.minimized = !this.minimized;
        }

        boolean isMaximized() {
            return !this.minimized;
        }

        void minimize() {
            this.minimized = true;
        }

        void maximize() {
            this.minimized = false;
        }

        int getHeight() {
            if (this.minimized) {
                return this.minHeight;
            }
            return (int)this.maxRenderer.getComponent().getPreferredSize().getHeight();
        }

        TableCellRenderer getRenderer() {
            if (this.minimized) {
                return this.minRenderer;
            }
            return this.maxRenderer;
        }
    }

    class UserDataCellRenderer
    extends DefaultTableCellRenderer {
        Component comp;

        UserDataCellRenderer(Component component) {
            this.comp = component;
            Dimension dimension = component.getPreferredSize();
            if (dimension.getHeight() > 200.0) {
                component.setPreferredSize(new Dimension((int)dimension.getWidth(), 200));
            }
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return this.comp;
        }

        public Component getComponent() {
            return this.comp;
        }
    }
}

