/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import com.ibm.lang.management.OperatingSystemMXBean;
import com.sun.tools.jconsole.JConsoleContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteObjectInvocationHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIServer;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.swing.event.SwingPropertyChangeSupport;
import sun.rmi.server.UnicastRef2;
import sun.rmi.transport.LiveRef;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.LocalVirtualMachine;
import sun.tools.jconsole.MemoryPoolProxy;
import sun.tools.jconsole.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyClient
implements JConsoleContext {
    private JConsoleContext.ConnectionState connectionState = JConsoleContext.ConnectionState.DISCONNECTED;
    private SwingPropertyChangeSupport propertyChangeSupport = new SwingPropertyChangeSupport(this, true);
    private static Map<String, ProxyClient> cache = Collections.synchronizedMap(new HashMap());
    private volatile boolean isDead = true;
    private String hostName = null;
    private int port = 0;
    private String userName = null;
    private String password = null;
    private boolean hasPlatformMXBeans = false;
    private boolean hasCompilationMXBean = false;
    private boolean supportsLockUsage = false;
    private LocalVirtualMachine lvm;
    private String advancedUrl = null;
    private JMXServiceURL jmxUrl = null;
    private SnapshotMBeanServerConnection server = null;
    private JMXConnector jmxc = null;
    private RMIServer stub = null;
    private static final SslRMIClientSocketFactory sslRMIClientSocketFactory = new SslRMIClientSocketFactory();
    private String registryHostName = null;
    private int registryPort = 0;
    private boolean vmConnector = false;
    private boolean sslRegistry = false;
    private boolean sslStub = false;
    private final String connectionName;
    private final String displayName;
    private ClassLoadingMXBean classLoadingMBean = null;
    private CompilationMXBean compilationMBean = null;
    private MemoryMXBean memoryMBean = null;
    private java.lang.management.OperatingSystemMXBean operatingSystemMBean = null;
    private RuntimeMXBean runtimeMBean = null;
    private ThreadMXBean threadMBean = null;
    private OperatingSystemMXBean sunOperatingSystemMXBean = null;
    private List<MemoryPoolProxy> memoryPoolProxies = null;
    private List<GarbageCollectorMXBean> garbageCollectorMBeans = null;
    private String detectDeadlocksOperation = null;
    private static final String rmiServerImplStubClassName = "javax.management.remote.rmi.RMIServerImpl_Stub";
    private static final Class<? extends Remote> rmiServerImplStubClass;

    private ProxyClient(String string, int n, String string2, String string3) throws IOException {
        this.displayName = this.connectionName = ProxyClient.getConnectionName(string, n, string2);
        if (string.equals("localhost") && n == 0) {
            this.hostName = string;
            this.port = n;
        } else {
            String string4 = "/jndi/rmi://" + string + ":" + n + "/jmxrmi";
            JMXServiceURL jMXServiceURL = new JMXServiceURL("rmi", "", 0, string4);
            this.setParameters(jMXServiceURL, string2, string3);
            this.vmConnector = true;
            this.registryHostName = string;
            this.registryPort = n;
            this.checkSslConfig();
        }
    }

    private ProxyClient(String string, String string2, String string3) throws IOException {
        this.advancedUrl = string;
        this.displayName = this.connectionName = ProxyClient.getConnectionName(string, string2);
        this.setParameters(new JMXServiceURL(string), string2, string3);
    }

    private ProxyClient(LocalVirtualMachine localVirtualMachine) throws IOException {
        this.lvm = localVirtualMachine;
        this.connectionName = ProxyClient.getConnectionName(localVirtualMachine);
        this.displayName = "pid: " + localVirtualMachine.vmid() + " " + localVirtualMachine.displayName();
    }

    private void setParameters(JMXServiceURL jMXServiceURL, String string, String string2) {
        this.jmxUrl = jMXServiceURL;
        this.hostName = this.jmxUrl.getHost();
        this.port = this.jmxUrl.getPort();
        this.userName = string;
        this.password = string2;
    }

    private static void checkStub(Remote remote, Class<? extends Remote> clazz) {
        Object object;
        if (remote.getClass() != clazz) {
            if (!Proxy.isProxyClass(remote.getClass())) {
                throw new SecurityException("Expecting a " + clazz.getName() + " stub!");
            }
            object = Proxy.getInvocationHandler(remote);
            if (object.getClass() != RemoteObjectInvocationHandler.class) {
                throw new SecurityException("Expecting a dynamic proxy instance with a " + RemoteObjectInvocationHandler.class.getName() + " invocation handler!");
            }
            remote = (Remote)object;
        }
        if ((object = ((RemoteObject)remote).getRef()).getClass() != UnicastRef2.class) {
            throw new SecurityException("Expecting a " + UnicastRef2.class.getName() + " remote reference in stub!");
        }
        LiveRef liveRef = ((UnicastRef2)object).getLiveRef();
        RMIClientSocketFactory rMIClientSocketFactory = liveRef.getClientSocketFactory();
        if (rMIClientSocketFactory == null || rMIClientSocketFactory.getClass() != SslRMIClientSocketFactory.class) {
            throw new SecurityException("Expecting a " + SslRMIClientSocketFactory.class.getName() + " RMI client socket factory in stub!");
        }
    }

    private void checkSslConfig() throws IOException {
        try {
            Registry registry = LocateRegistry.getRegistry(this.registryHostName, this.registryPort, sslRMIClientSocketFactory);
            try {
                this.stub = (RMIServer)registry.lookup("jmxrmi");
            }
            catch (NotBoundException notBoundException) {
                throw (IOException)new IOException(notBoundException.getMessage()).initCause(notBoundException);
            }
            this.sslRegistry = true;
        }
        catch (IOException iOException) {
            Registry registry = LocateRegistry.getRegistry(this.registryHostName, this.registryPort);
            try {
                this.stub = (RMIServer)registry.lookup("jmxrmi");
            }
            catch (NotBoundException notBoundException) {
                throw (IOException)new IOException(notBoundException.getMessage()).initCause(notBoundException);
            }
            this.sslRegistry = false;
        }
        try {
            ProxyClient.checkStub(this.stub, rmiServerImplStubClass);
            this.sslStub = true;
        }
        catch (SecurityException securityException) {
            this.sslStub = false;
        }
    }

    public boolean isSslRmiRegistry() {
        if (!this.isVmConnector()) {
            throw new UnsupportedOperationException("ProxyClient.isSslRmiRegistry() is only supported if this ProxyClient is a JMX connector for a JMX VM agent");
        }
        return this.sslRegistry;
    }

    public boolean isSslRmiStub() {
        if (!this.isVmConnector()) {
            throw new UnsupportedOperationException("ProxyClient.isSslRmiStub() is only supported if this ProxyClient is a JMX connector for a JMX VM agent");
        }
        return this.sslStub;
    }

    public boolean isVmConnector() {
        return this.vmConnector;
    }

    private void setConnectionState(JConsoleContext.ConnectionState connectionState) {
        JConsoleContext.ConnectionState connectionState2 = this.connectionState;
        this.connectionState = connectionState;
        this.propertyChangeSupport.firePropertyChange("connectionState", (Object)connectionState2, (Object)connectionState);
    }

    @Override
    public JConsoleContext.ConnectionState getConnectionState() {
        return this.connectionState;
    }

    void flush() {
        if (this.server != null) {
            this.server.flush();
        }
    }

    void connect() {
        this.setConnectionState(JConsoleContext.ConnectionState.CONNECTING);
        Exception exception = null;
        try {
            this.tryConnect();
        }
        catch (IOException iOException) {
            if (JConsole.isDebug()) {
                iOException.printStackTrace();
            }
            exception = iOException;
        }
        catch (SecurityException securityException) {
            if (JConsole.isDebug()) {
                securityException.printStackTrace();
            }
            exception = securityException;
        }
        if (exception != null) {
            this.setConnectionState(JConsoleContext.ConnectionState.DISCONNECTED);
        } else {
            this.setConnectionState(JConsoleContext.ConnectionState.CONNECTED);
        }
    }

    private void tryConnect() throws IOException {
        Serializable serializable;
        if (this.jmxUrl == null && "localhost".equals(this.hostName) && this.port == 0) {
            this.jmxc = null;
            this.server = Snapshot.newSnapshot(ManagementFactory.getPlatformMBeanServer());
        } else {
            if (this.lvm != null) {
                if (!this.lvm.isManageable()) {
                    this.lvm.startManagementAgent();
                    if (!this.lvm.isManageable()) {
                        throw new IOException(this.lvm + "not manageable");
                    }
                }
                if (this.jmxUrl == null) {
                    this.jmxUrl = new JMXServiceURL(this.lvm.connectorAddress());
                }
            }
            if (this.userName == null && this.password == null) {
                if (this.isVmConnector()) {
                    if (this.stub == null) {
                        this.checkSslConfig();
                    }
                    this.jmxc = new RMIConnector(this.stub, null);
                    this.jmxc.connect();
                } else {
                    this.jmxc = JMXConnectorFactory.connect(this.jmxUrl);
                }
            } else {
                serializable = new HashMap<String, String[]>();
                serializable.put("jmx.remote.credentials", new String[]{this.userName, this.password});
                if (this.isVmConnector()) {
                    if (this.stub == null) {
                        this.checkSslConfig();
                    }
                    this.jmxc = new RMIConnector(this.stub, null);
                    this.jmxc.connect((Map<String, ?>)((Object)serializable));
                } else {
                    this.jmxc = JMXConnectorFactory.connect(this.jmxUrl, serializable);
                }
            }
            this.server = Snapshot.newSnapshot(this.jmxc.getMBeanServerConnection());
        }
        this.isDead = false;
        try {
            serializable = new ObjectName("java.lang:type=Threading");
            this.hasPlatformMXBeans = this.server.isRegistered((ObjectName)serializable);
            if (this.hasPlatformMXBeans) {
                MBeanOperationInfo[] mBeanOperationInfoArray;
                for (MBeanOperationInfo mBeanOperationInfo : mBeanOperationInfoArray = this.server.getMBeanInfo((ObjectName)serializable).getOperations()) {
                    if (!mBeanOperationInfo.getName().equals("findDeadlockedThreads")) continue;
                    this.supportsLockUsage = true;
                    break;
                }
                serializable = new ObjectName("java.lang:type=Compilation");
                this.hasCompilationMXBean = this.server.isRegistered((ObjectName)serializable);
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new InternalError(malformedObjectNameException.getMessage());
        }
        catch (IntrospectionException introspectionException) {
            InternalError internalError = new InternalError(introspectionException.getMessage());
            internalError.initCause(introspectionException);
            throw internalError;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            InternalError internalError = new InternalError(instanceNotFoundException.getMessage());
            internalError.initCause(instanceNotFoundException);
            throw internalError;
        }
        catch (ReflectionException reflectionException) {
            InternalError internalError = new InternalError(reflectionException.getMessage());
            internalError.initCause(reflectionException);
            throw internalError;
        }
        if (this.hasPlatformMXBeans) {
            this.getRuntimeMXBean();
        }
    }

    public static ProxyClient getProxyClient(LocalVirtualMachine localVirtualMachine) throws IOException {
        String string = ProxyClient.getCacheKey(localVirtualMachine);
        ProxyClient proxyClient = cache.get(string);
        if (proxyClient == null) {
            proxyClient = new ProxyClient(localVirtualMachine);
            cache.put(string, proxyClient);
        }
        return proxyClient;
    }

    public static String getConnectionName(LocalVirtualMachine localVirtualMachine) {
        return Integer.toString(localVirtualMachine.vmid());
    }

    private static String getCacheKey(LocalVirtualMachine localVirtualMachine) {
        return Integer.toString(localVirtualMachine.vmid());
    }

    public static ProxyClient getProxyClient(String string, String string2, String string3) throws IOException {
        String string4 = ProxyClient.getCacheKey(string, string2, string3);
        ProxyClient proxyClient = cache.get(string4);
        if (proxyClient == null) {
            proxyClient = new ProxyClient(string, string2, string3);
            cache.put(string4, proxyClient);
        }
        return proxyClient;
    }

    public static String getConnectionName(String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            return string2 + "@" + string;
        }
        return string;
    }

    private static String getCacheKey(String string, String string2, String string3) {
        return (string == null ? "" : string) + ":" + (string2 == null ? "" : string2) + ":" + (string3 == null ? "" : string3);
    }

    public static ProxyClient getProxyClient(String string, int n, String string2, String string3) throws IOException {
        String string4 = ProxyClient.getCacheKey(string, n, string2, string3);
        ProxyClient proxyClient = cache.get(string4);
        if (proxyClient == null) {
            proxyClient = new ProxyClient(string, n, string2, string3);
            cache.put(string4, proxyClient);
        }
        return proxyClient;
    }

    public static String getConnectionName(String string, int n, String string2) {
        String string3 = string + ":" + n;
        if (string2 != null && string2.length() > 0) {
            return string2 + "@" + string3;
        }
        return string3;
    }

    private static String getCacheKey(String string, int n, String string2, String string3) {
        return (string == null ? "" : string) + ":" + n + ":" + (string2 == null ? "" : string2) + ":" + (string3 == null ? "" : string3);
    }

    public String connectionName() {
        return this.connectionName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        if (!this.isConnected()) {
            return Resources.getText("ConnectionName (disconnected)", this.displayName);
        }
        return this.displayName;
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection() {
        return this.server;
    }

    public String getUrl() {
        return this.advancedUrl;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public int getVmid() {
        return this.lvm != null ? this.lvm.vmid() : 0;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void disconnect() {
        this.stub = null;
        if (this.jmxc != null) {
            try {
                this.jmxc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.classLoadingMBean = null;
        this.compilationMBean = null;
        this.memoryMBean = null;
        this.operatingSystemMBean = null;
        this.runtimeMBean = null;
        this.threadMBean = null;
        this.sunOperatingSystemMXBean = null;
        this.garbageCollectorMBeans = null;
        if (!this.isDead) {
            this.isDead = true;
            this.setConnectionState(JConsoleContext.ConnectionState.DISCONNECTED);
        }
    }

    public String[] getDomains() throws IOException {
        return this.server.getDomains();
    }

    public Map<ObjectName, MBeanInfo> getMBeans(String string) throws IOException {
        ObjectName objectName;
        block8: {
            objectName = null;
            if (string != null) {
                try {
                    objectName = new ObjectName(string + ":*");
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    if ($assertionsDisabled) break block8;
                    throw new AssertionError();
                }
            }
        }
        Set<ObjectName> set = this.server.queryNames(objectName, null);
        HashMap<ObjectName, MBeanInfo> hashMap = new HashMap<ObjectName, MBeanInfo>(set.size());
        for (ObjectName objectName2 : set) {
            if (!(objectName2 instanceof ObjectName)) continue;
            ObjectName objectName3 = objectName2;
            try {
                MBeanInfo mBeanInfo = this.server.getMBeanInfo(objectName3);
                hashMap.put(objectName3, mBeanInfo);
            }
            catch (IntrospectionException introspectionException) {
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
            }
            catch (ReflectionException reflectionException) {}
        }
        return hashMap;
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws IOException {
        AttributeList attributeList = null;
        try {
            attributeList = this.server.getAttributes(objectName, stringArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (ReflectionException reflectionException) {
            // empty catch block
        }
        return attributeList;
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InvalidAttributeValueException, MBeanException, IOException {
        try {
            this.server.setAttribute(objectName, attribute);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            assert (false);
        }
        catch (ReflectionException reflectionException) {
            // empty catch block
        }
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws IOException, MBeanException {
        Object object = null;
        try {
            object = this.server.invoke(objectName, string, objectArray, stringArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (ReflectionException reflectionException) {
            // empty catch block
        }
        return object;
    }

    public synchronized ClassLoadingMXBean getClassLoadingMXBean() throws IOException {
        if (this.hasPlatformMXBeans && this.classLoadingMBean == null) {
            this.classLoadingMBean = ManagementFactory.newPlatformMXBeanProxy(this.server, "java.lang:type=ClassLoading", ClassLoadingMXBean.class);
        }
        return this.classLoadingMBean;
    }

    public synchronized CompilationMXBean getCompilationMXBean() throws IOException {
        if (this.hasCompilationMXBean && this.compilationMBean == null) {
            this.compilationMBean = ManagementFactory.newPlatformMXBeanProxy(this.server, "java.lang:type=Compilation", CompilationMXBean.class);
        }
        return this.compilationMBean;
    }

    public Collection<MemoryPoolProxy> getMemoryPoolProxies() throws IOException {
        if (this.memoryPoolProxies == null) {
            ObjectName objectName;
            block5: {
                objectName = null;
                try {
                    objectName = new ObjectName("java.lang:type=MemoryPool,*");
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError();
                }
            }
            Set<ObjectName> set = this.server.queryNames(objectName, null);
            if (set != null) {
                this.memoryPoolProxies = new ArrayList<MemoryPoolProxy>();
                for (ObjectName objectName2 : set) {
                    MemoryPoolProxy memoryPoolProxy = new MemoryPoolProxy(this, objectName2);
                    this.memoryPoolProxies.add(memoryPoolProxy);
                }
            }
        }
        return this.memoryPoolProxies;
    }

    public synchronized Collection<GarbageCollectorMXBean> getGarbageCollectorMXBeans() throws IOException {
        if (this.garbageCollectorMBeans == null) {
            ObjectName objectName;
            block5: {
                objectName = null;
                try {
                    objectName = new ObjectName("java.lang:type=GarbageCollector,*");
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError();
                }
            }
            Set<ObjectName> set = this.server.queryNames(objectName, null);
            if (set != null) {
                this.garbageCollectorMBeans = new ArrayList<GarbageCollectorMXBean>();
                for (ObjectName objectName2 : set) {
                    String string = "java.lang:type=GarbageCollector,name=" + objectName2.getKeyProperty("name");
                    GarbageCollectorMXBean garbageCollectorMXBean = ManagementFactory.newPlatformMXBeanProxy(this.server, string, GarbageCollectorMXBean.class);
                    this.garbageCollectorMBeans.add(garbageCollectorMXBean);
                }
            }
        }
        return this.garbageCollectorMBeans;
    }

    public synchronized MemoryMXBean getMemoryMXBean() throws IOException {
        if (this.hasPlatformMXBeans && this.memoryMBean == null) {
            this.memoryMBean = ManagementFactory.newPlatformMXBeanProxy(this.server, "java.lang:type=Memory", MemoryMXBean.class);
        }
        return this.memoryMBean;
    }

    public synchronized RuntimeMXBean getRuntimeMXBean() throws IOException {
        if (this.hasPlatformMXBeans && this.runtimeMBean == null) {
            this.runtimeMBean = ManagementFactory.newPlatformMXBeanProxy(this.server, "java.lang:type=Runtime", RuntimeMXBean.class);
        }
        return this.runtimeMBean;
    }

    public synchronized ThreadMXBean getThreadMXBean() throws IOException {
        if (this.hasPlatformMXBeans && this.threadMBean == null) {
            this.threadMBean = ManagementFactory.newPlatformMXBeanProxy(this.server, "java.lang:type=Threading", ThreadMXBean.class);
        }
        return this.threadMBean;
    }

    public synchronized java.lang.management.OperatingSystemMXBean getOperatingSystemMXBean() throws IOException {
        if (this.hasPlatformMXBeans && this.operatingSystemMBean == null) {
            this.operatingSystemMBean = ManagementFactory.newPlatformMXBeanProxy(this.server, "java.lang:type=OperatingSystem", java.lang.management.OperatingSystemMXBean.class);
        }
        return this.operatingSystemMBean;
    }

    public synchronized OperatingSystemMXBean getSunOperatingSystemMXBean() throws IOException {
        try {
            ObjectName objectName = new ObjectName("java.lang:type=OperatingSystem");
            if (this.sunOperatingSystemMXBean == null && this.server.isInstanceOf(objectName, "com.ibm.lang.management.OperatingSystemMXBean")) {
                this.sunOperatingSystemMXBean = ManagementFactory.newPlatformMXBeanProxy(this.server, "java.lang:type=OperatingSystem", OperatingSystemMXBean.class);
            }
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            return null;
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            return null;
        }
        return this.sunOperatingSystemMXBean;
    }

    public <T> T getMXBean(ObjectName objectName, Class<T> clazz) throws IOException {
        return ManagementFactory.newPlatformMXBeanProxy(this.server, objectName.toString(), clazz);
    }

    public long[] findDeadlockedThreads() throws IOException {
        ThreadMXBean threadMXBean = this.getThreadMXBean();
        if (this.supportsLockUsage && threadMXBean.isSynchronizerUsageSupported()) {
            return threadMXBean.findDeadlockedThreads();
        }
        return threadMXBean.findMonitorDeadlockedThreads();
    }

    public synchronized void markAsDead() {
        this.disconnect();
    }

    public boolean isDead() {
        return this.isDead;
    }

    boolean isConnected() {
        return !this.isDead();
    }

    boolean hasPlatformMXBeans() {
        return this.hasPlatformMXBeans;
    }

    boolean hasHotSpotDiagnosticMXBean() {
        return false;
    }

    boolean isLockUsageSupported() {
        return this.supportsLockUsage;
    }

    public boolean isRegistered(ObjectName objectName) throws IOException {
        return this.server.isRegistered(objectName);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addWeakPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (!(propertyChangeListener instanceof WeakPCL)) {
            propertyChangeListener = new WeakPCL(propertyChangeListener);
        }
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (!(propertyChangeListener instanceof WeakPCL)) {
            for (PropertyChangeListener propertyChangeListener2 : this.propertyChangeSupport.getPropertyChangeListeners()) {
                if (!(propertyChangeListener2 instanceof WeakPCL) || ((WeakPCL)propertyChangeListener2).get() != propertyChangeListener) continue;
                propertyChangeListener = propertyChangeListener2;
                break;
            }
        }
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    static {
        Class<Remote> clazz = null;
        try {
            clazz = Class.forName(rmiServerImplStubClassName).asSubclass(Remote.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw (InternalError)new InternalError(classNotFoundException.getMessage()).initCause(classNotFoundException);
        }
        rmiServerImplStubClass = clazz;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SnapshotInvocationHandler
    implements InvocationHandler {
        private final MBeanServerConnection conn;
        private Map<ObjectName, NameValueMap> cachedValues = SnapshotInvocationHandler.newMap();
        private Map<ObjectName, Set<String>> cachedNames = SnapshotInvocationHandler.newMap();

        SnapshotInvocationHandler(MBeanServerConnection mBeanServerConnection) {
            this.conn = mBeanServerConnection;
        }

        synchronized void flush() {
            this.cachedValues = SnapshotInvocationHandler.newMap();
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            String string = method.getName();
            if (string.equals("getAttribute")) {
                return this.getAttribute((ObjectName)objectArray[0], (String)objectArray[1]);
            }
            if (string.equals("getAttributes")) {
                return this.getAttributes((ObjectName)objectArray[0], (String[])objectArray[1]);
            }
            if (string.equals("flush")) {
                this.flush();
                return null;
            }
            try {
                return method.invoke((Object)this.conn, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
        }

        private Object getAttribute(ObjectName objectName, String string) throws MBeanException, InstanceNotFoundException, AttributeNotFoundException, ReflectionException, IOException {
            NameValueMap nameValueMap = this.getCachedAttributes(objectName, Collections.singleton(string));
            Object v = nameValueMap.get(string);
            if (v != null || nameValueMap.containsKey(string)) {
                return v;
            }
            return this.conn.getAttribute(objectName, string);
        }

        private AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException, IOException {
            NameValueMap nameValueMap = this.getCachedAttributes(objectName, new TreeSet<String>(Arrays.asList(stringArray)));
            AttributeList attributeList = new AttributeList();
            for (String string : stringArray) {
                Object v = nameValueMap.get(string);
                if (v == null && !nameValueMap.containsKey(string)) continue;
                attributeList.add(new Attribute(string, v));
            }
            return attributeList;
        }

        private synchronized NameValueMap getCachedAttributes(ObjectName objectName, Set<String> set) throws InstanceNotFoundException, ReflectionException, IOException {
            NameValueMap nameValueMap = this.cachedValues.get(objectName);
            if (nameValueMap != null && nameValueMap.keySet().containsAll(set)) {
                return nameValueMap;
            }
            set = new TreeSet<String>(set);
            Set<String> set2 = this.cachedNames.get(objectName);
            if (set2 != null) {
                set.addAll(set2);
            }
            nameValueMap = new NameValueMap();
            AttributeList attributeList = this.conn.getAttributes(objectName, set.toArray(new String[set.size()]));
            for (Attribute attribute : attributeList.asList()) {
                nameValueMap.put(attribute.getName(), attribute.getValue());
            }
            this.cachedValues.put(objectName, nameValueMap);
            this.cachedNames.put(objectName, set);
            return nameValueMap;
        }

        private static <K, V> Map<K, V> newMap() {
            return new HashMap();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class NameValueMap
        extends HashMap<String, Object> {
            private NameValueMap() {
            }
        }
    }

    public static class Snapshot {
        private Snapshot() {
        }

        public static SnapshotMBeanServerConnection newSnapshot(MBeanServerConnection mBeanServerConnection) {
            SnapshotInvocationHandler snapshotInvocationHandler = new SnapshotInvocationHandler(mBeanServerConnection);
            return (SnapshotMBeanServerConnection)Proxy.newProxyInstance(Snapshot.class.getClassLoader(), new Class[]{SnapshotMBeanServerConnection.class}, (InvocationHandler)snapshotInvocationHandler);
        }
    }

    public static interface SnapshotMBeanServerConnection
    extends MBeanServerConnection {
        public void flush();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WeakPCL
    extends WeakReference<PropertyChangeListener>
    implements PropertyChangeListener {
        WeakPCL(PropertyChangeListener propertyChangeListener) {
            super(propertyChangeListener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.get();
            if (propertyChangeListener == null) {
                this.dispose();
            } else {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }

        private void dispose() {
            ProxyClient.this.removePropertyChangeListener(this);
        }
    }
}

