/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import com.ibm.lang.management.GarbageCollectorMXBean;
import java.io.IOException;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import sun.tools.jconsole.GcInfo;
import sun.tools.jconsole.MemoryPoolStat;
import sun.tools.jconsole.ProxyClient;

public class MemoryPoolProxy {
    private String poolName;
    private ProxyClient client;
    private ObjectName objName;
    private MemoryPoolMXBean pool;
    private Map<ObjectName, Long> gcMBeans;
    private GcInfo lastGcInfo;

    public MemoryPoolProxy(ProxyClient proxyClient, ObjectName objectName) throws IOException {
        String[] stringArray;
        this.client = proxyClient;
        this.objName = this.objName;
        this.pool = proxyClient.getMXBean(objectName, MemoryPoolMXBean.class);
        this.poolName = this.pool.getName();
        this.gcMBeans = new HashMap<ObjectName, Long>();
        this.lastGcInfo = null;
        for (String string : stringArray = this.pool.getMemoryManagerNames()) {
            try {
                ObjectName objectName2 = new ObjectName("java.lang:type=GarbageCollector,name=" + string);
                if (!proxyClient.isRegistered(objectName2)) continue;
                this.gcMBeans.put(objectName2, new Long(0L));
            }
            catch (Exception exception) {
                assert (false);
            }
        }
    }

    public boolean isCollectedMemoryPool() {
        return this.gcMBeans.size() != 0;
    }

    public ObjectName getObjectName() {
        return this.objName;
    }

    public MemoryPoolStat getStat() throws IOException {
        long l = this.pool.isUsageThresholdSupported() ? this.pool.getUsageThreshold() : -1L;
        long l2 = this.pool.isCollectionUsageThresholdSupported() ? this.pool.getCollectionUsageThreshold() : -1L;
        long l3 = 0L;
        long l4 = 0L;
        MemoryUsage memoryUsage = null;
        MemoryUsage memoryUsage2 = null;
        long l5 = 0L;
        if (this.lastGcInfo != null) {
            l5 = this.lastGcInfo.getId();
            l3 = this.lastGcInfo.getStartTime();
            l4 = this.lastGcInfo.getEndTime();
            memoryUsage = this.lastGcInfo.getMemoryUsageBeforeGc().get(this.poolName);
            memoryUsage2 = this.lastGcInfo.getMemoryUsageAfterGc().get(this.poolName);
        }
        Set<Map.Entry<ObjectName, Long>> set = this.gcMBeans.entrySet();
        for (Map.Entry<ObjectName, Long> entry : set) {
            GarbageCollectorMXBean garbageCollectorMXBean = this.client.getMXBean(entry.getKey(), GarbageCollectorMXBean.class);
            Long l6 = entry.getValue();
            Long l7 = garbageCollectorMXBean.getCollectionCount();
            if (l7 <= l6) continue;
            this.gcMBeans.put(entry.getKey(), new Long(l7));
            this.lastGcInfo = new GcInfo(garbageCollectorMXBean);
            if (this.lastGcInfo.getEndTime() <= l4) continue;
            l5 = this.lastGcInfo.getId();
            l3 = this.lastGcInfo.getStartTime();
            l4 = this.lastGcInfo.getEndTime();
            memoryUsage = this.lastGcInfo.getMemoryUsageBeforeGc().get(this.poolName);
            memoryUsage2 = this.lastGcInfo.getMemoryUsageAfterGc().get(this.poolName);
            assert (memoryUsage != null);
            assert (memoryUsage2 != null);
        }
        MemoryUsage memoryUsage3 = this.pool.getUsage();
        return new MemoryPoolStat(this.poolName, l, memoryUsage3, l5, l3, l4, l2, memoryUsage, memoryUsage2);
    }
}

