/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.beans.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.List;

public class ColorEditor
extends Panel
implements PropertyEditor {
    List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
    private Color value;
    private Object source;

    public ColorEditor(Object object) {
        if (null == object) {
            throw new NullPointerException();
        }
        this.source = object;
    }

    public ColorEditor() {
    }

    @Override
    public Component getCustomEditor() {
        return this;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public String getJavaInitializationString() {
        String string = null;
        Color color = (Color)this.getValue();
        if (color != null) {
            int n = color.getRed();
            int n2 = color.getGreen();
            int n3 = color.getBlue();
            string = "new java.awt.Color(" + n + "," + n2 + "," + n3 + ")";
        }
        return string;
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public void setValue(Object object) {
        if (null == object) {
            return;
        }
        Color color = this.value;
        this.value = (Color)object;
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "value", color, object);
        PropertyChangeListener[] propertyChangeListenerArray = new PropertyChangeListener[this.listeners.size()];
        this.listeners.toArray(propertyChangeListenerArray);
        for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray) {
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    @Override
    public String getAsText() {
        Color color = (Color)this.getValue();
        if (null == color) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder(14);
        stringBuilder.append(color.getRed());
        stringBuilder.append(",");
        stringBuilder.append(color.getGreen());
        stringBuilder.append(",");
        stringBuilder.append(color.getBlue());
        return stringBuilder.toString();
    }

    @Override
    public void setAsText(String string) {
        if (null == string) {
            throw new NullPointerException();
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string2 = string;
        try {
            int n4 = string.indexOf(",");
            n = Integer.parseInt(string.substring(0, n4));
            string2 = string.substring(n4 + 1);
            n4 = string2.indexOf(",");
            n2 = Integer.parseInt(string2.substring(0, n4));
            string2 = string2.substring(n4 + 1);
            n3 = Integer.parseInt(string2);
            this.setValue(new Color(n, n2, n3));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(string2);
        }
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Color color = (Color)this.getValue();
        if (color != null) {
            graphics.setColor(color);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners != null) {
            this.listeners.remove(propertyChangeListener);
        }
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.add(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ArrayList<PropertyChangeListener> arrayList = new ArrayList<PropertyChangeListener>(this.listeners.size());
        Object object = this.listeners;
        synchronized (object) {
            arrayList.addAll(this.listeners);
        }
        object = new PropertyChangeEvent(this.source, null, null, null);
        for (PropertyChangeListener propertyChangeListener : arrayList) {
            propertyChangeListener.propertyChange((PropertyChangeEvent)object);
        }
    }
}

