/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.beans.editors;

import java.beans.PropertyEditorSupport;

public final class BooleanEditor
extends PropertyEditorSupport {
    public BooleanEditor(Object object) {
        super(object);
    }

    public BooleanEditor() {
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (!string.equalsIgnoreCase("true") && !string.equalsIgnoreCase("false")) {
            throw new IllegalArgumentException(string);
        }
        this.setValue(new Boolean(string));
    }

    @Override
    public String getJavaInitializationString() {
        return this.getValueAsString();
    }

    @Override
    public String[] getTags() {
        return new String[]{"True", "False"};
    }

    @Override
    public void setValue(Object object) {
        if (object instanceof Boolean) {
            super.setValue(object);
        }
    }

    private String getValueAsString() {
        String string = null;
        Object object = this.getValue();
        if (object != null) {
            Boolean bl = (Boolean)object;
            string = bl.toString();
        }
        return string;
    }
}

