/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.awt.SystemColor;
import java.awt.font.TextAttribute;
import java.beans.Encoder;
import java.beans.Expression;
import java.beans.ReferenceMap;
import java.beans.Statement;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class XMLEncoder
extends Encoder {
    private static final int INDENT_UNIT = 1;
    private static final boolean isStaticConstantsSupported = true;
    private ArrayList<Object> flushPending = new ArrayList();
    private ArrayList<Object> flushPendingStat = new ArrayList();
    private ArrayList<Object> flushPrePending = new ArrayList();
    private boolean hasXmlHeader = false;
    private int idSerialNo = 0;
    private boolean needOwner = false;
    private PrintWriter out;
    private Object owner = null;
    private ReferenceMap records = new ReferenceMap();
    private boolean writingObject = false;

    public XMLEncoder(OutputStream outputStream) {
        if (null != outputStream) {
            try {
                this.out = new PrintWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"), true);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
    }

    public void close() {
        this.flush();
        this.out.println("</java>");
        this.out.close();
    }

    private StringBuffer decapitalize(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.setCharAt(0, Character.toLowerCase(stringBuffer.charAt(0)));
        return stringBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        XMLEncoder xMLEncoder = this;
        synchronized (xMLEncoder) {
            if (!this.hasXmlHeader) {
                this.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                this.out.println("<java version=\"" + System.getProperty("java.version") + "\" class=\"java.beans.XMLDecoder\">");
                this.hasXmlHeader = true;
            }
            for (Object object : this.flushPending) {
                Record record = (Record)this.records.get(object);
                if (record == null) continue;
                this.preprocess(object, record);
            }
            Iterator<Object> iterator = this.flushPending.iterator();
            while (iterator.hasNext()) {
                Object object;
                object = iterator.next();
                this.flushObject(object, 1);
                iterator.remove();
            }
            this.records.clear();
            this.flushPendingStat.clear();
            super.clear();
        }
    }

    private void flushBasicObject(Object object, int n) {
        if (object instanceof Proxy) {
            return;
        }
        this.flushIndent(n);
        if (object == null) {
            this.out.println("<null />");
        } else if (object instanceof String) {
            Record record = (Record)this.records.get(object);
            if (null != record) {
                if (this.flushPendingStat.contains(object)) {
                    this.flushExpression(object, record, n - 3, true);
                } else {
                    this.flushExpression(object, record, n - 3, false);
                }
                return;
            }
            this.out.print("<string>");
            this.flushString((String)object);
            this.out.println("</string>");
        } else if (object instanceof Class) {
            this.out.print("<class>");
            this.out.print(((Class)object).getName());
            this.out.println("</class>");
        } else if (object instanceof Boolean) {
            this.out.print("<boolean>");
            this.out.print(object);
            this.out.println("</boolean>");
        } else if (object instanceof Byte) {
            this.out.print("<byte>");
            this.out.print(object);
            this.out.println("</byte>");
        } else if (object instanceof Character) {
            this.out.print("<char>");
            this.out.print(object);
            this.out.println("</char>");
        } else if (object instanceof Double) {
            this.out.print("<double>");
            this.out.print(object);
            this.out.println("</double>");
        } else if (object instanceof Float) {
            this.out.print("<float>");
            this.out.print(object);
            this.out.println("</float>");
        } else if (object instanceof Integer) {
            this.out.print("<int>");
            this.out.print(object);
            this.out.println("</int>");
        } else if (object instanceof Long) {
            this.out.print("<long>");
            this.out.print(object);
            this.out.println("</long>");
        } else if (object instanceof Short) {
            this.out.print("<short>");
            this.out.print(object);
            this.out.println("</short>");
        } else {
            this.getExceptionListener().exceptionThrown(new Exception("Unknown basic object: " + object));
        }
    }

    private void flushExpression(Object object, Record record, int n, boolean bl) {
        if (record.id != null) {
            this.flushIndent(n);
            this.out.print("<object idref=\"");
            this.out.print(record.id);
            this.out.println("\" />");
            return;
        }
        if (record.refCount > 1) {
            record.id = this.nameForClass(object.getClass()) + this.idSerialNo;
            ++this.idSerialNo;
        }
        Statement statement = bl ? new Statement(record.exp.getTarget(), record.exp.getMethodName(), record.exp.getArguments()) : record.exp;
        this.flushStatement(statement, record.id, record.stats, n);
    }

    private void flushIndent(int n) {
        for (int i = 0; i < n; ++i) {
            this.out.print(" ");
        }
    }

    private void flushObject(Object object, int n) {
        Record record = (Record)this.records.get(object);
        if (record == null && !this.isBasicType(object)) {
            return;
        }
        if (object == this.owner && this.needOwner) {
            this.flushOwner(object, record, n);
            this.needOwner = false;
            return;
        }
        if (this.isBasicType(object)) {
            this.flushBasicObject(object, n);
        } else if (this.flushPendingStat.contains(object)) {
            this.flushExpression(object, record, n, true);
        } else {
            this.flushExpression(object, record, n, false);
        }
    }

    private void flushOwner(Object object, Record record, int n) {
        if (record.refCount > 1) {
            record.id = this.nameForClass(object.getClass()) + this.idSerialNo;
            ++this.idSerialNo;
        }
        this.flushIndent(n);
        String string = "void";
        this.out.print("<");
        this.out.print(string);
        if (record.id != null) {
            this.out.print(" id=\"");
            this.out.print(record.id);
            this.out.print("\"");
        }
        this.out.print(" property=\"owner\"");
        if (record.exp.getArguments().length == 0 && record.stats.isEmpty()) {
            this.out.println("/>");
            return;
        }
        this.out.println(">");
        for (int i = 0; i < record.exp.getArguments().length; ++i) {
            this.flushObject(record.exp.getArguments()[i], n + 1);
        }
        this.flushSubStatements(record.stats, n);
        this.flushIndent(n);
        this.out.print("</");
        this.out.print(string);
        this.out.println(">");
    }

    private void flushStatArray(Statement statement, String string, List<?> list, int n) {
        this.flushIndent(n);
        this.out.print("<array");
        if (string != null) {
            this.out.print(" id=\"");
            this.out.print(string);
            this.out.print("\"");
        }
        this.out.print(" class=\"");
        this.out.print(((Class)statement.getArguments()[0]).getName());
        this.out.print("\" length=\"");
        this.out.print(statement.getArguments()[1]);
        this.out.print("\"");
        if (list.isEmpty()) {
            this.out.println("/>");
            return;
        }
        this.out.println(">");
        this.flushSubStatements(list, n);
        this.flushIndent(n);
        this.out.println("</array>");
    }

    private void flushStatCommon(Statement statement, String string, List<?> list, int n) {
        this.flushIndent(n);
        String string2 = statement instanceof Expression ? "object" : "void";
        this.out.print("<");
        this.out.print(string2);
        if (string != null) {
            this.out.print(" id=\"");
            this.out.print(string);
            this.out.print("\"");
        }
        if (statement.getTarget() instanceof Class) {
            this.out.print(" class=\"");
            this.out.print(((Class)statement.getTarget()).getName());
            this.out.print("\"");
        }
        if (!"new".equals(statement.getMethodName())) {
            this.out.print(" method=\"");
            this.out.print(statement.getMethodName());
            this.out.print("\"");
        }
        if (statement.getArguments().length == 0 && list.isEmpty()) {
            this.out.println("/>");
            return;
        }
        this.out.println(">");
        for (int i = 0; i < statement.getArguments().length; ++i) {
            this.flushObject(statement.getArguments()[i], n + 1);
        }
        this.flushSubStatements(list, n);
        this.flushIndent(n);
        this.out.print("</");
        this.out.print(string2);
        this.out.println(">");
    }

    private void flushStatement(Statement statement, String string, List<?> list, int n) {
        Object object = statement.getTarget();
        String string2 = statement.getMethodName();
        Object[] objectArray = statement.getArguments();
        if (Array.class == object && "newInstance".equals(string2)) {
            this.flushStatArray(statement, string, list, n);
            return;
        }
        if (this.isGetArrayStat(object, string2, objectArray) || this.isSetArrayStat(object, string2, objectArray)) {
            this.flushStatIndexed(statement, string, list, n);
            return;
        }
        if (this.isGetPropertyStat(string2, objectArray) || this.isSetPropertyStat(string2, objectArray)) {
            this.flushStatGetterSetter(statement, string, list, n);
            return;
        }
        if ("getField".equals(statement.getMethodName())) {
            this.flushStatField(statement, string, n);
            return;
        }
        this.flushStatCommon(statement, string, list, n);
    }

    private void flushStatField(Statement statement, String string, int n) {
        Object object;
        this.flushIndent(n);
        String string2 = "object";
        this.out.print("<");
        this.out.print(string2);
        if (string != null) {
            this.out.print(" id=\"");
            this.out.print(string);
            this.out.print("\"");
        }
        if (statement.getTarget() instanceof Class) {
            this.out.print(" class=\"");
            this.out.print(((Class)statement.getTarget()).getName());
            this.out.print("\"");
        }
        if ((object = statement.getTarget()) == SystemColor.class || object == TextAttribute.class) {
            this.out.print(" field=\"");
            this.out.print(statement.getArguments()[0]);
            this.out.print("\"");
            this.out.println("/>");
        } else {
            this.out.print(" method=\"");
            this.out.print(statement.getMethodName());
            this.out.print("\"");
            this.out.println(">");
            Object object2 = statement.getArguments()[0];
            this.flushObject(object2, n + 1);
            this.flushIndent(n);
            this.out.println("</object>");
        }
    }

    private void flushStatGetterSetter(Statement statement, String string, List<?> list, int n) {
        this.flushIndent(n);
        String string2 = statement instanceof Expression ? "object" : "void";
        this.out.print("<");
        this.out.print(string2);
        if (string != null) {
            this.out.print(" id=\"");
            this.out.print(string);
            this.out.print("\"");
        }
        if (statement.getTarget() instanceof Class) {
            this.out.print(" class=\"");
            this.out.print(((Class)statement.getTarget()).getName());
            this.out.print("\"");
        }
        this.out.print(" property=\"");
        this.out.print(this.decapitalize(statement.getMethodName().substring(3)));
        this.out.print("\"");
        if (statement.getArguments().length == 0 && list.isEmpty()) {
            this.out.println("/>");
            return;
        }
        this.out.println(">");
        for (int i = 0; i < statement.getArguments().length; ++i) {
            this.flushObject(statement.getArguments()[i], n + 1);
        }
        this.flushSubStatements(list, n);
        this.flushIndent(n);
        this.out.print("</");
        this.out.print(string2);
        this.out.println(">");
    }

    private void flushStatIndexed(Statement statement, String string, List<?> list, int n) {
        this.flushIndent(n);
        String string2 = statement instanceof Expression ? "object" : "void";
        this.out.print("<");
        this.out.print(string2);
        if (string != null) {
            this.out.print(" id=\"");
            this.out.print(string);
            this.out.print("\"");
        }
        if (statement.getTarget() instanceof Class) {
            this.out.print(" class=\"");
            this.out.print(((Class)statement.getTarget()).getName());
            this.out.print("\"");
        }
        this.out.print(" index=\"");
        this.out.print(statement.getArguments()[0]);
        this.out.print("\"");
        if (statement.getArguments().length == 1 && list.isEmpty()) {
            this.out.println("/>");
            return;
        }
        this.out.println(">");
        for (int i = 1; i < statement.getArguments().length; ++i) {
            this.flushObject(statement.getArguments()[i], n + 1);
        }
        this.flushSubStatements(list, n);
        this.flushIndent(n);
        this.out.print("</");
        this.out.print(string2);
        this.out.println(">");
    }

    private void flushString(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                this.out.print("&lt;");
                continue;
            }
            if (c == '>') {
                this.out.print("&gt;");
                continue;
            }
            if (c == '&') {
                this.out.print("&amp;");
                continue;
            }
            if (c == '\'') {
                this.out.print("&apos;");
                continue;
            }
            if (c == '\"') {
                this.out.print("&quot;");
                continue;
            }
            this.out.print(c);
        }
    }

    private void flushSubStatements(List<?> list, int n) {
        for (int i = 0; i < list.size(); ++i) {
            Statement statement = (Statement)list.get(i);
            try {
                if (statement instanceof Expression) {
                    Expression expression = (Expression)statement;
                    Object object = expression.getValue();
                    Record record = (Record)this.records.get(object);
                    this.flushExpression(object, record, n + 1, true);
                    continue;
                }
                this.flushStatement(statement, null, Collections.EMPTY_LIST, n + 1);
                continue;
            }
            catch (Exception exception) {
                this.getExceptionListener().exceptionThrown(exception);
            }
        }
    }

    public Object getOwner() {
        return this.owner;
    }

    private boolean isBasicType(Object object) {
        return object == null || object instanceof Boolean || object instanceof Byte || object instanceof Character || object instanceof Class || object instanceof Double || object instanceof Float || object instanceof Integer || object instanceof Long || object instanceof Short || object instanceof String || object instanceof Proxy;
    }

    private boolean isGetArrayStat(Object object, String string, Object[] objectArray) {
        return "get".equals(string) && objectArray.length == 1 && objectArray[0] instanceof Integer && object.getClass().isArray();
    }

    private boolean isGetPropertyStat(String string, Object[] objectArray) {
        return string.startsWith("get") && string.length() > 3 && objectArray.length == 0;
    }

    private boolean isSetArrayStat(Object object, String string, Object[] objectArray) {
        return "set".equals(string) && objectArray.length == 2 && objectArray[0] instanceof Integer && object.getClass().isArray();
    }

    private boolean isSetPropertyStat(String string, Object[] objectArray) {
        return string.startsWith("set") && string.length() > 3 && objectArray.length == 1;
    }

    private String nameForClass(Class<?> clazz) {
        if (clazz.isArray()) {
            return this.nameForClass(clazz.getComponentType()) + "Array";
        }
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (-1 == n) {
            return string;
        }
        return string.substring(n + 1);
    }

    private void preprocess(Object object, Record record) {
        Object object2;
        Object object3;
        if (this.isBasicType(object) && this.writingObject) {
            return;
        }
        ++record.refCount;
        if (record.refCount > 1) {
            return;
        }
        try {
            if ("getField".equals(((Record)this.records.get((Object)record.exp.getTarget())).exp.getMethodName())) {
                this.records.remove(object);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (null != record.exp) {
            object3 = record.exp.getArguments();
            for (int i = 0; i < ((Object)object3).length; ++i) {
                object2 = (Record)this.records.get(object3[i]);
                if (object2 == null) continue;
                this.preprocess(object3[i], (Record)object2);
            }
        }
        object3 = record.stats.iterator();
        while (object3.hasNext()) {
            Statement statement = (Statement)object3.next();
            if (statement instanceof Expression) {
                try {
                    object2 = (Expression)statement;
                    Record record2 = (Record)this.records.get(((Expression)object2).getValue());
                    if (record2 == null || record2.exp == null || record2.exp != object2) {
                        object3.remove();
                        continue;
                    }
                    this.preprocess(((Expression)object2).getValue(), record2);
                    if (!record2.stats.isEmpty() || !this.isGetArrayStat(((Statement)object2).getTarget(), ((Statement)object2).getMethodName(), ((Statement)object2).getArguments()) && !this.isGetPropertyStat(((Statement)object2).getMethodName(), ((Statement)object2).getArguments())) continue;
                    object3.remove();
                }
                catch (Exception exception) {
                    this.getExceptionListener().exceptionThrown(exception);
                    object3.remove();
                }
                continue;
            }
            object2 = statement.getArguments();
            for (int i = 0; i < ((Object)object2).length; ++i) {
                Record record3 = (Record)this.records.get(object2[i]);
                if (record3 == null) continue;
                this.preprocess(object2[i], record3);
            }
        }
    }

    private void recordExpression(Object object, Expression expression) {
        Record record = (Record)this.records.get(object);
        if (record == null) {
            record = new Record();
            this.records.put(object, record);
        }
        if (record.exp == null) {
            for (Statement statement : record.stats) {
                try {
                    if (!(statement instanceof Expression)) continue;
                    this.flushPrePending.add(object);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        record.exp = expression;
        if (object == this.owner && this.owner != null) {
            this.needOwner = true;
        }
        this.recordStatement(expression);
    }

    private void recordStatement(Statement statement) {
        Record record;
        if (statement.getTarget() == this.owner && this.owner != null) {
            this.needOwner = true;
        }
        if ((record = (Record)this.records.get(statement.getTarget())) == null) {
            record = new Record();
            this.records.put(statement.getTarget(), record);
        }
        record.stats.add(statement);
    }

    public void setOwner(Object object) {
        this.owner = object;
    }

    @Override
    public void writeExpression(Expression expression) {
        boolean bl = this.writingObject;
        this.writingObject = true;
        Object object = null;
        try {
            object = expression.getValue();
        }
        catch (Exception exception) {
            this.getExceptionListener().exceptionThrown(new Exception("failed to execute expression: " + expression, exception));
            return;
        }
        if (this.get(object) != null && (!(object instanceof String) || bl)) {
            return;
        }
        if (!this.isBasicType(object) || object instanceof String && !bl) {
            this.recordExpression(object, expression);
        }
        super.writeExpression(expression);
        this.writingObject = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObject(Object object) {
        XMLEncoder xMLEncoder = this;
        synchronized (xMLEncoder) {
            boolean bl = this.writingObject;
            this.writingObject = true;
            try {
                super.writeObject(object);
            }
            finally {
                this.writingObject = bl;
            }
            if (!this.writingObject) {
                this.flushPending.addAll(this.flushPrePending);
                this.flushPendingStat.addAll(this.flushPrePending);
                this.flushPrePending.clear();
                if (this.flushPending.contains(object)) {
                    this.flushPrePending.remove(object);
                    this.flushPendingStat.remove(object);
                } else {
                    this.flushPending.add(object);
                }
                if (this.needOwner) {
                    this.flushPending.remove(this.owner);
                    this.flushPending.add(0, this.owner);
                }
            }
        }
    }

    @Override
    public void writeStatement(Statement statement) {
        this.recordStatement(statement);
        super.writeStatement(statement);
    }

    private static class Record {
        boolean born = false;
        Expression exp = null;
        String id = null;
        int refCount = 0;
        ArrayList<Statement> stats = new ArrayList();

        private Record() {
        }
    }
}

