/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.ExceptionListener;
import java.beans.Expression;
import java.beans.Statement;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.parsers.SAXParserFactory;
import org.apache.harmony.beans.internal.nls.Messages;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLDecoder {
    private ClassLoader defaultClassLoader = null;
    private InputStream inputStream;
    private ExceptionListener listener;
    private Object owner;
    private Stack<Elem> readObjs = new Stack();
    private int readObjIndex = 0;

    public XMLDecoder(InputStream inputStream) {
        this(inputStream, null, null);
    }

    public XMLDecoder(InputStream inputStream, Object object) {
        this(inputStream, object, null);
    }

    public XMLDecoder(InputStream inputStream, Object object, ExceptionListener exceptionListener) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Input stream cannot be null");
        }
        this.inputStream = inputStream;
        this.owner = object;
        this.listener = exceptionListener == null ? new DefaultExceptionListener() : exceptionListener;
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(inputStream, (DefaultHandler)new SAXHandler());
        }
        catch (Exception exception) {
            this.listener.exceptionThrown(exception);
        }
    }

    public XMLDecoder(InputStream inputStream, Object object, ExceptionListener exceptionListener, ClassLoader classLoader) {
        this(inputStream, object, exceptionListener);
        this.defaultClassLoader = classLoader;
    }

    public void close() {
        try {
            this.inputStream.close();
        }
        catch (Exception exception) {
            this.listener.exceptionThrown(exception);
        }
    }

    public ExceptionListener getExceptionListener() {
        return this.listener;
    }

    public Object getOwner() {
        return this.owner;
    }

    public Object readObject() {
        if (this.readObjIndex >= this.readObjs.size()) {
            throw new ArrayIndexOutOfBoundsException("no more objects to read");
        }
        Elem elem = (Elem)this.readObjs.get(this.readObjIndex);
        if (!elem.isClosed) {
            throw new ArrayIndexOutOfBoundsException("no more objects to read");
        }
        ++this.readObjIndex;
        return elem.result;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        if (exceptionListener != null) {
            this.listener = exceptionListener;
        }
    }

    public void setOwner(Object object) {
        this.owner = object;
    }

    private static class Elem {
        String id;
        String idref;
        boolean isExecuted;
        boolean isExpression;
        boolean isBasicType;
        boolean isClosed;
        Object target;
        String methodName;
        boolean fromProperty;
        boolean fromIndex;
        boolean fromField;
        boolean fromOwner;
        Object result;

        private Elem() {
        }
    }

    private class SAXHandler
    extends DefaultHandler {
        boolean inJavaElem = false;
        HashMap<String, Object> idObjMap = new HashMap();

        private SAXHandler() {
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (!this.inJavaElem) {
                return;
            }
            if (XMLDecoder.this.readObjs.size() > 0) {
                Elem elem = (Elem)XMLDecoder.this.readObjs.peek();
                if (elem.isBasicType) {
                    String string = new String(cArray, n, n2);
                    elem.methodName = elem.methodName == null ? string : elem.methodName + string;
                }
            }
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (!this.inJavaElem) {
                if ("java".equals(string3)) {
                    this.inJavaElem = true;
                } else {
                    XMLDecoder.this.listener.exceptionThrown(new Exception("unknown root element: " + string3));
                }
                return;
            }
            if ("object".equals(string3)) {
                this.startObjectElem(attributes);
            } else if ("array".equals(string3)) {
                this.startArrayElem(attributes);
            } else if ("void".equals(string3)) {
                this.startVoidElem(attributes);
            } else if ("boolean".equals(string3) || "byte".equals(string3) || "char".equals(string3) || "class".equals(string3) || "double".equals(string3) || "float".equals(string3) || "int".equals(string3) || "long".equals(string3) || "short".equals(string3) || "string".equals(string3) || "null".equals(string3)) {
                this.startBasicElem(string3, attributes);
            }
        }

        private void startObjectElem(Attributes attributes) {
            Elem elem = new Elem();
            elem.isExpression = true;
            elem.id = attributes.getValue("id");
            elem.idref = attributes.getValue("idref");
            if (elem.idref == null) {
                this.obtainTarget(elem, attributes);
                this.obtainMethod(elem, attributes);
            }
            XMLDecoder.this.readObjs.push(elem);
        }

        private void obtainTarget(Elem elem, Attributes attributes) {
            String string = attributes.getValue("class");
            if (string != null) {
                try {
                    elem.target = this.classForName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    XMLDecoder.this.listener.exceptionThrown(classNotFoundException);
                }
            } else {
                Elem elem2 = this.latestUnclosedElem();
                if (elem2 == null) {
                    elem.target = XMLDecoder.this.owner;
                    return;
                }
                elem.target = this.execute(elem2);
            }
        }

        private void obtainMethod(Elem elem, Attributes attributes) {
            elem.methodName = attributes.getValue("method");
            if (elem.methodName != null) {
                return;
            }
            elem.methodName = attributes.getValue("property");
            if (elem.methodName != null) {
                elem.fromProperty = true;
                return;
            }
            elem.methodName = attributes.getValue("index");
            if (elem.methodName != null) {
                elem.fromIndex = true;
                return;
            }
            elem.methodName = attributes.getValue("field");
            if (elem.methodName != null) {
                elem.fromField = true;
                return;
            }
            elem.methodName = attributes.getValue("owner");
            if (elem.methodName != null) {
                elem.fromOwner = true;
                return;
            }
            elem.methodName = "new";
        }

        private Class<?> classForName(String string) throws ClassNotFoundException {
            if ("boolean".equals(string)) {
                return Boolean.TYPE;
            }
            if ("byte".equals(string)) {
                return Byte.TYPE;
            }
            if ("char".equals(string)) {
                return Character.TYPE;
            }
            if ("double".equals(string)) {
                return Double.TYPE;
            }
            if ("float".equals(string)) {
                return Float.TYPE;
            }
            if ("int".equals(string)) {
                return Integer.TYPE;
            }
            if ("long".equals(string)) {
                return Long.TYPE;
            }
            if ("short".equals(string)) {
                return Short.TYPE;
            }
            return Class.forName(string, true, XMLDecoder.this.defaultClassLoader == null ? Thread.currentThread().getContextClassLoader() : XMLDecoder.this.defaultClassLoader);
        }

        private void startArrayElem(Attributes attributes) {
            Elem elem = new Elem();
            elem.isExpression = true;
            elem.id = attributes.getValue("id");
            try {
                Class<?> clazz = this.classForName(attributes.getValue("class"));
                String string = attributes.getValue("length");
                if (string != null) {
                    int n = Integer.parseInt(attributes.getValue("length"));
                    elem.result = Array.newInstance(clazz, n);
                    elem.isExecuted = true;
                } else {
                    elem.target = clazz;
                    elem.methodName = "newArray";
                    elem.isExecuted = false;
                }
            }
            catch (Exception exception) {
                XMLDecoder.this.listener.exceptionThrown(exception);
            }
            XMLDecoder.this.readObjs.push(elem);
        }

        private void startVoidElem(Attributes attributes) {
            Elem elem = new Elem();
            elem.id = attributes.getValue("id");
            this.obtainTarget(elem, attributes);
            this.obtainMethod(elem, attributes);
            XMLDecoder.this.readObjs.push(elem);
        }

        private void startBasicElem(String string, Attributes attributes) {
            Elem elem = new Elem();
            elem.isBasicType = true;
            elem.isExpression = true;
            elem.id = attributes.getValue("id");
            elem.idref = attributes.getValue("idref");
            elem.target = string;
            XMLDecoder.this.readObjs.push(elem);
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (!this.inJavaElem) {
                return;
            }
            if ("java".equals(string3)) {
                this.inJavaElem = false;
                return;
            }
            Elem elem = this.latestUnclosedElem();
            this.execute(elem);
            elem.isClosed = true;
            while (XMLDecoder.this.readObjs.pop() != elem) {
            }
            if (elem.isExpression) {
                XMLDecoder.this.readObjs.push(elem);
            }
        }

        private Elem latestUnclosedElem() {
            for (int i = XMLDecoder.this.readObjs.size() - 1; i >= 0; --i) {
                Elem elem = (Elem)XMLDecoder.this.readObjs.get(i);
                if (elem.isClosed) continue;
                return elem;
            }
            return null;
        }

        private Object execute(Elem elem) {
            if (elem.isExecuted) {
                return elem.result;
            }
            try {
                elem.result = elem.idref != null ? this.idObjMap.get(elem.idref) : (elem.isBasicType ? this.executeBasic(elem) : this.executeCommon(elem));
            }
            catch (Exception exception) {
                XMLDecoder.this.listener.exceptionThrown(exception);
            }
            if (elem.id != null) {
                this.idObjMap.put(elem.id, elem.result);
            }
            elem.isExecuted = true;
            return elem.result;
        }

        private Object executeCommon(Elem elem) throws Exception {
            Object object;
            Object object2;
            ArrayList<Object> arrayList = new ArrayList<Object>(5);
            while (XMLDecoder.this.readObjs.peek() != elem) {
                object2 = (Elem)XMLDecoder.this.readObjs.pop();
                arrayList.add(0, ((Elem)object2).result);
            }
            object2 = elem.methodName;
            if (elem.fromProperty) {
                object2 = (arrayList.size() == 0 ? "get" : "set") + this.capitalize((String)object2);
            }
            if (elem.fromIndex) {
                object = Integer.valueOf((String)object2);
                arrayList.add(0, object);
                Object object3 = object2 = arrayList.size() == 1 ? "get" : "set";
            }
            if (elem.fromField) {
                object = ((Class)elem.target).getField((String)object2);
                return new Expression(object, "get", new Object[]{null}).getValue();
            }
            if (elem.fromOwner) {
                return XMLDecoder.this.owner;
            }
            if (elem.target == XMLDecoder.this.owner) {
                if ("getOwner".equals(object2)) {
                    return XMLDecoder.this.owner;
                }
                object = new Class[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    Object e = arrayList.get(i);
                    object[i] = e == null ? null : e.getClass();
                }
                try {
                    Method method = XMLDecoder.this.owner.getClass().getMethod((String)object2, (Class<?>)object);
                    return method.invoke(XMLDecoder.this.owner, arrayList.toArray());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Method method = this.findMethod(XMLDecoder.this.owner instanceof Class ? (Class<?>)XMLDecoder.this.owner : XMLDecoder.this.owner.getClass(), (String)object2, (Class[])object);
                    return method.invoke(XMLDecoder.this.owner, arrayList.toArray());
                }
            }
            object = new Expression(elem.target, (String)object2, arrayList.toArray());
            return ((Expression)object).getValue();
        }

        private Method findMethod(Class clazz, String string, Class[] classArray) throws Exception {
            int n;
            Method[] methodArray = clazz.getMethods();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Method method : methodArray) {
                Class<?>[] object2;
                if (!string.equals(method.getName()) || (object2 = method.getParameterTypes()).length != classArray.length) continue;
                n = 1;
                for (int i = 0; i < object2.length; ++i) {
                    boolean bl;
                    boolean bl2 = classArray[i] == null;
                    boolean bl3 = this.isPrimitiveWrapper(classArray[i], object2[i]);
                    boolean bl4 = bl = bl2 ? false : object2[i].isAssignableFrom(classArray[i]);
                    if (bl2 || bl3 || bl) continue;
                    n = 0;
                    break;
                }
                if (n == 0) continue;
                arrayList.add(method);
            }
            int n2 = arrayList.size();
            if (n2 == 1) {
                return (Method)arrayList.get(0);
            }
            if (n2 == 0) {
                throw new NoSuchMethodException(Messages.getString("beans.41", string));
            }
            Statement.MethodComparator methodComparator = new Statement.MethodComparator(string, classArray);
            Method object = (Method)arrayList.get(0);
            arrayList.remove(0);
            for (Method method : arrayList) {
                n = methodComparator.compare(object, method);
                if (n > 0) {
                    object = method;
                    continue;
                }
                if (n != 0) continue;
                throw new NoSuchMethodException(Messages.getString("beans.62", string));
            }
            return object;
        }

        private boolean isPrimitiveWrapper(Class<?> clazz, Class<?> clazz2) {
            return clazz2 == Boolean.TYPE && clazz == Boolean.class || clazz2 == Byte.TYPE && clazz == Byte.class || clazz2 == Character.TYPE && clazz == Character.class || clazz2 == Short.TYPE && clazz == Short.class || clazz2 == Integer.TYPE && clazz == Integer.class || clazz2 == Long.TYPE && clazz == Long.class || clazz2 == Float.TYPE && clazz == Float.class || clazz2 == Double.TYPE && clazz == Double.class;
        }

        private String capitalize(String string) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.setCharAt(0, Character.toUpperCase(stringBuffer.charAt(0)));
            return stringBuffer.toString();
        }

        private Object executeBasic(Elem elem) throws Exception {
            String string = (String)elem.target;
            String string2 = elem.methodName;
            if ("null".equals(string)) {
                return null;
            }
            if ("string".equals(string)) {
                return string2 == null ? "" : string2;
            }
            if ("class".equals(string)) {
                return this.classForName(string2);
            }
            if ("boolean".equals(string)) {
                return Boolean.valueOf(string2);
            }
            if ("byte".equals(string)) {
                return Byte.valueOf(string2);
            }
            if ("char".equals(string)) {
                return new Character(string2.charAt(0));
            }
            if ("double".equals(string)) {
                return Double.valueOf(string2);
            }
            if ("float".equals(string)) {
                return Float.valueOf(string2);
            }
            if ("int".equals(string)) {
                return Integer.valueOf(string2);
            }
            if ("long".equals(string)) {
                return Long.valueOf(string2);
            }
            if ("short".equals(string)) {
                return Short.valueOf(string2);
            }
            throw new Exception("Unknown tag of basic type: " + string);
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            XMLDecoder.this.listener.exceptionThrown(sAXParseException);
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            XMLDecoder.this.listener.exceptionThrown(sAXParseException);
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            XMLDecoder.this.listener.exceptionThrown(sAXParseException);
        }
    }

    private static class DefaultExceptionListener
    implements ExceptionListener {
        private DefaultExceptionListener() {
        }

        @Override
        public void exceptionThrown(Exception exception) {
            exception.printStackTrace();
            System.err.println("Continue...");
        }
    }
}

