/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.harmony.beans.internal.nls.Messages;

public class Statement {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Object target;
    private String methodName;
    private Object[] arguments;
    static final String CONSTRUCTOR_NAME = "new";
    static final String ARRAY_GET = "get";
    static final String ARRAY_SET = "set";
    private static final String[][] pdConstructorSignatures = new String[][]{{"java.lang.Class", "new", "java.lang.Boolean", "", "", ""}, {"java.lang.Class", "new", "java.lang.Byte", "", "", ""}, {"java.lang.Class", "new", "java.lang.Character", "", "", ""}, {"java.lang.Class", "new", "java.lang.Double", "", "", ""}, {"java.lang.Class", "new", "java.lang.Float", "", "", ""}, {"java.lang.Class", "new", "java.lang.Integer", "", "", ""}, {"java.lang.Class", "new", "java.lang.Long", "", "", ""}, {"java.lang.Class", "new", "java.lang.Short", "", "", ""}, {"java.lang.Class", "new", "java.lang.String", "", "", ""}, {"java.lang.Class", "forName", "java.lang.String", "", "", ""}, {"java.lang.Class", "newInstance", "java.lang.Class", "java.lang.Integer", "", ""}, {"java.lang.reflect.Field", "get", "null", "", "", ""}, {"java.lang.Class", "forName", "java.lang.String", "", "", ""}};

    public Statement(Object object, String string, Object[] objectArray) {
        this.target = object;
        this.methodName = string;
        this.arguments = objectArray != null ? objectArray : EMPTY_ARRAY;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Object object = this.getTarget();
        String string = this.getMethodName();
        Object[] objectArray = this.getArguments();
        String string2 = object != null ? Statement.convertClassName(object.getClass()) : "null";
        stringBuilder.append(string2);
        stringBuilder.append('.');
        stringBuilder.append(string);
        stringBuilder.append('(');
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                if (objectArray[i] == null) {
                    stringBuilder.append("null");
                    continue;
                }
                if (objectArray[i] instanceof String) {
                    stringBuilder.append('\"');
                    stringBuilder.append(objectArray[i].toString());
                    stringBuilder.append('\"');
                    continue;
                }
                stringBuilder.append(Statement.convertClassName(objectArray[i].getClass()));
            }
        }
        stringBuilder.append(')');
        stringBuilder.append(';');
        return stringBuilder.toString();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public Object getTarget() {
        return this.target;
    }

    public void execute() throws Exception {
        this.invokeMethod();
    }

    Object invokeMethod() throws Exception {
        Class<?> clazz;
        block22: {
            clazz = null;
            try {
                Object object = this.getTarget();
                String string = this.getMethodName();
                Object[] objectArray = this.getArguments();
                if (object.getClass().isArray()) {
                    Method method = this.findArrayMethod(string, objectArray);
                    Object[] objectArray2 = new Object[objectArray.length + 1];
                    objectArray2[0] = object;
                    System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
                    clazz = method.invoke(null, objectArray2);
                    break block22;
                }
                if (string.equals("newInstance") && object == Array.class) {
                    Class clazz2 = (Class)objectArray[0];
                    int n = (Integer)objectArray[1];
                    clazz = Array.newInstance(clazz2, n);
                    break block22;
                }
                if (string.equals(CONSTRUCTOR_NAME) || string.equals("newInstance")) {
                    if (object instanceof Class) {
                        Constructor<?> constructor = this.findConstructor((Class)object, objectArray);
                        clazz = (Class<?>)constructor.newInstance(objectArray);
                        break block22;
                    }
                    throw new NoSuchMethodException(this.toString());
                }
                if (string.equals("newArray")) {
                    int n = objectArray.length;
                    Class clazz3 = (Class)object;
                    for (int i = 0; i < n; ++i) {
                        boolean bl;
                        boolean bl2 = objectArray[i] == null;
                        boolean bl3 = bl2 ? false : Statement.isPrimitiveWrapper(objectArray[i].getClass(), clazz3);
                        boolean bl4 = bl = bl2 ? false : clazz3.isAssignableFrom(objectArray[i].getClass());
                        if (bl2 || bl3 || bl) continue;
                        throw new IllegalArgumentException(Messages.getString("beans.63"));
                    }
                    clazz = Array.newInstance(clazz3, n);
                    if (clazz3.isPrimitive()) {
                        this.arrayCopy(clazz3, objectArray, clazz, n);
                    } else {
                        System.arraycopy(objectArray, 0, clazz, 0, n);
                    }
                    return clazz;
                }
                if (object instanceof Class) {
                    Method method = null;
                    boolean bl = false;
                    try {
                        if (object != Class.class) {
                            method = Statement.findMethod((Class)object, string, objectArray, true);
                            clazz = method.invoke(null, objectArray);
                            bl = true;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (!bl) {
                        if (string.equals("forName") && objectArray.length == 1 && objectArray[0] instanceof String) {
                            try {
                                clazz = Class.forName((String)objectArray[0]);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                clazz = Class.forName((String)objectArray[0], true, Thread.currentThread().getContextClassLoader());
                            }
                        } else {
                            method = Statement.findMethod(object.getClass(), string, objectArray, false);
                            clazz = method.invoke(object, objectArray);
                        }
                    }
                    break block22;
                }
                if (object instanceof Iterator) {
                    final Iterator iterator = (Iterator)object;
                    final Method method = Statement.findMethod(object.getClass(), string, objectArray, false);
                    if (iterator.hasNext()) {
                        PrivilegedAction<Object> privilegedAction = new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                try {
                                    method.setAccessible(true);
                                    return method.invoke((Object)iterator, new Object[0]);
                                }
                                catch (Exception exception) {
                                    return null;
                                }
                            }
                        };
                        clazz = privilegedAction.run();
                    }
                } else {
                    Method method = Statement.findMethod(object.getClass(), string, objectArray, false);
                    clazz = method.invoke(object, objectArray);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                throw throwable != null && throwable instanceof Exception ? (Exception)throwable : invocationTargetException;
            }
        }
        return clazz;
    }

    private void arrayCopy(Class clazz, Object[] objectArray, Object object, int n) {
        block9: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block8: {
                                        if (clazz != Boolean.TYPE) break block8;
                                        boolean[] blArray = (boolean[])object;
                                        for (int i = 0; i < n; ++i) {
                                            blArray[i] = (Boolean)objectArray[i];
                                        }
                                        break block9;
                                    }
                                    if (clazz != Short.TYPE) break block10;
                                    short[] sArray = (short[])object;
                                    for (int i = 0; i < n; ++i) {
                                        sArray[i] = (Short)objectArray[i];
                                    }
                                    break block9;
                                }
                                if (clazz != Byte.TYPE) break block11;
                                byte[] byArray = (byte[])object;
                                for (int i = 0; i < n; ++i) {
                                    byArray[i] = (Byte)objectArray[i];
                                }
                                break block9;
                            }
                            if (clazz != Character.TYPE) break block12;
                            char[] cArray = (char[])object;
                            for (int i = 0; i < n; ++i) {
                                cArray[i] = ((Character)objectArray[i]).charValue();
                            }
                            break block9;
                        }
                        if (clazz != Integer.TYPE) break block13;
                        int[] nArray = (int[])object;
                        for (int i = 0; i < n; ++i) {
                            nArray[i] = (Integer)objectArray[i];
                        }
                        break block9;
                    }
                    if (clazz != Long.TYPE) break block14;
                    long[] lArray = (long[])object;
                    for (int i = 0; i < n; ++i) {
                        lArray[i] = (Long)objectArray[i];
                    }
                    break block9;
                }
                if (clazz != Float.TYPE) break block15;
                float[] fArray = (float[])object;
                for (int i = 0; i < n; ++i) {
                    fArray[i] = ((Float)objectArray[i]).floatValue();
                }
                break block9;
            }
            if (clazz != Double.TYPE) break block9;
            double[] dArray = (double[])object;
            for (int i = 0; i < n; ++i) {
                dArray[i] = (Double)objectArray[i];
            }
        }
    }

    private Method findArrayMethod(String string, Object[] objectArray) throws NoSuchMethodException {
        if (!string.equals(ARRAY_SET) && !string.equals(ARRAY_GET)) {
            throw new NoSuchMethodException(Messages.getString("beans.3C"));
        }
        if (objectArray.length > 0 && objectArray[0].getClass() != Integer.class) {
            throw new ClassCastException(Messages.getString("beans.3D"));
        }
        if (string.equals(ARRAY_GET) && objectArray.length != 1) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("beans.3E"));
        }
        if (string.equals(ARRAY_SET) && objectArray.length != 2) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("beans.3F"));
        }
        if (string.equals(ARRAY_GET)) {
            return Array.class.getMethod(ARRAY_GET, Object.class, Integer.TYPE);
        }
        return Array.class.getMethod(ARRAY_SET, Object.class, Integer.TYPE, Object.class);
    }

    private Constructor<?> findConstructor(Class<?> clazz, Object[] objectArray) throws NoSuchMethodException {
        Constructor<?>[] constructorArray;
        Class<?>[] classArray = Statement.getClasses(objectArray);
        Constructor<?> constructor = null;
        for (Constructor<?> constructor2 : constructorArray = clazz.getConstructors()) {
            Class<?>[] classArray2 = constructor2.getParameterTypes();
            if (classArray2.length != classArray.length) continue;
            boolean bl = true;
            for (int i = 0; i < classArray2.length; ++i) {
                boolean bl2;
                boolean bl3 = classArray[i] == null;
                boolean bl4 = Statement.isPrimitiveWrapper(classArray[i], classArray2[i]);
                boolean bl5 = classArray2[i].isPrimitive();
                boolean bl6 = bl2 = bl3 ? false : classArray2[i].isAssignableFrom(classArray[i]);
                if ((bl3 || bl2 || bl4) && (!bl3 || !bl5)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            constructor = constructor2;
            break;
        }
        if (constructor == null) {
            throw new NoSuchMethodException(Messages.getString("beans.40", clazz.getName()));
        }
        return constructor;
    }

    static Method findMethod(Class<?> clazz, String string, Object[] objectArray, boolean bl) throws NoSuchMethodException {
        Object object;
        Class<?>[] classArray = Statement.getClasses(objectArray);
        Method[] methodArray = clazz.getMethods();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Method method : methodArray) {
            int n = method.getModifiers();
            if (!method.getName().equals(string) || bl && !Modifier.isStatic(n) || ((Class<?>[])(object = method.getParameterTypes())).length != classArray.length) continue;
            boolean bl2 = true;
            for (int i = 0; i < ((Class<?>[])object).length; ++i) {
                boolean bl3;
                boolean bl4 = classArray[i] == null;
                boolean bl5 = Statement.isPrimitiveWrapper(classArray[i], object[i]);
                boolean bl6 = bl3 = bl4 ? false : object[i].isAssignableFrom(classArray[i]);
                if (bl4 || bl3 || bl5) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            arrayList.add(method);
        }
        if (arrayList.size() == 0) {
            throw new NoSuchMethodException(Messages.getString("beans.41", string));
        }
        if (arrayList.size() == 1) {
            return (Method)arrayList.get(0);
        }
        Method[] methodArray2 = arrayList.toArray(new Method[arrayList.size()]);
        MethodComparator methodComparator = new MethodComparator(string, classArray);
        Method method = methodArray2[0];
        for (int i = 1; i < methodArray2.length; ++i) {
            int n = methodComparator.compare(method, methodArray2[i]);
            if (n == 0) {
                Class<?> clazz2 = method.getReturnType();
                if (clazz2.equals(object = methodArray2[i].getReturnType())) {
                    throw new NoSuchMethodException(Messages.getString("beans.62", string));
                }
                if (clazz2.isAssignableFrom((Class<?>)object)) {
                    method = methodArray2[i];
                }
            }
            if (n <= 0) continue;
            method = methodArray2[i];
        }
        return method;
    }

    static boolean isStaticMethodCall(Statement statement) {
        Object object = statement.getTarget();
        String string = statement.getMethodName();
        if (!(object instanceof Class)) {
            return false;
        }
        try {
            Statement.findMethod((Class)object, string, statement.getArguments(), true);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    static boolean isPDConstructor(Statement statement) {
        Object object = statement.getTarget();
        String string = statement.getMethodName();
        Object[] objectArray = statement.getArguments();
        Object[] objectArray2 = new String[pdConstructorSignatures[0].length];
        if (object == null || string == null || objectArray == null || objectArray.length == 0) {
            return false;
        }
        objectArray2[0] = object.getClass().getName();
        objectArray2[1] = string;
        for (int i = 2; i < objectArray2.length; ++i) {
            objectArray2[i] = objectArray.length > i - 2 ? (objectArray[i - 2] != null ? objectArray[i - 2].getClass().getName() : "null") : "";
        }
        for (Object[] objectArray3 : pdConstructorSignatures) {
            if (!Arrays.equals(objectArray2, objectArray3)) continue;
            return true;
        }
        return false;
    }

    private static boolean isPrimitiveWrapper(Class<?> clazz, Class<?> clazz2) {
        return clazz2 == Boolean.TYPE && clazz == Boolean.class || clazz2 == Byte.TYPE && clazz == Byte.class || clazz2 == Character.TYPE && clazz == Character.class || clazz2 == Short.TYPE && clazz == Short.class || clazz2 == Integer.TYPE && clazz == Integer.class || clazz2 == Long.TYPE && clazz == Long.class || clazz2 == Float.TYPE && clazz == Float.class || clazz2 == Double.TYPE && clazz == Double.class;
    }

    private static Class<?> getPrimitiveWrapper(Class<?> clazz) {
        Class clazz2 = null;
        if (clazz == Boolean.TYPE) {
            clazz2 = Boolean.class;
        } else if (clazz == Byte.TYPE) {
            clazz2 = Byte.class;
        } else if (clazz == Character.TYPE) {
            clazz2 = Character.class;
        } else if (clazz == Short.TYPE) {
            clazz2 = Short.class;
        } else if (clazz == Integer.TYPE) {
            clazz2 = Integer.class;
        } else if (clazz == Long.TYPE) {
            clazz2 = Long.class;
        } else if (clazz == Float.TYPE) {
            clazz2 = Float.class;
        } else if (clazz == Double.TYPE) {
            clazz2 = Double.class;
        }
        return clazz2;
    }

    static String convertClassName(Class<?> clazz) {
        Class<?> clazz2 = clazz.getComponentType();
        Class<?> clazz3 = clazz2 == null ? clazz : clazz2;
        String string = clazz3.getName();
        int n = string.lastIndexOf(46);
        if (n != -1 && n < string.length()) {
            string = string.substring(n + 1);
        }
        if (clazz2 != null) {
            string = string + "Array";
        }
        return string;
    }

    private static Class<?>[] getClasses(Object[] objectArray) {
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = objectArray[i] == null ? null : objectArray[i].getClass();
        }
        return classArray;
    }

    static class MethodComparator
    implements Comparator<Method> {
        static int INFINITY = Integer.MAX_VALUE;
        private String referenceMethodName;
        private Class<?>[] referenceMethodArgumentTypes;
        private final Map<Method, Integer> cache;

        public MethodComparator(String string, Class<?>[] classArray) {
            this.referenceMethodName = string;
            this.referenceMethodArgumentTypes = classArray;
            this.cache = new HashMap<Method, Integer>();
        }

        @Override
        public int compare(Method method, Method method2) {
            Integer n = this.cache.get(method);
            Integer n2 = this.cache.get(method2);
            if (n == null) {
                n = this.getNorm(method);
                this.cache.put(method, n);
            }
            if (n2 == null) {
                n2 = this.getNorm(method2);
                this.cache.put(method2, n2);
            }
            return n - n2;
        }

        private int getNorm(Method method) {
            String string = method.getName();
            Class<?>[] classArray = method.getParameterTypes();
            int n = 0;
            if (!this.referenceMethodName.equals(string) || this.referenceMethodArgumentTypes.length != classArray.length) {
                return INFINITY;
            }
            for (int i = 0; i < this.referenceMethodArgumentTypes.length; ++i) {
                if (this.referenceMethodArgumentTypes[i] == null) {
                    if (!classArray[i].isPrimitive()) continue;
                    return INFINITY;
                }
                if (this.referenceMethodArgumentTypes[i].isPrimitive()) {
                    this.referenceMethodArgumentTypes[i] = Statement.getPrimitiveWrapper(this.referenceMethodArgumentTypes[i]);
                }
                if (classArray[i].isPrimitive()) {
                    classArray[i] = Statement.getPrimitiveWrapper(classArray[i]);
                }
                n += MethodComparator.getDistance(this.referenceMethodArgumentTypes[i], classArray[i]);
            }
            return n;
        }

        private static int getDistance(Class<?> clazz, Class<?> clazz2) {
            int n = INFINITY;
            if (!clazz2.isAssignableFrom(clazz)) {
                return INFINITY;
            }
            if (clazz.getName().equals(clazz2.getName())) {
                return 0;
            }
            Class<?> clazz3 = clazz.getSuperclass();
            if (clazz3 != null) {
                n = MethodComparator.getDistance(clazz3, clazz2);
            }
            if (clazz2.isInterface()) {
                Class<?>[] classArray = clazz.getInterfaces();
                int n2 = INFINITY;
                for (Class<?> clazz4 : classArray) {
                    int n3 = MethodComparator.getDistance(clazz4, clazz2);
                    if (n3 >= n2) continue;
                    n2 = n3;
                }
                if (n < n2) {
                    n2 = n;
                }
                return n2 != INFINITY ? n2 + 1 : INFINITY;
            }
            return n != INFINITY ? n + 1 : INFINITY;
        }
    }
}

