/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;
import java.beans.SimpleBeanInfo;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.TooManyListenersException;

class StandardBeanInfo
extends SimpleBeanInfo {
    private static final String PREFIX_IS = "is";
    private static final String PREFIX_GET = "get";
    private static final String PREFIX_SET = "set";
    private static final String PREFIX_ADD = "add";
    private static final String PREFIX_REMOVE = "remove";
    private static final String SUFFIX_LISTEN = "Listener";
    private boolean explicitMethods = false;
    private boolean explicitProperties = false;
    private boolean explicitEvents = false;
    private BeanInfo explicitBeanInfo = null;
    private EventSetDescriptor[] events = null;
    private MethodDescriptor[] methods = null;
    private PropertyDescriptor[] properties = null;
    BeanInfo[] additionalBeanInfo = null;
    private Class<?> beanClass;
    private int defaultEventIndex = -1;
    private int defaultPropertyIndex = -1;
    private static PropertyComparator comparator = new PropertyComparator();
    private Image[] icon = new Image[4];
    private boolean canAddPropertyChangeListener;
    private boolean canRemovePropertyChangeListener;

    StandardBeanInfo(Class<?> clazz, BeanInfo beanInfo, Class<?> clazz2) throws IntrospectionException {
        this.beanClass = clazz;
        if (beanInfo != null) {
            this.explicitBeanInfo = beanInfo;
            this.events = beanInfo.getEventSetDescriptors();
            this.methods = beanInfo.getMethodDescriptors();
            this.properties = beanInfo.getPropertyDescriptors();
            this.defaultEventIndex = beanInfo.getDefaultEventIndex();
            if (this.defaultEventIndex < 0 || this.defaultEventIndex >= this.events.length) {
                this.defaultEventIndex = -1;
            }
            this.defaultPropertyIndex = beanInfo.getDefaultPropertyIndex();
            if (this.defaultPropertyIndex < 0 || this.defaultPropertyIndex >= this.properties.length) {
                this.defaultPropertyIndex = -1;
            }
            this.additionalBeanInfo = beanInfo.getAdditionalBeanInfo();
            for (int i = 0; i < 4; ++i) {
                this.icon[i] = beanInfo.getIcon(i + 1);
            }
            if (this.events != null) {
                this.explicitEvents = true;
            }
            if (this.methods != null) {
                this.explicitMethods = true;
            }
            if (this.properties != null) {
                this.explicitProperties = true;
            }
        }
        if (this.methods == null) {
            this.methods = this.introspectMethods();
        }
        if (this.properties == null) {
            this.properties = this.introspectProperties(clazz2);
        }
        if (this.events == null) {
            this.events = this.introspectEvents();
        }
    }

    @Override
    public BeanInfo[] getAdditionalBeanInfo() {
        return null;
    }

    @Override
    public EventSetDescriptor[] getEventSetDescriptors() {
        return this.events;
    }

    @Override
    public MethodDescriptor[] getMethodDescriptors() {
        return this.methods;
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.properties;
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        BeanDescriptor beanDescriptor;
        if (this.explicitBeanInfo != null && (beanDescriptor = this.explicitBeanInfo.getBeanDescriptor()) != null) {
            return beanDescriptor;
        }
        return new BeanDescriptor(this.beanClass);
    }

    @Override
    public int getDefaultEventIndex() {
        return this.defaultEventIndex;
    }

    @Override
    public int getDefaultPropertyIndex() {
        return this.defaultPropertyIndex;
    }

    @Override
    public Image getIcon(int n) {
        return this.icon[n - 1];
    }

    void mergeBeanInfo(BeanInfo beanInfo, boolean bl) throws IntrospectionException {
        FeatureDescriptor[] featureDescriptorArray;
        if ((bl || !this.explicitProperties) && (featureDescriptorArray = beanInfo.getPropertyDescriptors()) != null) {
            if (this.getPropertyDescriptors() != null) {
                this.properties = this.mergeProps((PropertyDescriptor[])featureDescriptorArray, beanInfo.getDefaultPropertyIndex());
            } else {
                this.properties = featureDescriptorArray;
                this.defaultPropertyIndex = beanInfo.getDefaultPropertyIndex();
            }
        }
        if ((bl || !this.explicitMethods) && (featureDescriptorArray = beanInfo.getMethodDescriptors()) != null) {
            this.methods = this.methods != null ? this.mergeMethods((MethodDescriptor[])featureDescriptorArray) : featureDescriptorArray;
        }
        if ((bl || !this.explicitEvents) && (featureDescriptorArray = beanInfo.getEventSetDescriptors()) != null) {
            if (this.events != null) {
                this.events = this.mergeEvents((EventSetDescriptor[])featureDescriptorArray, beanInfo.getDefaultEventIndex());
            } else {
                this.events = featureDescriptorArray;
                this.defaultEventIndex = beanInfo.getDefaultEventIndex();
            }
        }
    }

    private PropertyDescriptor[] mergeProps(PropertyDescriptor[] propertyDescriptorArray, int n) throws IntrospectionException {
        HashMap<String, PropertyDescriptor> hashMap = StandardBeanInfo.internalAsMap(this.properties);
        String string = null;
        if (this.defaultPropertyIndex >= 0 && this.defaultPropertyIndex < this.properties.length) {
            string = this.properties[this.defaultPropertyIndex].getName();
        } else if (n >= 0 && n < propertyDescriptorArray.length) {
            string = propertyDescriptorArray[n].getName();
        }
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            PropertyDescriptor propertyDescriptor;
            PropertyDescriptor propertyDescriptor2 = propertyDescriptorArray[i];
            String string2 = propertyDescriptor2.getName();
            if (!hashMap.containsKey(string2)) {
                hashMap.put(string2, propertyDescriptor2);
                continue;
            }
            PropertyDescriptor propertyDescriptor3 = hashMap.get(string2);
            Method method = propertyDescriptor3.getReadMethod();
            Method method2 = propertyDescriptor3.getWriteMethod();
            Method method3 = propertyDescriptor2.getReadMethod();
            Method method4 = propertyDescriptor2.getWriteMethod();
            Class<?> clazz = propertyDescriptor2.getPropertyType();
            Class<?> clazz2 = null;
            Class<?> clazz3 = propertyDescriptor3.getPropertyType();
            Class<?> clazz4 = null;
            if (propertyDescriptor3 instanceof IndexedPropertyDescriptor) {
                clazz4 = ((IndexedPropertyDescriptor)propertyDescriptor3).getIndexedPropertyType();
            }
            if (propertyDescriptor2 instanceof IndexedPropertyDescriptor) {
                clazz2 = ((IndexedPropertyDescriptor)propertyDescriptor2).getIndexedPropertyType();
            }
            if (clazz2 == null) {
                propertyDescriptor = propertyDescriptor3;
                if (clazz4 == null) {
                    if (clazz3.getName().equals(clazz.getName())) {
                        if (method == null && method3 != null) {
                            propertyDescriptor.setReadMethod(method3);
                        }
                        if (method2 == null && method4 != null) {
                            propertyDescriptor.setWriteMethod(method4);
                        }
                    } else if (method == null && method3 != null) {
                        propertyDescriptor.setWriteMethod(null);
                        propertyDescriptor.setReadMethod(method3);
                    }
                } else if (clazz.isArray() && clazz.getComponentType().getName().equals(clazz4.getName())) {
                    if (method == null && method3 != null) {
                        propertyDescriptor.setReadMethod(method3);
                    }
                    if (method2 == null && method4 != null) {
                        propertyDescriptor.setWriteMethod(method4);
                    }
                }
                hashMap.put(string2, propertyDescriptor);
            } else if (clazz4 == null) {
                if (clazz3.isArray() && clazz3.getComponentType().getName().equals(clazz2.getName())) {
                    if (method != null) {
                        propertyDescriptor2.setReadMethod(method);
                    }
                    if (method2 != null) {
                        propertyDescriptor2.setWriteMethod(method2);
                    }
                    hashMap.put(string2, propertyDescriptor2);
                } else {
                    hashMap.put(string2, propertyDescriptor3);
                }
            } else if (clazz4.getName().equals(clazz2.getName())) {
                propertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor3;
                if (method == null && method3 != null) {
                    propertyDescriptor.setReadMethod(method3);
                }
                if (method2 == null && method4 != null) {
                    propertyDescriptor.setWriteMethod(method4);
                }
                IndexedPropertyDescriptor indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor2;
                if (((IndexedPropertyDescriptor)propertyDescriptor).getIndexedReadMethod() == null && indexedPropertyDescriptor.getIndexedReadMethod() != null) {
                    ((IndexedPropertyDescriptor)propertyDescriptor).setIndexedReadMethod(indexedPropertyDescriptor.getIndexedReadMethod());
                }
                if (((IndexedPropertyDescriptor)propertyDescriptor).getIndexedWriteMethod() == null && indexedPropertyDescriptor.getIndexedWriteMethod() != null) {
                    ((IndexedPropertyDescriptor)propertyDescriptor).setIndexedWriteMethod(indexedPropertyDescriptor.getIndexedWriteMethod());
                }
                hashMap.put(string2, propertyDescriptor);
            }
            StandardBeanInfo.mergeAttributes(propertyDescriptor3, propertyDescriptor2);
        }
        PropertyDescriptor[] propertyDescriptorArray2 = new PropertyDescriptor[hashMap.size()];
        hashMap.values().toArray(propertyDescriptorArray2);
        if (string != null && !this.explicitProperties) {
            for (int i = 0; i < propertyDescriptorArray2.length; ++i) {
                if (!string.equals(propertyDescriptorArray2[i].getName())) continue;
                this.defaultPropertyIndex = i;
                break;
            }
        }
        return propertyDescriptorArray2;
    }

    private static void mergeAttributes(PropertyDescriptor propertyDescriptor, PropertyDescriptor propertyDescriptor2) {
        propertyDescriptor.hidden |= propertyDescriptor2.hidden;
        propertyDescriptor.expert |= propertyDescriptor2.expert;
        propertyDescriptor.preferred |= propertyDescriptor2.preferred;
        propertyDescriptor.bound |= propertyDescriptor2.bound;
        propertyDescriptor.constrained |= propertyDescriptor2.constrained;
        propertyDescriptor.name = propertyDescriptor2.name;
        if (propertyDescriptor.shortDescription == null && propertyDescriptor2.shortDescription != null) {
            propertyDescriptor.shortDescription = propertyDescriptor2.shortDescription;
        }
        if (propertyDescriptor.displayName == null && propertyDescriptor2.displayName != null) {
            propertyDescriptor.displayName = propertyDescriptor2.displayName;
        }
    }

    private MethodDescriptor[] mergeMethods(MethodDescriptor[] methodDescriptorArray) {
        HashMap<String, MethodDescriptor> hashMap = StandardBeanInfo.internalAsMap(this.methods);
        for (MethodDescriptor methodDescriptor : methodDescriptorArray) {
            String string = StandardBeanInfo.getQualifiedName(methodDescriptor.getMethod());
            MethodDescriptor methodDescriptor2 = hashMap.get(string);
            if (methodDescriptor2 == null) {
                hashMap.put(string, methodDescriptor);
                continue;
            }
            methodDescriptor2.merge(methodDescriptor);
        }
        MethodDescriptor[] methodDescriptorArray2 = new MethodDescriptor[hashMap.size()];
        hashMap.values().toArray(methodDescriptorArray2);
        return methodDescriptorArray2;
    }

    private EventSetDescriptor[] mergeEvents(EventSetDescriptor[] eventSetDescriptorArray, int n) {
        HashMap<String, EventSetDescriptor> hashMap = StandardBeanInfo.internalAsMap(this.events);
        String string = null;
        if (this.defaultEventIndex >= 0 && this.defaultEventIndex < this.events.length) {
            string = this.events[this.defaultEventIndex].getName();
        } else if (n >= 0 && n < eventSetDescriptorArray.length) {
            string = eventSetDescriptorArray[n].getName();
        }
        for (EventSetDescriptor eventSetDescriptor : eventSetDescriptorArray) {
            String string2 = eventSetDescriptor.getName();
            EventSetDescriptor eventSetDescriptor2 = hashMap.get(string2);
            if (eventSetDescriptor2 == null) {
                hashMap.put(string2, eventSetDescriptor);
                continue;
            }
            eventSetDescriptor2.merge(eventSetDescriptor);
        }
        EventSetDescriptor[] eventSetDescriptorArray2 = new EventSetDescriptor[hashMap.size()];
        hashMap.values().toArray(eventSetDescriptorArray2);
        if (string != null && !this.explicitEvents) {
            for (int i = 0; i < eventSetDescriptorArray2.length; ++i) {
                if (!string.equals(eventSetDescriptorArray2[i].getName())) continue;
                this.defaultEventIndex = i;
                break;
            }
        }
        return eventSetDescriptorArray2;
    }

    private static HashMap<String, PropertyDescriptor> internalAsMap(PropertyDescriptor[] propertyDescriptorArray) {
        HashMap<String, PropertyDescriptor> hashMap = new HashMap<String, PropertyDescriptor>();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            hashMap.put(propertyDescriptorArray[i].getName(), propertyDescriptorArray[i]);
        }
        return hashMap;
    }

    private static HashMap<String, MethodDescriptor> internalAsMap(MethodDescriptor[] methodDescriptorArray) {
        HashMap<String, MethodDescriptor> hashMap = new HashMap<String, MethodDescriptor>();
        for (int i = 0; i < methodDescriptorArray.length; ++i) {
            String string = StandardBeanInfo.getQualifiedName(methodDescriptorArray[i].getMethod());
            hashMap.put(string, methodDescriptorArray[i]);
        }
        return hashMap;
    }

    private static HashMap<String, EventSetDescriptor> internalAsMap(EventSetDescriptor[] eventSetDescriptorArray) {
        HashMap<String, EventSetDescriptor> hashMap = new HashMap<String, EventSetDescriptor>();
        for (int i = 0; i < eventSetDescriptorArray.length; ++i) {
            hashMap.put(eventSetDescriptorArray[i].getName(), eventSetDescriptorArray[i]);
        }
        return hashMap;
    }

    private static String getQualifiedName(Method method) {
        String string = method.getName();
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray != null) {
            for (int i = 0; i < classArray.length; ++i) {
                string = string + "_" + classArray[i].getName();
            }
        }
        return string;
    }

    private MethodDescriptor[] introspectMethods() {
        return this.introspectMethods(false, this.beanClass);
    }

    private MethodDescriptor[] introspectMethods(boolean bl) {
        return this.introspectMethods(bl, this.beanClass);
    }

    private MethodDescriptor[] introspectMethods(boolean bl, Class<?> clazz) {
        int n;
        Method[] methodArray;
        Method[] methodArray2 = methodArray = bl ? clazz.getMethods() : clazz.getDeclaredMethods();
        if (methodArray == null || methodArray.length == 0) {
            return null;
        }
        ArrayList<MethodDescriptor> arrayList = new ArrayList<MethodDescriptor>(methodArray.length);
        for (n = 0; n < methodArray.length; ++n) {
            int n2 = methodArray[n].getModifiers();
            if (!Modifier.isPublic(n2)) continue;
            MethodDescriptor methodDescriptor = new MethodDescriptor(methodArray[n]);
            arrayList.add(methodDescriptor);
        }
        n = arrayList.size();
        MethodDescriptor[] methodDescriptorArray = null;
        if (n > 0) {
            methodDescriptorArray = new MethodDescriptor[n];
            methodDescriptorArray = arrayList.toArray(methodDescriptorArray);
        }
        return methodDescriptorArray;
    }

    private PropertyDescriptor[] introspectProperties(Class<?> clazz) throws IntrospectionException {
        MethodDescriptor[] methodDescriptorArray;
        int n;
        MethodDescriptor[] methodDescriptorArray2 = this.introspectMethods();
        if (methodDescriptorArray2 == null) {
            return null;
        }
        ArrayList<MethodDescriptor> arrayList = new ArrayList<MethodDescriptor>();
        for (n = 0; n < methodDescriptorArray2.length; ++n) {
            int n2 = methodDescriptorArray2[n].getMethod().getModifiers();
            if (Modifier.isStatic(n2)) continue;
            arrayList.add(methodDescriptorArray2[n]);
        }
        n = arrayList.size();
        MethodDescriptor[] methodDescriptorArray3 = null;
        if (n > 0) {
            methodDescriptorArray3 = new MethodDescriptor[n];
            methodDescriptorArray3 = arrayList.toArray(methodDescriptorArray3);
        }
        if (methodDescriptorArray3 == null) {
            return null;
        }
        HashMap<String, HashMap> hashMap = new HashMap<String, HashMap>(methodDescriptorArray3.length);
        for (int i = 0; i < methodDescriptorArray3.length; ++i) {
            StandardBeanInfo.introspectGet(methodDescriptorArray3[i].getMethod(), hashMap);
            StandardBeanInfo.introspectSet(methodDescriptorArray3[i].getMethod(), hashMap);
        }
        MethodDescriptor[] methodDescriptorArray4 = this.introspectMethods(true);
        if (clazz != null && (methodDescriptorArray = this.introspectMethods(true, clazz)) != null) {
            ArrayList arrayList2 = new ArrayList();
            for (MethodDescriptor methodDescriptor : methodDescriptorArray4) {
                if (this.isInSuper(methodDescriptor, methodDescriptorArray)) continue;
                arrayList2.add(methodDescriptor);
            }
            methodDescriptorArray4 = arrayList2.toArray(new MethodDescriptor[0]);
        }
        for (int i = 0; i < methodDescriptorArray4.length; ++i) {
            this.introspectPropertyListener(methodDescriptorArray4[i].getMethod());
        }
        ArrayList<PropertyDescriptor> arrayList3 = new ArrayList<PropertyDescriptor>();
        for (String string : hashMap.keySet()) {
            HashMap hashMap2 = hashMap.get(string);
            if (hashMap2 == null) continue;
            String string2 = (String)hashMap2.get("normal");
            String string3 = (String)hashMap2.get("indexed");
            if (string2 == null && string3 == null) continue;
            Method method = (Method)hashMap2.get("normalget");
            Method method2 = (Method)hashMap2.get("normalset");
            Method method3 = (Method)hashMap2.get("indexedget");
            Method method4 = (Method)hashMap2.get("indexedset");
            PropertyDescriptor propertyDescriptor = null;
            if (string3 == null) {
                propertyDescriptor = new PropertyDescriptor(string, method, method2);
            } else {
                try {
                    propertyDescriptor = new IndexedPropertyDescriptor(string, method, method2, method3, method4);
                }
                catch (IntrospectionException introspectionException) {
                    propertyDescriptor = new IndexedPropertyDescriptor(string, null, null, method3, method4);
                }
            }
            if (this.canAddPropertyChangeListener && this.canRemovePropertyChangeListener) {
                propertyDescriptor.setBound(true);
            } else {
                propertyDescriptor.setBound(false);
            }
            if (hashMap2.get("isConstrained") == Boolean.TRUE) {
                propertyDescriptor.setConstrained(true);
            }
            arrayList3.add(propertyDescriptor);
        }
        PropertyDescriptor[] propertyDescriptorArray = new PropertyDescriptor[arrayList3.size()];
        arrayList3.toArray(propertyDescriptorArray);
        return propertyDescriptorArray;
    }

    private boolean isInSuper(MethodDescriptor methodDescriptor, MethodDescriptor[] methodDescriptorArray) {
        for (MethodDescriptor methodDescriptor2 : methodDescriptorArray) {
            if (!methodDescriptor.getMethod().equals(methodDescriptor2.getMethod())) continue;
            return true;
        }
        return false;
    }

    private void introspectPropertyListener(Method method) {
        String string = method.getName();
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 1) {
            return;
        }
        if (string.equals("addPropertyChangeListener") && classArray[0].equals(PropertyChangeListener.class)) {
            this.canAddPropertyChangeListener = true;
        }
        if (string.equals("removePropertyChangeListener") && classArray[0].equals(PropertyChangeListener.class)) {
            this.canRemovePropertyChangeListener = true;
        }
    }

    private static void introspectGet(Method method, HashMap<String, HashMap> hashMap) {
        Class clazz;
        HashMap<String, Object> hashMap2;
        String string = method.getName();
        if (string == null) {
            return;
        }
        int n = 0;
        if (string.startsWith(PREFIX_GET)) {
            n = PREFIX_GET.length();
        }
        if (string.startsWith(PREFIX_IS)) {
            n = PREFIX_IS.length();
        }
        if (n == 0) {
            return;
        }
        String string2 = Introspector.decapitalize(string.substring(n));
        if (!StandardBeanInfo.isValidProperty(string2)) {
            return;
        }
        Class<?> clazz2 = method.getReturnType();
        if (clazz2.getName().equals(Void.TYPE.getName())) {
            return;
        }
        if (n == 2 && !clazz2.getName().equals(Boolean.TYPE.getName())) {
            return;
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length > 1) {
            return;
        }
        String string3 = "normal";
        if (classArray.length == 1) {
            if (classArray[0].getName().equals(Integer.TYPE.getName())) {
                string3 = "indexed";
            } else {
                return;
            }
        }
        if ((hashMap2 = hashMap.get(string2)) == null) {
            hashMap2 = new HashMap<String, Object>();
            hashMap.put(string2, hashMap2);
        }
        if ((clazz = (Class)hashMap2.get(string3 + "PropertyType")) != null && !clazz.getName().equals(clazz2.getName())) {
            hashMap2.put(string3, "invalid");
            hashMap2.remove(string3 + PREFIX_SET);
        } else {
            hashMap2.put(string3, "valid");
        }
        hashMap2.put(string3 + "PropertyType", clazz2);
        if (n == 3) {
            if (!hashMap2.containsKey(string3 + PREFIX_GET)) {
                hashMap2.put(string3 + PREFIX_GET, method);
            }
        } else {
            hashMap2.put(string3 + PREFIX_GET, method);
        }
    }

    private static void introspectSet(Method method, HashMap<String, HashMap> hashMap) {
        Class<?>[] classArray;
        Class clazz;
        HashMap<String, Object> hashMap2;
        String string = method.getName();
        if (string == null) {
            return;
        }
        int n = 0;
        if (string.startsWith(PREFIX_SET)) {
            n = PREFIX_GET.length();
        }
        if (n == 0) {
            return;
        }
        String string2 = Introspector.decapitalize(string.substring(n));
        if (!StandardBeanInfo.isValidProperty(string2)) {
            return;
        }
        Class<?> clazz2 = method.getReturnType();
        if (!clazz2.getName().equals(Void.TYPE.getName())) {
            return;
        }
        Class<?>[] classArray2 = method.getParameterTypes();
        if (classArray2.length == 0 || classArray2.length > 2) {
            return;
        }
        String string3 = "normal";
        Class<?> clazz3 = classArray2[0];
        if (classArray2.length == 2) {
            if (classArray2[0].getName().equals(Integer.TYPE.getName())) {
                string3 = "indexed";
                clazz3 = classArray2[1];
            } else {
                return;
            }
        }
        if ((hashMap2 = hashMap.get(string2)) == null) {
            hashMap2 = new HashMap<String, Object>();
        }
        if ((clazz = (Class)hashMap2.get(string3 + "PropertyType")) != null && !clazz.getName().equals(clazz3.getName())) {
            hashMap2.put(string3, "invalid");
            return;
        }
        hashMap2.put(string3, "valid");
        hashMap2.put(string3 + PREFIX_SET, method);
        hashMap2.put(string3 + "PropertyType", clazz3);
        for (Class<?> clazz4 : classArray = method.getExceptionTypes()) {
            if (!clazz4.equals(PropertyVetoException.class)) continue;
            hashMap2.put("isConstrained", Boolean.TRUE);
        }
        hashMap.put(string2, hashMap2);
    }

    private EventSetDescriptor[] introspectEvents() throws IntrospectionException {
        EventSetDescriptor[] eventSetDescriptorArray2;
        MethodDescriptor[] methodDescriptorArray = this.introspectMethods();
        if (methodDescriptorArray == null) {
            return null;
        }
        HashMap<String, HashMap> hashMap = new HashMap<String, HashMap>(methodDescriptorArray.length);
        for (int i = 0; i < methodDescriptorArray.length; ++i) {
            StandardBeanInfo.introspectListenerMethods(PREFIX_ADD, methodDescriptorArray[i].getMethod(), hashMap);
            StandardBeanInfo.introspectListenerMethods(PREFIX_REMOVE, methodDescriptorArray[i].getMethod(), hashMap);
            StandardBeanInfo.introspectGetListenerMethods(methodDescriptorArray[i].getMethod(), hashMap);
        }
        ArrayList<EventSetDescriptor> arrayList = new ArrayList<EventSetDescriptor>();
        for (EventSetDescriptor[] eventSetDescriptorArray2 : hashMap.keySet()) {
            HashMap hashMap2 = hashMap.get(eventSetDescriptorArray2);
            Method method = (Method)hashMap2.get(PREFIX_ADD);
            Method method2 = (Method)hashMap2.get(PREFIX_REMOVE);
            if (method == null || method2 == null) continue;
            Method method3 = (Method)hashMap2.get(PREFIX_GET);
            Class clazz = (Class)hashMap2.get("listenerType");
            Method[] methodArray = (Method[])hashMap2.get("listenerMethods");
            EventSetDescriptor eventSetDescriptor = new EventSetDescriptor(Introspector.decapitalize((String)eventSetDescriptorArray2), clazz, methodArray, method, method2, method3);
            eventSetDescriptor.setUnicast(hashMap2.get("isUnicast") != null);
            arrayList.add(eventSetDescriptor);
        }
        eventSetDescriptorArray2 = new EventSetDescriptor[arrayList.size()];
        arrayList.toArray(eventSetDescriptorArray2);
        return eventSetDescriptorArray2;
    }

    private static void introspectListenerMethods(String string, Method method, HashMap<String, HashMap> hashMap) {
        Class<?>[] classArray;
        String string2 = method.getName();
        if (string2 == null) {
            return;
        }
        if (!string2.startsWith(string) || !string2.endsWith(SUFFIX_LISTEN)) {
            return;
        }
        String string3 = string2.substring(string.length());
        String string4 = string3.substring(0, string3.lastIndexOf(SUFFIX_LISTEN));
        if (string4 == null || string4.length() == 0) {
            return;
        }
        Class<?>[] classArray2 = method.getParameterTypes();
        if (classArray2 == null || classArray2.length != 1) {
            return;
        }
        Class<?> clazz = classArray2[0];
        if (!EventListener.class.isAssignableFrom(clazz)) {
            return;
        }
        if (!clazz.getName().endsWith(string3)) {
            return;
        }
        HashMap<String, Object> hashMap2 = hashMap.get(string4);
        if (hashMap2 == null) {
            hashMap2 = new HashMap<String, Object>();
        }
        if (hashMap2.get("listenerType") == null) {
            hashMap2.put("listenerType", clazz);
            hashMap2.put("listenerMethods", StandardBeanInfo.introspectListenerMethods(clazz));
        }
        hashMap2.put(string, method);
        if (string.equals(PREFIX_ADD) && (classArray = method.getExceptionTypes()) != null) {
            for (int i = 0; i < classArray.length; ++i) {
                if (!classArray[i].getName().equals(TooManyListenersException.class.getName())) continue;
                hashMap2.put("isUnicast", "true");
                break;
            }
        }
        hashMap.put(string4, hashMap2);
    }

    private static Method[] introspectListenerMethods(Class<?> clazz) {
        Method[] methodArray = clazz.getDeclaredMethods();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            Class<?>[] classArray = methodArray[i].getParameterTypes();
            if (classArray.length != 1 || !EventObject.class.isAssignableFrom(classArray[0])) continue;
            arrayList.add(methodArray[i]);
        }
        Method[] methodArray2 = new Method[arrayList.size()];
        arrayList.toArray(methodArray2);
        return methodArray2;
    }

    private static void introspectGetListenerMethods(Method method, HashMap<String, HashMap> hashMap) {
        String string = PREFIX_GET;
        String string2 = method.getName();
        if (string2 == null) {
            return;
        }
        if (!string2.startsWith(string) || !string2.endsWith("Listeners")) {
            return;
        }
        String string3 = string2.substring(string.length(), string2.length() - 1);
        String string4 = string3.substring(0, string3.lastIndexOf(SUFFIX_LISTEN));
        if (string4 == null || string4.length() == 0) {
            return;
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray == null || classArray.length != 0) {
            return;
        }
        Class<?> clazz = method.getReturnType();
        if (clazz.getComponentType() == null || !clazz.getComponentType().getName().endsWith(string3)) {
            return;
        }
        HashMap<String, Method> hashMap2 = hashMap.get(string4);
        if (hashMap2 == null) {
            hashMap2 = new HashMap<String, Method>();
        }
        hashMap2.put(string, method);
        hashMap.put(string4, hashMap2);
    }

    private static boolean isValidProperty(String string) {
        return string != null && string.length() != 0;
    }

    void init() {
        if (this.events == null) {
            this.events = new EventSetDescriptor[0];
        }
        if (this.properties == null) {
            this.properties = new PropertyDescriptor[0];
        }
        if (this.properties != null) {
            String string = this.defaultPropertyIndex != -1 ? this.properties[this.defaultPropertyIndex].getName() : null;
            Arrays.sort(this.properties, comparator);
            if (null != string) {
                for (int i = 0; i < this.properties.length; ++i) {
                    if (!string.equals(this.properties[i].getName())) continue;
                    this.defaultPropertyIndex = i;
                    break;
                }
            }
        }
    }

    private static class PropertyComparator
    implements Comparator<PropertyDescriptor> {
        private PropertyComparator() {
        }

        @Override
        public int compare(PropertyDescriptor propertyDescriptor, PropertyDescriptor propertyDescriptor2) {
            return propertyDescriptor.getName().compareTo(propertyDescriptor2.getName());
        }
    }
}

