/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyEditor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.harmony.beans.BeansUtils;
import org.apache.harmony.beans.internal.nls.Messages;

public class PropertyDescriptor
extends FeatureDescriptor {
    private Method getter;
    private Method setter;
    private Class<?> propertyEditorClass;
    boolean constrained;
    boolean bound;

    public PropertyDescriptor(String string, Class<?> clazz, String string2, String string3) throws IntrospectionException {
        if (clazz == null) {
            throw new IntrospectionException(Messages.getString("beans.03"));
        }
        if (string == null || string.length() == 0) {
            throw new IntrospectionException(Messages.getString("beans.04"));
        }
        this.setName(string);
        if (string2 != null) {
            if (string2.length() == 0) {
                throw new IntrospectionException("read or write method cannot be empty.");
            }
            try {
                this.setReadMethod(clazz, string2);
            }
            catch (IntrospectionException introspectionException) {
                this.setReadMethod(clazz, this.createDefaultMethodName(string, "get"));
            }
        }
        if (string3 != null) {
            if (string3.length() == 0) {
                throw new IntrospectionException("read or write method cannot be empty.");
            }
            this.setWriteMethod(clazz, string3);
        }
    }

    public PropertyDescriptor(String string, Method method, Method method2) throws IntrospectionException {
        if (string == null || string.length() == 0) {
            throw new IntrospectionException(Messages.getString("beans.04"));
        }
        this.setName(string);
        this.setReadMethod(method);
        this.setWriteMethod(method2);
    }

    public PropertyDescriptor(String string, Class<?> clazz) throws IntrospectionException {
        if (clazz == null) {
            throw new IntrospectionException(Messages.getString("beans.03"));
        }
        if (string == null || string.length() == 0) {
            throw new IntrospectionException(Messages.getString("beans.04"));
        }
        this.setName(string);
        try {
            this.setReadMethod(clazz, this.createDefaultMethodName(string, "is"));
        }
        catch (Exception exception) {
            this.setReadMethod(clazz, this.createDefaultMethodName(string, "get"));
        }
        this.setWriteMethod(clazz, this.createDefaultMethodName(string, "set"));
    }

    public void setWriteMethod(Method method) throws IntrospectionException {
        if (method != null) {
            int n = method.getModifiers();
            if (!Modifier.isPublic(n)) {
                throw new IntrospectionException(Messages.getString("beans.05"));
            }
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length != 1) {
                throw new IntrospectionException(Messages.getString("beans.06"));
            }
            Class<?> clazz = classArray[0];
            Class<?> clazz2 = this.getPropertyType();
            if (clazz2 != null && !clazz2.equals(clazz)) {
                throw new IntrospectionException(Messages.getString("beans.07"));
            }
        }
        this.setter = method;
    }

    public void setReadMethod(Method method) throws IntrospectionException {
        if (method != null) {
            int n = method.getModifiers();
            if (!Modifier.isPublic(n)) {
                throw new IntrospectionException(Messages.getString("beans.0A"));
            }
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length != 0) {
                throw new IntrospectionException(Messages.getString("beans.08"));
            }
            Class<?> clazz = method.getReturnType();
            if (clazz.equals(Void.TYPE)) {
                throw new IntrospectionException(Messages.getString("beans.33"));
            }
            Class<?> clazz2 = this.getPropertyType();
            if (clazz2 != null && !clazz.equals(clazz2)) {
                throw new IntrospectionException(Messages.getString("beans.09"));
            }
        }
        this.getter = method;
    }

    public Method getWriteMethod() {
        return this.setter;
    }

    public Method getReadMethod() {
        return this.getter;
    }

    public boolean equals(Object object) {
        boolean bl = object instanceof PropertyDescriptor;
        if (bl) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)object;
            boolean bl2 = this.getter == null && propertyDescriptor.getReadMethod() == null || this.getter != null && this.getter.equals(propertyDescriptor.getReadMethod());
            boolean bl3 = this.setter == null && propertyDescriptor.getWriteMethod() == null || this.setter != null && this.setter.equals(propertyDescriptor.getWriteMethod());
            boolean bl4 = this.getPropertyType() == propertyDescriptor.getPropertyType();
            boolean bl5 = this.getPropertyEditorClass() == propertyDescriptor.getPropertyEditorClass();
            boolean bl6 = this.isBound() == propertyDescriptor.isBound();
            boolean bl7 = this.isConstrained() == propertyDescriptor.isConstrained();
            bl = bl2 && bl3 && bl4 && bl5 && bl6 && bl7;
        }
        return bl;
    }

    public int hashCode() {
        return BeansUtils.getHashCode(this.getter) + BeansUtils.getHashCode(this.setter) + BeansUtils.getHashCode(this.getPropertyType()) + BeansUtils.getHashCode(this.getPropertyEditorClass()) + BeansUtils.getHashCode(this.isBound()) + BeansUtils.getHashCode(this.isConstrained());
    }

    public void setPropertyEditorClass(Class<?> clazz) {
        this.propertyEditorClass = clazz;
    }

    public Class<?> getPropertyType() {
        Class<?> clazz = null;
        if (this.getter != null) {
            clazz = this.getter.getReturnType();
        } else if (this.setter != null) {
            Class<?>[] classArray = this.setter.getParameterTypes();
            clazz = classArray[0];
        }
        return clazz;
    }

    public Class<?> getPropertyEditorClass() {
        return this.propertyEditorClass;
    }

    public void setConstrained(boolean bl) {
        this.constrained = bl;
    }

    public void setBound(boolean bl) {
        this.bound = bl;
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public boolean isBound() {
        return this.bound;
    }

    String createDefaultMethodName(String string, String string2) {
        String string3 = null;
        if (string != null) {
            String string4 = BeansUtils.toASCIIUpperCase(string.substring(0, 1));
            String string5 = string.substring(1, string.length());
            string3 = string2 + string4 + string5;
        }
        return string3;
    }

    void setReadMethod(Class<?> clazz, String string) throws IntrospectionException {
        try {
            Method method = clazz.getMethod(string, new Class[0]);
            this.setReadMethod(method);
        }
        catch (Exception exception) {
            throw new IntrospectionException(exception.getLocalizedMessage());
        }
    }

    void setWriteMethod(Class<?> clazz, String string) throws IntrospectionException {
        Method method;
        block4: {
            method = null;
            try {
                Method[] methodArray;
                if (this.getter != null) {
                    method = clazz.getMethod(string, this.getter.getReturnType());
                    break block4;
                }
                for (Method method2 : methodArray = clazz.getMethods()) {
                    if (!method2.getName().equals(string) || method2.getParameterTypes().length != 1) continue;
                    method = method2;
                    break;
                }
            }
            catch (Exception exception) {
                throw new IntrospectionException(exception.getLocalizedMessage());
            }
        }
        this.setWriteMethod(method);
    }

    public PropertyEditor createPropertyEditor(Object object) {
        PropertyEditor propertyEditor;
        if (this.propertyEditorClass == null) {
            return null;
        }
        if (!PropertyEditor.class.isAssignableFrom(this.propertyEditorClass)) {
            throw new ClassCastException(Messages.getString("beans.48"));
        }
        try {
            try {
                Constructor<?> constructor = this.propertyEditorClass.getConstructor(Object.class);
                propertyEditor = (PropertyEditor)constructor.newInstance(object);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Constructor<?> constructor = this.propertyEditorClass.getConstructor(new Class[0]);
                propertyEditor = (PropertyEditor)constructor.newInstance(new Object[0]);
            }
        }
        catch (Exception exception) {
            RuntimeException runtimeException = new RuntimeException(Messages.getString("beans.47"), exception);
            throw runtimeException;
        }
        return propertyEditor;
    }
}

