/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.StandardBeanInfo;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public class Introspector {
    public static final int IGNORE_ALL_BEANINFO = 3;
    public static final int IGNORE_IMMEDIATE_BEANINFO = 2;
    public static final int USE_ALL_BEANINFO = 1;
    private static final String DEFAULT_BEANINFO_SEARCHPATH = "sun.beans.infos";
    private static String[] searchPath = new String[]{"sun.beans.infos"};
    private static final int DEFAULT_CAPACITY = 128;
    private static Map<Class<?>, StandardBeanInfo> theCache = Collections.synchronizedMap(new WeakHashMap(128));

    private Introspector() {
    }

    public static String decapitalize(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0 || string.length() > 1 && Character.isUpperCase(string.charAt(1))) {
            return string;
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toLowerCase(cArray[0]);
        return new String(cArray);
    }

    public static void flushCaches() {
        theCache.clear();
    }

    public static void flushFromCaches(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        theCache.remove(clazz);
    }

    public static BeanInfo getBeanInfo(Class<?> clazz) throws IntrospectionException {
        StandardBeanInfo standardBeanInfo = theCache.get(clazz);
        if (standardBeanInfo == null) {
            standardBeanInfo = Introspector.getBeanInfoImplAndInit(clazz, null, 1);
            theCache.put(clazz, standardBeanInfo);
        }
        return standardBeanInfo;
    }

    public static BeanInfo getBeanInfo(Class<?> clazz, Class<?> clazz2) throws IntrospectionException {
        if (clazz2 == null) {
            return Introspector.getBeanInfo(clazz);
        }
        return Introspector.getBeanInfoImplAndInit(clazz, clazz2, 1);
    }

    public static BeanInfo getBeanInfo(Class<?> clazz, int n) throws IntrospectionException {
        if (n == 1) {
            return Introspector.getBeanInfo(clazz);
        }
        return Introspector.getBeanInfoImplAndInit(clazz, null, n);
    }

    public static String[] getBeanInfoSearchPath() {
        String[] stringArray = new String[searchPath.length];
        System.arraycopy(searchPath, 0, stringArray, 0, searchPath.length);
        return stringArray;
    }

    public static void setBeanInfoSearchPath(String[] stringArray) {
        if (System.getSecurityManager() != null) {
            System.getSecurityManager().checkPropertiesAccess();
        }
        searchPath = stringArray;
    }

    private static StandardBeanInfo getBeanInfoImpl(Class<?> clazz, Class<?> clazz2, int n) throws IntrospectionException {
        Class<?> clazz3;
        BeanInfo beanInfo = null;
        if (n == 1) {
            beanInfo = Introspector.getExplicitBeanInfo(clazz);
        }
        StandardBeanInfo standardBeanInfo = new StandardBeanInfo(clazz, beanInfo, clazz2);
        if (standardBeanInfo.additionalBeanInfo != null) {
            for (int i = standardBeanInfo.additionalBeanInfo.length - 1; i >= 0; --i) {
                BeanInfo beanInfo2 = standardBeanInfo.additionalBeanInfo[i];
                standardBeanInfo.mergeBeanInfo(beanInfo2, true);
            }
        }
        if ((clazz3 = clazz.getSuperclass()) != clazz2) {
            if (clazz3 == null) {
                throw new IntrospectionException("Stop class is not super class of bean class");
            }
            int n2 = n == 2 ? 1 : n;
            StandardBeanInfo standardBeanInfo2 = Introspector.getBeanInfoImpl(clazz3, clazz2, n2);
            if (standardBeanInfo2 != null) {
                standardBeanInfo.mergeBeanInfo(standardBeanInfo2, false);
            }
        }
        return standardBeanInfo;
    }

    private static BeanInfo getExplicitBeanInfo(Class<?> clazz) {
        BeanInfo beanInfo = null;
        String string = clazz.getName() + "BeanInfo";
        try {
            beanInfo = Introspector.loadBeanInfo(string, clazz);
            return beanInfo;
        }
        catch (Exception exception) {
            int n = string.lastIndexOf(46);
            String string2 = n >= 0 ? string.substring(n + 1) : string;
            for (int i = 0; i < searchPath.length; ++i) {
                string = searchPath[i] + "." + string2;
                try {
                    beanInfo = Introspector.loadBeanInfo(string, clazz);
                    break;
                }
                catch (Exception exception2) {
                    continue;
                }
            }
            return beanInfo;
        }
    }

    private static BeanInfo loadBeanInfo(String string, Class<?> clazz) throws Exception {
        try {
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader != null) {
                return (BeanInfo)Class.forName(string, true, clazz.getClassLoader()).newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return (BeanInfo)Class.forName(string, true, ClassLoader.getSystemClassLoader()).newInstance();
        }
        catch (Exception exception) {
            return (BeanInfo)Class.forName(string, true, Thread.currentThread().getContextClassLoader()).newInstance();
        }
    }

    private static StandardBeanInfo getBeanInfoImplAndInit(Class<?> clazz, Class<?> clazz2, int n) throws IntrospectionException {
        StandardBeanInfo standardBeanInfo = Introspector.getBeanInfoImpl(clazz, clazz2, n);
        standardBeanInfo.init();
        return standardBeanInfo;
    }
}

