/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.apache.harmony.beans.BeansUtils;
import org.apache.harmony.beans.internal.nls.Messages;

public class IndexedPropertyDescriptor
extends PropertyDescriptor {
    private Class<?> indexedPropertyType;
    private Method indexedGetter;
    private Method indexedSetter;

    public IndexedPropertyDescriptor(String string, Class<?> clazz, String string2, String string3, String string4, String string5) throws IntrospectionException {
        super(string, clazz, string2, string3);
        this.setIndexedByName(clazz, string4, string5);
    }

    private void setIndexedByName(Class<?> clazz, String string, String string2) throws IntrospectionException {
        String string3 = string;
        if (string3 == null) {
            if (string2 != null) {
                this.setIndexedWriteMethod(clazz, string2);
            }
        } else {
            if (string3.length() == 0) {
                string3 = "get" + this.name;
            }
            this.setIndexedReadMethod(clazz, string3);
            if (string2 != null) {
                this.setIndexedWriteMethod(clazz, string2, this.indexedPropertyType);
            }
        }
        if (!this.isCompatible()) {
            throw new IntrospectionException(Messages.getString("beans.57"));
        }
    }

    private boolean isCompatible() {
        Class<?> clazz = this.getPropertyType();
        if (clazz == null) {
            return true;
        }
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2 == null) {
            return false;
        }
        if (this.indexedPropertyType == null) {
            return false;
        }
        return clazz2.getName().equals(this.indexedPropertyType.getName());
    }

    public IndexedPropertyDescriptor(String string, Method method, Method method2, Method method3, Method method4) throws IntrospectionException {
        super(string, method, method2);
        if (method3 != null) {
            this.internalSetIndexedReadMethod(method3);
            this.internalSetIndexedWriteMethod(method4, true);
        } else {
            this.internalSetIndexedWriteMethod(method4, true);
            this.internalSetIndexedReadMethod(method3);
        }
        if (!this.isCompatible()) {
            throw new IntrospectionException(Messages.getString("beans.57"));
        }
    }

    public IndexedPropertyDescriptor(String string, Class<?> clazz) throws IntrospectionException {
        super(string, clazz);
        this.setIndexedByName(clazz, "get".concat(IndexedPropertyDescriptor.initialUpperCase(string)), "set".concat(IndexedPropertyDescriptor.initialUpperCase(string)));
    }

    public void setIndexedReadMethod(Method method) throws IntrospectionException {
        this.internalSetIndexedReadMethod(method);
    }

    public void setIndexedWriteMethod(Method method) throws IntrospectionException {
        this.internalSetIndexedWriteMethod(method, false);
    }

    public Method getIndexedWriteMethod() {
        return this.indexedSetter;
    }

    public Method getIndexedReadMethod() {
        return this.indexedGetter;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof IndexedPropertyDescriptor)) {
            return false;
        }
        IndexedPropertyDescriptor indexedPropertyDescriptor = (IndexedPropertyDescriptor)object;
        return super.equals(indexedPropertyDescriptor) && (this.indexedPropertyType == null ? indexedPropertyDescriptor.indexedPropertyType == null : this.indexedPropertyType.equals(indexedPropertyDescriptor.indexedPropertyType)) && (this.indexedGetter == null ? indexedPropertyDescriptor.indexedGetter == null : this.indexedGetter.equals(indexedPropertyDescriptor.indexedGetter)) && (this.indexedSetter == null ? indexedPropertyDescriptor.indexedSetter == null : this.indexedSetter.equals(indexedPropertyDescriptor.indexedSetter));
    }

    @Override
    public int hashCode() {
        return super.hashCode() + BeansUtils.getHashCode(this.indexedPropertyType) + BeansUtils.getHashCode(this.indexedGetter) + BeansUtils.getHashCode(this.indexedSetter);
    }

    public Class<?> getIndexedPropertyType() {
        return this.indexedPropertyType;
    }

    private void setIndexedReadMethod(Class<?> clazz, String string) throws IntrospectionException {
        Method method;
        try {
            method = clazz.getMethod(string, Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IntrospectionException(Messages.getString("beans.58"));
        }
        catch (SecurityException securityException) {
            throw new IntrospectionException(Messages.getString("beans.59"));
        }
        this.internalSetIndexedReadMethod(method);
    }

    private void internalSetIndexedReadMethod(Method method) throws IntrospectionException {
        if (method == null) {
            if (this.indexedSetter == null) {
                if (this.getPropertyType() != null) {
                    throw new IntrospectionException(Messages.getString("beans.5A"));
                }
                this.indexedPropertyType = null;
            }
            this.indexedGetter = null;
            return;
        }
        if (method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != Integer.TYPE) {
            throw new IntrospectionException(Messages.getString("beans.5B"));
        }
        Class<?> clazz = method.getReturnType();
        if (clazz == Void.TYPE) {
            throw new IntrospectionException(Messages.getString("beans.5B"));
        }
        if (this.indexedSetter != null && method.getReturnType() != this.indexedSetter.getParameterTypes()[1]) {
            throw new IntrospectionException(Messages.getString("beans.5A"));
        }
        if (this.indexedGetter == null) {
            this.indexedPropertyType = clazz;
        } else if (this.indexedPropertyType != clazz) {
            throw new IntrospectionException(Messages.getString("beans.5A"));
        }
        this.indexedGetter = method;
    }

    private void setIndexedWriteMethod(Class<?> clazz, String string) throws IntrospectionException {
        Method method = null;
        try {
            method = clazz.getMethod(string, Integer.TYPE, this.getPropertyType().getComponentType());
        }
        catch (SecurityException securityException) {
            throw new IntrospectionException(Messages.getString("beans.5C"));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IntrospectionException(Messages.getString("beans.5D"));
        }
        this.internalSetIndexedWriteMethod(method, true);
    }

    private void setIndexedWriteMethod(Class<?> clazz, String string, Class<?> clazz2) throws IntrospectionException {
        try {
            Method method = clazz.getMethod(string, Integer.TYPE, clazz2);
            this.internalSetIndexedWriteMethod(method, true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IntrospectionException(Messages.getString("beans.5D"));
        }
        catch (SecurityException securityException) {
            throw new IntrospectionException(Messages.getString("beans.5C"));
        }
    }

    private void internalSetIndexedWriteMethod(Method method, boolean bl) throws IntrospectionException {
        if (method == null) {
            if (this.indexedGetter == null) {
                if (this.getPropertyType() != null) {
                    throw new IntrospectionException(Messages.getString("beans.5E"));
                }
                this.indexedPropertyType = null;
            }
            this.indexedSetter = null;
            return;
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 2) {
            throw new IntrospectionException(Messages.getString("beans.5F"));
        }
        if (classArray[0] != Integer.TYPE) {
            throw new IntrospectionException(Messages.getString("beans.60"));
        }
        Class<?> clazz = classArray[1];
        if (bl && this.indexedGetter == null) {
            this.indexedPropertyType = clazz;
        } else if (this.indexedPropertyType != clazz) {
            throw new IntrospectionException(Messages.getString("beans.61"));
        }
        this.indexedSetter = method;
    }

    private static String initialUpperCase(String string) {
        if (Character.isUpperCase(string.charAt(0))) {
            return string;
        }
        String string2 = string.substring(0, 1).toUpperCase();
        return string2.concat(string.substring(1));
    }
}

