/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class FeatureDescriptor {
    private Map<String, Object> values = new HashMap<String, Object>();
    boolean preferred;
    boolean hidden;
    boolean expert;
    String shortDescription;
    String name;
    String displayName;

    public void setValue(String string, Object object) {
        if (string == null || object == null) {
            throw new NullPointerException();
        }
        this.values.put(string, object);
    }

    public Object getValue(String string) {
        Object object = null;
        if (string != null) {
            object = this.values.get(string);
        }
        return object;
    }

    public Enumeration<String> attributeNames() {
        return Collections.enumeration(new LinkedList<String>(this.values.keySet()));
    }

    public void setShortDescription(String string) {
        this.shortDescription = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String getShortDescription() {
        return this.shortDescription == null ? this.getDisplayName() : this.shortDescription;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName == null ? this.getName() : this.displayName;
    }

    public void setPreferred(boolean bl) {
        this.preferred = bl;
    }

    public void setHidden(boolean bl) {
        this.hidden = bl;
    }

    public void setExpert(boolean bl) {
        this.expert = bl;
    }

    public boolean isPreferred() {
        return this.preferred;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isExpert() {
        return this.expert;
    }

    void merge(FeatureDescriptor featureDescriptor) {
        assert (this.name.equals(featureDescriptor.name));
        this.expert |= featureDescriptor.expert;
        this.hidden |= featureDescriptor.hidden;
        this.preferred |= featureDescriptor.preferred;
        if (this.shortDescription == null) {
            this.shortDescription = featureDescriptor.shortDescription;
        }
        if (this.name == null) {
            this.name = featureDescriptor.name;
        }
        if (this.displayName == null) {
            this.displayName = featureDescriptor.displayName;
        }
    }
}

