/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.SystemColor;
import java.awt.font.TextAttribute;
import java.beans.ArrayPersistenceDelegate;
import java.beans.AwtChoicePersistenceDelegate;
import java.beans.AwtColorPersistenceDelegate;
import java.beans.AwtComponentPersistenceDelegate;
import java.beans.AwtContainerPersistenceDelegate;
import java.beans.AwtCursorPersistenceDelegate;
import java.beans.AwtDimensionPersistenceDelegate;
import java.beans.AwtFontPersistenceDelegate;
import java.beans.AwtFontTextAttributePersistenceDelegate;
import java.beans.AwtInsetsPersistenceDelegate;
import java.beans.AwtListPersistenceDelegate;
import java.beans.AwtMenuBarPersistenceDelegate;
import java.beans.AwtMenuPersistenceDelegate;
import java.beans.AwtMenuShortcutPersistenceDelegate;
import java.beans.AwtPointPersistenceDelegate;
import java.beans.AwtRectanglePersistenceDelegate;
import java.beans.AwtScrollPanePersistenceDelegate;
import java.beans.AwtSystemColorPersistenceDelegate;
import java.beans.BeanInfo;
import java.beans.ClassPersistenceDelegate;
import java.beans.DefaultPersistenceDelegate;
import java.beans.ExceptionListener;
import java.beans.Expression;
import java.beans.FieldPersistenceDelegate;
import java.beans.Introspector;
import java.beans.MethodPersistenceDelegate;
import java.beans.NullPersistenceDelegate;
import java.beans.PersistenceDelegate;
import java.beans.PrimitiveWrapperPersistenceDelegate;
import java.beans.ProxyPersistenceDelegate;
import java.beans.ReferenceMap;
import java.beans.Statement;
import java.beans.StringPersistenceDelegate;
import java.beans.SwingBoxPersistenceDelegate;
import java.beans.SwingDefaultComboBoxModelPersistenceDelegate;
import java.beans.SwingJFramePersistenceDelegate;
import java.beans.SwingJTabbedPanePersistenceDelegate;
import java.beans.SwingToolTipManagerPersistenceDelegate;
import java.beans.UtilCollectionPersistenceDelegate;
import java.beans.UtilDatePersistenceDelegate;
import java.beans.UtilListPersistenceDelegate;
import java.beans.UtilMapPersistenceDelegate;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.ToolTipManager;

public class Encoder {
    private static final Hashtable delegates = new Hashtable();
    private static final DefaultPersistenceDelegate defaultPD = new DefaultPersistenceDelegate();
    private static final ArrayPersistenceDelegate arrayPD = new ArrayPersistenceDelegate();
    private static final ProxyPersistenceDelegate proxyPD = new ProxyPersistenceDelegate();
    private static final NullPersistenceDelegate nullPD = new NullPersistenceDelegate();
    private static final ExceptionListener defaultExListener = new DefaultExceptionListener();
    private ExceptionListener listener = defaultExListener;
    private ReferenceMap oldNewMap = new ReferenceMap();

    void clear() {
        this.oldNewMap.clear();
    }

    public Object get(Object object) {
        if (object == null || object instanceof String) {
            return object;
        }
        return this.oldNewMap.get(object);
    }

    public ExceptionListener getExceptionListener() {
        return this.listener;
    }

    public PersistenceDelegate getPersistenceDelegate(Class<?> clazz) {
        if (clazz == null) {
            return nullPD;
        }
        PersistenceDelegate persistenceDelegate = (PersistenceDelegate)delegates.get(clazz);
        if (persistenceDelegate != null) {
            return persistenceDelegate;
        }
        if (java.util.List.class.isAssignableFrom(clazz)) {
            return new UtilListPersistenceDelegate();
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return new UtilCollectionPersistenceDelegate();
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return new UtilMapPersistenceDelegate();
        }
        if (clazz.isArray()) {
            return arrayPD;
        }
        if (Proxy.isProxyClass(clazz)) {
            return proxyPD;
        }
        try {
            PersistenceDelegate persistenceDelegate2;
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            if (beanInfo != null && (persistenceDelegate2 = (PersistenceDelegate)beanInfo.getBeanDescriptor().getValue("persistenceDelegate")) != null) {
                return persistenceDelegate2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultPD;
    }

    private void put(Object object, Object object2) {
        this.oldNewMap.put(object, object2);
    }

    public Object remove(Object object) {
        return this.oldNewMap.remove(object);
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        if (exceptionListener == null) {
            this.listener = defaultExListener;
            return;
        }
        this.listener = exceptionListener;
    }

    public void setPersistenceDelegate(Class<?> clazz, PersistenceDelegate persistenceDelegate) {
        if (clazz == null || persistenceDelegate == null) {
            throw new NullPointerException();
        }
        delegates.put(clazz, persistenceDelegate);
    }

    private Object forceNew(Object object) {
        if (object == null) {
            return null;
        }
        Object object2 = this.get(object);
        if (object2 != null) {
            return object2;
        }
        this.writeObject(object);
        return this.get(object);
    }

    private Object[] forceNewArray(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = this.forceNew(objectArray[i]);
        }
        return objectArray2;
    }

    public void writeExpression(Expression expression) {
        if (expression == null) {
            throw new NullPointerException();
        }
        try {
            Object object = expression.getValue();
            if (object == null || this.get(object) != null) {
                return;
            }
            Object object2 = this.forceNew(expression.getTarget());
            Object[] objectArray = this.forceNewArray(expression.getArguments());
            Expression expression2 = new Expression(object2, expression.getMethodName(), objectArray);
            Object object3 = null;
            try {
                object3 = expression2.getValue();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            this.put(object, object3);
            this.writeObject(object);
        }
        catch (Exception exception) {
            this.listener.exceptionThrown(new Exception("failed to write expression: " + expression, exception));
        }
    }

    protected void writeObject(Object object) {
        if (object == null) {
            return;
        }
        Class<?> clazz = object.getClass();
        this.getPersistenceDelegate(clazz).writeObject(object, this);
    }

    public void writeStatement(Statement statement) {
        if (statement == null) {
            throw new NullPointerException();
        }
        try {
            Object object = this.forceNew(statement.getTarget());
            Object[] objectArray = this.forceNewArray(statement.getArguments());
            Statement statement2 = new Statement(object, statement.getMethodName(), objectArray);
            statement2.execute();
        }
        catch (Exception exception) {
            this.listener.exceptionThrown(new Exception("failed to write statement: " + statement, exception));
        }
    }

    static {
        PrimitiveWrapperPersistenceDelegate primitiveWrapperPersistenceDelegate = new PrimitiveWrapperPersistenceDelegate();
        delegates.put(Boolean.class, primitiveWrapperPersistenceDelegate);
        delegates.put(Byte.class, primitiveWrapperPersistenceDelegate);
        delegates.put(Character.class, primitiveWrapperPersistenceDelegate);
        delegates.put(Double.class, primitiveWrapperPersistenceDelegate);
        delegates.put(Float.class, primitiveWrapperPersistenceDelegate);
        delegates.put(Integer.class, primitiveWrapperPersistenceDelegate);
        delegates.put(Long.class, primitiveWrapperPersistenceDelegate);
        delegates.put(Short.class, primitiveWrapperPersistenceDelegate);
        delegates.put(Class.class, new ClassPersistenceDelegate());
        delegates.put(Field.class, new FieldPersistenceDelegate());
        delegates.put(Method.class, new MethodPersistenceDelegate());
        delegates.put(String.class, new StringPersistenceDelegate());
        delegates.put(Proxy.class, new ProxyPersistenceDelegate());
        delegates.put(Choice.class, new AwtChoicePersistenceDelegate());
        delegates.put(Color.class, new AwtColorPersistenceDelegate());
        delegates.put(Container.class, new AwtContainerPersistenceDelegate());
        delegates.put(Component.class, new AwtComponentPersistenceDelegate());
        delegates.put(Cursor.class, new AwtCursorPersistenceDelegate());
        delegates.put(Dimension.class, new AwtDimensionPersistenceDelegate());
        delegates.put(Font.class, new AwtFontPersistenceDelegate());
        delegates.put(Insets.class, new AwtInsetsPersistenceDelegate());
        delegates.put(List.class, new AwtListPersistenceDelegate());
        delegates.put(Menu.class, new AwtMenuPersistenceDelegate());
        delegates.put(MenuBar.class, new AwtMenuBarPersistenceDelegate());
        delegates.put(MenuShortcut.class, new AwtMenuShortcutPersistenceDelegate());
        delegates.put(Point.class, new AwtPointPersistenceDelegate());
        delegates.put(Rectangle.class, new AwtRectanglePersistenceDelegate());
        try {
            delegates.put(SystemColor.class, new AwtSystemColorPersistenceDelegate());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        delegates.put(TextAttribute.class, new AwtFontTextAttributePersistenceDelegate());
        delegates.put(Box.class, new SwingBoxPersistenceDelegate());
        delegates.put(JFrame.class, new SwingJFramePersistenceDelegate());
        delegates.put(JTabbedPane.class, new SwingJTabbedPanePersistenceDelegate());
        delegates.put(DefaultComboBoxModel.class, new SwingDefaultComboBoxModelPersistenceDelegate());
        delegates.put(ToolTipManager.class, new SwingToolTipManagerPersistenceDelegate());
        delegates.put(ScrollPane.class, new AwtScrollPanePersistenceDelegate());
        delegates.put(Date.class, new UtilDatePersistenceDelegate());
    }

    private static class DefaultExceptionListener
    implements ExceptionListener {
        private DefaultExceptionListener() {
        }

        @Override
        public void exceptionThrown(Exception exception) {
            System.err.println("Exception during encoding:" + exception);
            System.err.println("Continue...");
        }
    }
}

