/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.Encoder;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.beans.Statement;
import java.lang.reflect.Array;

class ArrayPersistenceDelegate
extends PersistenceDelegate {
    private static PersistenceDelegate pd = null;

    ArrayPersistenceDelegate() {
    }

    public static PersistenceDelegate getInstance() {
        if (pd == null) {
            pd = new ArrayPersistenceDelegate();
        }
        return pd;
    }

    @Override
    protected Expression instantiate(Object object, Encoder encoder) {
        assert (object != null && object.getClass().isArray()) : object;
        int n = Array.getLength(object);
        Class<?> clazz = object.getClass().getComponentType();
        return new Expression(object, Array.class, "newInstance", new Object[]{clazz, new Integer(n)});
    }

    @Override
    protected void initialize(Class<?> clazz, Object object, Object object2, Encoder encoder) {
        assert (object != null && object.getClass().isArray()) : object;
        assert (object2 != null && object2.getClass().isArray()) : object2;
        int n = Array.getLength(object);
        Class<?> clazz2 = clazz.getComponentType();
        Object object3 = Array.get(Array.newInstance(clazz2, 1), 0);
        for (int i = 0; i < n; ++i) {
            Object object4 = Array.get(object, i);
            Object object5 = Array.get(object2, i);
            if ((object4 == null || object4.equals(object5)) && (object4 != null || object5 == null) || object3 != null && object3.equals(object4)) continue;
            Statement statement = new Statement(object, "set", new Object[]{new Integer(i), object4});
            encoder.writeStatement(statement);
        }
    }

    @Override
    protected boolean mutatesTo(Object object, Object object2) {
        if (null == object || null == object2) {
            return false;
        }
        if (!object.getClass().isArray() || !object2.getClass().isArray()) {
            return false;
        }
        int n = Array.getLength(object);
        int n2 = Array.getLength(object2);
        Class<?> clazz = object.getClass().getComponentType();
        Class<?> clazz2 = object2.getClass().getComponentType();
        return n == n2 && clazz.equals(clazz2);
    }
}

