/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptedData;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.Realm;
import com.ibm.security.krb5.internal.KrbApErrException;
import com.ibm.security.krb5.internal.RealmException;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;

public class Ticket
implements Cloneable {
    private int b;
    private Realm c;
    private PrincipalName d;
    private EncryptedData e;

    private Ticket() {
    }

    public Object clone() {
        Ticket ticket = new Ticket();
        ticket.c = (Realm)this.c.clone();
        ticket.d = (PrincipalName)this.d.clone();
        ticket.e = (EncryptedData)this.e.clone();
        ticket.b = this.b;
        return ticket;
    }

    public Ticket(Realm realm, PrincipalName principalName, EncryptedData encryptedData) {
        this.b = 5;
        this.c = realm;
        this.d = principalName;
        this.e = encryptedData;
    }

    public Ticket(byte[] byArray) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        this.b(new DerValue(byArray));
    }

    public Ticket(DerValue derValue) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        this.b(derValue);
    }

    private void b(DerValue derValue) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        if ((derValue.getTag() & 0x1F) != 1 || !derValue.isApplication() || !derValue.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.b = derValue3.getData().getBigInteger().intValue();
        if (this.b != 5) {
            throw new KrbApErrException(39);
        }
        this.c = Realm.parse(derValue2.getData(), (byte)1, false);
        this.d = PrincipalName.parse(derValue2.getData(), (byte)2, false);
        this.e = EncryptedData.parse(derValue2.getData(), (byte)3, false);
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.b));
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream2);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), this.c.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), this.d.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)3), this.e.asn1Encode());
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write(DerValue.createTag((byte)64, (boolean)true, (byte)1), derOutputStream2);
        return derOutputStream3.toByteArray();
    }

    public static Ticket parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException, RealmException, KrbApErrException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new Ticket(derValue2);
    }

    public int getVersionNumber() {
        return this.b;
    }

    public Realm getRealm() {
        return this.c;
    }

    public PrincipalName getServer() {
        return this.d;
    }

    public EncryptedData getEncryptedPart() {
        return this.e;
    }
}

