/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.internal.KDCReqBody;
import com.ibm.security.krb5.internal.KrbApErrException;
import com.ibm.security.krb5.internal.PAData;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;

public class KDCReq {
    private int b;
    private int c;
    private PAData[] d;
    private KDCReqBody e;

    public KDCReq(PAData[] pADataArray, KDCReqBody kDCReqBody, int n2) {
        this.b = 5;
        this.c = n2;
        this.d = pADataArray;
        this.e = kDCReqBody;
    }

    public KDCReq() {
    }

    public KDCReq(byte[] byArray, int n2) throws Asn1Exception, IOException, KrbException {
        this.b(new DerValue(byArray), n2);
    }

    public KDCReq(DerValue derValue, int n2) throws Asn1Exception, IOException, KrbException {
        this.b(derValue, n2);
    }

    protected void b(DerValue derValue, int n2) throws Asn1Exception, IOException, KrbException {
        DerValue derValue2;
        BigInteger bigInteger;
        if ((derValue.getTag() & 0x1F) != n2) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue.getData().getDerValue();
        if (derValue3.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue4 = derValue3.getData().getDerValue();
        if ((derValue4.getTag() & 0x1F) == 1) {
            bigInteger = derValue4.getData().getBigInteger();
            this.b = bigInteger.intValue();
            if (this.b != 5) {
                throw new KrbApErrException(39);
            }
        } else {
            throw new Asn1Exception(906);
        }
        derValue4 = derValue3.getData().getDerValue();
        if ((derValue4.getTag() & 0x1F) == 2) {
            bigInteger = derValue4.getData().getBigInteger();
            this.c = bigInteger.intValue();
            if (this.c != n2) {
                throw new KrbApErrException(40);
            }
        } else {
            throw new Asn1Exception(906);
        }
        if ((derValue3.getData().peekByte() & 0x1F) == 3) {
            derValue4 = derValue3.getData().getDerValue();
            derValue2 = derValue4.getData().getDerValue();
            if (derValue2.getTag() != 48) {
                throw new Asn1Exception(906);
            }
            Vector<PAData> vector = new Vector<PAData>();
            while (derValue2.getData().available() > 0) {
                vector.addElement(new PAData(derValue2.getData().getDerValue()));
            }
            if (vector.size() > 0) {
                this.d = new PAData[vector.size()];
                vector.copyInto(this.d);
            }
        } else {
            this.d = null;
        }
        derValue4 = derValue3.getData().getDerValue();
        if ((derValue4.getTag() & 0x1F) != 4) {
            throw new Asn1Exception(906);
        }
        derValue2 = derValue4.getData().getDerValue();
        this.e = new KDCReqBody(derValue2, this.c);
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream;
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.b));
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.c));
        derOutputStream3.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), derOutputStream2);
        if (this.d != null && this.d.length > 0) {
            derOutputStream2 = new DerOutputStream();
            for (int i2 = 0; i2 < this.d.length; ++i2) {
                derOutputStream2.write(this.d[i2].asn1Encode());
            }
            derOutputStream = new DerOutputStream();
            derOutputStream.write((byte)48, derOutputStream2);
            derOutputStream3.write(DerValue.createTag((byte)-128, (boolean)true, (byte)3), derOutputStream);
        }
        derOutputStream3.write(DerValue.createTag((byte)-128, (boolean)true, (byte)4), this.e.asn1Encode(this.c));
        derOutputStream = new DerOutputStream();
        derOutputStream.write((byte)48, derOutputStream3);
        derOutputStream3 = new DerOutputStream();
        derOutputStream3.write(DerValue.createTag((byte)64, (boolean)true, (byte)((byte)this.c)), derOutputStream);
        return derOutputStream3.toByteArray();
    }

    public byte[] asn1EncodeReqBody() throws Asn1Exception, IOException {
        return this.e.asn1Encode(this.c);
    }

    public PAData[] getPAData() {
        return this.d;
    }

    public KDCReqBody getRequestBody() {
        return this.e;
    }

    public int getMessageType() {
        return this.c;
    }

    public int getProtocolVersionNumber() {
        return this.b;
    }
}

