/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptedData;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.Krb5Debug;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.Realm;
import com.ibm.security.krb5.internal.EncKDCRepPart;
import com.ibm.security.krb5.internal.KrbApErrException;
import com.ibm.security.krb5.internal.PAData;
import com.ibm.security.krb5.internal.RealmException;
import com.ibm.security.krb5.internal.Ticket;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;

public class KDCRep {
    public int pvno;
    public int msgType;
    public PAData[] pAData;
    public Realm crealm;
    public PrincipalName cname;
    public Ticket ticket;
    public EncryptedData encPart;
    public EncKDCRepPart encKDCRepPart;
    private static String[] a;

    public KDCRep(PAData[] pADataArray, Realm realm, PrincipalName principalName, Ticket ticket, EncryptedData encryptedData, int n2) {
        this.pvno = 5;
        this.msgType = n2;
        this.pAData = pADataArray;
        this.crealm = realm;
        this.cname = principalName;
        this.ticket = ticket;
        this.encPart = encryptedData;
    }

    public KDCRep() {
    }

    public KDCRep(byte[] byArray, int n2) throws Asn1Exception, KrbApErrException, RealmException, IOException {
        this.b(new DerValue(byArray), n2);
    }

    public KDCRep(DerValue derValue, int n2) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        this.b(derValue, n2);
    }

    public void decrypt(EncryptionKey encryptionKey) throws Asn1Exception, IOException, KrbException, RealmException {
        this.encKDCRepPart = new EncKDCRepPart(this.encPart.decrypt(encryptionKey), this.msgType);
    }

    protected void b(DerValue derValue, int n2) throws Asn1Exception, RealmException, IOException, KrbApErrException {
        if ((derValue.getTag() & 0x1F) != n2) {
            if (Krb5Debug.on(9)) {
                Krb5Debug krb5Debug = new Krb5Debug(a[1] + Thread.currentThread().getName() + a[3]);
                krb5Debug.out(5, a[0] + derValue.getTag() + a[2] + n2);
            }
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) == 0) {
            this.pvno = derValue3.getData().getBigInteger().intValue();
            if (this.pvno != 5) {
                throw new KrbApErrException(39);
            }
        } else {
            throw new Asn1Exception(906);
        }
        derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) == 1) {
            this.msgType = derValue3.getData().getBigInteger().intValue();
            if (this.msgType != n2) {
                throw new KrbApErrException(40);
            }
        } else {
            throw new Asn1Exception(906);
        }
        if ((derValue2.getData().peekByte() & 0x1F) == 2) {
            derValue3 = derValue2.getData().getDerValue();
            DerValue[] derValueArray = derValue3.getData().getSequence(1);
            this.pAData = new PAData[derValueArray.length];
            for (int i2 = 0; i2 < derValueArray.length; ++i2) {
                this.pAData[i2] = new PAData(derValueArray[i2]);
            }
        } else {
            this.pAData = null;
        }
        this.crealm = Realm.parse(derValue2.getData(), (byte)3, false);
        this.cname = PrincipalName.parse(derValue2.getData(), (byte)4, false);
        this.ticket = Ticket.parse(derValue2.getData(), (byte)5, false);
        this.encPart = EncryptedData.parse(derValue2.getData(), (byte)6, false);
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.pvno));
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.msgType));
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream2);
        if (this.pAData != null && this.pAData.length > 0) {
            DerOutputStream derOutputStream3 = new DerOutputStream();
            for (int i2 = 0; i2 < this.pAData.length; ++i2) {
                derOutputStream3.write(this.pAData[i2].asn1Encode());
            }
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.write((byte)48, derOutputStream3);
            derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), derOutputStream2);
        }
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)3), this.crealm.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)4), this.cname.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)5), this.ticket.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)6), this.encPart.asn1Encode());
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        derOutputStream = new DerOutputStream();
        derOutputStream.write(DerValue.createTag((byte)64, (boolean)true, (byte)((byte)this.msgType)), derOutputStream2);
        return derOutputStream.toByteArray();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block87: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block86: {
                char[] cArray3;
                Object var0_2;
                block85: {
                    int n5;
                    int n6;
                    char[] cArray4;
                    int n7;
                    block84: {
                        char[] cArray5;
                        Object var2;
                        block83: {
                            int n8;
                            int n9;
                            char[] cArray6;
                            block82: {
                                char[] cArray7;
                                block81: {
                                    int n10;
                                    int n11;
                                    char[] cArray8;
                                    block80: {
                                        char[] cArray9;
                                        block79: {
                                            int n12;
                                            int n13;
                                            char[] cArray10;
                                            block78: {
                                                char[] cArray11;
                                                block77: {
                                                    int n14;
                                                    int n15;
                                                    char[] cArray12;
                                                    block76: {
                                                        char[] cArray13;
                                                        block75: {
                                                            int n16;
                                                            int n17;
                                                            char[] cArray14;
                                                            block74: {
                                                                char[] cArray15;
                                                                block73: {
                                                                    int n18;
                                                                    int n19;
                                                                    char[] cArray16;
                                                                    block72: {
                                                                        stringArray = new String[4];
                                                                        var2 = null;
                                                                        char[] cArray17 = "H\u0017u\u0011\u00152j\u0019T.L\t\"_7\u0002\u0001b\u0011;\u0018J$U7\u0018NkE?\u0011\t\"B~".toCharArray();
                                                                        n7 = 0;
                                                                        int n20 = cArray17.length;
                                                                        cArray16 = cArray17;
                                                                        n19 = n20;
                                                                        if (n20 <= 1) break block72;
                                                                        cArray15 = cArray16;
                                                                        n18 = n19;
                                                                        if (n19 <= n7) break block73;
                                                                    }
                                                                    do {
                                                                        char[] cArray18 = cArray16;
                                                                        char[] cArray19 = cArray16;
                                                                        int n21 = n7;
                                                                        while (true) {
                                                                            int n22;
                                                                            char c2 = cArray18[n21];
                                                                            switch (n7 % 5) {
                                                                                case 0: {
                                                                                    n22 = 105;
                                                                                    break;
                                                                                }
                                                                                case 1: {
                                                                                    n22 = 46;
                                                                                    break;
                                                                                }
                                                                                case 2: {
                                                                                    n22 = 12;
                                                                                    break;
                                                                                }
                                                                                case 3: {
                                                                                    n22 = 96;
                                                                                    break;
                                                                                }
                                                                                default: {
                                                                                    n22 = 56;
                                                                                }
                                                                            }
                                                                            cArray18[n21] = (char)(c2 ^ n22);
                                                                            ++n7;
                                                                            cArray16 = cArray19;
                                                                            n19 = n19;
                                                                            if (n19 != 0) break;
                                                                            cArray19 = cArray16;
                                                                            n18 = n19;
                                                                            n21 = n19;
                                                                            cArray18 = cArray16;
                                                                        }
                                                                        cArray15 = cArray16;
                                                                        n18 = n19;
                                                                    } while (n19 > n7);
                                                                }
                                                                var0_2 = null;
                                                                char[] cArray20 = new String(cArray15).intern().toCharArray();
                                                                n4 = 0;
                                                                int n23 = cArray20.length;
                                                                cArray14 = cArray20;
                                                                n17 = n23;
                                                                if (n23 <= 1) break block74;
                                                                cArray13 = cArray14;
                                                                n16 = n17;
                                                                if (n17 <= n4) break block75;
                                                            }
                                                            do {
                                                                char[] cArray21 = cArray14;
                                                                char[] cArray22 = cArray14;
                                                                int n24 = n4;
                                                                while (true) {
                                                                    int n25;
                                                                    char c3 = cArray21[n24];
                                                                    switch (n4 % 5) {
                                                                        case 0: {
                                                                            n25 = 31;
                                                                            break;
                                                                        }
                                                                        case 1: {
                                                                            n25 = 7;
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            n25 = 71;
                                                                            break;
                                                                        }
                                                                        case 3: {
                                                                            n25 = 81;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            n25 = 102;
                                                                        }
                                                                    }
                                                                    cArray21[n24] = (char)(c3 ^ n25);
                                                                    ++n4;
                                                                    cArray14 = cArray22;
                                                                    n17 = n17;
                                                                    if (n17 != 0) break;
                                                                    cArray22 = cArray14;
                                                                    n16 = n17;
                                                                    n24 = n17;
                                                                    cArray21 = cArray14;
                                                                }
                                                                cArray13 = cArray14;
                                                                n16 = n17;
                                                            } while (n17 > n4);
                                                        }
                                                        stringArray[0] = new String(cArray13).intern();
                                                        var2 = null;
                                                        char[] cArray23 = "=m\bc;\u0006\u0013".toCharArray();
                                                        n7 = 0;
                                                        int n26 = cArray23.length;
                                                        cArray12 = cArray23;
                                                        n15 = n26;
                                                        if (n26 <= 1) break block76;
                                                        cArray11 = cArray12;
                                                        n14 = n15;
                                                        if (n15 <= n7) break block77;
                                                    }
                                                    do {
                                                        char[] cArray24 = cArray12;
                                                        char[] cArray25 = cArray12;
                                                        int n27 = n7;
                                                        while (true) {
                                                            int n28;
                                                            char c4 = cArray24[n27];
                                                            switch (n7 % 5) {
                                                                case 0: {
                                                                    n28 = 105;
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    n28 = 46;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    n28 = 12;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    n28 = 96;
                                                                    break;
                                                                }
                                                                default: {
                                                                    n28 = 56;
                                                                }
                                                            }
                                                            cArray24[n27] = (char)(c4 ^ n28);
                                                            ++n7;
                                                            cArray12 = cArray25;
                                                            n15 = n15;
                                                            if (n15 != 0) break;
                                                            cArray25 = cArray12;
                                                            n14 = n15;
                                                            n27 = n15;
                                                            cArray24 = cArray12;
                                                        }
                                                        cArray11 = cArray12;
                                                        n14 = n15;
                                                    } while (n15 > n7);
                                                }
                                                var0_2 = null;
                                                char[] cArray26 = new String(cArray11).intern().toCharArray();
                                                n4 = 0;
                                                int n29 = cArray26.length;
                                                cArray10 = cArray26;
                                                n13 = n29;
                                                if (n29 <= 1) break block78;
                                                cArray9 = cArray10;
                                                n12 = n13;
                                                if (n13 <= n4) break block79;
                                            }
                                            do {
                                                char[] cArray27 = cArray10;
                                                char[] cArray28 = cArray10;
                                                int n30 = n4;
                                                while (true) {
                                                    int n31;
                                                    char c5 = cArray27[n30];
                                                    switch (n4 % 5) {
                                                        case 0: {
                                                            n31 = 31;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n31 = 7;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n31 = 71;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n31 = 81;
                                                            break;
                                                        }
                                                        default: {
                                                            n31 = 102;
                                                        }
                                                    }
                                                    cArray27[n30] = (char)(c5 ^ n31);
                                                    ++n4;
                                                    cArray10 = cArray28;
                                                    n13 = n13;
                                                    if (n13 != 0) break;
                                                    cArray28 = cArray10;
                                                    n12 = n13;
                                                    n30 = n13;
                                                    cArray27 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n12 = n13;
                                            } while (n13 > n4);
                                        }
                                        stringArray[1] = new String(cArray9).intern();
                                        var2 = null;
                                        char[] cArray29 = "V[.@~\u0002P;T~\u001fZk".toCharArray();
                                        n7 = 0;
                                        int n32 = cArray29.length;
                                        cArray8 = cArray29;
                                        n11 = n32;
                                        if (n32 <= 1) break block80;
                                        cArray7 = cArray8;
                                        n10 = n11;
                                        if (n11 <= n7) break block81;
                                    }
                                    do {
                                        char[] cArray30 = cArray8;
                                        char[] cArray31 = cArray8;
                                        int n33 = n7;
                                        while (true) {
                                            int n34;
                                            char c6 = cArray30[n33];
                                            switch (n7 % 5) {
                                                case 0: {
                                                    n34 = 105;
                                                    break;
                                                }
                                                case 1: {
                                                    n34 = 46;
                                                    break;
                                                }
                                                case 2: {
                                                    n34 = 12;
                                                    break;
                                                }
                                                case 3: {
                                                    n34 = 96;
                                                    break;
                                                }
                                                default: {
                                                    n34 = 56;
                                                }
                                            }
                                            cArray30[n33] = (char)(c6 ^ n34);
                                            ++n7;
                                            cArray8 = cArray31;
                                            n11 = n11;
                                            if (n11 != 0) break;
                                            cArray31 = cArray8;
                                            n10 = n11;
                                            n33 = n11;
                                            cArray30 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n10 = n11;
                                    } while (n11 > n7);
                                }
                                var0_2 = null;
                                char[] cArray32 = new String(cArray7).intern().toCharArray();
                                n4 = 0;
                                int n35 = cArray32.length;
                                cArray6 = cArray32;
                                n9 = n35;
                                if (n35 <= 1) break block82;
                                cArray5 = cArray6;
                                n8 = n9;
                                if (n9 <= n4) break block83;
                            }
                            do {
                                char[] cArray33 = cArray6;
                                char[] cArray34 = cArray6;
                                int n36 = n4;
                                while (true) {
                                    int n37;
                                    char c7 = cArray33[n36];
                                    switch (n4 % 5) {
                                        case 0: {
                                            n37 = 31;
                                            break;
                                        }
                                        case 1: {
                                            n37 = 7;
                                            break;
                                        }
                                        case 2: {
                                            n37 = 71;
                                            break;
                                        }
                                        case 3: {
                                            n37 = 81;
                                            break;
                                        }
                                        default: {
                                            n37 = 102;
                                        }
                                    }
                                    cArray33[n36] = (char)(c7 ^ n37);
                                    ++n4;
                                    cArray6 = cArray34;
                                    n9 = n9;
                                    if (n9 != 0) break;
                                    cArray34 = cArray6;
                                    n8 = n9;
                                    n36 = n9;
                                    cArray33 = cArray6;
                                }
                                cArray5 = cArray6;
                                n8 = n9;
                            } while (n9 > n4);
                        }
                        stringArray[2] = new String(cArray5).intern();
                        var2 = null;
                        char[] cArray35 = "L\t".toCharArray();
                        n7 = 0;
                        int n38 = cArray35.length;
                        cArray4 = cArray35;
                        n6 = n38;
                        if (n38 <= 1) break block84;
                        cArray3 = cArray4;
                        n5 = n6;
                        if (n6 <= n7) break block85;
                    }
                    do {
                        char[] cArray36 = cArray4;
                        char[] cArray37 = cArray4;
                        int n39 = n7;
                        while (true) {
                            int n40;
                            char c8 = cArray36[n39];
                            switch (n7 % 5) {
                                case 0: {
                                    n40 = 105;
                                    break;
                                }
                                case 1: {
                                    n40 = 46;
                                    break;
                                }
                                case 2: {
                                    n40 = 12;
                                    break;
                                }
                                case 3: {
                                    n40 = 96;
                                    break;
                                }
                                default: {
                                    n40 = 56;
                                }
                            }
                            cArray36[n39] = (char)(c8 ^ n40);
                            ++n7;
                            cArray4 = cArray37;
                            n6 = n6;
                            if (n6 != 0) break;
                            cArray37 = cArray4;
                            n5 = n6;
                            n39 = n6;
                            cArray36 = cArray4;
                        }
                        cArray3 = cArray4;
                        n5 = n6;
                    } while (n6 > n7);
                }
                var0_2 = null;
                char[] cArray38 = new String(cArray3).intern().toCharArray();
                n4 = 0;
                int n41 = cArray38.length;
                cArray2 = cArray38;
                n3 = n41;
                if (n41 <= 1) break block86;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block87;
            }
            do {
                char[] cArray39 = cArray2;
                char[] cArray40 = cArray2;
                int n42 = n4;
                while (true) {
                    int n43;
                    char c9 = cArray39[n42];
                    switch (n4 % 5) {
                        case 0: {
                            n43 = 31;
                            break;
                        }
                        case 1: {
                            n43 = 7;
                            break;
                        }
                        case 2: {
                            n43 = 71;
                            break;
                        }
                        case 3: {
                            n43 = 81;
                            break;
                        }
                        default: {
                            n43 = 102;
                        }
                    }
                    cArray39[n42] = (char)(c9 ^ n43);
                    ++n4;
                    cArray2 = cArray40;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray40 = cArray2;
                    n2 = n3;
                    n42 = n3;
                    cArray39 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        stringArray[3] = new String(cArray).intern();
        a = stringArray;
    }
}

