/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.Krb5Debug;
import com.ibm.security.krb5.internal.KrbApErrException;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class HostAddress
implements Cloneable {
    public int addrType;
    public byte[] address;
    private static byte[] b;
    private static String[] c;

    private HostAddress(int n2) {
    }

    public Object clone() {
        HostAddress hostAddress = new HostAddress(0);
        hostAddress.addrType = this.addrType;
        if (this.address != null) {
            hostAddress.address = new byte[this.address.length];
            System.arraycopy(this.address, 0, hostAddress.address, 0, this.address.length);
        }
        return hostAddress;
    }

    public boolean equals(HostAddress hostAddress) {
        if (this.addrType != hostAddress.addrType || this.address != null && hostAddress.address == null || this.address == null && hostAddress.address != null) {
            return false;
        }
        if (this.address != null && hostAddress.address != null) {
            if (this.address.length != hostAddress.address.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.address.length; ++i2) {
                if (this.address[i2] == hostAddress.address[i2]) continue;
                return false;
            }
        }
        return true;
    }

    public static void refreshLocalInetAddress() throws UnknownHostException {
        b = InetAddress.getLocalHost().getAddress();
    }

    public static byte[] getLocalInetAddress() throws UnknownHostException {
        if (b == null) {
            HostAddress.refreshLocalInetAddress();
        }
        if (b == null) {
            throw new UnknownHostException();
        }
        byte[] byArray = new byte[b.length];
        System.arraycopy(b, 0, byArray, 0, b.length);
        return byArray;
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        if (this.addrType == 2 || this.addrType == 23) {
            return InetAddress.getByAddress(this.address);
        }
        return null;
    }

    private int b(InetAddress inetAddress) {
        int n2 = 0;
        if (inetAddress instanceof Inet4Address) {
            n2 = 2;
        } else if (inetAddress instanceof Inet6Address) {
            n2 = 23;
        }
        return n2;
    }

    public HostAddress() throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByAddress(HostAddress.getLocalInetAddress());
        this.addrType = this.b(inetAddress);
        this.address = inetAddress.getAddress();
    }

    public HostAddress(int n2, byte[] byArray) throws KrbApErrException {
        switch (n2) {
            case 2: {
                if (byArray.length == 4) break;
                throw new KrbApErrException(0, c[3]);
            }
            case 5: {
                if (byArray.length == 2) break;
                throw new KrbApErrException(0, c[8]);
            }
            case 7: {
                break;
            }
            case 6: {
                if (byArray.length == 6) break;
                throw new KrbApErrException(0, c[4]);
            }
            case 16: {
                if (byArray.length == 3) break;
                throw new KrbApErrException(0, c[0]);
            }
            case 12: {
                if (byArray.length == 2) break;
                throw new KrbApErrException(0, c[5]);
            }
            case 24: {
                if (byArray.length == 16) break;
                throw new KrbApErrException(0, c[1]);
            }
        }
        this.addrType = n2;
        this.address = byArray;
        if (Krb5Debug.on(5) && this.addrType == 2) {
            Krb5Debug krb5Debug = new Krb5Debug(c[6] + Thread.currentThread().getName() + c[2]);
            krb5Debug.out(5, c[7] + (this.address[0] & 0xFF) + "." + (this.address[1] & 0xFF) + "." + (this.address[2] & 0xFF) + "." + (this.address[3] & 0xFF));
        }
    }

    public HostAddress(InetAddress inetAddress) {
        this.addrType = this.b(inetAddress);
        byte[] byArray = inetAddress.getAddress();
        this.address = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.address, 0, byArray.length);
    }

    public HostAddress(DerValue derValue) throws Asn1Exception, IOException {
        DerValue derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.addrType = derValue2.getData().getBigInteger().intValue();
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.address = derValue2.getData().getOctetString();
        if (derValue.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.addrType);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOctetString(this.address);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public static HostAddress parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new HostAddress(derValue2);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block197: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block196: {
                char[] cArray3;
                Object var0_2;
                block195: {
                    int n5;
                    int n6;
                    char[] cArray4;
                    int n7;
                    block194: {
                        char[] cArray5;
                        Object var2;
                        block193: {
                            int n8;
                            int n9;
                            char[] cArray6;
                            block192: {
                                char[] cArray7;
                                block191: {
                                    int n10;
                                    int n11;
                                    char[] cArray8;
                                    block190: {
                                        char[] cArray9;
                                        block189: {
                                            int n12;
                                            int n13;
                                            char[] cArray10;
                                            block188: {
                                                char[] cArray11;
                                                block187: {
                                                    int n14;
                                                    int n15;
                                                    char[] cArray12;
                                                    block186: {
                                                        char[] cArray13;
                                                        block185: {
                                                            int n16;
                                                            int n17;
                                                            char[] cArray14;
                                                            block184: {
                                                                char[] cArray15;
                                                                block183: {
                                                                    int n18;
                                                                    int n19;
                                                                    char[] cArray16;
                                                                    block182: {
                                                                        char[] cArray17;
                                                                        block181: {
                                                                            int n20;
                                                                            int n21;
                                                                            char[] cArray18;
                                                                            block180: {
                                                                                char[] cArray19;
                                                                                block179: {
                                                                                    int n22;
                                                                                    int n23;
                                                                                    char[] cArray20;
                                                                                    block178: {
                                                                                        char[] cArray21;
                                                                                        block177: {
                                                                                            int n24;
                                                                                            int n25;
                                                                                            char[] cArray22;
                                                                                            block176: {
                                                                                                char[] cArray23;
                                                                                                block175: {
                                                                                                    int n26;
                                                                                                    int n27;
                                                                                                    char[] cArray24;
                                                                                                    block174: {
                                                                                                        char[] cArray25;
                                                                                                        block173: {
                                                                                                            int n28;
                                                                                                            int n29;
                                                                                                            char[] cArray26;
                                                                                                            block172: {
                                                                                                                char[] cArray27;
                                                                                                                block171: {
                                                                                                                    int n30;
                                                                                                                    int n31;
                                                                                                                    char[] cArray28;
                                                                                                                    block170: {
                                                                                                                        char[] cArray29;
                                                                                                                        block169: {
                                                                                                                            int n32;
                                                                                                                            int n33;
                                                                                                                            char[] cArray30;
                                                                                                                            block168: {
                                                                                                                                char[] cArray31;
                                                                                                                                block167: {
                                                                                                                                    int n34;
                                                                                                                                    int n35;
                                                                                                                                    char[] cArray32;
                                                                                                                                    block166: {
                                                                                                                                        char[] cArray33;
                                                                                                                                        block165: {
                                                                                                                                            int n36;
                                                                                                                                            int n37;
                                                                                                                                            char[] cArray34;
                                                                                                                                            block164: {
                                                                                                                                                char[] cArray35;
                                                                                                                                                block163: {
                                                                                                                                                    int n38;
                                                                                                                                                    int n39;
                                                                                                                                                    char[] cArray36;
                                                                                                                                                    block162: {
                                                                                                                                                        stringArray = new String[9];
                                                                                                                                                        var2 = null;
                                                                                                                                                        char[] cArray37 = "R[\f}|@{\f]JuI\u001b".toCharArray();
                                                                                                                                                        n7 = 0;
                                                                                                                                                        int n40 = cArray37.length;
                                                                                                                                                        cArray36 = cArray37;
                                                                                                                                                        n39 = n40;
                                                                                                                                                        if (n40 <= 1) break block162;
                                                                                                                                                        cArray35 = cArray36;
                                                                                                                                                        n38 = n39;
                                                                                                                                                        if (n39 <= n7) break block163;
                                                                                                                                                    }
                                                                                                                                                    do {
                                                                                                                                                        char[] cArray38 = cArray36;
                                                                                                                                                        char[] cArray39 = cArray36;
                                                                                                                                                        int n41 = n7;
                                                                                                                                                        while (true) {
                                                                                                                                                            int n42;
                                                                                                                                                            char c2 = cArray38[n41];
                                                                                                                                                            switch (n7 % 5) {
                                                                                                                                                                case 0: {
                                                                                                                                                                    n42 = 34;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                case 1: {
                                                                                                                                                                    n42 = 52;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                case 2: {
                                                                                                                                                                    n42 = 21;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                case 3: {
                                                                                                                                                                    n42 = 7;
                                                                                                                                                                    break;
                                                                                                                                                                }
                                                                                                                                                                default: {
                                                                                                                                                                    n42 = 63;
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                            cArray38[n41] = (char)(c2 ^ n42);
                                                                                                                                                            ++n7;
                                                                                                                                                            cArray36 = cArray39;
                                                                                                                                                            n39 = n39;
                                                                                                                                                            if (n39 != 0) break;
                                                                                                                                                            cArray39 = cArray36;
                                                                                                                                                            n38 = n39;
                                                                                                                                                            n41 = n39;
                                                                                                                                                            cArray38 = cArray36;
                                                                                                                                                        }
                                                                                                                                                        cArray35 = cArray36;
                                                                                                                                                        n38 = n39;
                                                                                                                                                    } while (n39 > n7);
                                                                                                                                                }
                                                                                                                                                var0_2 = null;
                                                                                                                                                char[] cArray40 = new String(cArray35).intern().toCharArray();
                                                                                                                                                n4 = 0;
                                                                                                                                                int n43 = cArray40.length;
                                                                                                                                                cArray34 = cArray40;
                                                                                                                                                n37 = n43;
                                                                                                                                                if (n43 <= 1) break block164;
                                                                                                                                                cArray33 = cArray34;
                                                                                                                                                n36 = n37;
                                                                                                                                                if (n37 <= n4) break block165;
                                                                                                                                            }
                                                                                                                                            do {
                                                                                                                                                char[] cArray41 = cArray34;
                                                                                                                                                char[] cArray42 = cArray34;
                                                                                                                                                int n44 = n4;
                                                                                                                                                while (true) {
                                                                                                                                                    int n45;
                                                                                                                                                    char c3 = cArray41[n44];
                                                                                                                                                    switch (n4 % 5) {
                                                                                                                                                        case 0: {
                                                                                                                                                            n45 = 50;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 1: {
                                                                                                                                                            n45 = 14;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 2: {
                                                                                                                                                            n45 = 125;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        case 3: {
                                                                                                                                                            n45 = 62;
                                                                                                                                                            break;
                                                                                                                                                        }
                                                                                                                                                        default: {
                                                                                                                                                            n45 = 7;
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                    cArray41[n44] = (char)(c3 ^ n45);
                                                                                                                                                    ++n4;
                                                                                                                                                    cArray34 = cArray42;
                                                                                                                                                    n37 = n37;
                                                                                                                                                    if (n37 != 0) break;
                                                                                                                                                    cArray42 = cArray34;
                                                                                                                                                    n36 = n37;
                                                                                                                                                    n44 = n37;
                                                                                                                                                    cArray41 = cArray34;
                                                                                                                                                }
                                                                                                                                                cArray33 = cArray34;
                                                                                                                                                n36 = n37;
                                                                                                                                            } while (n37 > n4);
                                                                                                                                        }
                                                                                                                                        stringArray[0] = new String(cArray33).intern();
                                                                                                                                        var2 = null;
                                                                                                                                        char[] cArray43 = "R[\fphf\f!W]d{\f]JuI\u001b".toCharArray();
                                                                                                                                        n7 = 0;
                                                                                                                                        int n46 = cArray43.length;
                                                                                                                                        cArray32 = cArray43;
                                                                                                                                        n35 = n46;
                                                                                                                                        if (n46 <= 1) break block166;
                                                                                                                                        cArray31 = cArray32;
                                                                                                                                        n34 = n35;
                                                                                                                                        if (n35 <= n7) break block167;
                                                                                                                                    }
                                                                                                                                    do {
                                                                                                                                        char[] cArray44 = cArray32;
                                                                                                                                        char[] cArray45 = cArray32;
                                                                                                                                        int n47 = n7;
                                                                                                                                        while (true) {
                                                                                                                                            int n48;
                                                                                                                                            char c4 = cArray44[n47];
                                                                                                                                            switch (n7 % 5) {
                                                                                                                                                case 0: {
                                                                                                                                                    n48 = 34;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 1: {
                                                                                                                                                    n48 = 52;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 2: {
                                                                                                                                                    n48 = 21;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 3: {
                                                                                                                                                    n48 = 7;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                default: {
                                                                                                                                                    n48 = 63;
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                            cArray44[n47] = (char)(c4 ^ n48);
                                                                                                                                            ++n7;
                                                                                                                                            cArray32 = cArray45;
                                                                                                                                            n35 = n35;
                                                                                                                                            if (n35 != 0) break;
                                                                                                                                            cArray45 = cArray32;
                                                                                                                                            n34 = n35;
                                                                                                                                            n47 = n35;
                                                                                                                                            cArray44 = cArray32;
                                                                                                                                        }
                                                                                                                                        cArray31 = cArray32;
                                                                                                                                        n34 = n35;
                                                                                                                                    } while (n35 > n7);
                                                                                                                                }
                                                                                                                                var0_2 = null;
                                                                                                                                char[] cArray46 = new String(cArray31).intern().toCharArray();
                                                                                                                                n4 = 0;
                                                                                                                                int n49 = cArray46.length;
                                                                                                                                cArray30 = cArray46;
                                                                                                                                n33 = n49;
                                                                                                                                if (n49 <= 1) break block168;
                                                                                                                                cArray29 = cArray30;
                                                                                                                                n32 = n33;
                                                                                                                                if (n33 <= n4) break block169;
                                                                                                                            }
                                                                                                                            do {
                                                                                                                                char[] cArray47 = cArray30;
                                                                                                                                char[] cArray48 = cArray30;
                                                                                                                                int n50 = n4;
                                                                                                                                while (true) {
                                                                                                                                    int n51;
                                                                                                                                    char c5 = cArray47[n50];
                                                                                                                                    switch (n4 % 5) {
                                                                                                                                        case 0: {
                                                                                                                                            n51 = 50;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 1: {
                                                                                                                                            n51 = 14;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 2: {
                                                                                                                                            n51 = 125;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 3: {
                                                                                                                                            n51 = 62;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        default: {
                                                                                                                                            n51 = 7;
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    cArray47[n50] = (char)(c5 ^ n51);
                                                                                                                                    ++n4;
                                                                                                                                    cArray30 = cArray48;
                                                                                                                                    n33 = n33;
                                                                                                                                    if (n33 != 0) break;
                                                                                                                                    cArray48 = cArray30;
                                                                                                                                    n32 = n33;
                                                                                                                                    n50 = n33;
                                                                                                                                    cArray47 = cArray30;
                                                                                                                                }
                                                                                                                                cArray29 = cArray30;
                                                                                                                                n32 = n33;
                                                                                                                            } while (n33 > n4);
                                                                                                                        }
                                                                                                                        stringArray[1] = new String(cArray29).intern();
                                                                                                                        var2 = null;
                                                                                                                        char[] cArray49 = "*\u001a".toCharArray();
                                                                                                                        n7 = 0;
                                                                                                                        int n52 = cArray49.length;
                                                                                                                        cArray28 = cArray49;
                                                                                                                        n31 = n52;
                                                                                                                        if (n52 <= 1) break block170;
                                                                                                                        cArray27 = cArray28;
                                                                                                                        n30 = n31;
                                                                                                                        if (n31 <= n7) break block171;
                                                                                                                    }
                                                                                                                    do {
                                                                                                                        char[] cArray50 = cArray28;
                                                                                                                        char[] cArray51 = cArray28;
                                                                                                                        int n53 = n7;
                                                                                                                        while (true) {
                                                                                                                            int n54;
                                                                                                                            char c6 = cArray50[n53];
                                                                                                                            switch (n7 % 5) {
                                                                                                                                case 0: {
                                                                                                                                    n54 = 34;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 1: {
                                                                                                                                    n54 = 52;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 2: {
                                                                                                                                    n54 = 21;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 3: {
                                                                                                                                    n54 = 7;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                default: {
                                                                                                                                    n54 = 63;
                                                                                                                                }
                                                                                                                            }
                                                                                                                            cArray50[n53] = (char)(c6 ^ n54);
                                                                                                                            ++n7;
                                                                                                                            cArray28 = cArray51;
                                                                                                                            n31 = n31;
                                                                                                                            if (n31 != 0) break;
                                                                                                                            cArray51 = cArray28;
                                                                                                                            n30 = n31;
                                                                                                                            n53 = n31;
                                                                                                                            cArray50 = cArray28;
                                                                                                                        }
                                                                                                                        cArray27 = cArray28;
                                                                                                                        n30 = n31;
                                                                                                                    } while (n31 > n7);
                                                                                                                }
                                                                                                                var0_2 = null;
                                                                                                                char[] cArray52 = new String(cArray27).intern().toCharArray();
                                                                                                                n4 = 0;
                                                                                                                int n55 = cArray52.length;
                                                                                                                cArray26 = cArray52;
                                                                                                                n29 = n55;
                                                                                                                if (n55 <= 1) break block172;
                                                                                                                cArray25 = cArray26;
                                                                                                                n28 = n29;
                                                                                                                if (n29 <= n4) break block173;
                                                                                                            }
                                                                                                            do {
                                                                                                                char[] cArray53 = cArray26;
                                                                                                                char[] cArray54 = cArray26;
                                                                                                                int n56 = n4;
                                                                                                                while (true) {
                                                                                                                    int n57;
                                                                                                                    char c7 = cArray53[n56];
                                                                                                                    switch (n4 % 5) {
                                                                                                                        case 0: {
                                                                                                                            n57 = 50;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 1: {
                                                                                                                            n57 = 14;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 2: {
                                                                                                                            n57 = 125;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 3: {
                                                                                                                            n57 = 62;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        default: {
                                                                                                                            n57 = 7;
                                                                                                                        }
                                                                                                                    }
                                                                                                                    cArray53[n56] = (char)(c7 ^ n57);
                                                                                                                    ++n4;
                                                                                                                    cArray26 = cArray54;
                                                                                                                    n29 = n29;
                                                                                                                    if (n29 != 0) break;
                                                                                                                    cArray54 = cArray26;
                                                                                                                    n28 = n29;
                                                                                                                    n56 = n29;
                                                                                                                    cArray53 = cArray26;
                                                                                                                }
                                                                                                                cArray25 = cArray26;
                                                                                                                n28 = n29;
                                                                                                            } while (n29 > n4);
                                                                                                        }
                                                                                                        stringArray[2] = new String(cArray25).intern();
                                                                                                        var2 = null;
                                                                                                        char[] cArray55 = "R[\fpVuN)]\\b_\u001bJ".toCharArray();
                                                                                                        n7 = 0;
                                                                                                        int n58 = cArray55.length;
                                                                                                        cArray24 = cArray55;
                                                                                                        n27 = n58;
                                                                                                        if (n58 <= 1) break block174;
                                                                                                        cArray23 = cArray24;
                                                                                                        n26 = n27;
                                                                                                        if (n27 <= n7) break block175;
                                                                                                    }
                                                                                                    do {
                                                                                                        char[] cArray56 = cArray24;
                                                                                                        char[] cArray57 = cArray24;
                                                                                                        int n59 = n7;
                                                                                                        while (true) {
                                                                                                            int n60;
                                                                                                            char c8 = cArray56[n59];
                                                                                                            switch (n7 % 5) {
                                                                                                                case 0: {
                                                                                                                    n60 = 34;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 1: {
                                                                                                                    n60 = 52;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 2: {
                                                                                                                    n60 = 21;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 3: {
                                                                                                                    n60 = 7;
                                                                                                                    break;
                                                                                                                }
                                                                                                                default: {
                                                                                                                    n60 = 63;
                                                                                                                }
                                                                                                            }
                                                                                                            cArray56[n59] = (char)(c8 ^ n60);
                                                                                                            ++n7;
                                                                                                            cArray24 = cArray57;
                                                                                                            n27 = n27;
                                                                                                            if (n27 != 0) break;
                                                                                                            cArray57 = cArray24;
                                                                                                            n26 = n27;
                                                                                                            n59 = n27;
                                                                                                            cArray56 = cArray24;
                                                                                                        }
                                                                                                        cArray23 = cArray24;
                                                                                                        n26 = n27;
                                                                                                    } while (n27 > n7);
                                                                                                }
                                                                                                var0_2 = null;
                                                                                                char[] cArray58 = new String(cArray23).intern().toCharArray();
                                                                                                n4 = 0;
                                                                                                int n61 = cArray58.length;
                                                                                                cArray22 = cArray58;
                                                                                                n25 = n61;
                                                                                                if (n61 <= 1) break block176;
                                                                                                cArray21 = cArray22;
                                                                                                n24 = n25;
                                                                                                if (n25 <= n4) break block177;
                                                                                            }
                                                                                            do {
                                                                                                char[] cArray59 = cArray22;
                                                                                                char[] cArray60 = cArray22;
                                                                                                int n62 = n4;
                                                                                                while (true) {
                                                                                                    int n63;
                                                                                                    char c9 = cArray59[n62];
                                                                                                    switch (n4 % 5) {
                                                                                                        case 0: {
                                                                                                            n63 = 50;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 1: {
                                                                                                            n63 = 14;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 2: {
                                                                                                            n63 = 125;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 3: {
                                                                                                            n63 = 62;
                                                                                                            break;
                                                                                                        }
                                                                                                        default: {
                                                                                                            n63 = 7;
                                                                                                        }
                                                                                                    }
                                                                                                    cArray59[n62] = (char)(c9 ^ n63);
                                                                                                    ++n4;
                                                                                                    cArray22 = cArray60;
                                                                                                    n25 = n25;
                                                                                                    if (n25 != 0) break;
                                                                                                    cArray60 = cArray22;
                                                                                                    n24 = n25;
                                                                                                    n62 = n25;
                                                                                                    cArray59 = cArray22;
                                                                                                }
                                                                                                cArray21 = cArray22;
                                                                                                n24 = n25;
                                                                                            } while (n25 > n4);
                                                                                        }
                                                                                        stringArray[3] = new String(cArray21).intern();
                                                                                        var2 = null;
                                                                                        char[] cArray61 = "R[\favC{\f]JuI\u001b".toCharArray();
                                                                                        n7 = 0;
                                                                                        int n64 = cArray61.length;
                                                                                        cArray20 = cArray61;
                                                                                        n23 = n64;
                                                                                        if (n64 <= 1) break block178;
                                                                                        cArray19 = cArray20;
                                                                                        n22 = n23;
                                                                                        if (n23 <= n7) break block179;
                                                                                    }
                                                                                    do {
                                                                                        char[] cArray62 = cArray20;
                                                                                        char[] cArray63 = cArray20;
                                                                                        int n65 = n7;
                                                                                        while (true) {
                                                                                            int n66;
                                                                                            char c10 = cArray62[n65];
                                                                                            switch (n7 % 5) {
                                                                                                case 0: {
                                                                                                    n66 = 34;
                                                                                                    break;
                                                                                                }
                                                                                                case 1: {
                                                                                                    n66 = 52;
                                                                                                    break;
                                                                                                }
                                                                                                case 2: {
                                                                                                    n66 = 21;
                                                                                                    break;
                                                                                                }
                                                                                                case 3: {
                                                                                                    n66 = 7;
                                                                                                    break;
                                                                                                }
                                                                                                default: {
                                                                                                    n66 = 63;
                                                                                                }
                                                                                            }
                                                                                            cArray62[n65] = (char)(c10 ^ n66);
                                                                                            ++n7;
                                                                                            cArray20 = cArray63;
                                                                                            n23 = n23;
                                                                                            if (n23 != 0) break;
                                                                                            cArray63 = cArray20;
                                                                                            n22 = n23;
                                                                                            n65 = n23;
                                                                                            cArray62 = cArray20;
                                                                                        }
                                                                                        cArray19 = cArray20;
                                                                                        n22 = n23;
                                                                                    } while (n23 > n7);
                                                                                }
                                                                                var0_2 = null;
                                                                                char[] cArray64 = new String(cArray19).intern().toCharArray();
                                                                                n4 = 0;
                                                                                int n67 = cArray64.length;
                                                                                cArray18 = cArray64;
                                                                                n21 = n67;
                                                                                if (n67 <= 1) break block180;
                                                                                cArray17 = cArray18;
                                                                                n20 = n21;
                                                                                if (n21 <= n4) break block181;
                                                                            }
                                                                            do {
                                                                                char[] cArray65 = cArray18;
                                                                                char[] cArray66 = cArray18;
                                                                                int n68 = n4;
                                                                                while (true) {
                                                                                    int n69;
                                                                                    char c11 = cArray65[n68];
                                                                                    switch (n4 % 5) {
                                                                                        case 0: {
                                                                                            n69 = 50;
                                                                                            break;
                                                                                        }
                                                                                        case 1: {
                                                                                            n69 = 14;
                                                                                            break;
                                                                                        }
                                                                                        case 2: {
                                                                                            n69 = 125;
                                                                                            break;
                                                                                        }
                                                                                        case 3: {
                                                                                            n69 = 62;
                                                                                            break;
                                                                                        }
                                                                                        default: {
                                                                                            n69 = 7;
                                                                                        }
                                                                                    }
                                                                                    cArray65[n68] = (char)(c11 ^ n69);
                                                                                    ++n4;
                                                                                    cArray18 = cArray66;
                                                                                    n21 = n21;
                                                                                    if (n21 != 0) break;
                                                                                    cArray66 = cArray18;
                                                                                    n20 = n21;
                                                                                    n68 = n21;
                                                                                    cArray65 = cArray18;
                                                                                }
                                                                                cArray17 = cArray18;
                                                                                n20 = n21;
                                                                            } while (n21 > n4);
                                                                        }
                                                                        stringArray[4] = new String(cArray17).intern();
                                                                        var2 = null;
                                                                        char[] cArray67 = "R[\f}}St\rMyt^\u001a\\Kc".toCharArray();
                                                                        n7 = 0;
                                                                        int n70 = cArray67.length;
                                                                        cArray16 = cArray67;
                                                                        n19 = n70;
                                                                        if (n70 <= 1) break block182;
                                                                        cArray15 = cArray16;
                                                                        n18 = n19;
                                                                        if (n19 <= n7) break block183;
                                                                    }
                                                                    do {
                                                                        char[] cArray68 = cArray16;
                                                                        char[] cArray69 = cArray16;
                                                                        int n71 = n7;
                                                                        while (true) {
                                                                            int n72;
                                                                            char c12 = cArray68[n71];
                                                                            switch (n7 % 5) {
                                                                                case 0: {
                                                                                    n72 = 34;
                                                                                    break;
                                                                                }
                                                                                case 1: {
                                                                                    n72 = 52;
                                                                                    break;
                                                                                }
                                                                                case 2: {
                                                                                    n72 = 21;
                                                                                    break;
                                                                                }
                                                                                case 3: {
                                                                                    n72 = 7;
                                                                                    break;
                                                                                }
                                                                                default: {
                                                                                    n72 = 63;
                                                                                }
                                                                            }
                                                                            cArray68[n71] = (char)(c12 ^ n72);
                                                                            ++n7;
                                                                            cArray16 = cArray69;
                                                                            n19 = n19;
                                                                            if (n19 != 0) break;
                                                                            cArray69 = cArray16;
                                                                            n18 = n19;
                                                                            n71 = n19;
                                                                            cArray68 = cArray16;
                                                                        }
                                                                        cArray15 = cArray16;
                                                                        n18 = n19;
                                                                    } while (n19 > n7);
                                                                }
                                                                var0_2 = null;
                                                                char[] cArray70 = new String(cArray15).intern().toCharArray();
                                                                n4 = 0;
                                                                int n73 = cArray70.length;
                                                                cArray14 = cArray70;
                                                                n17 = n73;
                                                                if (n73 <= 1) break block184;
                                                                cArray13 = cArray14;
                                                                n16 = n17;
                                                                if (n17 <= n4) break block185;
                                                            }
                                                            do {
                                                                char[] cArray71 = cArray14;
                                                                char[] cArray72 = cArray14;
                                                                int n74 = n4;
                                                                while (true) {
                                                                    int n75;
                                                                    char c13 = cArray71[n74];
                                                                    switch (n4 % 5) {
                                                                        case 0: {
                                                                            n75 = 50;
                                                                            break;
                                                                        }
                                                                        case 1: {
                                                                            n75 = 14;
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            n75 = 125;
                                                                            break;
                                                                        }
                                                                        case 3: {
                                                                            n75 = 62;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            n75 = 7;
                                                                        }
                                                                    }
                                                                    cArray71[n74] = (char)(c13 ^ n75);
                                                                    ++n4;
                                                                    cArray14 = cArray72;
                                                                    n17 = n17;
                                                                    if (n17 != 0) break;
                                                                    cArray72 = cArray14;
                                                                    n16 = n17;
                                                                    n74 = n17;
                                                                    cArray71 = cArray14;
                                                                }
                                                                cArray13 = cArray14;
                                                                n16 = n17;
                                                            } while (n17 > n4);
                                                        }
                                                        stringArray[5] = new String(cArray13).intern();
                                                        var2 = null;
                                                        char[] cArray73 = "SU\u0006_Qw\u0000".toCharArray();
                                                        n7 = 0;
                                                        int n76 = cArray73.length;
                                                        cArray12 = cArray73;
                                                        n15 = n76;
                                                        if (n76 <= 1) break block186;
                                                        cArray11 = cArray12;
                                                        n14 = n15;
                                                        if (n15 <= n7) break block187;
                                                    }
                                                    do {
                                                        char[] cArray74 = cArray12;
                                                        char[] cArray75 = cArray12;
                                                        int n77 = n7;
                                                        while (true) {
                                                            int n78;
                                                            char c14 = cArray74[n77];
                                                            switch (n7 % 5) {
                                                                case 0: {
                                                                    n78 = 34;
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    n78 = 52;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    n78 = 21;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    n78 = 7;
                                                                    break;
                                                                }
                                                                default: {
                                                                    n78 = 63;
                                                                }
                                                            }
                                                            cArray74[n77] = (char)(c14 ^ n78);
                                                            ++n7;
                                                            cArray12 = cArray75;
                                                            n15 = n15;
                                                            if (n15 != 0) break;
                                                            cArray75 = cArray12;
                                                            n14 = n15;
                                                            n77 = n15;
                                                            cArray74 = cArray12;
                                                        }
                                                        cArray11 = cArray12;
                                                        n14 = n15;
                                                    } while (n15 > n7);
                                                }
                                                var0_2 = null;
                                                char[] cArray76 = new String(cArray11).intern().toCharArray();
                                                n4 = 0;
                                                int n79 = cArray76.length;
                                                cArray10 = cArray76;
                                                n13 = n79;
                                                if (n79 <= 1) break block188;
                                                cArray9 = cArray10;
                                                n12 = n13;
                                                if (n13 <= n4) break block189;
                                            }
                                            do {
                                                char[] cArray77 = cArray10;
                                                char[] cArray78 = cArray10;
                                                int n80 = n4;
                                                while (true) {
                                                    int n81;
                                                    char c15 = cArray77[n80];
                                                    switch (n4 % 5) {
                                                        case 0: {
                                                            n81 = 50;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n81 = 14;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n81 = 125;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n81 = 62;
                                                            break;
                                                        }
                                                        default: {
                                                            n81 = 7;
                                                        }
                                                    }
                                                    cArray77[n80] = (char)(c15 ^ n81);
                                                    ++n4;
                                                    cArray10 = cArray78;
                                                    n13 = n13;
                                                    if (n13 != 0) break;
                                                    cArray78 = cArray10;
                                                    n12 = n13;
                                                    n80 = n13;
                                                    cArray77 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n12 = n13;
                                            } while (n13 > n4);
                                        }
                                        stringArray[6] = new String(cArray9).intern();
                                        var2 = null;
                                        char[] cArray79 = "XU\u001bM\u0018q^\fK]cIHPK0".toCharArray();
                                        n7 = 0;
                                        int n82 = cArray79.length;
                                        cArray8 = cArray79;
                                        n11 = n82;
                                        if (n82 <= 1) break block190;
                                        cArray7 = cArray8;
                                        n10 = n11;
                                        if (n11 <= n7) break block191;
                                    }
                                    do {
                                        char[] cArray80 = cArray8;
                                        char[] cArray81 = cArray8;
                                        int n83 = n7;
                                        while (true) {
                                            int n84;
                                            char c16 = cArray80[n83];
                                            switch (n7 % 5) {
                                                case 0: {
                                                    n84 = 34;
                                                    break;
                                                }
                                                case 1: {
                                                    n84 = 52;
                                                    break;
                                                }
                                                case 2: {
                                                    n84 = 21;
                                                    break;
                                                }
                                                case 3: {
                                                    n84 = 7;
                                                    break;
                                                }
                                                default: {
                                                    n84 = 63;
                                                }
                                            }
                                            cArray80[n83] = (char)(c16 ^ n84);
                                            ++n7;
                                            cArray8 = cArray81;
                                            n11 = n11;
                                            if (n11 != 0) break;
                                            cArray81 = cArray8;
                                            n10 = n11;
                                            n83 = n11;
                                            cArray80 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n10 = n11;
                                    } while (n11 > n7);
                                }
                                var0_2 = null;
                                char[] cArray82 = new String(cArray7).intern().toCharArray();
                                n4 = 0;
                                int n85 = cArray82.length;
                                cArray6 = cArray82;
                                n9 = n85;
                                if (n85 <= 1) break block192;
                                cArray5 = cArray6;
                                n8 = n9;
                                if (n9 <= n4) break block193;
                            }
                            do {
                                char[] cArray83 = cArray6;
                                char[] cArray84 = cArray6;
                                int n86 = n4;
                                while (true) {
                                    int n87;
                                    char c17 = cArray83[n86];
                                    switch (n4 % 5) {
                                        case 0: {
                                            n87 = 50;
                                            break;
                                        }
                                        case 1: {
                                            n87 = 14;
                                            break;
                                        }
                                        case 2: {
                                            n87 = 125;
                                            break;
                                        }
                                        case 3: {
                                            n87 = 62;
                                            break;
                                        }
                                        default: {
                                            n87 = 7;
                                        }
                                    }
                                    cArray83[n86] = (char)(c17 ^ n87);
                                    ++n4;
                                    cArray6 = cArray84;
                                    n9 = n9;
                                    if (n9 != 0) break;
                                    cArray84 = cArray6;
                                    n8 = n9;
                                    n86 = n9;
                                    cArray83 = cArray6;
                                }
                                cArray5 = cArray6;
                                n8 = n9;
                            } while (n9 > n4);
                        }
                        stringArray[7] = new String(cArray5).intern();
                        var2 = null;
                        char[] cArray85 = "R[\fzpQu;x\\tH\rJK".toCharArray();
                        n7 = 0;
                        int n88 = cArray85.length;
                        cArray4 = cArray85;
                        n6 = n88;
                        if (n88 <= 1) break block194;
                        cArray3 = cArray4;
                        n5 = n6;
                        if (n6 <= n7) break block195;
                    }
                    do {
                        char[] cArray86 = cArray4;
                        char[] cArray87 = cArray4;
                        int n89 = n7;
                        while (true) {
                            int n90;
                            char c18 = cArray86[n89];
                            switch (n7 % 5) {
                                case 0: {
                                    n90 = 34;
                                    break;
                                }
                                case 1: {
                                    n90 = 52;
                                    break;
                                }
                                case 2: {
                                    n90 = 21;
                                    break;
                                }
                                case 3: {
                                    n90 = 7;
                                    break;
                                }
                                default: {
                                    n90 = 63;
                                }
                            }
                            cArray86[n89] = (char)(c18 ^ n90);
                            ++n7;
                            cArray4 = cArray87;
                            n6 = n6;
                            if (n6 != 0) break;
                            cArray87 = cArray4;
                            n5 = n6;
                            n89 = n6;
                            cArray86 = cArray4;
                        }
                        cArray3 = cArray4;
                        n5 = n6;
                    } while (n6 > n7);
                }
                var0_2 = null;
                char[] cArray88 = new String(cArray3).intern().toCharArray();
                n4 = 0;
                int n91 = cArray88.length;
                cArray2 = cArray88;
                n3 = n91;
                if (n91 <= 1) break block196;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block197;
            }
            do {
                char[] cArray89 = cArray2;
                char[] cArray90 = cArray2;
                int n92 = n4;
                while (true) {
                    int n93;
                    char c19 = cArray89[n92];
                    switch (n4 % 5) {
                        case 0: {
                            n93 = 50;
                            break;
                        }
                        case 1: {
                            n93 = 14;
                            break;
                        }
                        case 2: {
                            n93 = 125;
                            break;
                        }
                        case 3: {
                            n93 = 62;
                            break;
                        }
                        default: {
                            n93 = 7;
                        }
                    }
                    cArray89[n92] = (char)(c19 ^ n93);
                    ++n4;
                    cArray2 = cArray90;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray90 = cArray2;
                    n2 = n3;
                    n92 = n3;
                    cArray89 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        stringArray[8] = new String(cArray).intern();
        c = stringArray;
    }
}

