/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.internal.KerberosTime;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;

public class EncAPRepPart {
    private KerberosTime b;
    private int c;
    private EncryptionKey d;
    private Integer e;

    public EncAPRepPart(KerberosTime kerberosTime, int n2, EncryptionKey encryptionKey, Integer n3) {
        this.b = kerberosTime;
        this.c = n2;
        this.d = encryptionKey;
        this.e = n3;
    }

    public EncAPRepPart(byte[] byArray) throws Asn1Exception, IOException {
        this.b(new DerValue(byArray));
    }

    public EncAPRepPart(DerValue derValue) throws Asn1Exception, IOException {
        this.b(derValue);
    }

    private void b(DerValue derValue) throws Asn1Exception, IOException {
        if ((derValue.getTag() & 0x1F) != 27 || !derValue.isApplication() || !derValue.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        this.b = KerberosTime.parse(derValue2.getData(), (byte)0, true);
        DerValue derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.c = derValue3.getData().getBigInteger().intValue();
        if (derValue2.getData().available() > 0) {
            this.d = EncryptionKey.parse(derValue2.getData(), (byte)2, true);
        } else {
            this.d = null;
            this.e = null;
        }
        if (derValue2.getData().available() > 0) {
            derValue3 = derValue2.getData().getDerValue();
            if ((derValue3.getTag() & 0x1F) != 3) {
                throw new Asn1Exception(906);
            }
            this.e = new Integer(derValue3.getData().getBigInteger().intValue());
        } else {
            this.e = null;
        }
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        Vector<DerValue> vector = new Vector<DerValue>();
        DerOutputStream derOutputStream = new DerOutputStream();
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)0), this.b.asn1Encode()));
        derOutputStream.putInteger(BigInteger.valueOf(this.c));
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream.toByteArray()));
        if (this.d != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)2), this.d.asn1Encode()));
        }
        if (this.e != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(this.e);
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)3), derOutputStream.toByteArray()));
        }
        Object[] objectArray = new DerValue[vector.size()];
        vector.copyInto(objectArray);
        derOutputStream = new DerOutputStream();
        derOutputStream.putSequence((DerValue[])objectArray);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(DerValue.createTag((byte)64, (boolean)true, (byte)27), derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public final EncryptionKey getSubKey() {
        return this.d;
    }

    public final Integer getSeqNumber() {
        return this.e;
    }

    public KerberosTime getTime() {
        return this.b;
    }

    public int getMicroSeconds() {
        return this.c;
    }
}

