/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.internal.ccache.c;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;

public class AuthorizationDataEntry
implements Cloneable {
    public int adType;
    public byte[] adData;

    private AuthorizationDataEntry() {
    }

    public AuthorizationDataEntry(int n2, byte[] byArray) {
        this.adType = n2;
        this.adData = byArray;
    }

    public Object clone() {
        AuthorizationDataEntry authorizationDataEntry = new AuthorizationDataEntry();
        authorizationDataEntry.adType = this.adType;
        if (this.adData != null) {
            authorizationDataEntry.adData = new byte[this.adData.length];
            System.arraycopy(this.adData, 0, authorizationDataEntry.adData, 0, this.adData.length);
        }
        return authorizationDataEntry;
    }

    public AuthorizationDataEntry(DerValue derValue) throws Asn1Exception, IOException {
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.adType = derValue2.getData().getBigInteger().intValue();
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.adData = derValue2.getData().getOctetString();
        if (derValue.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.adType);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOctetString(this.adData);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public void writeEntry(c c2) throws IOException {
        c2.c(this.adType);
        c2.b(this.adData.length);
        c2.write(this.adData, 0, this.adData.length);
    }
}

