/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.Checksum;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.Realm;
import com.ibm.security.krb5.internal.AuthorizationData;
import com.ibm.security.krb5.internal.KerberosTime;
import com.ibm.security.krb5.internal.KrbApErrException;
import com.ibm.security.krb5.internal.RealmException;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;

public class Authenticator {
    private int b;
    private Realm c;
    private PrincipalName d;
    private Checksum e;
    private int f;
    private KerberosTime g;
    private EncryptionKey h;
    private Integer i;
    private AuthorizationData j;

    public Authenticator(Realm realm, PrincipalName principalName, Checksum checksum, int n2, KerberosTime kerberosTime, EncryptionKey encryptionKey, Integer n3, AuthorizationData authorizationData) {
        this.b = 5;
        this.c = realm;
        this.d = principalName;
        this.e = checksum;
        this.f = n2;
        this.g = kerberosTime;
        this.h = encryptionKey;
        this.i = n3;
        this.j = authorizationData;
    }

    public Authenticator(byte[] byArray) throws Asn1Exception, IOException, KrbApErrException, RealmException {
        this.b(new DerValue(byArray));
    }

    public Authenticator(DerValue derValue) throws Asn1Exception, IOException, KrbApErrException, RealmException {
        this.b(derValue);
    }

    private void b(DerValue derValue) throws Asn1Exception, IOException, KrbApErrException, RealmException {
        if ((derValue.getTag() & 0x1F) != 2 || !derValue.isApplication() || !derValue.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.b = derValue3.getData().getBigInteger().intValue();
        if (this.b != 5) {
            throw new KrbApErrException(39);
        }
        this.c = Realm.parse(derValue2.getData(), (byte)1, false);
        this.d = PrincipalName.parse(derValue2.getData(), (byte)2, false);
        this.e = Checksum.parse(derValue2.getData(), (byte)3, true);
        derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 4) {
            throw new Asn1Exception(906);
        }
        this.f = derValue3.getData().getBigInteger().intValue();
        this.g = KerberosTime.parse(derValue2.getData(), (byte)5, false);
        if (derValue2.getData().available() > 0) {
            this.h = EncryptionKey.parse(derValue2.getData(), (byte)6, true);
        } else {
            this.h = null;
            this.i = null;
            this.j = null;
        }
        if (derValue2.getData().available() > 0) {
            if ((derValue2.getData().peekByte() & 0x1F) == 7 && ((derValue3 = derValue2.getData().getDerValue()).getTag() & 0x1F) == 7) {
                this.i = new Integer(derValue3.getData().getBigInteger().intValue());
            }
        } else {
            this.i = null;
            this.j = null;
        }
        this.j = derValue2.getData().available() > 0 ? AuthorizationData.parse(derValue2.getData(), (byte)8, true) : null;
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        ArrayList<DerValue> arrayList = new ArrayList<DerValue>();
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.b));
        arrayList.add(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream.toByteArray()));
        if (this.c != null) {
            arrayList.add(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)1), this.c.asn1Encode()));
        }
        arrayList.add(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)2), this.d.asn1Encode()));
        if (this.e != null) {
            arrayList.add(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)3), this.e.asn1Encode()));
        }
        derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(BigInteger.valueOf(this.f));
        arrayList.add(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)4), derOutputStream.toByteArray()));
        arrayList.add(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)5), this.g.asn1Encode()));
        if (this.h != null) {
            arrayList.add(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)6), this.h.asn1Encode()));
        }
        if (this.i != null) {
            derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(this.i);
            arrayList.add(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)7), derOutputStream.toByteArray()));
        }
        if (this.j != null) {
            arrayList.add(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)8), this.j.asn1Encode()));
        }
        DerValue[] derValueArray = new DerValue[arrayList.size()];
        arrayList.toArray(derValueArray);
        derOutputStream = new DerOutputStream();
        derOutputStream.putSequence(derValueArray);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(DerValue.createTag((byte)64, (boolean)true, (byte)2), derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public final Checksum getChecksum() {
        return this.e;
    }

    public final Integer getSeqNumber() {
        return this.i;
    }

    public final EncryptionKey getSubKey() {
        return this.h;
    }

    public int getVersionNumber() {
        return this.b;
    }

    public Realm getRealm() {
        return this.c;
    }

    public PrincipalName getClient() {
        return this.d;
    }

    public int getMicroSeconds() {
        return this.f;
    }

    public KerberosTime getTime() {
        return this.g;
    }

    public EncryptionKey getSubsesionKey() {
        return this.h;
    }

    public int getSequenceNumber() {
        if (this.i == null) {
            return -1;
        }
        return this.i;
    }

    public AuthorizationData getAuthzData() {
        return this.j;
    }
}

