/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptedData;
import com.ibm.security.krb5.internal.APOptions;
import com.ibm.security.krb5.internal.KrbApErrException;
import com.ibm.security.krb5.internal.RealmException;
import com.ibm.security.krb5.internal.Ticket;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;

public class APReq {
    private int b;
    private int c;
    private APOptions d;
    private Ticket e;
    private EncryptedData f;

    public APReq(APOptions aPOptions, Ticket ticket, EncryptedData encryptedData) {
        this.b = 5;
        this.c = 14;
        this.d = aPOptions;
        this.e = ticket;
        this.f = encryptedData;
    }

    public APReq(byte[] byArray) throws Asn1Exception, IOException, KrbApErrException, RealmException {
        this.b(new DerValue(byArray));
    }

    public APReq(DerValue derValue) throws Asn1Exception, IOException, KrbApErrException, RealmException {
        this.b(derValue);
    }

    private void b(DerValue derValue) throws Asn1Exception, IOException, KrbApErrException, RealmException {
        if ((derValue.getTag() & 0x1F) != 14 || !derValue.isApplication() || !derValue.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.b = derValue3.getData().getBigInteger().intValue();
        if (this.b != 5) {
            throw new KrbApErrException(39);
        }
        derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.c = derValue3.getData().getBigInteger().intValue();
        if (this.c != 14) {
            throw new KrbApErrException(40);
        }
        this.d = APOptions.parse(derValue2.getData(), (byte)2, false);
        this.e = Ticket.parse(derValue2.getData(), (byte)3, false);
        this.f = EncryptedData.parse(derValue2.getData(), (byte)4, false);
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.b));
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.c));
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream2);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), this.d.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)3), this.e.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)4), this.f.asn1Encode());
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write(DerValue.createTag((byte)64, (boolean)true, (byte)14), derOutputStream2);
        return derOutputStream3.toByteArray();
    }

    public int getProtocolVersionNumber() {
        return this.b;
    }

    public int getMessageType() {
        return this.c;
    }

    public APOptions getOptions() {
        return this.d;
    }

    public Ticket getTicket() {
        return this.e;
    }

    public EncryptedData getEncryptedAuthenticator() {
        return this.f;
    }
}

