/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5;

import com.ibm.security.jgss.i18n.I18NException;
import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptedData;
import com.ibm.security.krb5.Krb5Debug;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.internal.Config;
import com.ibm.security.krb5.internal.ccache.c;
import com.ibm.security.krb5.internal.crypto.Des3EType;
import com.ibm.security.krb5.internal.crypto.KrbCryptoException;
import com.ibm.security.krb5.internal.crypto.p;
import com.ibm.security.krb5.internal.crypto.r;
import com.ibm.security.krb5.internal.crypto.s;
import com.ibm.security.krb5.internal.crypto.t;
import com.ibm.security.krb5.internal.crypto.z;
import com.ibm.security.krb5.internal.ktab.KeyTab;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.util.Arrays;

public class EncryptionKey
implements Cloneable {
    public static EncryptionKey NULL_KEY;
    private int b;
    private byte[] c;
    private Integer d;
    public static final int KEYTYPE_DEFAULT;
    private static String[] e;

    private static int b() {
        int n2 = 16;
        try {
            int[] nArray = Config.getInstance().defaultEtype(e[1]);
            if (nArray != null && nArray.length > 0) {
                if (EncryptedData.isSupportedEncType(nArray[0])) {
                    n2 = nArray[0];
                    if (Krb5Debug.on(9)) {
                        Krb5Debug krb5Debug = new Krb5Debug(e[5] + Thread.currentThread().getName() + e[6]);
                        krb5Debug.out(9, e[4] + EncryptedData.encTypeToString(n2));
                    }
                } else if (Krb5Debug.on(9)) {
                    Krb5Debug krb5Debug = new Krb5Debug(e[5] + Thread.currentThread().getName() + e[6]);
                    krb5Debug.out(9, e[3] + nArray[0]);
                }
            }
        }
        catch (Exception exception) {
            n2 = 16;
        }
        return n2;
    }

    public synchronized int getEType() {
        return this.b;
    }

    public final Integer getKeyVersionNumber() {
        return this.d;
    }

    public final byte[] getBytes() {
        byte[] byArray = null;
        if (this.c != null) {
            byArray = new byte[this.c.length];
            System.arraycopy(this.c, 0, byArray, 0, this.c.length);
        }
        return byArray;
    }

    public int getKeyType() {
        return this.b;
    }

    public synchronized Object clone() {
        return new EncryptionKey(this.c, this.b, this.d);
    }

    public static EncryptionKey acquireSecretKey(PrincipalName principalName, String string) throws KrbException, IOException {
        KeyTab keyTab;
        if (principalName == null) {
            I18NException.throwIllegalArgumentException(e[7]);
        }
        if ((keyTab = KeyTab.getInstance(string)) == null) {
            return null;
        }
        return keyTab.readServiceKey(principalName);
    }

    public EncryptionKey(byte[] byArray, int n2, Integer n3) {
        if (!EncryptedData.isSupportedEncType(n2)) {
            I18NException.throwIllegalArgumentException(e[0], new Integer[]{new Integer(n2)});
        }
        this.b = n2;
        this.d = n3;
        if (byArray != null) {
            this.c = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.c, 0, this.c.length);
        }
    }

    public EncryptionKey(int n2, byte[] byArray) {
        this(byArray, n2, null);
    }

    public EncryptionKey(byte[] byArray) {
        this(byArray, KEYTYPE_DEFAULT, null);
    }

    public EncryptionKey(String string) throws KrbCryptoException {
        this.b = KEYTYPE_DEFAULT;
        this.c = this.b(string, this.b);
    }

    public EncryptionKey(String string, String string2) throws KrbCryptoException {
        this.b = KEYTYPE_DEFAULT;
        this.c = this.b(string, string2, this.b);
    }

    public EncryptionKey(String string, String string2, int n2) throws KrbCryptoException {
        this.b = n2;
        this.c = this.b(string, string2, this.b);
    }

    public EncryptionKey(String string, String string2, int n2, byte[] byArray) throws KrbCryptoException {
        this.b = n2;
        this.c = EncryptionKey.b(string, string2, this.b, byArray);
    }

    public EncryptionKey(String string, int n2, Integer n3) throws KrbCryptoException {
        this.c = this.b(string, n2);
        this.b = n2;
        this.d = n3;
    }

    public EncryptionKey(String string, int n2, String string2, Integer n3) throws KrbCryptoException {
        this.c = this.b(string, string2, n2);
        this.b = n2;
        this.d = n3;
    }

    public EncryptionKey(EncryptionKey encryptionKey) throws KrbCryptoException {
        this.c = (byte[])encryptionKey.c.clone();
        this.b = encryptionKey.b;
    }

    public EncryptionKey(DerValue derValue) throws Asn1Exception, IOException {
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.b = derValue2.getData().getBigInteger().intValue();
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.c = derValue2.getData().getOctetString();
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    static int b(byte[] byArray) {
        int n2 = 4;
        int n3 = 0;
        while (--n2 >= 0) {
            n3 <<= 8;
            n3 |= byArray[n2] & 0xFF;
        }
        return n3;
    }

    public synchronized byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.b);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOctetString(this.c);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public synchronized void destroy() {
        if (this.c != null) {
            for (int i2 = 0; i2 < this.c.length; ++i2) {
                this.c[i2] = 0;
            }
        }
    }

    public static EncryptionKey parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new EncryptionKey(derValue2);
    }

    public void writeKey(c c2) throws IOException {
        c2.c(this.b);
        c2.c(this.b);
        c2.b(this.c.length);
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            c2.d(this.c[i2]);
        }
    }

    private byte[] b(String string, int n2) throws KrbCryptoException {
        if (!EncryptedData.isSupportedEncType(n2)) {
            I18NException.throwIllegalArgumentException(e[0], new Integer[]{new Integer(n2)});
        }
        if (EncryptedData.isDesEncType(n2)) {
            if (n2 == 16) {
                return Des3EType.stringToKey(string);
            }
            return p.d(string);
        }
        if (EncryptedData.isRc4HMacEncType(n2)) {
            return z.a(string);
        }
        if (EncryptedData.isAES128EncType(n2)) {
            return s.a(string);
        }
        if (EncryptedData.isAES256EncType(n2)) {
            return t.a(string);
        }
        return new byte[0];
    }

    private byte[] b(String string, String string2, int n2) throws KrbCryptoException {
        if (!EncryptedData.isSupportedEncType(n2)) {
            I18NException.throwIllegalArgumentException(e[0], new Integer[]{new Integer(n2)});
        }
        if (EncryptedData.isDesEncType(n2)) {
            if (string2 == null) {
                I18NException.throwIllegalArgumentException(e[2]);
            }
            if (n2 == 16) {
                return Des3EType.stringToKey(string, string2);
            }
            return p.d(string + string2);
        }
        if (EncryptedData.isRc4HMacEncType(n2)) {
            return z.a(string);
        }
        if (EncryptedData.isAES128EncType(n2)) {
            return s.b(string, string2);
        }
        if (EncryptedData.isAES256EncType(n2)) {
            return t.b(string, string2);
        }
        return new byte[0];
    }

    private static byte[] b(String string, String string2, int n2, byte[] byArray) throws KrbCryptoException {
        if (!EncryptedData.isSupportedEncType(n2)) {
            I18NException.throwIllegalArgumentException(e[0], new Integer[]{new Integer(n2)});
        }
        if (EncryptedData.isDesEncType(n2)) {
            if (string2 == null) {
                I18NException.throwIllegalArgumentException(e[2]);
            }
            if (n2 == 16) {
                return Des3EType.stringToKey(string, string2);
            }
            return p.d(string + string2);
        }
        if (EncryptedData.isRc4HMacEncType(n2)) {
            return z.a(string);
        }
        if (EncryptedData.isAES128EncType(n2)) {
            int n3 = 4096;
            if (byArray != null) {
                n3 = EncryptionKey.b(byArray);
            }
            return s.b(string, string2, n3);
        }
        if (EncryptedData.isAES256EncType(n2)) {
            int n4 = 4096;
            if (byArray != null) {
                n4 = EncryptionKey.b(byArray);
            }
            return t.b(string, string2, n4);
        }
        return new byte[0];
    }

    public static EncryptionKey[] acquireSecretKeys(String string, String string2, boolean bl, int n2, byte[] byArray) throws KrbException {
        int[] nArray = r.b(e[1]);
        if (nArray == null) {
            nArray = r.e();
        }
        if (bl && n2 != 0 && r.c(n2)) {
            nArray = new int[]{n2};
        }
        EncryptionKey[] encryptionKeyArray = new EncryptionKey[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (!r.c(nArray[i2])) continue;
            encryptionKeyArray[i2] = new EncryptionKey(EncryptionKey.b(string, string2, nArray[i2], byArray), nArray[i2], null);
        }
        return encryptionKeyArray;
    }

    public static EncryptionKey findKey(int n2, EncryptionKey[] encryptionKeyArray) throws KrbException {
        int n3;
        int n4;
        for (n4 = 0; n4 < encryptionKeyArray.length; ++n4) {
            n3 = encryptionKeyArray[n4].getEType();
            if (!r.c(n3) || n2 != n3) continue;
            return encryptionKeyArray[n4];
        }
        if (n2 == 1 || n2 == 3) {
            for (n4 = 0; n4 < encryptionKeyArray.length; ++n4) {
                n3 = encryptionKeyArray[n4].getEType();
                if (n3 != 1 && n3 != 3) continue;
                return new EncryptionKey(n2, encryptionKeyArray[n4].getBytes());
            }
        }
        return null;
    }

    public int hashCode() {
        int n2 = 17;
        n2 = 37 * n2 + Arrays.hashCode(this.c);
        n2 = 37 * n2 + this.d;
        return 37 * n2 + this.b;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof EncryptionKey)) {
            return false;
        }
        EncryptionKey encryptionKey = (EncryptionKey)object;
        return this.b == encryptionKey.getKeyType() && Arrays.equals(this.c, encryptionKey.getBytes());
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block175: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block174: {
                char[] cArray3;
                Object var0_2;
                block173: {
                    int n5;
                    int n6;
                    char[] cArray4;
                    int n7;
                    block172: {
                        char[] cArray5;
                        Object var2;
                        block171: {
                            int n8;
                            int n9;
                            char[] cArray6;
                            block170: {
                                char[] cArray7;
                                block169: {
                                    int n10;
                                    int n11;
                                    char[] cArray8;
                                    block168: {
                                        char[] cArray9;
                                        block167: {
                                            int n12;
                                            int n13;
                                            char[] cArray10;
                                            block166: {
                                                char[] cArray11;
                                                block165: {
                                                    int n14;
                                                    int n15;
                                                    char[] cArray12;
                                                    block164: {
                                                        char[] cArray13;
                                                        block163: {
                                                            int n16;
                                                            int n17;
                                                            char[] cArray14;
                                                            block162: {
                                                                char[] cArray15;
                                                                block161: {
                                                                    int n18;
                                                                    int n19;
                                                                    char[] cArray16;
                                                                    block160: {
                                                                        char[] cArray17;
                                                                        block159: {
                                                                            int n20;
                                                                            int n21;
                                                                            char[] cArray18;
                                                                            block158: {
                                                                                char[] cArray19;
                                                                                block157: {
                                                                                    int n22;
                                                                                    int n23;
                                                                                    char[] cArray20;
                                                                                    block156: {
                                                                                        char[] cArray21;
                                                                                        block155: {
                                                                                            int n24;
                                                                                            int n25;
                                                                                            char[] cArray22;
                                                                                            block154: {
                                                                                                char[] cArray23;
                                                                                                block153: {
                                                                                                    int n26;
                                                                                                    int n27;
                                                                                                    char[] cArray24;
                                                                                                    block152: {
                                                                                                        char[] cArray25;
                                                                                                        block151: {
                                                                                                            int n28;
                                                                                                            int n29;
                                                                                                            char[] cArray26;
                                                                                                            block150: {
                                                                                                                char[] cArray27;
                                                                                                                block149: {
                                                                                                                    int n30;
                                                                                                                    int n31;
                                                                                                                    char[] cArray28;
                                                                                                                    block148: {
                                                                                                                        char[] cArray29;
                                                                                                                        block147: {
                                                                                                                            int n32;
                                                                                                                            int n33;
                                                                                                                            char[] cArray30;
                                                                                                                            block146: {
                                                                                                                                char[] cArray31;
                                                                                                                                block145: {
                                                                                                                                    int n34;
                                                                                                                                    int n35;
                                                                                                                                    char[] cArray32;
                                                                                                                                    block144: {
                                                                                                                                        stringArray = new String[8];
                                                                                                                                        var2 = null;
                                                                                                                                        char[] cArray33 = "(\u001cL(O\u0013)Q\u0013O".toCharArray();
                                                                                                                                        n7 = 0;
                                                                                                                                        int n36 = cArray33.length;
                                                                                                                                        cArray32 = cArray33;
                                                                                                                                        n35 = n36;
                                                                                                                                        if (n36 <= 1) break block144;
                                                                                                                                        cArray31 = cArray32;
                                                                                                                                        n34 = n35;
                                                                                                                                        if (n35 <= n7) break block145;
                                                                                                                                    }
                                                                                                                                    do {
                                                                                                                                        char[] cArray34 = cArray32;
                                                                                                                                        char[] cArray35 = cArray32;
                                                                                                                                        int n37 = n7;
                                                                                                                                        while (true) {
                                                                                                                                            int n38;
                                                                                                                                            char c2 = cArray34[n37];
                                                                                                                                            switch (n7 % 5) {
                                                                                                                                                case 0: {
                                                                                                                                                    n38 = 51;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 1: {
                                                                                                                                                    n38 = 81;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 2: {
                                                                                                                                                    n38 = 69;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                case 3: {
                                                                                                                                                    n38 = 68;
                                                                                                                                                    break;
                                                                                                                                                }
                                                                                                                                                default: {
                                                                                                                                                    n38 = 10;
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                            cArray34[n37] = (char)(c2 ^ n38);
                                                                                                                                            ++n7;
                                                                                                                                            cArray32 = cArray35;
                                                                                                                                            n35 = n35;
                                                                                                                                            if (n35 != 0) break;
                                                                                                                                            cArray35 = cArray32;
                                                                                                                                            n34 = n35;
                                                                                                                                            n37 = n35;
                                                                                                                                            cArray34 = cArray32;
                                                                                                                                        }
                                                                                                                                        cArray31 = cArray32;
                                                                                                                                        n34 = n35;
                                                                                                                                    } while (n35 > n7);
                                                                                                                                }
                                                                                                                                var0_2 = null;
                                                                                                                                char[] cArray36 = new String(cArray31).intern().toCharArray();
                                                                                                                                n4 = 0;
                                                                                                                                int n39 = cArray36.length;
                                                                                                                                cArray30 = cArray36;
                                                                                                                                n33 = n39;
                                                                                                                                if (n39 <= 1) break block146;
                                                                                                                                cArray29 = cArray30;
                                                                                                                                n32 = n33;
                                                                                                                                if (n33 <= n4) break block147;
                                                                                                                            }
                                                                                                                            do {
                                                                                                                                char[] cArray37 = cArray30;
                                                                                                                                char[] cArray38 = cArray30;
                                                                                                                                int n40 = n4;
                                                                                                                                while (true) {
                                                                                                                                    int n41;
                                                                                                                                    char c3 = cArray37[n40];
                                                                                                                                    switch (n4 % 5) {
                                                                                                                                        case 0: {
                                                                                                                                            n41 = 89;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 1: {
                                                                                                                                            n41 = 44;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 2: {
                                                                                                                                            n41 = 109;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        case 3: {
                                                                                                                                            n41 = 39;
                                                                                                                                            break;
                                                                                                                                        }
                                                                                                                                        default: {
                                                                                                                                            n41 = 32;
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                    cArray37[n40] = (char)(c3 ^ n41);
                                                                                                                                    ++n4;
                                                                                                                                    cArray30 = cArray38;
                                                                                                                                    n33 = n33;
                                                                                                                                    if (n33 != 0) break;
                                                                                                                                    cArray38 = cArray30;
                                                                                                                                    n32 = n33;
                                                                                                                                    n40 = n33;
                                                                                                                                    cArray37 = cArray30;
                                                                                                                                }
                                                                                                                                cArray29 = cArray30;
                                                                                                                                n32 = n33;
                                                                                                                            } while (n33 > n4);
                                                                                                                        }
                                                                                                                        stringArray[0] = new String(cArray29).intern();
                                                                                                                        var2 = null;
                                                                                                                        char[] cArray39 = "\u000e\u0018N\u0002_\u0006\tw\u0017A\u001e\"M\rI\u001e\u0004X\u0006Y".toCharArray();
                                                                                                                        n7 = 0;
                                                                                                                        int n42 = cArray39.length;
                                                                                                                        cArray28 = cArray39;
                                                                                                                        n31 = n42;
                                                                                                                        if (n42 <= 1) break block148;
                                                                                                                        cArray27 = cArray28;
                                                                                                                        n30 = n31;
                                                                                                                        if (n31 <= n7) break block149;
                                                                                                                    }
                                                                                                                    do {
                                                                                                                        char[] cArray40 = cArray28;
                                                                                                                        char[] cArray41 = cArray28;
                                                                                                                        int n43 = n7;
                                                                                                                        while (true) {
                                                                                                                            int n44;
                                                                                                                            char c4 = cArray40[n43];
                                                                                                                            switch (n7 % 5) {
                                                                                                                                case 0: {
                                                                                                                                    n44 = 51;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 1: {
                                                                                                                                    n44 = 81;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 2: {
                                                                                                                                    n44 = 69;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                case 3: {
                                                                                                                                    n44 = 68;
                                                                                                                                    break;
                                                                                                                                }
                                                                                                                                default: {
                                                                                                                                    n44 = 10;
                                                                                                                                }
                                                                                                                            }
                                                                                                                            cArray40[n43] = (char)(c4 ^ n44);
                                                                                                                            ++n7;
                                                                                                                            cArray28 = cArray41;
                                                                                                                            n31 = n31;
                                                                                                                            if (n31 != 0) break;
                                                                                                                            cArray41 = cArray28;
                                                                                                                            n30 = n31;
                                                                                                                            n43 = n31;
                                                                                                                            cArray40 = cArray28;
                                                                                                                        }
                                                                                                                        cArray27 = cArray28;
                                                                                                                        n30 = n31;
                                                                                                                    } while (n31 > n7);
                                                                                                                }
                                                                                                                var0_2 = null;
                                                                                                                char[] cArray42 = new String(cArray27).intern().toCharArray();
                                                                                                                n4 = 0;
                                                                                                                int n45 = cArray42.length;
                                                                                                                cArray26 = cArray42;
                                                                                                                n29 = n45;
                                                                                                                if (n45 <= 1) break block150;
                                                                                                                cArray25 = cArray26;
                                                                                                                n28 = n29;
                                                                                                                if (n29 <= n4) break block151;
                                                                                                            }
                                                                                                            do {
                                                                                                                char[] cArray43 = cArray26;
                                                                                                                char[] cArray44 = cArray26;
                                                                                                                int n46 = n4;
                                                                                                                while (true) {
                                                                                                                    int n47;
                                                                                                                    char c5 = cArray43[n46];
                                                                                                                    switch (n4 % 5) {
                                                                                                                        case 0: {
                                                                                                                            n47 = 89;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 1: {
                                                                                                                            n47 = 44;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 2: {
                                                                                                                            n47 = 109;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        case 3: {
                                                                                                                            n47 = 39;
                                                                                                                            break;
                                                                                                                        }
                                                                                                                        default: {
                                                                                                                            n47 = 32;
                                                                                                                        }
                                                                                                                    }
                                                                                                                    cArray43[n46] = (char)(c5 ^ n47);
                                                                                                                    ++n4;
                                                                                                                    cArray26 = cArray44;
                                                                                                                    n29 = n29;
                                                                                                                    if (n29 != 0) break;
                                                                                                                    cArray44 = cArray26;
                                                                                                                    n28 = n29;
                                                                                                                    n46 = n29;
                                                                                                                    cArray43 = cArray26;
                                                                                                                }
                                                                                                                cArray25 = cArray26;
                                                                                                                n28 = n29;
                                                                                                            } while (n29 > n4);
                                                                                                        }
                                                                                                        stringArray[1] = new String(cArray25).intern();
                                                                                                        var2 = null;
                                                                                                        char[] cArray45 = "$\bD\u000fy\u000b\u0011\\".toCharArray();
                                                                                                        n7 = 0;
                                                                                                        int n48 = cArray45.length;
                                                                                                        cArray24 = cArray45;
                                                                                                        n27 = n48;
                                                                                                        if (n48 <= 1) break block152;
                                                                                                        cArray23 = cArray24;
                                                                                                        n26 = n27;
                                                                                                        if (n27 <= n7) break block153;
                                                                                                    }
                                                                                                    do {
                                                                                                        char[] cArray46 = cArray24;
                                                                                                        char[] cArray47 = cArray24;
                                                                                                        int n49 = n7;
                                                                                                        while (true) {
                                                                                                            int n50;
                                                                                                            char c6 = cArray46[n49];
                                                                                                            switch (n7 % 5) {
                                                                                                                case 0: {
                                                                                                                    n50 = 51;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 1: {
                                                                                                                    n50 = 81;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 2: {
                                                                                                                    n50 = 69;
                                                                                                                    break;
                                                                                                                }
                                                                                                                case 3: {
                                                                                                                    n50 = 68;
                                                                                                                    break;
                                                                                                                }
                                                                                                                default: {
                                                                                                                    n50 = 10;
                                                                                                                }
                                                                                                            }
                                                                                                            cArray46[n49] = (char)(c6 ^ n50);
                                                                                                            ++n7;
                                                                                                            cArray24 = cArray47;
                                                                                                            n27 = n27;
                                                                                                            if (n27 != 0) break;
                                                                                                            cArray47 = cArray24;
                                                                                                            n26 = n27;
                                                                                                            n49 = n27;
                                                                                                            cArray46 = cArray24;
                                                                                                        }
                                                                                                        cArray23 = cArray24;
                                                                                                        n26 = n27;
                                                                                                    } while (n27 > n7);
                                                                                                }
                                                                                                var0_2 = null;
                                                                                                char[] cArray48 = new String(cArray23).intern().toCharArray();
                                                                                                n4 = 0;
                                                                                                int n51 = cArray48.length;
                                                                                                cArray22 = cArray48;
                                                                                                n25 = n51;
                                                                                                if (n51 <= 1) break block154;
                                                                                                cArray21 = cArray22;
                                                                                                n24 = n25;
                                                                                                if (n25 <= n4) break block155;
                                                                                            }
                                                                                            do {
                                                                                                char[] cArray49 = cArray22;
                                                                                                char[] cArray50 = cArray22;
                                                                                                int n52 = n4;
                                                                                                while (true) {
                                                                                                    int n53;
                                                                                                    char c7 = cArray49[n52];
                                                                                                    switch (n4 % 5) {
                                                                                                        case 0: {
                                                                                                            n53 = 89;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 1: {
                                                                                                            n53 = 44;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 2: {
                                                                                                            n53 = 109;
                                                                                                            break;
                                                                                                        }
                                                                                                        case 3: {
                                                                                                            n53 = 39;
                                                                                                            break;
                                                                                                        }
                                                                                                        default: {
                                                                                                            n53 = 32;
                                                                                                        }
                                                                                                    }
                                                                                                    cArray49[n52] = (char)(c7 ^ n53);
                                                                                                    ++n4;
                                                                                                    cArray22 = cArray50;
                                                                                                    n25 = n25;
                                                                                                    if (n25 != 0) break;
                                                                                                    cArray50 = cArray22;
                                                                                                    n24 = n25;
                                                                                                    n52 = n25;
                                                                                                    cArray49 = cArray22;
                                                                                                }
                                                                                                cArray21 = cArray22;
                                                                                                n24 = n25;
                                                                                            } while (n25 > n4);
                                                                                        }
                                                                                        stringArray[2] = new String(cArray21).intern();
                                                                                        var2 = null;
                                                                                        char[] cArray51 = "TC\u0016Co\u0004\u001eZ\u001aZ\u001e\u0014G\ra\u000f\u0004\u0004C}+/f*d-]\u0005C_\u0004\u000e]\u0013Z\u0005\u000f\\\u0006NJ\u0018F\u0000\n\u001e\u0004X\u0006\n\u0003\u0013\b\u0000E\u0004\u001bA\u0004\u0010J".toCharArray();
                                                                                        n7 = 0;
                                                                                        int n54 = cArray51.length;
                                                                                        cArray20 = cArray51;
                                                                                        n23 = n54;
                                                                                        if (n54 <= 1) break block156;
                                                                                        cArray19 = cArray20;
                                                                                        n22 = n23;
                                                                                        if (n23 <= n7) break block157;
                                                                                    }
                                                                                    do {
                                                                                        char[] cArray52 = cArray20;
                                                                                        char[] cArray53 = cArray20;
                                                                                        int n55 = n7;
                                                                                        while (true) {
                                                                                            int n56;
                                                                                            char c8 = cArray52[n55];
                                                                                            switch (n7 % 5) {
                                                                                                case 0: {
                                                                                                    n56 = 51;
                                                                                                    break;
                                                                                                }
                                                                                                case 1: {
                                                                                                    n56 = 81;
                                                                                                    break;
                                                                                                }
                                                                                                case 2: {
                                                                                                    n56 = 69;
                                                                                                    break;
                                                                                                }
                                                                                                case 3: {
                                                                                                    n56 = 68;
                                                                                                    break;
                                                                                                }
                                                                                                default: {
                                                                                                    n56 = 10;
                                                                                                }
                                                                                            }
                                                                                            cArray52[n55] = (char)(c8 ^ n56);
                                                                                            ++n7;
                                                                                            cArray20 = cArray53;
                                                                                            n23 = n23;
                                                                                            if (n23 != 0) break;
                                                                                            cArray53 = cArray20;
                                                                                            n22 = n23;
                                                                                            n55 = n23;
                                                                                            cArray52 = cArray20;
                                                                                        }
                                                                                        cArray19 = cArray20;
                                                                                        n22 = n23;
                                                                                    } while (n23 > n7);
                                                                                }
                                                                                var0_2 = null;
                                                                                char[] cArray54 = new String(cArray19).intern().toCharArray();
                                                                                n4 = 0;
                                                                                int n57 = cArray54.length;
                                                                                cArray18 = cArray54;
                                                                                n21 = n57;
                                                                                if (n57 <= 1) break block158;
                                                                                cArray17 = cArray18;
                                                                                n20 = n21;
                                                                                if (n21 <= n4) break block159;
                                                                            }
                                                                            do {
                                                                                char[] cArray55 = cArray18;
                                                                                char[] cArray56 = cArray18;
                                                                                int n58 = n4;
                                                                                while (true) {
                                                                                    int n59;
                                                                                    char c9 = cArray55[n58];
                                                                                    switch (n4 % 5) {
                                                                                        case 0: {
                                                                                            n59 = 89;
                                                                                            break;
                                                                                        }
                                                                                        case 1: {
                                                                                            n59 = 44;
                                                                                            break;
                                                                                        }
                                                                                        case 2: {
                                                                                            n59 = 109;
                                                                                            break;
                                                                                        }
                                                                                        case 3: {
                                                                                            n59 = 39;
                                                                                            break;
                                                                                        }
                                                                                        default: {
                                                                                            n59 = 32;
                                                                                        }
                                                                                    }
                                                                                    cArray55[n58] = (char)(c9 ^ n59);
                                                                                    ++n4;
                                                                                    cArray18 = cArray56;
                                                                                    n21 = n21;
                                                                                    if (n21 != 0) break;
                                                                                    cArray56 = cArray18;
                                                                                    n20 = n21;
                                                                                    n58 = n21;
                                                                                    cArray55 = cArray18;
                                                                                }
                                                                                cArray17 = cArray18;
                                                                                n20 = n21;
                                                                            } while (n21 > n4);
                                                                        }
                                                                        stringArray[3] = new String(cArray17).intern();
                                                                        var2 = null;
                                                                        char[] cArray57 = "TC\u0016Co\u0004\u001eZ\u001aZ\u001e\u0014G\ra\u000f\u0004\u0012CI\u0005\u0013N\nMJ\u0019M\u0005K\u001f\u0011\\CA\u000f\u0004\b\u0017S\u001a\u0018\b\nYJ".toCharArray();
                                                                        n7 = 0;
                                                                        int n60 = cArray57.length;
                                                                        cArray16 = cArray57;
                                                                        n19 = n60;
                                                                        if (n60 <= 1) break block160;
                                                                        cArray15 = cArray16;
                                                                        n18 = n19;
                                                                        if (n19 <= n7) break block161;
                                                                    }
                                                                    do {
                                                                        char[] cArray58 = cArray16;
                                                                        char[] cArray59 = cArray16;
                                                                        int n61 = n7;
                                                                        while (true) {
                                                                            int n62;
                                                                            char c10 = cArray58[n61];
                                                                            switch (n7 % 5) {
                                                                                case 0: {
                                                                                    n62 = 51;
                                                                                    break;
                                                                                }
                                                                                case 1: {
                                                                                    n62 = 81;
                                                                                    break;
                                                                                }
                                                                                case 2: {
                                                                                    n62 = 69;
                                                                                    break;
                                                                                }
                                                                                case 3: {
                                                                                    n62 = 68;
                                                                                    break;
                                                                                }
                                                                                default: {
                                                                                    n62 = 10;
                                                                                }
                                                                            }
                                                                            cArray58[n61] = (char)(c10 ^ n62);
                                                                            ++n7;
                                                                            cArray16 = cArray59;
                                                                            n19 = n19;
                                                                            if (n19 != 0) break;
                                                                            cArray59 = cArray16;
                                                                            n18 = n19;
                                                                            n61 = n19;
                                                                            cArray58 = cArray16;
                                                                        }
                                                                        cArray15 = cArray16;
                                                                        n18 = n19;
                                                                    } while (n19 > n7);
                                                                }
                                                                var0_2 = null;
                                                                char[] cArray60 = new String(cArray15).intern().toCharArray();
                                                                n4 = 0;
                                                                int n63 = cArray60.length;
                                                                cArray14 = cArray60;
                                                                n17 = n63;
                                                                if (n63 <= 1) break block162;
                                                                cArray13 = cArray14;
                                                                n16 = n17;
                                                                if (n17 <= n4) break block163;
                                                            }
                                                            do {
                                                                char[] cArray61 = cArray14;
                                                                char[] cArray62 = cArray14;
                                                                int n64 = n4;
                                                                while (true) {
                                                                    int n65;
                                                                    char c11 = cArray61[n64];
                                                                    switch (n4 % 5) {
                                                                        case 0: {
                                                                            n65 = 89;
                                                                            break;
                                                                        }
                                                                        case 1: {
                                                                            n65 = 44;
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            n65 = 109;
                                                                            break;
                                                                        }
                                                                        case 3: {
                                                                            n65 = 39;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            n65 = 32;
                                                                        }
                                                                    }
                                                                    cArray61[n64] = (char)(c11 ^ n65);
                                                                    ++n4;
                                                                    cArray14 = cArray62;
                                                                    n17 = n17;
                                                                    if (n17 != 0) break;
                                                                    cArray62 = cArray14;
                                                                    n16 = n17;
                                                                    n64 = n17;
                                                                    cArray61 = cArray14;
                                                                }
                                                                cArray13 = cArray14;
                                                                n16 = n17;
                                                            } while (n17 > n4);
                                                        }
                                                        stringArray[4] = new String(cArray13).intern();
                                                        var2 = null;
                                                        char[] cArray63 = "/\u0013K\u0011S\u001a\tA\fD!\u0018QY".toCharArray();
                                                        n7 = 0;
                                                        int n66 = cArray63.length;
                                                        cArray12 = cArray63;
                                                        n15 = n66;
                                                        if (n66 <= 1) break block164;
                                                        cArray11 = cArray12;
                                                        n14 = n15;
                                                        if (n15 <= n7) break block165;
                                                    }
                                                    do {
                                                        char[] cArray64 = cArray12;
                                                        char[] cArray65 = cArray12;
                                                        int n67 = n7;
                                                        while (true) {
                                                            int n68;
                                                            char c12 = cArray64[n67];
                                                            switch (n7 % 5) {
                                                                case 0: {
                                                                    n68 = 51;
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    n68 = 81;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    n68 = 69;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    n68 = 68;
                                                                    break;
                                                                }
                                                                default: {
                                                                    n68 = 10;
                                                                }
                                                            }
                                                            cArray64[n67] = (char)(c12 ^ n68);
                                                            ++n7;
                                                            cArray12 = cArray65;
                                                            n15 = n15;
                                                            if (n15 != 0) break;
                                                            cArray65 = cArray12;
                                                            n14 = n15;
                                                            n67 = n15;
                                                            cArray64 = cArray12;
                                                        }
                                                        cArray11 = cArray12;
                                                        n14 = n15;
                                                    } while (n15 > n7);
                                                }
                                                var0_2 = null;
                                                char[] cArray66 = new String(cArray11).intern().toCharArray();
                                                n4 = 0;
                                                int n69 = cArray66.length;
                                                cArray10 = cArray66;
                                                n13 = n69;
                                                if (n69 <= 1) break block166;
                                                cArray9 = cArray10;
                                                n12 = n13;
                                                if (n13 <= n4) break block167;
                                            }
                                            do {
                                                char[] cArray67 = cArray10;
                                                char[] cArray68 = cArray10;
                                                int n70 = n4;
                                                while (true) {
                                                    int n71;
                                                    char c13 = cArray67[n70];
                                                    switch (n4 % 5) {
                                                        case 0: {
                                                            n71 = 89;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n71 = 44;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n71 = 109;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n71 = 39;
                                                            break;
                                                        }
                                                        default: {
                                                            n71 = 32;
                                                        }
                                                    }
                                                    cArray67[n70] = (char)(c13 ^ n71);
                                                    ++n4;
                                                    cArray10 = cArray68;
                                                    n13 = n13;
                                                    if (n13 != 0) break;
                                                    cArray68 = cArray10;
                                                    n12 = n13;
                                                    n70 = n13;
                                                    cArray67 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n12 = n13;
                                            } while (n13 > n4);
                                        }
                                        stringArray[5] = new String(cArray9).intern();
                                        var2 = null;
                                        char[] cArray69 = "P]".toCharArray();
                                        n7 = 0;
                                        int n72 = cArray69.length;
                                        cArray8 = cArray69;
                                        n11 = n72;
                                        if (n72 <= 1) break block168;
                                        cArray7 = cArray8;
                                        n10 = n11;
                                        if (n11 <= n7) break block169;
                                    }
                                    do {
                                        char[] cArray70 = cArray8;
                                        char[] cArray71 = cArray8;
                                        int n73 = n7;
                                        while (true) {
                                            int n74;
                                            char c14 = cArray70[n73];
                                            switch (n7 % 5) {
                                                case 0: {
                                                    n74 = 51;
                                                    break;
                                                }
                                                case 1: {
                                                    n74 = 81;
                                                    break;
                                                }
                                                case 2: {
                                                    n74 = 69;
                                                    break;
                                                }
                                                case 3: {
                                                    n74 = 68;
                                                    break;
                                                }
                                                default: {
                                                    n74 = 10;
                                                }
                                            }
                                            cArray70[n73] = (char)(c14 ^ n74);
                                            ++n7;
                                            cArray8 = cArray71;
                                            n11 = n11;
                                            if (n11 != 0) break;
                                            cArray71 = cArray8;
                                            n10 = n11;
                                            n73 = n11;
                                            cArray70 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n10 = n11;
                                    } while (n11 > n7);
                                }
                                var0_2 = null;
                                char[] cArray72 = new String(cArray7).intern().toCharArray();
                                n4 = 0;
                                int n75 = cArray72.length;
                                cArray6 = cArray72;
                                n9 = n75;
                                if (n75 <= 1) break block170;
                                cArray5 = cArray6;
                                n8 = n9;
                                if (n9 <= n4) break block171;
                            }
                            do {
                                char[] cArray73 = cArray6;
                                char[] cArray74 = cArray6;
                                int n76 = n4;
                                while (true) {
                                    int n77;
                                    char c15 = cArray73[n76];
                                    switch (n4 % 5) {
                                        case 0: {
                                            n77 = 89;
                                            break;
                                        }
                                        case 1: {
                                            n77 = 44;
                                            break;
                                        }
                                        case 2: {
                                            n77 = 109;
                                            break;
                                        }
                                        case 3: {
                                            n77 = 39;
                                            break;
                                        }
                                        default: {
                                            n77 = 32;
                                        }
                                    }
                                    cArray73[n76] = (char)(c15 ^ n77);
                                    ++n4;
                                    cArray6 = cArray74;
                                    n9 = n9;
                                    if (n9 != 0) break;
                                    cArray74 = cArray6;
                                    n8 = n9;
                                    n76 = n9;
                                    cArray73 = cArray6;
                                }
                                cArray5 = cArray6;
                                n8 = n9;
                            } while (n9 > n4);
                        }
                        stringArray[6] = new String(cArray5).intern();
                        var2 = null;
                        char[] cArray75 = "$\bD\u000fa\u000f\u0004".toCharArray();
                        n7 = 0;
                        int n78 = cArray75.length;
                        cArray4 = cArray75;
                        n6 = n78;
                        if (n78 <= 1) break block172;
                        cArray3 = cArray4;
                        n5 = n6;
                        if (n6 <= n7) break block173;
                    }
                    do {
                        char[] cArray76 = cArray4;
                        char[] cArray77 = cArray4;
                        int n79 = n7;
                        while (true) {
                            int n80;
                            char c16 = cArray76[n79];
                            switch (n7 % 5) {
                                case 0: {
                                    n80 = 51;
                                    break;
                                }
                                case 1: {
                                    n80 = 81;
                                    break;
                                }
                                case 2: {
                                    n80 = 69;
                                    break;
                                }
                                case 3: {
                                    n80 = 68;
                                    break;
                                }
                                default: {
                                    n80 = 10;
                                }
                            }
                            cArray76[n79] = (char)(c16 ^ n80);
                            ++n7;
                            cArray4 = cArray77;
                            n6 = n6;
                            if (n6 != 0) break;
                            cArray77 = cArray4;
                            n5 = n6;
                            n79 = n6;
                            cArray76 = cArray4;
                        }
                        cArray3 = cArray4;
                        n5 = n6;
                    } while (n6 > n7);
                }
                var0_2 = null;
                char[] cArray78 = new String(cArray3).intern().toCharArray();
                n4 = 0;
                int n81 = cArray78.length;
                cArray2 = cArray78;
                n3 = n81;
                if (n81 <= 1) break block174;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block175;
            }
            do {
                char[] cArray79 = cArray2;
                char[] cArray80 = cArray2;
                int n82 = n4;
                while (true) {
                    int n83;
                    char c17 = cArray79[n82];
                    switch (n4 % 5) {
                        case 0: {
                            n83 = 89;
                            break;
                        }
                        case 1: {
                            n83 = 44;
                            break;
                        }
                        case 2: {
                            n83 = 109;
                            break;
                        }
                        case 3: {
                            n83 = 39;
                            break;
                        }
                        default: {
                            n83 = 32;
                        }
                    }
                    cArray79[n82] = (char)(c17 ^ n83);
                    ++n4;
                    cArray2 = cArray80;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray80 = cArray2;
                    n2 = n3;
                    n82 = n3;
                    cArray79 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        stringArray[7] = new String(cArray).intern();
        e = stringArray;
        NULL_KEY = new EncryptionKey(new byte[0], 0, new Integer(0));
        KEYTYPE_DEFAULT = EncryptionKey.b();
    }
}

