/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.indexsupport;

import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.image.j9.Builder;
import com.ibm.dtfj.image.j9.IFileLocationResolver;
import com.ibm.dtfj.image.j9.Image;
import com.ibm.dtfj.image.j9.ImageAddressSpace;
import com.ibm.dtfj.image.j9.ImageProcess;
import com.ibm.jvm.j9.dump.indexsupport.IParserNode;
import com.ibm.jvm.j9.dump.indexsupport.NodeJ9Dump;
import com.ibm.jvm.j9.dump.indexsupport.NodeUnexpectedTag;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLIndexReader
extends DefaultHandler
implements IParserNode {
    private ICoreFileReader _coreFile;
    private Image _coreImage;
    private Stack _elements;
    private StringBuffer _scrapingBuffer = new StringBuffer();
    private IFileLocationResolver _fileResolvingAgent;
    private ClosingFileReader _reader;

    public Image parseIndexWithDump(InputStream input, ICoreFileReader core, ClosingFileReader reader, IFileLocationResolver fileResolver) {
        this._fileResolvingAgent = fileResolver;
        this._elements = new Stack();
        this._coreFile = core;
        this._reader = reader;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            this._elements.push(this);
            parser.parse(input, (DefaultHandler)this);
            this._elements.pop();
        }
        catch (ParserConfigurationException e) {
            this._createCoreImageAfterParseError(e);
        }
        catch (SAXException e) {
            this._createCoreImageAfterParseError(e);
        }
        catch (IOException e) {
            this._createCoreImageAfterParseError(e);
        }
        return this._coreImage;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this._checkScrapeBuffer();
        IParserNode node = ((IParserNode)this._elements.peek()).nodeToPushAfterStarting(uri, localName, qName, attributes);
        assert (null != node) : "Node should not be null when starting new tag: " + qName;
        this._elements.push(node);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this._checkScrapeBuffer();
        IParserNode formerTop = (IParserNode)this._elements.pop();
        formerTop.didFinishParsing();
    }

    private void _checkScrapeBuffer() {
        String collapse = this._scrapingBuffer.toString();
        this._scrapingBuffer = new StringBuffer();
        ((IParserNode)this._elements.peek()).stringWasParsed(collapse);
    }

    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        this._scrapingBuffer.append(arg0, arg1, arg2);
    }

    public IParserNode nodeToPushAfterStarting(String uri, String localName, String qName, Attributes attributes) {
        IParserNode next = null;
        next = qName.equals("j9dump") ? new NodeJ9Dump(this, attributes) : NodeUnexpectedTag.unexpectedTag(qName, attributes);
        return next;
    }

    public void stringWasParsed(String string) {
    }

    public void didFinishParsing() {
    }

    public void setJ9DumpData(long environ, String osType, String osSubType, String cpuType, int cpuCount, long bytesMem, int pointerSize, Image[] imageRef, ImageAddressSpace[] addressSpaceRef, ImageProcess[] processRef) {
        Builder builder = new Builder(this._coreFile, this._reader, environ, this._fileResolvingAgent);
        this._coreFile.extract(builder);
        String cpuSubType = builder.getCPUSubType();
        long creationTime = builder.getCreationTime();
        this._coreImage = new Image(osType, osSubType, cpuType, cpuSubType, cpuCount, bytesMem, creationTime);
        ImageAddressSpace addressSpace = (ImageAddressSpace)builder.getAddressSpaces().next();
        ImageProcess process = (ImageProcess)addressSpace.getCurrentProcess();
        Iterator it = builder.getAddressSpaces();
        while (it.hasNext()) {
            ImageAddressSpace addressSpace1 = (ImageAddressSpace)it.next();
            boolean vb = false;
            this._coreImage.addAddressSpace(addressSpace1);
            Iterator it2 = addressSpace1.getProcesses();
            while (it2.hasNext()) {
                ImageProcess process1 = (ImageProcess)it2.next();
                if (process != null && !this.isProcessForEnvironment(environ, addressSpace1, process1)) continue;
                addressSpace = addressSpace1;
                process = process1;
            }
        }
        if (null != process && process.getPointerSize() != pointerSize) {
            throw new IllegalStateException("XML and core file pointer sizes differ");
        }
        imageRef[0] = this._coreImage;
        addressSpaceRef[0] = addressSpace;
        processRef[0] = process;
    }

    private boolean isProcessForEnvironment(long environ, ImageAddressSpace addressSpace1, ImageProcess process1) {
        boolean found = false;
        try {
            long pid = Long.decode(process1.getID());
            for (int i = 0; i < 64; ++i) {
                long ptr = addressSpace1.readPointerAtIndex(pid).getAddress();
                pid += (long)addressSpace1.bytesPerPointer();
                if (ptr != environ) continue;
                found = true;
                break;
            }
        }
        catch (MemoryAccessException e) {
        }
        catch (CorruptDataException e) {
        }
        catch (DataUnavailable e) {
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return found;
    }

    private void _createCoreImageAfterParseError(Exception e) {
        Builder builder = new Builder(this._coreFile, this._reader, 0L, this._fileResolvingAgent);
        this._coreFile.extract(builder);
        String osType = builder.getOSType();
        String cpuType = builder.getCPUType();
        String cpuSubType = builder.getCPUSubType();
        long creationTime = builder.getCreationTime();
        this._coreImage = new Image(osType, null, cpuType, cpuSubType, 0, 0L, creationTime);
        Iterator spaces = builder.getAddressSpaces();
        while (spaces.hasNext()) {
            ImageAddressSpace addressSpace = (ImageAddressSpace)spaces.next();
            Iterator processes = addressSpace.getProcesses();
            while (processes.hasNext()) {
                ImageProcess process = (ImageProcess)processes.next();
                process.runtimeExtractionFailed(e);
            }
            this._coreImage.addAddressSpace(addressSpace);
        }
    }
}

