/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.extract;

import com.ibm.dtfj.addressspace.IAbstractAddressSpace;
import com.ibm.dtfj.corereaders.Builder;
import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.DeprecatedCoreAPI;
import com.ibm.dtfj.corereaders.Dump;
import com.ibm.dtfj.corereaders.DumpFactory;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Main {
    private String _dumpName = null;
    private File _virtualRootDirectory = null;
    private boolean _verbose;
    private ICoreFileReader _dump = null;
    private static final String J9_LIB_NAME = "j9jextract";
    private static final int ZIP_BUFFER_SIZE = 32768;
    private static int JEXTRACT_SUCCESS = 0;
    private static int JEXTRACT_SYNTAX_ERROR = 1;
    private static int JEXTRACT_FILE_ERROR = 2;
    private static int JEXTRACT_NOJVM_ERROR = 3;
    private static int JEXTRACT_ADDRESS_ERROR = 4;
    private static int JEXTRACT_VERSION_ERROR = 5;
    private static int JEXTRACT_INTERNAL_ERROR = 6;

    public static void main(String[] args) {
        String dumpName = null;
        String outputName = null;
        File virtualRootDirectory = null;
        boolean ignoreOptions = false;
        boolean interactive = false;
        boolean verbose = false;
        boolean zip = true;
        if (args.length == 0) {
            Main.usageMessage(null, JEXTRACT_SUCCESS);
        }
        for (int i = 0; i < args.length; ++i) {
            if (!ignoreOptions && args[i].startsWith("-")) {
                File file;
                if ("--".equals(args[i])) {
                    ignoreOptions = true;
                    continue;
                }
                if ("-interactive".equals(args[i])) {
                    interactive = true;
                    continue;
                }
                if ("-help".equals(args[i])) {
                    Main.usageMessage(null, JEXTRACT_SUCCESS);
                    continue;
                }
                if ("-nozip".equals(args[i]) || "-nojar".equals(args[i])) {
                    zip = false;
                    continue;
                }
                if ("-f".equals(args[i])) {
                    Main.ensure(++i < args.length && !args[i].startsWith("-"), "Syntax error: -f option specified but no file following");
                    file = new File(args[i]);
                    Main.ensure(file.exists() && file.canRead(), "File specified using -f option (\"" + args[i] + "\") not found.");
                    continue;
                }
                if ("-p".equals(args[i])) {
                    Main.ensure(++i < args.length && !args[i].startsWith("-"), "Syntax error: -p option specified but no virtual root directory given");
                    file = new File(args[i]);
                    Main.ensure(file.exists() && file.canRead() && file.isDirectory(), "Virtual directory specified using -p option (\"" + args[i] + "\") does not exist as a readable directory.");
                    virtualRootDirectory = new File(args[i]);
                    continue;
                }
                if (args[i].equals("-v")) {
                    verbose = true;
                    continue;
                }
                Main.usageMessage("Unrecognized option: " + args[i], JEXTRACT_SYNTAX_ERROR);
                continue;
            }
            if (dumpName == null) {
                dumpName = args[i];
                continue;
            }
            if (outputName == null) {
                outputName = args[i];
                continue;
            }
            Main.usageMessage("Too many file arguments: " + args[i], JEXTRACT_SYNTAX_ERROR);
        }
        Main.ensure(null != dumpName, "No dump file specified");
        Main dumper = new Main(dumpName, virtualRootDirectory, verbose);
        if (interactive) {
            dumper.runInteractive();
        } else {
            dumper.runJextract(outputName, zip);
        }
    }

    private static void ensure(boolean condition, String errorMessage) {
        if (!condition) {
            Main.usageMessage(errorMessage, JEXTRACT_SYNTAX_ERROR);
        }
    }

    private static void usageMessage(String message, int code) {
        if (message != null) {
            Main.report(message);
        }
        Main.report("Usage: jextract dump_name [output_filename] [options]");
        Main.report(" output filename defaults to dump_name.zip");
        Main.report("    or dump_name.xml if -nozip option specified");
        Main.report(" options:");
        Main.report("   -help         print this usage message");
        Main.report("   -nozip        don't create a zip");
        Main.report("   -v            enable verbose output");
        System.exit(code);
    }

    private static void errorMessage(String message, int code) {
        if (message != null) {
            Main.report(message);
        }
        System.exit(code);
    }

    private static void errorMessage(String message, int code, Throwable throwable) {
        if (message != null) {
            Main.report(message);
        }
        throwable.printStackTrace();
        System.exit(code);
    }

    private Main(String dumpName, File virtualRootDirectory, boolean verbose) {
        this._dumpName = dumpName;
        this._virtualRootDirectory = virtualRootDirectory;
        this._verbose = verbose;
        try {
            System.loadLibrary(J9_LIB_NAME);
        }
        catch (SecurityException e) {
            Main.errorMessage("Error. Security permissions don't allow required native library to be loaded.", JEXTRACT_INTERNAL_ERROR);
        }
        catch (UnsatisfiedLinkError e) {
            Main.errorMessage("Error. Native library j9jextract cannot be found. Please check your path.", JEXTRACT_INTERNAL_ERROR);
        }
        catch (Exception e) {
            Main.errorMessage("Error. Unexpected exception occurred loading: j9jextract", JEXTRACT_INTERNAL_ERROR, e);
        }
        Main.report("Loading dump file...");
        File dumpFile = new File(dumpName);
        try {
            ClosingFileReader reader = new ClosingFileReader(dumpFile);
            this._dump = DumpFactory.createDumpForCore(reader, this._verbose);
        }
        catch (FileNotFoundException e) {
            if (!dumpFile.exists()) {
                Main.errorMessage("Error. Could not find dump file: " + dumpName, JEXTRACT_FILE_ERROR);
            } else if (!dumpFile.canRead()) {
                Main.errorMessage("Error. Unable to read dump file (check permission): " + dumpName, JEXTRACT_FILE_ERROR);
            } else {
                Main.errorMessage("Error. Unexpected FileNotFoundException occurred opening: " + dumpName, JEXTRACT_FILE_ERROR, e);
            }
        }
        catch (Exception e) {
            Main.errorMessage("Error. Unexpected Exception occurred opening: " + dumpName, JEXTRACT_FILE_ERROR, e);
        }
        if (null == this._dump) {
            Main.errorMessage("Error. Dump type not recognised for dump: " + dumpName, JEXTRACT_FILE_ERROR);
        }
        Main.report("Read memory image from " + this._dumpName);
    }

    private void runJextract(String outputName, boolean zip) {
        try {
            String xmlOutputName = null;
            xmlOutputName = null != outputName && false == zip ? outputName : this._dumpName.concat(".xml");
            File f = new File(xmlOutputName);
            if (!f.exists()) {
                try {
                    f.createNewFile();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (!f.canWrite()) {
                Main.errorMessage("Error. Unable to write to \"" + xmlOutputName + "\" (check permission)", JEXTRACT_FILE_ERROR);
            }
            DummyBuilder builder = new DummyBuilder(this._virtualRootDirectory);
            this._dump.extract(builder);
            try {
                IAbstractAddressSpace addressSpace = this._dump.getAddressSpace();
                if (addressSpace == null) {
                    f.delete();
                    Main.errorMessage("Error. Address space not found in dump: " + this._dumpName + ". Dump is truncated, corrupted or does not contain a supported JVM.", JEXTRACT_NOJVM_ERROR);
                } else {
                    this.doJextract(addressSpace, xmlOutputName);
                }
            }
            catch (Throwable t) {
                String jextractnativeMessage = t.getMessage();
                if (jextractnativeMessage != null) {
                    if (this._verbose) {
                        Main.report(jextractnativeMessage);
                    }
                    if (jextractnativeMessage.indexOf("JVM anchor block (J9VMRAS) not found in dump") >= 0) {
                        Main.errorMessage("Error. No known JVM found in dump", JEXTRACT_NOJVM_ERROR);
                    } else if (jextractnativeMessage.indexOf("J9RAS is out of range for a 32-bit pointer") >= 0) {
                        Main.errorMessage("Error. JVM out of address range, needs 64-bit jextract", JEXTRACT_ADDRESS_ERROR);
                    } else if (jextractnativeMessage.indexOf("J9RAS.version is incorrect") >= 0 || jextractnativeMessage.indexOf("J9RAS.length is incorrect") >= 0 || jextractnativeMessage.indexOf("J9RAS.buildID is incorrect") >= 0) {
                        Main.errorMessage("Error. Incompatible JVM version found in dump", JEXTRACT_VERSION_ERROR);
                    } else {
                        Main.errorMessage("Error. Internal failure detected during jextract", JEXTRACT_INTERNAL_ERROR);
                    }
                }
                Main.errorMessage("Error. Internal failure detected during jextract", JEXTRACT_INTERNAL_ERROR);
            }
            if (zip) {
                ArrayList<String> files = new ArrayList<String>();
                files.add(this._dumpName);
                files.add(xmlOutputName);
                Iterator iter = this._dump.getAdditionalFileNames();
                while (iter.hasNext()) {
                    files.add((String)iter.next());
                }
                try {
                    String j9trace;
                    String lib_dir = System.getProperty("java.home") + File.separator + "lib" + File.separator;
                    String trace = lib_dir + "TraceFormat.dat";
                    if (new File(trace).exists()) {
                        files.add(trace);
                    }
                    if (new File(j9trace = lib_dir + "J9TraceFormat.dat").exists()) {
                        files.add(j9trace);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                Main.createZipFromFileNames(null != outputName ? outputName : this._dumpName.concat(".zip"), files.iterator(), builder);
                f.deleteOnExit();
            }
            Main.report("jextract complete.");
        }
        catch (Exception e) {
            e.printStackTrace();
            Main.report(e.getMessage());
            Main.report("jextract failed.");
        }
    }

    private void runInteractive() {
        Main.report("Jextract interactive mode.");
        Main.report("Type '!j9help' for help.");
        Main.report("Type 'quit' to quit.");
        Main.report("(Commands must be prefixed with '!')");
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        block4: while (true) {
            try {
                while (true) {
                    Main.report("> ");
                    String command = input.readLine().trim();
                    if ("quit".equalsIgnoreCase(command) || "q".equalsIgnoreCase(command)) break block4;
                    try {
                        this.doCommand(this._dump.getAddressSpace(), command);
                        continue block4;
                    }
                    catch (Throwable e) {
                        Main.report(e.getMessage());
                        Main.report("Failure detected during command execution, see previous message(s).");
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                Main.report("Error reading input.");
                break;
            }
        }
    }

    private static void report(String message) {
        System.err.println(message);
    }

    private static void createZipFromFileNames(String zipFileName, Iterator fileNames, Builder fileResolver) throws Exception {
        Main.report("Creating zip file: " + zipFileName);
        try {
            ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(zipFileName));
            byte[] buffer = new byte[32768];
            while (fileNames.hasNext()) {
                String name = (String)fileNames.next();
                try {
                    ClosingFileReader in = fileResolver.openFile(name);
                    boolean mvsfile = in.isMVSFile();
                    String absolute = in.getAbsolutePath();
                    if (absolute.equals(new File(name).getAbsolutePath()) || mvsfile) {
                        Main.report("Adding \"" + name + "\" to zip");
                    } else {
                        Main.report("Adding \"" + name + "\" to zip (found at \"" + absolute + "\")");
                    }
                    if (mvsfile) {
                        zip.putNextEntry(new ZipEntry(name));
                        Main.copy(in, (OutputStream)zip, buffer);
                        continue;
                    }
                    InputStream fileStream = in.streamFromFile();
                    zip.putNextEntry(new ZipEntry(name));
                    Main.copy(fileStream, (OutputStream)zip, buffer);
                    fileStream.close();
                }
                catch (FileNotFoundException e1) {
                    Main.report("Warning:  Could not find file \"" + name + "\" for inclusion in zip file.  This will limit the usefulness of the zip file.");
                }
                catch (IOException e) {
                    throw new Exception("Failure adding file to zip file (" + name + ") : " + e.getMessage());
                }
                finally {
                    zip.closeEntry();
                }
            }
            try {
                zip.close();
            }
            catch (IOException e) {
                throw new Exception("Failure closing zip file (" + zipFileName + ") : " + e.getMessage());
            }
        }
        catch (FileNotFoundException e1) {
            throw new Exception("Could not find zip file to output to: " + e1.getMessage());
        }
    }

    private static void copy(InputStream from, OutputStream to, byte[] buffer) throws IOException {
        int count = from.read(buffer);
        while (count != -1) {
            to.write(buffer, 0, count);
            count = from.read(buffer);
        }
    }

    private static void copy(ClosingFileReader from, OutputStream to, byte[] buffer) throws IOException {
        int count = from.read(buffer);
        while (count != -1) {
            to.write(buffer, 0, count);
            count = from.read(buffer);
        }
    }

    private native void doJextract(DeprecatedCoreAPI var1, String var2) throws Exception;

    private native void doCommand(DeprecatedCoreAPI var1, String var2) throws Exception;

    private static class DummyBuilder
    implements Builder {
        private File _virtualRootDirectory = null;
        private Vector _successfulSearchPaths = new Vector();

        public DummyBuilder(File rootDirectory) {
            this._virtualRootDirectory = rootDirectory;
            String jre_bin = System.getProperty("java.home") + File.separator + "bin";
            File javaPath = new File(jre_bin);
            this._successfulSearchPaths.add(javaPath);
        }

        public Object buildProcess(Object addressSpace, String pid, String commandLine, Properties environment, Object currentThread, Iterator threads, Object executable, Iterator libraries, int addressSize) {
            return new Object();
        }

        public Object buildAddressSpace(String name, Dump core, int id) {
            return new Object();
        }

        public Object buildRegister(String name, Number value) {
            return new Register(name, value.longValue());
        }

        public Object buildStackSection(Object addressSpace, long stackStart, long stackEnd) {
            return new Object();
        }

        public Object buildThread(String name, Iterator registers, Iterator stackSections, Iterator stackFrames, Properties properties, int signalNumber) {
            return new Object();
        }

        public Object buildModuleSection(Object addressSpace, String name, long imageStart, long imageEnd) {
            return new Object();
        }

        public Object buildModule(String name, Properties properties, Iterator sections, Iterator symbols, long loadAddress) {
            return new Object();
        }

        public long getEnvironmentAddress() {
            return 0L;
        }

        public long getValueOfNamedRegister(List registers, String name) {
            for (Register register : registers) {
                if (!name.equals(register.name)) continue;
                return register.value;
            }
            return -1L;
        }

        public Object buildStackFrame(Object addressSpace, long stackBasePointer, long pc) {
            return new Object();
        }

        public ClosingFileReader openFile(String nameOrPath) throws FileNotFoundException {
            File fileRep = new File(nameOrPath);
            if (null != this._virtualRootDirectory && fileRep.isAbsolute()) {
                fileRep = this.sysFileRelative(this._virtualRootDirectory, fileRep);
            } else if (!fileRep.isAbsolute() && !fileRep.exists()) {
                Iterator paths = this._successfulSearchPaths.iterator();
                String filename = fileRep.getName();
                while (paths.hasNext()) {
                    File path = (File)paths.next();
                    File nextPath = new File(path, filename);
                    if (!nextPath.exists()) continue;
                    ClosingFileReader reader = new ClosingFileReader(nextPath);
                    return reader;
                }
            }
            if (fileRep.exists()) {
                File absolute;
                ClosingFileReader reader = new ClosingFileReader(fileRep);
                File parent = fileRep.getParentFile();
                if (null != parent && !this._successfulSearchPaths.contains(absolute = parent.getAbsoluteFile())) {
                    this._successfulSearchPaths.add(absolute);
                }
                return reader;
            }
            ClosingFileReader zosReader = new ClosingFileReader(fileRep);
            return zosReader;
        }

        private File sysFileRelative(File virtualRoot, File originalPath) {
            File temp = originalPath;
            while (null != temp.getParentFile()) {
                temp = temp.getParentFile();
            }
            File result = originalPath;
            if (originalPath.isAbsolute()) {
                String middle = originalPath.getAbsolutePath().substring(temp.getAbsolutePath().length());
                result = new File(virtualRoot, middle);
            }
            return result;
        }

        public Object buildSymbol(Object addressSpace, String functionName, long relocatedFunctionAddress) {
            return new Object();
        }

        public void setExecutableUnavailable(String description) {
        }

        public Object buildAddressSpace(String name, int id) {
            return new Object();
        }

        public void setOSType(String osType) {
        }

        public void setCPUType(String cpuType) {
        }

        public void setCPUSubType(String subType) {
        }

        public void setCreationTime(long millis) {
        }

        public Object buildCorruptData(Object addressSpace, String message, long address) {
            return new Object();
        }

        private static class Register {
            final String name;
            final long value;

            Register(String name, long value) {
                this.name = name;
                this.value = value;
            }
        }
    }
}

