/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.thread;

import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.dtfj.javacore.builder.BuilderFailureException;
import com.ibm.dtfj.javacore.builder.IImageProcessBuilder;
import com.ibm.dtfj.javacore.builder.IJavaRuntimeBuilder;
import com.ibm.dtfj.javacore.parser.framework.parser.ParserException;
import com.ibm.dtfj.javacore.parser.j9.IAttributeValueMap;
import com.ibm.dtfj.javacore.parser.j9.SectionParser;
import com.ibm.dtfj.javacore.parser.j9.section.thread.IThreadTypes;
import java.util.Properties;

public class ThreadSectionParser
extends SectionParser
implements IThreadTypes {
    private IJavaRuntimeBuilder fRuntimeBuilder;
    private IImageProcessBuilder fImageProcessBuilder;

    public ThreadSectionParser() {
        super("THREADS");
    }

    protected void topLevelRule() throws ParserException {
        this.fImageProcessBuilder = this.fImageBuilder.getCurrentAddressSpaceBuilder().getCurrentImageProcessBuilder();
        this.fRuntimeBuilder = this.fImageProcessBuilder.getCurrentJavaRuntimeBuilder();
        this.currentThreadInfoSubsection();
        this.allThreadInfoSubsection();
    }

    protected void currentThreadInfoSubsection() throws ParserException {
        this.processTagLineRequired("1XMCURTHDINFO");
        this.threadInfo(false);
    }

    protected void allThreadInfoSubsection() throws ParserException {
        this.processTagLineRequired("1XMTHDINFO");
        IAttributeValueMap results = this.processTagLineRequired("2XMFULLTHDDUMP");
        if (results != null) {
            int pointerSize = results.getIntValue("pointer_size");
            this.fImageProcessBuilder.setPointerSize(pointerSize);
        }
        this.threadInfo(true);
    }

    protected void threadInfo(boolean buildModel) throws ParserException {
        IAttributeValueMap results = null;
        int currentLineNumber = this.getCurrentFileLineNumber();
        results = this.processTagLineRequired("3XMTHREADINFO");
        if (results != null) {
            this.processThreadandStackTrace(results, buildModel, currentLineNumber);
            while ((results = this.processTagLineOptional("3XMTHREADINFO")) != null) {
                this.processThreadandStackTrace(results, buildModel, currentLineNumber);
            }
        }
    }

    protected int processThreadandStackTrace(IAttributeValueMap javaThreadResults, boolean buildModel, int currentLineNumber) throws ParserException {
        JavaThread javaThread = null;
        IAttributeValueMap nativeResults = this.processTagLineOptional("3XMTHREADINFO1");
        if (buildModel) {
            javaThread = this.addThread(javaThreadResults, nativeResults, currentLineNumber);
        }
        this.parseStackTrace(javaThread, currentLineNumber, buildModel);
        return this.getCurrentFileLineNumber();
    }

    private JavaThread addThread(IAttributeValueMap javaThreadResults, IAttributeValueMap nativeResults, int currentFileLineNumber) throws ParserException {
        long imageThreadID = nativeResults != null ? nativeResults.getLongValue("native_thread_id") : javaThreadResults.getLongValue("native_thread_id");
        long tid = javaThreadResults.getLongValue("vm_thread_id");
        if (imageThreadID == -1L) {
            imageThreadID = tid;
        }
        ImageThread imageThread = null;
        JavaThread javaThread = null;
        String threadName = javaThreadResults.getTokenValue("java_thread_name");
        String threadState = javaThreadResults.getTokenValue("vm_thread_state");
        int threadPriority = javaThreadResults.getIntValue("vm_thread_priority");
        long abstractThreadID = javaThreadResults.getLongValue("abstract_thread_id");
        Properties properties = new Properties();
        this.addAsProperty(properties, "abstract_thread_id", Long.toHexString(abstractThreadID));
        if (nativeResults != null) {
            this.addAsProperty(properties, "native_thread_priority", nativeResults.getTokenValue("native_thread_priority"));
            this.addAsProperty(properties, "native_thread_policy", nativeResults.getTokenValue("native_thread_policy"));
            this.addAsProperty(properties, "scope", nativeResults.getTokenValue("scope"));
        }
        try {
            imageThread = this.fImageProcessBuilder.addImageThread(imageThreadID, abstractThreadID, properties);
            javaThread = this.fRuntimeBuilder.addJavaThread(imageThread, threadName, tid, abstractThreadID, threadState, threadPriority);
        }
        catch (BuilderFailureException e) {
            this.handleErrorAtLineNumber(currentFileLineNumber, "Failed to add thread: " + threadName + " " + imageThreadID, e);
        }
        return javaThread;
    }

    private void parseStackTrace(JavaThread javaThread, int currentFileLineNumber, boolean buildModel) throws ParserException {
        IAttributeValueMap stackTraceResults = null;
        currentFileLineNumber = this.getCurrentFileLineNumber();
        while ((stackTraceResults = this.processTagLineOptional("4XESTACKTRACE")) != null) {
            if (javaThread == null) continue;
            this.addStackTrace(stackTraceResults, javaThread, currentFileLineNumber);
            currentFileLineNumber = this.getCurrentFileLineNumber();
        }
        this.sovOnlyRules("3XMTHREADINFO");
    }

    private void addStackTrace(IAttributeValueMap stackTraceResults, JavaThread javaThread, int fileLineNumber) throws ParserException {
        if (stackTraceResults == null) {
            return;
        }
        String className = stackTraceResults.getTokenValue("full_location_name");
        String methodName = stackTraceResults.getTokenValue("method_name");
        String methodType = stackTraceResults.getTokenValue("stacktrace_method_type");
        String classFile = null;
        String compilationLevel = null;
        int lineNumber = -1;
        if (methodType.equals("stacktrace_java_method")) {
            classFile = stackTraceResults.getTokenValue("class_file_name");
            compilationLevel = stackTraceResults.getTokenValue("comp_level");
            lineNumber = stackTraceResults.getIntValue("stacktrace_line_number");
        }
        try {
            this.fRuntimeBuilder.addJavaStackFrame(javaThread, className, classFile, methodName, methodType, compilationLevel, lineNumber);
        }
        catch (BuilderFailureException e) {
            this.handleErrorAtLineNumber(fileLineNumber, "Failed to add stack frame: " + className + "." + methodName + " " + lineNumber, e);
        }
    }

    protected void sovOnlyRules(String startingTag) throws ParserException {
    }
}

