/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.platform;

import com.ibm.dtfj.javacore.parser.framework.tag.LineRule;
import com.ibm.dtfj.javacore.parser.framework.tag.TagParser;
import com.ibm.dtfj.javacore.parser.j9.section.common.CommonPatternMatchers;
import com.ibm.dtfj.javacore.parser.j9.section.platform.IPlatformTypes;
import com.ibm.dtfj.javacore.parser.j9.section.platform.PlatformPatternMatchers;

public class PlatformTagParser
extends TagParser
implements IPlatformTypes {
    public PlatformTagParser() {
        super("GPINFO");
    }

    protected void initTagAttributeRules() {
        this.addOSLevel();
        this.addTag("2XHCPUS", null);
        this.addCPUArch();
        this.addCPUCount();
        this.addExceptionCodeRule();
        this.addTag("1XHERROR2", null);
    }

    private void addOSLevel() {
        LineRule lineRule = new LineRule(){

            public void processLine(String source, int startingOffset) {
                this.consumeUntilFirstMatch(CommonPatternMatchers.colon);
                if (this.findFirst(PlatformPatternMatchers.Windows_XP)) {
                    this.addToken("platform_os_name", PlatformPatternMatchers.Windows_XP);
                } else if (this.findFirst(PlatformPatternMatchers.Windows_Server_2003)) {
                    this.addToken("platform_os_name", PlatformPatternMatchers.Windows_Server_2003);
                } else if (this.findFirst(PlatformPatternMatchers.Windows_Server_2008)) {
                    this.addToken("platform_os_name", PlatformPatternMatchers.Windows_Server_2008);
                } else if (this.findFirst(PlatformPatternMatchers.Windows_2000)) {
                    this.addToken("platform_os_name", PlatformPatternMatchers.Windows_2000);
                } else if (this.findFirst(PlatformPatternMatchers.Windows_Vista)) {
                    this.addToken("platform_os_name", PlatformPatternMatchers.Windows_Vista);
                } else if (this.findFirst(PlatformPatternMatchers.Linux)) {
                    this.addToken("platform_os_name", PlatformPatternMatchers.Linux);
                } else if (this.findFirst(PlatformPatternMatchers.AIX)) {
                    this.addToken("platform_os_name", PlatformPatternMatchers.AIX);
                } else if (this.findFirst(PlatformPatternMatchers.z_OS)) {
                    this.addToken("platform_os_name", PlatformPatternMatchers.z_OS);
                }
                this.addToken("platform_os_version", CommonPatternMatchers.allButLineFeed);
            }
        };
        this.addTag("2XHOSLEVEL", lineRule);
    }

    private void addCPUArch() {
        LineRule lineRule = new LineRule(){

            public void processLine(String source, int startingOffset) {
                this.consumeUntilFirstMatch(CommonPatternMatchers.colon);
                this.addToken("platform_cpu_arch", CommonPatternMatchers.allButLineFeed);
            }
        };
        this.addTag("3XHCPUARCH", lineRule);
    }

    private void addCPUCount() {
        LineRule lineRule = new LineRule(){

            public void processLine(String source, int startingOffset) {
                this.consumeUntilFirstMatch(CommonPatternMatchers.colon);
                this.addToken("platform_cpu_count", CommonPatternMatchers.dec);
            }
        };
        this.addTag("3XHNUMCPUS", lineRule);
    }

    private void addExceptionCodeRule() {
        LineRule lineRule = new LineRule(){

            public void processLine(String source, int startingOffset) {
                if (this.findFirst(PlatformPatternMatchers.J9Signal_1)) {
                    this.consumeUntilFirstMatch(PlatformPatternMatchers.J9Signal_1);
                    this.addNonPrefixedHexToken("platform_signal");
                } else if (this.findFirst(PlatformPatternMatchers.J9Signal_2)) {
                    this.consumeUntilFirstMatch(PlatformPatternMatchers.J9Signal_2);
                    this.addNonPrefixedHexToken("platform_signal");
                }
            }
        };
        this.addTag("1XHEXCPCODE", lineRule);
    }
}

